/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.parsing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ResourcesManager;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.ArchivedPackageParcel;
import android.content.pm.ConfigurationInfo;
import android.content.pm.FeatureGroupInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningDetails;
import android.content.pm.parsing.ApkLiteParseUtils;
import android.content.pm.parsing.FrameworkParsingPackageUtils;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.split.SplitDependencyLoader;
import android.content.res.ApkAssets;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os._Original_Build;
import android.os.ext.SdkExtensions;
import android.permission.PermissionManager;
import android.ravenwood.annotation.RavenwoodKeep;
import android.ravenwood.annotation.RavenwoodKeepPartialClass;
import android.ravenwood.annotation.RavenwoodKeepStaticInitializer;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.util.apk.ApkSignatureVerifier;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.os.ClassLoaderFactory;
import com.android.internal.pm.parsing.pkg.ParsedPackage;
import com.android.internal.pm.permission.CompatibilityPermissionInfo;
import com.android.internal.pm.pkg.component.AconfigFlags;
import com.android.internal.pm.pkg.component.ComponentMutateUtils;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.InstallConstraintsTagParser;
import com.android.internal.pm.pkg.component.ParsedActivity;
import com.android.internal.pm.pkg.component.ParsedActivityImpl;
import com.android.internal.pm.pkg.component.ParsedActivityUtils;
import com.android.internal.pm.pkg.component.ParsedApexSystemService;
import com.android.internal.pm.pkg.component.ParsedApexSystemServiceUtils;
import com.android.internal.pm.pkg.component.ParsedAttribution;
import com.android.internal.pm.pkg.component.ParsedAttributionUtils;
import com.android.internal.pm.pkg.component.ParsedComponent;
import com.android.internal.pm.pkg.component.ParsedInstrumentation;
import com.android.internal.pm.pkg.component.ParsedInstrumentationUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.component.ParsedIntentInfoUtils;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import com.android.internal.pm.pkg.component.ParsedPermission;
import com.android.internal.pm.pkg.component.ParsedPermissionGroup;
import com.android.internal.pm.pkg.component.ParsedPermissionUtils;
import com.android.internal.pm.pkg.component.ParsedProcess;
import com.android.internal.pm.pkg.component.ParsedProcessUtils;
import com.android.internal.pm.pkg.component.ParsedProvider;
import com.android.internal.pm.pkg.component.ParsedProviderUtils;
import com.android.internal.pm.pkg.component.ParsedService;
import com.android.internal.pm.pkg.component.ParsedServiceUtils;
import com.android.internal.pm.pkg.component.ParsedUsesPermission;
import com.android.internal.pm.pkg.component.ParsedUsesPermissionImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingUtils;
import com.android.internal.pm.split.DefaultSplitAssetLoader;
import com.android.internal.pm.split.SplitAssetDependencyLoader;
import com.android.internal.pm.split.SplitAssetLoader;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import libcore.util.HexEncoding;
import org.xmlpull.v1.XmlPullParserException;

@RavenwoodKeepPartialClass
@RavenwoodKeepStaticInitializer
public class ParsingPackageUtils {
    private static final String TAG = "PackageParsing";
    private static final int MAXIMUM_LAUNCHER_ALTERNATE_IDS_LENGTH = 500;
    private static final String TYPE_STRING = "string";
    private static final String TYPE_DRAWABLE = "drawable";
    public static final boolean DEBUG_JAR = false;
    public static final boolean DEBUG_BACKUP = false;
    public static final float DEFAULT_PRE_O_MAX_ASPECT_RATIO = 1.86f;
    public static final float ASPECT_RATIO_NOT_SET = -1.0f;
    public static final String ANDROID_MANIFEST_FILENAME = "AndroidManifest.xml";
    public static final String MNT_EXPAND = "/mnt/expand/";
    public static final String TAG_ADOPT_PERMISSIONS = "adopt-permissions";
    public static final String TAG_APPLICATION = "application";
    public static final String TAG_ATTRIBUTION = "attribution";
    public static final String TAG_COMPATIBLE_SCREENS = "compatible-screens";
    public static final String TAG_EAT_COMMENT = "eat-comment";
    public static final String TAG_FEATURE_GROUP = "feature-group";
    public static final String TAG_INSTALL_CONSTRAINTS = "install-constraints";
    public static final String TAG_INSTRUMENTATION = "instrumentation";
    public static final String TAG_KEY_SETS = "key-sets";
    public static final String TAG_MANIFEST = "manifest";
    public static final String TAG_ORIGINAL_PACKAGE = "original-package";
    public static final String TAG_OVERLAY = "overlay";
    public static final String TAG_PACKAGE = "package";
    public static final String TAG_PACKAGE_VERIFIER = "package-verifier";
    public static final String TAG_PERMISSION = "permission";
    public static final String TAG_PERMISSION_GROUP = "permission-group";
    public static final String TAG_PERMISSION_TREE = "permission-tree";
    public static final String TAG_PROFILEABLE = "profileable";
    public static final String TAG_PROTECTED_BROADCAST = "protected-broadcast";
    public static final String TAG_QUERIES = "queries";
    public static final String TAG_RECEIVER = "receiver";
    public static final String TAG_RESTRICT_UPDATE = "restrict-update";
    public static final String TAG_SUPPORTS_INPUT = "supports-input";
    public static final String TAG_SUPPORT_SCREENS = "supports-screens";
    public static final String TAG_USES_CONFIGURATION = "uses-configuration";
    public static final String TAG_USES_FEATURE = "uses-feature";
    public static final String TAG_USES_GL_TEXTURE = "uses-gl-texture";
    public static final String TAG_USES_PERMISSION = "uses-permission";
    public static final String TAG_USES_PERMISSION_SDK_23 = "uses-permission-sdk-23";
    public static final String TAG_USES_PERMISSION_SDK_M = "uses-permission-sdk-m";
    public static final String TAG_USES_SDK = "uses-sdk";
    public static final String TAG_USES_SPLIT = "uses-split";
    public static final String METADATA_MAX_ASPECT_RATIO = "android.max_aspect";
    public static final String METADATA_SUPPORTS_SIZE_CHANGES = "android.supports_size_changes";
    public static final String METADATA_CAN_DISPLAY_ON_REMOTE_DEVICES = "android.can_display_on_remote_devices";
    public static final String METADATA_ACTIVITY_WINDOW_LAYOUT_AFFINITY = "android.activity_window_layout_affinity";
    public static final String METADATA_ACTIVITY_LAUNCH_MODE = "android.activity.launch_mode";
    public static final int SDK_VERSION = _Original_Build.VERSION.SDK_INT;
    public static final String[] SDK_CODENAMES = _Original_Build.VERSION.ACTIVE_CODENAMES;
    public static boolean sCompatibilityModeEnabled = true;
    public static boolean sUseRoundIcon = false;
    public static final int PARSE_DEFAULT_INSTALL_LOCATION = -1;
    public static final int PARSE_DEFAULT_TARGET_SANDBOX = 1;
    public static final boolean RIGID_PARSER = false;
    public static final int PARSE_MUST_BE_APK = 1;
    public static final int PARSE_IGNORE_PROCESSES = 2;
    public static final int PARSE_EXTERNAL_STORAGE = 8;
    public static final int PARSE_IS_SYSTEM_DIR = 16;
    public static final int PARSE_COLLECT_CERTIFICATES = 32;
    public static final int PARSE_ENFORCE_CODE = 64;
    public static final int PARSE_IGNORE_OVERLAY_REQUIRED_SYSTEM_PROPERTY = 128;
    public static final int PARSE_APK_IN_APEX = 512;
    public static final int PARSE_APEX = 1024;
    public static final int PARSE_CHATTY = Integer.MIN_VALUE;
    private final String[] mSeparateProcesses;
    private final DisplayMetrics mDisplayMetrics;
    @NonNull
    private final List<PermissionManager.SplitPermissionInfo> mSplitPermissionInfos;
    private final Callback mCallback;
    private static final AconfigFlags sAconfigFlags = new AconfigFlags();

    @NonNull
    public static ParseResult<ParsedPackage> parseDefault(ParseInput input, File file, int parseFlags, @NonNull List<PermissionManager.SplitPermissionInfo> splitPermissions, boolean collectCertificates, Callback callback) {
        ParsingPackageUtils parser = new ParsingPackageUtils(null, null, splitPermissions, callback);
        ParseResult<ParsingPackage> parseResult = parser.parsePackage(input, file, parseFlags);
        if (parseResult.isError()) {
            return input.error(parseResult);
        }
        ParsedPackage pkg = parseResult.getResult().hideAsParsed();
        if (collectCertificates) {
            ParseResult<SigningDetails> ret = ParsingPackageUtils.getSigningDetails(input, pkg, false);
            if (ret.isError()) {
                return input.error(ret);
            }
            pkg.setSigningDetails(ret.getResult());
        }
        return input.success(pkg);
    }

    public ParsingPackageUtils(String[] separateProcesses, DisplayMetrics displayMetrics, @NonNull List<PermissionManager.SplitPermissionInfo> splitPermissions, @NonNull Callback callback) {
        this.mSeparateProcesses = separateProcesses;
        this.mDisplayMetrics = displayMetrics;
        this.mSplitPermissionInfos = splitPermissions;
        this.mCallback = callback;
    }

    public ParseResult<ParsingPackage> parsePackage(ParseInput input, File packageFile, int flags) {
        if (packageFile.isDirectory()) {
            return this.parseClusterPackage(input, packageFile, flags);
        }
        return this.parseMonolithicPackage(input, packageFile, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseClusterPackage(ParseInput input, File packageDir, int flags) {
        SplitAssetLoader assetLoader;
        ParseResult<PackageLite> liteResult;
        int liteParseFlags = 0;
        if ((flags & 0x200) != 0) {
            liteParseFlags |= 0x200;
        }
        if ((flags & 0x400) != 0) {
            liteParseFlags |= 0x400;
        }
        if ((liteResult = ApkLiteParseUtils.parseClusterPackageLite(input, packageDir, liteParseFlags)).isError()) {
            return input.error(liteResult);
        }
        PackageLite lite = liteResult.getResult();
        SparseArray<int[]> splitDependencies = null;
        if (lite.isIsolatedSplits() && !ArrayUtils.isEmpty(lite.getSplitNames())) {
            try {
                splitDependencies = SplitAssetDependencyLoader.createDependenciesFromPackage(lite);
                assetLoader = new SplitAssetDependencyLoader(lite, splitDependencies, flags);
            }
            catch (SplitDependencyLoader.IllegalDependencyException e) {
                return input.error(-101, e.getMessage());
            }
        } else {
            assetLoader = new DefaultSplitAssetLoader(lite, flags);
        }
        try {
            File baseApk = new File(lite.getBaseApkPath());
            boolean shouldSkipComponents = lite.isIsSdkLibrary() && com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags.disallowSdkLibsToBeApps();
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, baseApk, lite.getPath(), assetLoader, flags, shouldSkipComponents);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result);
                return parseResult;
            }
            ParsingPackage pkg = result.getResult();
            if (!ArrayUtils.isEmpty(lite.getSplitNames())) {
                pkg.asSplit(lite.getSplitNames(), lite.getSplitApkPaths(), lite.getSplitRevisionCodes(), splitDependencies);
                int num = lite.getSplitNames().length;
                for (int i = 0; i < num; ++i) {
                    AssetManager splitAssets = assetLoader.getSplitAssetManager(i);
                    ParseResult<ParsingPackage> split = this.parseSplitApk(input, pkg, i, splitAssets, flags);
                    if (!split.isError()) continue;
                    ParseResult<ParsingPackage> parseResult = input.error(split);
                    return parseResult;
                }
            }
            pkg.set32BitAbiPreferred(lite.isUse32bitAbi());
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        catch (IllegalArgumentException e) {
            ParseResult<ParsingPackage> parseResult = input.error(e.getCause() instanceof IOException ? -2 : -100, e.getMessage(), e);
            return parseResult;
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseMonolithicPackage(ParseInput input, File apkFile, int flags) {
        int liteParseFlags = flags & 0xFFFFFFDF;
        ParseResult<PackageLite> liteResult = ApkLiteParseUtils.parseMonolithicPackageLite(input, apkFile, liteParseFlags);
        if (liteResult.isError()) {
            return input.error(liteResult);
        }
        PackageLite lite = liteResult.getResult();
        DefaultSplitAssetLoader assetLoader = new DefaultSplitAssetLoader(lite, flags);
        try {
            boolean shouldSkipComponents = lite.isIsSdkLibrary() && com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags.disallowSdkLibsToBeApps();
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, apkFile, apkFile.getCanonicalPath(), assetLoader, flags, shouldSkipComponents);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result);
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(result.getResult().set32BitAbiPreferred(lite.isUse32bitAbi()));
            return parseResult;
        }
        catch (IOException e) {
            ParseResult<ParsingPackage> parseResult = input.error(-102, "Failed to get path: " + apkFile, e);
            return parseResult;
        }
        finally {
            IoUtils.closeQuietly(assetLoader);
        }
    }

    public ParseResult<ParsingPackage> parsePackageFromPackageLite(ParseInput input, PackageLite lite, int flags) {
        String volumeUuid = ParsingPackageUtils.getVolumeUuid(lite.getPath());
        String pkgName = lite.getPackageName();
        TypedArray manifestArray = null;
        ParsingPackage pkg = this.mCallback.startParsingPackage(pkgName, lite.getBaseApkPath(), lite.getPath(), manifestArray, lite.isCoreApp());
        int targetSdk = lite.getTargetSdk();
        String versionName = null;
        boolean compileSdkVersion = false;
        String compileSdkVersionCodeName = null;
        boolean isolatedSplitLoading = false;
        pkg.setVersionCode(lite.getVersionCode());
        pkg.setVersionCodeMajor(lite.getVersionCodeMajor());
        pkg.setBaseRevisionCode(lite.getBaseRevisionCode());
        pkg.setVersionName(versionName);
        pkg.setCompileSdkVersion(0);
        pkg.setCompileSdkVersionCodeName(compileSdkVersionCodeName);
        pkg.setIsolatedSplitLoading(false);
        pkg.setTargetSdkVersion(targetSdk);
        pkg.setInstallLocation(lite.getInstallLocation()).setTargetSandboxVersion(1).setExternalStorage((flags & 8) != 0);
        ArchivedPackageParcel archivedPackage = lite.getArchivedPackage();
        if (archivedPackage == null) {
            return input.error(-102, "archivePackage is missing");
        }
        pkg.setBackupAllowed(true).setClearUserDataAllowed(true).setClearUserDataOnFailedRestoreAllowed(true).setAllowNativeHeapPointerTagging(true).setEnabled(true).setExtractNativeLibrariesRequested(true).setAllowAudioPlaybackCapture(targetSdk >= 29).setHardwareAccelerated(targetSdk >= 14).setRequestLegacyExternalStorage(XmlUtils.convertValueToBoolean(archivedPackage.requestLegacyExternalStorage, targetSdk < 29)).setCleartextTrafficAllowed(targetSdk < 28).setDefaultToDeviceProtectedStorage(XmlUtils.convertValueToBoolean(archivedPackage.defaultToDeviceProtectedStorage, false)).setUserDataFragile(XmlUtils.convertValueToBoolean(archivedPackage.userDataFragile, false)).setCategory(-1).setMaxAspectRatio(0.0f).setMinAspectRatio(0.0f);
        pkg.setDeclaredHavingCode(false);
        CharSequence taskAffinity = null;
        ParseResult<String> taskAffinityResult = ComponentParseUtils.buildTaskAffinityName(pkgName, pkgName, taskAffinity, input);
        if (taskAffinityResult.isError()) {
            return input.error(taskAffinityResult);
        }
        pkg.setTaskAffinity(taskAffinityResult.getResult());
        CharSequence pname = null;
        ParseResult<String> processNameResult = ComponentParseUtils.buildProcessName(pkgName, null, pname, flags, this.mSeparateProcesses, input);
        if (processNameResult.isError()) {
            return input.error(processNameResult);
        }
        pkg.setProcessName(processNameResult.getResult());
        pkg.setGwpAsanMode(-1);
        pkg.setMemtagMode(-1);
        pkg.setPageSizeAppCompatFlags(0);
        this.afterParseBaseApplication(pkg);
        ParseResult<ParsingPackage> result = this.validateBaseApkTags(input, pkg, flags);
        if (result.isError()) {
            return result;
        }
        pkg.setVolumeUuid(volumeUuid);
        if ((flags & 0x20) != 0) {
            pkg.setSigningDetails(lite.getSigningDetails());
        } else {
            pkg.setSigningDetails(SigningDetails.UNKNOWN);
        }
        return input.success(pkg.set32BitAbiPreferred(lite.isUse32bitAbi()));
    }

    private static String getVolumeUuid(String apkPath) {
        String volumeUuid = null;
        if (apkPath.startsWith(MNT_EXPAND)) {
            int end = apkPath.indexOf(47, MNT_EXPAND.length());
            volumeUuid = apkPath.substring(MNT_EXPAND.length(), end);
        }
        return volumeUuid;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParseResult<ParsingPackage> parseBaseApk(ParseInput input, File apkFile, String codePath, SplitAssetLoader assetLoader, int flags, boolean shouldSkipComponents) {
        AssetManager assets;
        String apkPath = apkFile.getAbsolutePath();
        String volumeUuid = ParsingPackageUtils.getVolumeUuid(apkPath);
        try {
            assets = assetLoader.getBaseAssetManager();
        }
        catch (IllegalArgumentException e) {
            int n;
            if (e.getCause() instanceof IOException) {
                n = -2;
                return input.error(n, e.getMessage(), e);
            }
            n = -100;
            return input.error(n, e.getMessage(), e);
        }
        int cookie = assets.findCookieForPath(apkPath);
        if (cookie == 0) {
            return input.error(-101, "Failed adding asset path: " + apkPath);
        }
        try (XmlResourceParser parser = assets.openXmlResourceParser(cookie, ANDROID_MANIFEST_FILENAME);){
            ParseResult<?> deferResult;
            Resources res = new Resources(assets, this.mDisplayMetrics, null);
            ParseResult<ParsingPackage> result = this.parseBaseApk(input, apkPath, codePath, res, parser, flags, shouldSkipComponents);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(result.getErrorCode(), apkPath + " (at " + parser.getPositionDescription() + "): " + result.getErrorMessage());
                return parseResult;
            }
            ParsingPackage pkg = result.getResult();
            if (assets.containsAllocatedTable() && (deferResult = input.deferError("Targeting R+ (version 30 and above) requires the resources.arsc of installed APKs to be stored uncompressed and aligned on a 4-byte boundary", 132742131L)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(-124, deferResult.getErrorMessage());
                return parseResult;
            }
            ApkAssets apkAssets = assetLoader.getBaseApkAssets();
            boolean definesOverlayable = false;
            try {
                definesOverlayable = apkAssets.definesOverlayable();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (definesOverlayable) {
                SparseArray<String> packageNames = assets.getAssignedPackageIdentifiers();
                int size = packageNames.size();
                for (int index = 0; index < size; ++index) {
                    String packageName = packageNames.valueAt(index);
                    Map<String, String> overlayableToActor = assets.getOverlayableMap(packageName);
                    if (overlayableToActor == null || overlayableToActor.isEmpty()) continue;
                    for (String overlayable : overlayableToActor.keySet()) {
                        pkg.addOverlayable(overlayable, overlayableToActor.get(overlayable));
                    }
                }
            }
            pkg.setVolumeUuid(volumeUuid);
            if ((flags & 0x20) != 0) {
                ParseResult<SigningDetails> ret = ParsingPackageUtils.getSigningDetails(input, pkg, false);
                if (ret.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(ret);
                    return parseResult;
                }
                pkg.setSigningDetails(ret.getResult());
            } else {
                pkg.setSigningDetails(SigningDetails.UNKNOWN);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        catch (Exception e) {
            return input.error(-102, "Failed to read manifest from " + apkPath, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ParseResult<ParsingPackage> parseSplitApk(ParseInput input, ParsingPackage pkg, int splitIndex, AssetManager assets, int flags) {
        String apkPath = pkg.getSplitCodePaths()[splitIndex];
        int cookie = assets.findCookieForPath(apkPath);
        if (cookie == 0) {
            return input.error(-101, "Failed adding asset path: " + apkPath);
        }
        try (XmlResourceParser parser = assets.openXmlResourceParser(cookie, ANDROID_MANIFEST_FILENAME, false);){
            Resources res = new Resources(assets, this.mDisplayMetrics, null);
            ParseResult<ParsingPackage> parseResult = this.parseSplitApk(input, pkg, res, parser, flags, splitIndex);
            if (parseResult.isError()) {
                ParseResult<ParsingPackage> parseResult2 = input.error(parseResult.getErrorCode(), apkPath + " (at " + parser.getPositionDescription() + "): " + parseResult.getErrorMessage());
                return parseResult2;
            }
            ParseResult<ParsingPackage> parseResult3 = parseResult;
            return parseResult3;
        }
        catch (Exception e) {
            return input.error(-102, "Failed to read manifest from " + apkPath, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseBaseApk(ParseInput input, String apkPath, String codePath, Resources res, XmlResourceParser parser, int flags, boolean shouldSkipComponents) throws XmlPullParserException, IOException {
        ParseResult<Pair<String, String>> packageSplitResult = ApkLiteParseUtils.parsePackageSplitNames(input, parser);
        if (packageSplitResult.isError()) {
            return input.error(packageSplitResult);
        }
        Pair<String, String> packageSplit = packageSplitResult.getResult();
        String pkgName = (String)packageSplit.first;
        String splitName = (String)packageSplit.second;
        if (!TextUtils.isEmpty(splitName)) {
            return input.error(-106, "Expected base APK, but found split " + splitName);
        }
        TypedArray manifestArray = res.obtainAttributes(parser, R.styleable.AndroidManifest);
        try {
            boolean isCoreApp = parser.getAttributeBooleanValue(null, "coreApp", false);
            ParsingPackage pkg = this.mCallback.startParsingPackage(pkgName, apkPath, codePath, manifestArray, isCoreApp);
            ParseResult<ParsingPackage> result = this.parseBaseApkTags(input, pkg, manifestArray, res, parser, flags, shouldSkipComponents);
            if (result.isError()) {
                ParseResult<ParsingPackage> parseResult = result;
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            manifestArray.recycle();
        }
    }

    private ParseResult<ParsingPackage> parseSplitApk(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex) throws XmlPullParserException, IOException {
        ParseResult<?> deferResult;
        int type;
        ParseResult<Pair<String, String>> packageSplitResult = ApkLiteParseUtils.parsePackageSplitNames(input, parser);
        if (packageSplitResult.isError()) {
            return input.error(packageSplitResult);
        }
        boolean foundApp = false;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1) {
            ParseResult<Object> result;
            if (outerDepth + 1 < parser.getDepth() || type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            String tagName = parser.getName();
            if (TAG_APPLICATION.equals(tagName)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    result = input.success(null);
                } else {
                    foundApp = true;
                    result = this.parseSplitApplication(input, pkg, res, parser, flags, splitIndex);
                }
            } else {
                result = ParsingUtils.unknownTag("<manifest>", pkg, parser, input);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!foundApp && (deferResult = input.deferError("<manifest> does not contain an <application>", 150776642L)).isError()) {
            return input.error(deferResult);
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseSplitApplication(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, int splitIndex) throws XmlPullParserException, IOException {
        int type;
        block26: {
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
            try {
                pkg.setSplitHasCode(splitIndex, sa.getBoolean(7, true));
                String classLoaderName = sa.getString(46);
                if (classLoaderName == null || ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
                    pkg.setSplitClassLoaderName(splitIndex, classLoaderName);
                    break block26;
                }
                ParseResult<ParsingPackage> parseResult = input.error("Invalid class loader name: " + classLoaderName);
                return parseResult;
            }
            finally {
                sa.recycle();
            }
        }
        String defaultSplitName = pkg.getSplitNames()[splitIndex];
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedMainComponent> result;
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            ParsedMainComponent mainComponent = null;
            String tagName = parser.getName();
            boolean isActivity = false;
            switch (tagName) {
                case "activity": {
                    isActivity = true;
                }
                case "receiver": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityOrReceiver(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, defaultSplitName, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        if (isActivity) {
                            pkg.addActivity(activity);
                        } else {
                            pkg.addReceiver(activity);
                        }
                        mainComponent = activity;
                    }
                    result = activityResult;
                    break;
                }
                case "service": {
                    ParseResult<ParsedService> serviceResult = ParsedServiceUtils.parseService(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, defaultSplitName, input);
                    if (serviceResult.isSuccess()) {
                        ParsedService service = serviceResult.getResult();
                        pkg.addService(service);
                        mainComponent = service;
                    }
                    result = serviceResult;
                    break;
                }
                case "provider": {
                    ParseResult<ParsedProvider> providerResult = ParsedProviderUtils.parseProvider(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, defaultSplitName, input);
                    if (providerResult.isSuccess()) {
                        ParsedProvider provider = providerResult.getResult();
                        pkg.addProvider(provider);
                        mainComponent = provider;
                    }
                    result = providerResult;
                    break;
                }
                case "activity-alias": {
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityAlias(pkg, res, parser, sUseRoundIcon, defaultSplitName, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        pkg.addActivity(activity);
                        mainComponent = activity;
                    }
                    result = activityResult;
                    break;
                }
                default: {
                    result = this.parseSplitBaseAppChildTags(input, tagName, pkg, res, parser);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        return input.success(pkg);
    }

    private ParseResult parseSplitBaseAppChildTags(ParseInput input, String tag, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        switch (tag) {
            case "meta-data": {
                ParseResult<PackageManager.Property> metaDataResult = ParsingPackageUtils.parseMetaData(pkg, null, res, parser, "<meta-data>", input);
                if (metaDataResult.isSuccess() && metaDataResult.getResult() != null) {
                    pkg.setMetaData(metaDataResult.getResult().toBundle(pkg.getMetaData()));
                }
                return metaDataResult;
            }
            case "property": {
                ParseResult<PackageManager.Property> propertyResult = ParsingPackageUtils.parseMetaData(pkg, null, res, parser, "<property>", input);
                if (propertyResult.isSuccess()) {
                    pkg.addProperty(propertyResult.getResult());
                }
                return propertyResult;
            }
            case "uses-sdk-library": {
                return ParsingPackageUtils.parseUsesSdkLibrary(input, pkg, res, parser);
            }
            case "uses-static-library": {
                return ParsingPackageUtils.parseUsesStaticLibrary(input, pkg, res, parser);
            }
            case "uses-library": {
                return ParsingPackageUtils.parseUsesLibrary(input, pkg, res, parser);
            }
            case "uses-native-library": {
                return ParsingPackageUtils.parseUsesNativeLibrary(input, pkg, res, parser);
            }
            case "uses-package": {
                return input.success(null);
            }
        }
        return ParsingUtils.unknownTag("<application>", pkg, parser, input);
    }

    private ParseResult<ParsingPackage> parseBaseApkTags(ParseInput input, ParsingPackage pkg, TypedArray sa, Resources res, XmlResourceParser parser, int flags, boolean shouldSkipComponents) throws XmlPullParserException, IOException {
        ParseResult<?> deferResult;
        int type;
        ParseResult<ParsingPackage> sharedUserResult = ParsingPackageUtils.parseSharedUser(input, pkg, sa);
        if (sharedUserResult.isError()) {
            return sharedUserResult;
        }
        boolean updatableSystem = parser.getAttributeBooleanValue(null, "updatableSystem", true);
        String emergencyInstaller = parser.getAttributeValue(null, "emergencyInstaller");
        pkg.setInstallLocation(ParsingPackageUtils.anInteger(-1, 4, sa)).setTargetSandboxVersion(ParsingPackageUtils.anInteger(1, 7, sa)).setExternalStorage((flags & 8) != 0).setUpdatableSystem(updatableSystem).setEmergencyInstaller(emergencyInstaller);
        boolean foundApp = false;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            String tagName = parser.getName();
            if (TAG_APPLICATION.equals(tagName)) {
                if (foundApp) {
                    Slog.w(TAG, "<manifest> has more than one <application>");
                    result = input.success(null);
                } else {
                    foundApp = true;
                    result = this.parseBaseApplication(input, pkg, res, parser, flags, shouldSkipComponents);
                }
            } else {
                result = this.parseBaseApkTag(tagName, input, pkg, res, parser, flags);
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (!foundApp && ArrayUtils.size(pkg.getInstrumentations()) == 0 && (deferResult = input.deferError("<manifest> does not contain an <application> or <instrumentation>", 150776642L)).isError()) {
            return input.error(deferResult);
        }
        return this.validateBaseApkTags(input, pkg, flags);
    }

    private ParseResult<ParsingPackage> validateBaseApkTags(ParseInput input, ParsingPackage pkg, int flags) {
        boolean isApex;
        if (!ParsedAttributionUtils.isCombinationValid(pkg.getAttributions())) {
            return input.error(-101, "Combination <attribution> tags are not valid");
        }
        if (ParsedPermissionUtils.declareDuplicatePermission(pkg)) {
            return input.error(-108, "Found duplicate permission with a different attribute value.");
        }
        ParsingPackageUtils.convertCompatPermissions(pkg);
        this.convertSplitPermissions(pkg);
        if (!(pkg.getTargetSdkVersion() >= 4 && (pkg.isSmallScreensSupported() || pkg.isNormalScreensSupported() || pkg.isLargeScreensSupported() || pkg.isExtraLargeScreensSupported() || pkg.isResizeable() || pkg.isAnyDensity()))) {
            ParsingPackageUtils.adjustPackageToBeUnresizeableAndUnpipable(pkg);
        }
        boolean bl = isApex = (flags & 0x400) != 0;
        if (isApex && !pkg.getPermissions().isEmpty()) {
            return input.error(-108, pkg.getPackageName() + " is an APEX package and shouldn't declare permissions.");
        }
        return input.success(pkg);
    }

    private ParseResult parseBaseApkTag(String tag, ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws IOException, XmlPullParserException {
        switch (tag) {
            case "overlay": {
                return ParsingPackageUtils.parseOverlay(input, pkg, res, parser);
            }
            case "key-sets": {
                return ParsingPackageUtils.parseKeySets(input, pkg, res, parser);
            }
            case "feature": 
            case "attribution": {
                return ParsingPackageUtils.parseAttribution(input, pkg, res, parser);
            }
            case "permission-group": {
                return ParsingPackageUtils.parsePermissionGroup(input, pkg, res, parser);
            }
            case "permission": {
                return ParsingPackageUtils.parsePermission(input, pkg, res, parser, flags);
            }
            case "permission-tree": {
                return ParsingPackageUtils.parsePermissionTree(input, pkg, res, parser);
            }
            case "uses-permission": 
            case "uses-permission-sdk-m": 
            case "uses-permission-sdk-23": {
                return this.parseUsesPermission(input, pkg, res, parser);
            }
            case "uses-configuration": {
                return ParsingPackageUtils.parseUsesConfiguration(input, pkg, res, parser);
            }
            case "uses-feature": {
                return ParsingPackageUtils.parseUsesFeature(input, pkg, res, parser);
            }
            case "feature-group": {
                return ParsingPackageUtils.parseFeatureGroup(input, pkg, res, parser);
            }
            case "uses-sdk": {
                return ParsingPackageUtils.parseUsesSdk(input, pkg, res, parser, flags);
            }
            case "supports-screens": {
                return ParsingPackageUtils.parseSupportScreens(input, pkg, res, parser);
            }
            case "protected-broadcast": {
                return ParsingPackageUtils.parseProtectedBroadcast(input, pkg, res, parser);
            }
            case "instrumentation": {
                return ParsingPackageUtils.parseInstrumentation(input, pkg, res, parser);
            }
            case "original-package": {
                return ParsingPackageUtils.parseOriginalPackage(input, pkg, res, parser);
            }
            case "adopt-permissions": {
                return ParsingPackageUtils.parseAdoptPermissions(input, pkg, res, parser);
            }
            case "uses-gl-texture": 
            case "compatible-screens": 
            case "supports-input": 
            case "eat-comment": {
                XmlUtils.skipCurrentTag(parser);
                return input.success(pkg);
            }
            case "restrict-update": {
                return ParsingPackageUtils.parseRestrictUpdateHash(flags, input, pkg, res, parser);
            }
            case "install-constraints": {
                return ParsingPackageUtils.parseInstallConstraints(input, pkg, res, parser, this.mCallback.getInstallConstraintsAllowlist());
            }
            case "queries": {
                return ParsingPackageUtils.parseQueries(input, pkg, res, parser);
            }
        }
        return ParsingUtils.unknownTag("<manifest>", pkg, parser, input);
    }

    private static ParseResult<ParsingPackage> parseSharedUser(ParseInput input, ParsingPackage pkg, TypedArray sa) {
        ParseResult nameResult;
        String str = ParsingPackageUtils.nonConfigString(0, 0, sa);
        if (TextUtils.isEmpty(str)) {
            return input.success(pkg);
        }
        if (!"android".equals(pkg.getPackageName()) && (nameResult = FrameworkParsingPackageUtils.validateName(input, str, true, true)).isError()) {
            return input.error(-107, "<manifest> specifies bad sharedUserId name \"" + str + "\": " + nameResult.getErrorMessage());
        }
        boolean leaving = false;
        int max = ParsingPackageUtils.anInteger(0, 13, sa);
        leaving = max != 0 && max < _Original_Build.VERSION.RESOURCES_SDK_INT;
        return input.success(pkg.setLeavingSharedUser(leaving).setSharedUserId(str.intern()).setSharedUserLabelResourceId(ParsingPackageUtils.resId(3, sa)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseKeySets(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        int currentKeySetDepth = -1;
        String currentKeySet = null;
        ArrayMap<String, PublicKey> publicKeys = new ArrayMap<String, PublicKey>();
        ArraySet<String> upgradeKeySets = new ArraySet<String>();
        ArrayMap definedKeySets = new ArrayMap();
        ArraySet<String> improperKeySets = new ArraySet<String>();
        block22: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String tagName;
            if (type == 3) {
                if (parser.getDepth() != currentKeySetDepth) continue;
                currentKeySet = null;
                currentKeySetDepth = -1;
                continue;
            }
            switch (tagName = parser.getName()) {
                case "key-set": {
                    if (currentKeySet != null) {
                        return input.error("Improperly nested 'key-set' tag at " + parser.getPositionDescription());
                    }
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestKeySet);
                    try {
                        String keysetName = sa.getNonResourceString(0);
                        definedKeySets.put(keysetName, new ArraySet());
                        currentKeySet = keysetName;
                        currentKeySetDepth = parser.getDepth();
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                case "public-key": {
                    if (currentKeySet == null) {
                        return input.error("Improperly nested 'key-set' tag at " + parser.getPositionDescription());
                    }
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestPublicKey);
                    try {
                        String publicKeyName = ParsingPackageUtils.nonResString(0, sa);
                        String encodedKey = ParsingPackageUtils.nonResString(1, sa);
                        if (encodedKey == null && publicKeys.get(publicKeyName) == null) {
                            ParseResult<ParsingPackage> parseResult = input.error("'public-key' " + publicKeyName + " must define a public-key value on first use at " + parser.getPositionDescription());
                            return parseResult;
                        }
                        if (encodedKey != null) {
                            PublicKey currentKey = FrameworkParsingPackageUtils.parsePublicKey(encodedKey);
                            if (currentKey == null) {
                                Slog.w(TAG, "No recognized valid key in 'public-key' tag at " + parser.getPositionDescription() + " key-set " + currentKeySet + " will not be added to the package's defined key-sets.");
                                improperKeySets.add(currentKeySet);
                                XmlUtils.skipCurrentTag(parser);
                                continue block22;
                            }
                            if (publicKeys.get(publicKeyName) == null || ((PublicKey)publicKeys.get(publicKeyName)).equals(currentKey)) {
                                publicKeys.put(publicKeyName, currentKey);
                            } else {
                                ParseResult<ParsingPackage> parseResult = input.error("Value of 'public-key' " + publicKeyName + " conflicts with previously defined value at " + parser.getPositionDescription());
                                return parseResult;
                            }
                        }
                        ((ArraySet)definedKeySets.get(currentKeySet)).add(publicKeyName);
                        XmlUtils.skipCurrentTag(parser);
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                case "upgrade-key-set": {
                    TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUpgradeKeySet);
                    try {
                        String name = sa.getNonResourceString(0);
                        upgradeKeySets.add(name);
                        XmlUtils.skipCurrentTag(parser);
                        continue block22;
                    }
                    finally {
                        sa.recycle();
                        continue block22;
                    }
                }
                default: {
                    ParseResult result = ParsingUtils.unknownTag("<key-sets>", pkg, parser, input);
                    if (!result.isError()) continue block22;
                    return input.error(result);
                }
            }
        }
        String packageName = pkg.getPackageName();
        Set publicKeyNames = publicKeys.keySet();
        if (publicKeyNames.removeAll(definedKeySets.keySet())) {
            return input.error("Package" + packageName + " AndroidManifest.xml 'key-set' and 'public-key' names must be distinct.");
        }
        for (Map.Entry e : definedKeySets.entrySet()) {
            String keySetName = (String)e.getKey();
            if (((ArraySet)e.getValue()).size() == 0) {
                Slog.w(TAG, "Package" + packageName + " AndroidManifest.xml 'key-set' " + keySetName + " has no valid associated 'public-key'. Not including in package's defined key-sets.");
                continue;
            }
            if (improperKeySets.contains(keySetName)) {
                Slog.w(TAG, "Package" + packageName + " AndroidManifest.xml 'key-set' " + keySetName + " contained improper 'public-key' tags. Not including in package's defined key-sets.");
                continue;
            }
            for (String s : (ArraySet)e.getValue()) {
                pkg.addKeySet(keySetName, (PublicKey)publicKeys.get(s));
            }
        }
        if (!pkg.getKeySetMapping().keySet().containsAll(upgradeKeySets)) {
            return input.error("Package" + packageName + " AndroidManifest.xml does not define all 'upgrade-key-set's .");
        }
        pkg.setUpgradeKeySets(upgradeKeySets);
        return input.success(pkg);
    }

    private static ParseResult<ParsingPackage> parseAttribution(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        ParseResult<ParsedAttribution> result = ParsedAttributionUtils.parseAttribution(res, parser, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addAttribution(result.getResult()));
    }

    private static ParseResult<ParsingPackage> parsePermissionGroup(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermissionGroup> result = ParsedPermissionUtils.parsePermissionGroup(pkg, res, parser, sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addPermissionGroup(result.getResult()));
    }

    private static ParseResult<ParsingPackage> parsePermission(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermission> result = ParsedPermissionUtils.parsePermission(pkg, res, parser, sUseRoundIcon, input, flags);
        if (result.isError()) {
            return input.error(result);
        }
        ParsedPermission permission2 = result.getResult();
        if (permission2 != null) {
            pkg.addPermission(permission2);
        }
        return input.success(pkg);
    }

    private static ParseResult<ParsingPackage> parsePermissionTree(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedPermission> result = ParsedPermissionUtils.parsePermissionTree(pkg, res, parser, sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addPermission(result.getResult()));
    }

    private int parseMinOrMaxSdkVersion(TypedArray sa, int attr2, int defaultValue) {
        int val = defaultValue;
        TypedValue peekVal = sa.peekValue(attr2);
        if (peekVal != null && peekVal.type >= 16 && peekVal.type <= 31) {
            val = peekVal.data;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseUsesPermission(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesPermission);
        try {
            ParseResult<ParsingPackage> parseResult;
            int type;
            String name = sa.getNonResourceString(0);
            int minSdkVersion = this.parseMinOrMaxSdkVersion(sa, 1, Integer.MIN_VALUE);
            int maxSdkVersion = this.parseMinOrMaxSdkVersion(sa, 2, Integer.MAX_VALUE);
            ArraySet<String> requiredFeatures = new ArraySet<String>();
            String feature = sa.getNonConfigurationString(3, 0);
            if (feature != null) {
                requiredFeatures.add(feature);
            }
            ArraySet<String> requiredNotFeatures = new ArraySet<String>();
            feature = sa.getNonConfigurationString(4, 0);
            if (feature != null) {
                requiredNotFeatures.add(feature);
            }
            int usesPermissionFlags = sa.getInt(5, 0);
            ArraySet<String> purposes = new ArraySet<String>();
            boolean isPurposesEnabled = com.android.internal.hidden_from_bootclasspath.android.permission.flags.Flags.purposeDeclarationEnabled();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                ParseResult result;
                if (type == 3 || type == 4) continue;
                switch (parser.getName()) {
                    case "required-feature": {
                        result = this.parseRequiredFeature(input, res, parser);
                        if (!result.isSuccess()) break;
                        requiredFeatures.add((String)result.getResult());
                        break;
                    }
                    case "required-not-feature": {
                        result = this.parseRequiredNotFeature(input, res, parser);
                        if (!result.isSuccess()) break;
                        requiredNotFeatures.add((String)result.getResult());
                        break;
                    }
                    case "purpose": {
                        ParseResult parseResult2 = result = isPurposesEnabled ? this.parsePurpose(input, res, parser) : input.success(null);
                        if (!result.isSuccess() || result.getResult() == null) break;
                        purposes.add((String)result.getResult());
                        break;
                    }
                    default: {
                        result = ParsingUtils.unknownTag("<uses-permission>", pkg, parser, input);
                    }
                }
                if (!result.isError()) continue;
                parseResult = input.error(result);
                return parseResult;
            }
            ParseResult<ParsingPackage> success = input.success(pkg);
            if (name == null) {
                parseResult = success;
                return parseResult;
            }
            if (_Original_Build.VERSION.RESOURCES_SDK_INT < minSdkVersion || _Original_Build.VERSION.RESOURCES_SDK_INT > maxSdkVersion) {
                parseResult = success;
                return parseResult;
            }
            if (this.mCallback != null) {
                int i;
                for (i = requiredFeatures.size() - 1; i >= 0; --i) {
                    if (this.mCallback.hasFeature((String)requiredFeatures.valueAt(i))) continue;
                    ParseResult<ParsingPackage> parseResult3 = success;
                    return parseResult3;
                }
                for (i = requiredNotFeatures.size() - 1; i >= 0; --i) {
                    if (!this.mCallback.hasFeature((String)requiredNotFeatures.valueAt(i))) continue;
                    ParseResult<ParsingPackage> parseResult4 = success;
                    return parseResult4;
                }
            }
            boolean found = false;
            List<ParsedUsesPermission> usesPermissions = pkg.getUsesPermissions();
            int size = usesPermissions.size();
            for (int i = 0; i < size; ++i) {
                ParsedUsesPermission usesPermission = usesPermissions.get(i);
                if (!Objects.equals(usesPermission.getName(), name)) continue;
                if (usesPermission.getUsesPermissionFlags() != usesPermissionFlags) {
                    ParseResult<ParsingPackage> parseResult5 = input.error("Conflicting uses-permissions flags: " + name + " in package: " + pkg.getPackageName() + " at: " + parser.getPositionDescription());
                    return parseResult5;
                }
                if (isPurposesEnabled && !Objects.equals(usesPermission.getPurposes(), purposes)) {
                    ParseResult<ParsingPackage> parseResult6 = input.error("Conflicting uses-permissions purposes: " + name + " in package: " + pkg.getPackageName() + " at: " + parser.getPositionDescription());
                    return parseResult6;
                }
                Slog.w(TAG, "Ignoring duplicate uses-permissions/uses-permissions-sdk-m: " + name + " in package: " + pkg.getPackageName() + " at: " + parser.getPositionDescription());
                found = true;
                break;
            }
            if (!found) {
                pkg.addUsesPermission(new ParsedUsesPermissionImpl(name, usesPermissionFlags, purposes));
            }
            ParseResult<ParsingPackage> parseResult7 = success;
            return parseResult7;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<String> parsePurpose(ParseInput input, Resources res, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestPurpose);
        try {
            String purpose = sa.getString(0);
            int minSdkVersion = this.parseMinOrMaxSdkVersion(sa, 1, Integer.MIN_VALUE);
            int maxSdkVersion = this.parseMinOrMaxSdkVersion(sa, 2, Integer.MAX_VALUE);
            ParseResult<String> parseResult = input.success(this.isValidPurpose(purpose, minSdkVersion, maxSdkVersion) ? purpose : null);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private boolean isValidPurpose(String purpose, int minSdkVersion, int maxSdkVersion) {
        return !TextUtils.isEmpty(purpose) && SDK_VERSION >= minSdkVersion && SDK_VERSION <= maxSdkVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<String> parseRequiredFeature(ParseInput input, Resources res, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestRequiredFeature);
        try {
            String featureName = sa.getString(0);
            ParseResult<String> parseResult = TextUtils.isEmpty(featureName) ? input.error("Feature name is missing from <required-feature> tag.") : input.success(featureName);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<String> parseRequiredNotFeature(ParseInput input, Resources res, AttributeSet attrs) {
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestRequiredNotFeature);
        try {
            String featureName = sa.getString(0);
            ParseResult<String> parseResult = TextUtils.isEmpty(featureName) ? input.error("Feature name is missing from <required-not-feature> tag.") : input.success(featureName);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesConfiguration(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        ConfigurationInfo cPref = new ConfigurationInfo();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesConfiguration);
        try {
            cPref.reqTouchScreen = sa.getInt(0, 0);
            cPref.reqKeyboardType = sa.getInt(1, 0);
            if (sa.getBoolean(2, false)) {
                cPref.reqInputFeatures |= 1;
            }
            cPref.reqNavigation = sa.getInt(3, 0);
            if (sa.getBoolean(4, false)) {
                cPref.reqInputFeatures |= 2;
            }
            pkg.addConfigPreference(cPref);
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseUsesFeature(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        FeatureInfo fi = ParsingPackageUtils.parseFeatureInfo(res, parser);
        pkg.addReqFeature(fi);
        if (fi.name == null) {
            ConfigurationInfo cPref = new ConfigurationInfo();
            cPref.reqGlEsVersion = fi.reqGlEsVersion;
            pkg.addConfigPreference(cPref);
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureInfo parseFeatureInfo(Resources res, AttributeSet attrs) {
        FeatureInfo fi = new FeatureInfo();
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestUsesFeature);
        try {
            fi.name = sa.getNonResourceString(0);
            fi.version = sa.getInt(3, 0);
            if (fi.name == null) {
                fi.reqGlEsVersion = sa.getInt(1, 0);
            }
            if (sa.getBoolean(2, true)) {
                fi.flags |= 1;
            }
            FeatureInfo featureInfo = fi;
            return featureInfo;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseFeatureGroup(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        int type;
        FeatureGroupInfo group = new FeatureGroupInfo();
        ArrayList<FeatureInfo> features = null;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            String innerTagName = parser.getName();
            if (innerTagName.equals(TAG_USES_FEATURE)) {
                FeatureInfo featureInfo = ParsingPackageUtils.parseFeatureInfo(res, parser);
                featureInfo.flags |= 1;
                features = ArrayUtils.add(features, featureInfo);
                continue;
            }
            Slog.w(TAG, "Unknown element under <feature-group>: " + innerTagName + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
        }
        if (features != null) {
            group.features = new FeatureInfo[features.size()];
            group.features = features.toArray(group.features);
        }
        pkg.addFeatureGroup(group);
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseUsesSdk(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws IOException, XmlPullParserException {
        if (SDK_VERSION > 0) {
            boolean isApkInApex = (flags & 0x200) != 0;
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdk);
            try {
                int type;
                ParseResult<Integer> targetSdkVersionResult;
                int minVers = 1;
                String minCode = null;
                boolean minAssigned = false;
                int targetVers = 0;
                String targetCode = null;
                int maxVers = Integer.MAX_VALUE;
                TypedValue val = sa.peekValue(0);
                if (val != null) {
                    if (val.type == 3 && val.string != null) {
                        minCode = val.string.toString();
                        minAssigned = !TextUtils.isEmpty(minCode);
                    } else {
                        minVers = val.data;
                        minAssigned = true;
                    }
                }
                if ((val = sa.peekValue(1)) != null) {
                    if (val.type == 3 && val.string != null) {
                        targetCode = val.string.toString();
                        if (!minAssigned) {
                            minCode = targetCode;
                        }
                    } else {
                        targetVers = val.data;
                    }
                } else {
                    targetVers = minVers;
                    targetCode = minCode;
                }
                if (isApkInApex && (val = sa.peekValue(2)) != null) {
                    maxVers = val.data;
                }
                if ((targetSdkVersionResult = FrameworkParsingPackageUtils.computeTargetSdkVersion(targetVers, targetCode, SDK_CODENAMES, input, isApkInApex)).isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(targetSdkVersionResult);
                    return parseResult;
                }
                int targetSdkVersion = targetSdkVersionResult.getResult();
                ParseResult<?> deferResult = input.enableDeferredError(pkg.getPackageName(), targetSdkVersion);
                if (deferResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(deferResult);
                    return parseResult;
                }
                ParseResult<Integer> minSdkVersionResult = FrameworkParsingPackageUtils.computeMinSdkVersion(minVers, minCode, SDK_VERSION, SDK_CODENAMES, input);
                if (minSdkVersionResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(minSdkVersionResult);
                    return parseResult;
                }
                int minSdkVersion = minSdkVersionResult.getResult();
                pkg.setMinSdkVersion(minSdkVersion).setTargetSdkVersion(targetSdkVersion);
                if (isApkInApex) {
                    ParseResult<Integer> maxSdkVersionResult = FrameworkParsingPackageUtils.computeMaxSdkVersion(maxVers, SDK_VERSION, input);
                    if (maxSdkVersionResult.isError()) {
                        ParseResult<ParsingPackage> parseResult = input.error(maxSdkVersionResult);
                        return parseResult;
                    }
                    int maxSdkVersion = maxSdkVersionResult.getResult();
                    pkg.setMaxSdkVersion(maxSdkVersion);
                }
                int innerDepth = parser.getDepth();
                SparseIntArray minExtensionVersions = null;
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    ParseResult<SparseIntArray> result;
                    if (type == 3 || type == 4) continue;
                    if (parser.getName().equals("extension-sdk")) {
                        if (minExtensionVersions == null) {
                            minExtensionVersions = new SparseIntArray();
                        }
                        result = ParsingPackageUtils.parseExtensionSdk(input, res, parser, minExtensionVersions);
                        XmlUtils.skipCurrentTag(parser);
                    } else {
                        result = ParsingUtils.unknownTag("<uses-sdk>", pkg, parser, input);
                    }
                    if (!result.isError()) continue;
                    ParseResult<ParsingPackage> parseResult = input.error(result);
                    return parseResult;
                }
                pkg.setMinExtensionVersions(ParsingPackageUtils.exactSizedCopyOfSparseArray(minExtensionVersions));
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    @Nullable
    private static SparseIntArray exactSizedCopyOfSparseArray(@Nullable SparseIntArray input) {
        if (input == null) {
            return null;
        }
        SparseIntArray output = new SparseIntArray(input.size());
        for (int i = 0; i < input.size(); ++i) {
            output.put(input.keyAt(i), input.valueAt(i));
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<SparseIntArray> parseExtensionSdk(ParseInput input, Resources res, XmlResourceParser parser, SparseIntArray minExtensionVersions) {
        int minVersion;
        int sdkVersion;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestExtensionSdk);
        try {
            sdkVersion = sa.getInt(0, -1);
            minVersion = sa.getInt(1, -1);
        }
        finally {
            sa.recycle();
        }
        if (sdkVersion < 0) {
            return input.error(-108, "<extension-sdk> must specify an sdkVersion >= 0");
        }
        if (minVersion < 0) {
            return input.error(-108, "<extension-sdk> must specify minExtensionVersion >= 0");
        }
        try {
            int version = SdkExtensions.getExtensionVersion(sdkVersion);
            if (version < minVersion) {
                return input.error(-12, "Package requires " + sdkVersion + " extension version " + minVersion + " which exceeds device version " + version);
            }
        }
        catch (RuntimeException e) {
            return input.error(-108, "Specified sdkVersion " + sdkVersion + " is not valid");
        }
        minExtensionVersions.put(sdkVersion, minVersion);
        return input.success(minExtensionVersions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseRestrictUpdateHash(int flags, ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        if ((flags & 0x10) != 0) {
            TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestRestrictUpdate);
            try {
                String hash = sa.getNonConfigurationString(0, 0);
                if (hash != null) {
                    int hashLength = hash.length();
                    byte[] hashBytes = new byte[hashLength / 2];
                    for (int i = 0; i < hashLength; i += 2) {
                        hashBytes[i / 2] = (byte)((Character.digit(hash.charAt(i), 16) << 4) + Character.digit(hash.charAt(i + 1), 16));
                    }
                    pkg.setRestrictUpdateHash(hashBytes);
                } else {
                    pkg.setRestrictUpdateHash(null);
                }
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    private static ParseResult<ParsingPackage> parseInstallConstraints(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, Set<String> allowlist) throws IOException, XmlPullParserException {
        return InstallConstraintsTagParser.parseInstallConstraints(input, pkg, res, parser, allowlist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseQueries(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws IOException, XmlPullParserException {
        int type;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            TypedArray sa;
            Object data;
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals("intent")) {
                ParseResult<ParsedIntentInfoImpl> result = ParsedIntentInfoUtils.parseIntentInfo(null, pkg, res, parser, true, true, input);
                if (result.isError()) {
                    return input.error(result);
                }
                IntentFilter intentInfo = result.getResult().getIntentFilter();
                data = null;
                String dataType = null;
                String host = null;
                int numActions = intentInfo.countActions();
                int numSchemes = intentInfo.countDataSchemes();
                int numTypes = intentInfo.countDataTypes();
                int numHosts = intentInfo.getHosts().length;
                if (numSchemes == 0 && numTypes == 0 && numActions == 0) {
                    return input.error("intent tags must contain either an action or data.");
                }
                if (numActions > 1) {
                    return input.error("intent tag may have at most one action.");
                }
                if (numTypes > 1) {
                    return input.error("intent tag may have at most one data type.");
                }
                if (numSchemes > 1) {
                    return input.error("intent tag may have at most one data scheme.");
                }
                if (numHosts > 1) {
                    return input.error("intent tag may have at most one data host.");
                }
                Intent intent = new Intent();
                int max = intentInfo.countCategories();
                for (int i = 0; i < max; ++i) {
                    intent.addCategory(intentInfo.getCategory(i));
                }
                if (numHosts == 1) {
                    host = intentInfo.getHosts()[0];
                }
                if (numSchemes == 1) {
                    data = new Uri.Builder().scheme(intentInfo.getDataScheme(0)).authority(host).path("/*").build();
                }
                if (numTypes == 1) {
                    dataType = intentInfo.getDataType(0);
                    if (!dataType.contains("/")) {
                        dataType = dataType + "/*";
                    }
                    if (data == null) {
                        data = new Uri.Builder().scheme("content").authority("*").path("/*").build();
                    }
                }
                intent.setDataAndType((Uri)data, dataType);
                if (numActions == 1) {
                    intent.setAction(intentInfo.getAction(0));
                }
                pkg.addQueriesIntent(intent);
                continue;
            }
            if (parser.getName().equals(TAG_PACKAGE)) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestQueriesPackage);
                try {
                    String packageName = sa.getNonConfigurationString(0, 0);
                    if (TextUtils.isEmpty(packageName)) {
                        data = input.error("Package name is missing from package tag.");
                        return data;
                    }
                    pkg.addQueriesPackage(packageName.intern());
                    continue;
                }
                finally {
                    sa.recycle();
                    continue;
                }
            }
            if (!parser.getName().equals("provider")) continue;
            sa = res.obtainAttributes(parser, R.styleable.AndroidManifestQueriesProvider);
            try {
                String authorities = sa.getNonConfigurationString(0, 0);
                if (TextUtils.isEmpty(authorities)) {
                    data = input.error(-108, "Authority missing from provider tag.");
                    return data;
                }
                StringTokenizer authoritiesTokenizer = new StringTokenizer(authorities, ";");
                while (authoritiesTokenizer.hasMoreElements()) {
                    pkg.addQueriesProvider(authoritiesTokenizer.nextToken());
                }
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult<ParsingPackage> parseBaseApplication(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags, boolean shouldSkipComponents) throws XmlPullParserException, IOException {
        int type;
        String pkgName = pkg.getPackageName();
        int targetSdk = pkg.getTargetSdkVersion();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestApplication);
        try {
            ParseResult<Set<String>> knownActivityEmbeddingCertsResult;
            String pname;
            ParseResult<String> processNameResult;
            TypedValue labelValue;
            if (sa == null) {
                ParseResult<ParsingPackage> parseResult = input.error("<application> does not contain any attributes");
                return parseResult;
            }
            String name = sa.getNonConfigurationString(3, 0);
            if (name != null) {
                String packageName = pkg.getPackageName();
                String outInfoName = ParsingUtils.buildClassName(packageName, name);
                if (PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME.equals(outInfoName)) {
                    ParseResult<ParsingPackage> parseResult = input.error("<application> invalid android:name");
                    return parseResult;
                }
                if (outInfoName == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + packageName);
                    return parseResult;
                }
                pkg.setApplicationClassName(outInfoName);
            }
            if ((labelValue = sa.peekValue(1)) != null) {
                pkg.setLabelResourceId(labelValue.resourceId);
                if (labelValue.resourceId == 0) {
                    pkg.setNonLocalizedLabel(labelValue.coerceToString());
                }
            }
            this.parseBaseAppBasicFlags(pkg, sa);
            String manageSpaceActivity = ParsingPackageUtils.nonConfigString(1024, 4, sa);
            if (manageSpaceActivity != null) {
                String manageSpaceActivityName = ParsingUtils.buildClassName(pkgName, manageSpaceActivity);
                if (manageSpaceActivityName == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                    return parseResult;
                }
                pkg.setManageSpaceActivityName(manageSpaceActivityName);
            }
            if (com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags.changeLauncherBadging()) {
                ParseResult<int[]> result = ParsingPackageUtils.drawableResIdArray(input, sa, res, 78, 500);
                if (result.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(result);
                    return parseResult;
                }
                pkg.setAlternateLauncherIconResIds(result.getResult());
                result = ParsingPackageUtils.stringResIdArray(input, sa, res, 79, 500);
                if (result.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(result);
                    return parseResult;
                }
                pkg.setAlternateLauncherLabelResIds(result.getResult());
            }
            if (pkg.isBackupAllowed()) {
                String backupAgent = ParsingPackageUtils.nonConfigString(1024, 16, sa);
                if (backupAgent != null) {
                    String backupAgentName = ParsingUtils.buildClassName(pkgName, backupAgent);
                    if (backupAgentName == null) {
                        ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                        return parseResult;
                    }
                    pkg.setBackupAgentName(backupAgentName).setFullBackupOnly(ParsingPackageUtils.bool(false, 32, sa)).setBackupInForeground(ParsingPackageUtils.bool(false, 40, sa));
                }
                pkg.setKillAfterRestoreAllowed(ParsingPackageUtils.bool(true, 18, sa)).setRestoreAnyVersion(ParsingPackageUtils.bool(false, 21, sa));
                TypedValue v = sa.peekValue(35);
                int fullBackupContent = 0;
                if (v != null) {
                    fullBackupContent = v.resourceId;
                    if (v.resourceId == 0) {
                        fullBackupContent = v.data == 0 ? -1 : 0;
                    }
                    pkg.setFullBackupContentResourceId(fullBackupContent);
                }
            }
            if (sa.getBoolean(8, false)) {
                String requiredFeature = sa.getNonResourceString(45);
                pkg.setPersistent(requiredFeature == null || this.mCallback.hasFeature(requiredFeature));
            }
            if (sa.hasValueOrEmpty(37)) {
                pkg.setResizeableActivity(sa.getBoolean(37, true));
            } else {
                pkg.setResizeableActivityViaSdkVersion(targetSdk >= 24);
            }
            String taskAffinity = targetSdk >= 8 ? sa.getNonConfigurationString(12, 1024) : sa.getNonResourceString(12);
            ParseResult<String> taskAffinityResult = ComponentParseUtils.buildTaskAffinityName(pkgName, pkgName, taskAffinity, input);
            if (taskAffinityResult.isError()) {
                ParseResult<ParsingPackage> fullBackupContent = input.error(taskAffinityResult);
                return fullBackupContent;
            }
            pkg.setTaskAffinity(taskAffinityResult.getResult());
            String factory = sa.getNonResourceString(48);
            if (factory != null) {
                String appComponentFactory = ParsingUtils.buildClassName(pkgName, factory);
                if (appComponentFactory == null) {
                    ParseResult<ParsingPackage> parseResult = input.error("Empty class name in package " + pkgName);
                    return parseResult;
                }
                pkg.setAppComponentFactory(appComponentFactory);
            }
            if ((processNameResult = ComponentParseUtils.buildProcessName(pkgName, null, pname = targetSdk >= 8 ? sa.getNonConfigurationString(11, 1024) : sa.getNonResourceString(11), flags, this.mSeparateProcesses, input)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(processNameResult);
                return parseResult;
            }
            String processName = processNameResult.getResult();
            pkg.setProcessName(processName);
            if (pkg.isSaveStateDisallowed() && processName != null && !processName.equals(pkgName)) {
                ParseResult<ParsingPackage> parseResult = input.error("cantSaveState applications can not use custom processes");
                return parseResult;
            }
            String classLoaderName = pkg.getClassLoaderName();
            if (classLoaderName != null && !ClassLoaderFactory.isValidClassLoaderName(classLoaderName)) {
                ParseResult<ParsingPackage> parseResult = input.error("Invalid class loader name: " + classLoaderName);
                return parseResult;
            }
            pkg.setGwpAsanMode(sa.getInt(62, -1));
            pkg.setMemtagMode(sa.getInt(64, -1));
            if (com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags.appCompatOption16kb()) {
                pkg.setPageSizeAppCompatFlags(sa.getInt(76, 0));
            }
            if (sa.hasValue(65)) {
                boolean v = sa.getBoolean(65, false);
                pkg.setNativeHeapZeroInitialized(v ? 1 : 0);
            }
            if (sa.hasValue(67)) {
                pkg.setRequestRawExternalStorageAccess(sa.getBoolean(67, false));
            }
            if (sa.hasValue(68)) {
                pkg.setRequestForegroundServiceExemption(sa.getBoolean(68, false));
            }
            if ((knownActivityEmbeddingCertsResult = ParsingUtils.parseKnownActivityEmbeddingCerts(sa, res, 72, input)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(knownActivityEmbeddingCertsResult);
                return parseResult;
            }
            Set<String> knownActivityEmbeddingCerts = knownActivityEmbeddingCertsResult.getResult();
            if (knownActivityEmbeddingCerts != null) {
                pkg.setKnownActivityEmbeddingCerts(knownActivityEmbeddingCerts);
            }
            pkg.setIntentMatchingFlags(sa.getInt(75, 0));
        }
        finally {
            sa.recycle();
        }
        boolean hasActivityOrder = false;
        boolean hasReceiverOrder = false;
        boolean hasServiceOrder = false;
        int depth = parser.getDepth();
        block32: while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<Object> result;
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            String tagName = parser.getName();
            boolean isActivity = false;
            switch (tagName) {
                case "activity": {
                    isActivity = true;
                }
                case "receiver": {
                    if (shouldSkipComponents) continue block32;
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityOrReceiver(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, null, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        if (isActivity) {
                            hasActivityOrder |= activity.getOrder() != 0;
                            pkg.addActivity(activity);
                        } else {
                            hasReceiverOrder |= activity.getOrder() != 0;
                            pkg.addReceiver(activity);
                        }
                    }
                    result = activityResult;
                    break;
                }
                case "service": {
                    if (shouldSkipComponents) continue block32;
                    ParseResult<ParsedService> serviceResult = ParsedServiceUtils.parseService(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, null, input);
                    if (serviceResult.isSuccess()) {
                        ParsedService service = serviceResult.getResult();
                        hasServiceOrder |= service.getOrder() != 0;
                        pkg.addService(service);
                    }
                    result = serviceResult;
                    break;
                }
                case "provider": {
                    if (shouldSkipComponents) continue block32;
                    ParseResult<ParsedProvider> providerResult = ParsedProviderUtils.parseProvider(this.mSeparateProcesses, pkg, res, parser, flags, sUseRoundIcon, null, input);
                    if (providerResult.isSuccess()) {
                        pkg.addProvider(providerResult.getResult());
                    }
                    result = providerResult;
                    break;
                }
                case "activity-alias": {
                    if (shouldSkipComponents) continue block32;
                    ParseResult<ParsedActivity> activityResult = ParsedActivityUtils.parseActivityAlias(pkg, res, parser, sUseRoundIcon, null, input);
                    if (activityResult.isSuccess()) {
                        ParsedActivity activity = activityResult.getResult();
                        hasActivityOrder |= activity.getOrder() != 0;
                        pkg.addActivity(activity);
                    }
                    result = activityResult;
                    break;
                }
                case "apex-system-service": {
                    ParseResult<ParsedApexSystemService> systemServiceResult = ParsedApexSystemServiceUtils.parseApexSystemService(res, parser, input);
                    if (systemServiceResult.isSuccess()) {
                        ParsedApexSystemService systemService = systemServiceResult.getResult();
                        pkg.addApexSystemService(systemService);
                    }
                    result = systemServiceResult;
                    break;
                }
                default: {
                    result = this.parseBaseAppChildTag(input, tagName, pkg, res, parser, flags);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        if (TextUtils.isEmpty(pkg.getStaticSharedLibraryName()) && TextUtils.isEmpty(pkg.getSdkLibraryName())) {
            ParseResult<ParsedActivity> a = ParsingPackageUtils.generateAppDetailsHiddenActivity(input, pkg);
            if (a.isError()) {
                return input.error(a);
            }
            pkg.addActivity(a.getResult());
        }
        if (hasActivityOrder) {
            pkg.sortActivities();
        }
        if (hasReceiverOrder) {
            pkg.sortReceivers();
        }
        if (hasServiceOrder) {
            pkg.sortServices();
        }
        this.afterParseBaseApplication(pkg);
        return input.success(pkg);
    }

    private void afterParseBaseApplication(ParsingPackage pkg) {
        ParsingPackageUtils.setMaxAspectRatio(pkg);
        this.setMinAspectRatio(pkg);
        this.setSupportsSizeChanges(pkg);
        pkg.setHasDomainUrls(ParsingPackageUtils.hasDomainURLs(pkg));
    }

    private void parseBaseAppBasicFlags(ParsingPackage pkg, TypedArray sa) {
        int targetSdk = pkg.getTargetSdkVersion();
        pkg.setBackupAllowed(ParsingPackageUtils.bool(true, 17, sa)).setClearUserDataAllowed(ParsingPackageUtils.bool(true, 5, sa)).setClearUserDataOnFailedRestoreAllowed(ParsingPackageUtils.bool(true, 54, sa)).setAllowNativeHeapPointerTagging(ParsingPackageUtils.bool(true, 59, sa)).setEnabled(ParsingPackageUtils.bool(true, 9, sa)).setExtractNativeLibrariesRequested(ParsingPackageUtils.bool(true, 34, sa)).setDeclaredHavingCode(ParsingPackageUtils.bool(true, 7, sa)).setTaskReparentingAllowed(ParsingPackageUtils.bool(false, 14, sa)).setSaveStateDisallowed(ParsingPackageUtils.bool(false, 47, sa)).setCrossProfile(ParsingPackageUtils.bool(false, 58, sa)).setDebuggable(ParsingPackageUtils.bool(false, 10, sa)).setDefaultToDeviceProtectedStorage(ParsingPackageUtils.bool(false, 38, sa)).setDirectBootAware(ParsingPackageUtils.bool(false, 39, sa)).setForceQueryable(ParsingPackageUtils.bool(false, 57, sa)).setGame(ParsingPackageUtils.bool(false, 31, sa)).setUserDataFragile(ParsingPackageUtils.bool(false, 50, sa)).setLargeHeap(ParsingPackageUtils.bool(false, 24, sa)).setMultiArch(ParsingPackageUtils.bool(false, 33, sa)).setPreserveLegacyExternalStorage(ParsingPackageUtils.bool(false, 61, sa)).setRequiredForAllUsers(ParsingPackageUtils.bool(false, 27, sa)).setRtlSupported(ParsingPackageUtils.bool(false, 26, sa)).setTestOnly(ParsingPackageUtils.bool(false, 15, sa)).setUseEmbeddedDex(ParsingPackageUtils.bool(false, 53, sa)).setNonSdkApiRequested(ParsingPackageUtils.bool(false, 49, sa)).setVmSafeMode(ParsingPackageUtils.bool(false, 20, sa)).setAutoRevokePermissions(ParsingPackageUtils.anInt(60, sa)).setAttributionsAreUserVisible(ParsingPackageUtils.bool(false, 69, sa)).setResetEnabledSettingsOnAppDataCleared(ParsingPackageUtils.bool(false, 70, sa)).setAllowAudioPlaybackCapture(ParsingPackageUtils.bool(targetSdk >= 29, 55, sa)).setHardwareAccelerated(ParsingPackageUtils.bool(targetSdk >= 14, 23, sa)).setRequestLegacyExternalStorage(ParsingPackageUtils.bool(targetSdk < 29, 56, sa)).setCleartextTrafficAllowed(ParsingPackageUtils.bool(targetSdk < 28, 36, sa)).setOnBackInvokedCallbackEnabled(ParsingPackageUtils.bool(Flags.predictiveBackDefaultEnableSdk36() && targetSdk > 35, 73, sa)).setUiOptions(ParsingPackageUtils.anInt(25, sa)).setCategory(ParsingPackageUtils.anInt(-1, 43, sa)).setMaxAspectRatio(ParsingPackageUtils.aFloat(44, sa)).setMinAspectRatio(ParsingPackageUtils.aFloat(51, sa)).setBannerResourceId(ParsingPackageUtils.resId(30, sa)).setDescriptionResourceId(ParsingPackageUtils.resId(13, sa)).setIconResourceId(ParsingPackageUtils.resId(2, sa)).setLogoResourceId(ParsingPackageUtils.resId(22, sa)).setNetworkSecurityConfigResourceId(ParsingPackageUtils.resId(41, sa)).setRoundIconResourceId(ParsingPackageUtils.resId(42, sa)).setThemeResourceId(ParsingPackageUtils.resId(0, sa)).setDataExtractionRulesResourceId(ParsingPackageUtils.resId(66, sa)).setLocaleConfigResourceId(ParsingPackageUtils.resId(71, sa)).setClassLoaderName(ParsingPackageUtils.string(46, sa)).setRequiredAccountType(ParsingPackageUtils.string(29, sa)).setRestrictedAccountType(ParsingPackageUtils.string(28, sa)).setZygotePreloadName(ParsingPackageUtils.string(52, sa)).setPermission(ParsingPackageUtils.nonConfigString(0, 6, sa)).setAllowCrossUidActivitySwitchFromBelow(ParsingPackageUtils.bool(true, 74, sa));
    }

    private ParseResult parseBaseAppChildTag(ParseInput input, String tag, ParsingPackage pkg, Resources res, XmlResourceParser parser, int flags) throws IOException, XmlPullParserException {
        switch (tag) {
            case "meta-data": {
                ParseResult<PackageManager.Property> metaDataResult = ParsingPackageUtils.parseMetaData(pkg, null, res, parser, "<meta-data>", input);
                if (metaDataResult.isSuccess() && metaDataResult.getResult() != null) {
                    pkg.setMetaData(metaDataResult.getResult().toBundle(pkg.getMetaData()));
                }
                return metaDataResult;
            }
            case "property": {
                ParseResult<PackageManager.Property> propertyResult = ParsingPackageUtils.parseMetaData(pkg, null, res, parser, "<property>", input);
                if (propertyResult.isSuccess()) {
                    pkg.addProperty(propertyResult.getResult());
                }
                return propertyResult;
            }
            case "sdk-library": {
                return ParsingPackageUtils.parseSdkLibrary(pkg, res, parser, input);
            }
            case "static-library": {
                return ParsingPackageUtils.parseStaticLibrary(pkg, res, parser, input);
            }
            case "library": {
                return ParsingPackageUtils.parseLibrary(pkg, res, parser, input);
            }
            case "uses-sdk-library": {
                return ParsingPackageUtils.parseUsesSdkLibrary(input, pkg, res, parser);
            }
            case "uses-static-library": {
                return ParsingPackageUtils.parseUsesStaticLibrary(input, pkg, res, parser);
            }
            case "uses-library": {
                return ParsingPackageUtils.parseUsesLibrary(input, pkg, res, parser);
            }
            case "uses-native-library": {
                return ParsingPackageUtils.parseUsesNativeLibrary(input, pkg, res, parser);
            }
            case "processes": {
                return ParsingPackageUtils.parseProcesses(input, pkg, res, parser, this.mSeparateProcesses, flags);
            }
            case "uses-package": {
                return input.success(null);
            }
            case "profileable": {
                return ParsingPackageUtils.parseProfileable(input, pkg, res, parser);
            }
        }
        return ParsingUtils.unknownTag("<application>", pkg, parser, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseSdkLibrary(ParsingPackage pkg, Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSdkLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            int versionMajor = sa.getInt(1, -1);
            if (lname == null || versionMajor < 0) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad sdk-library declaration name: " + lname + " version: " + versionMajor);
                return parseResult;
            }
            if (pkg.getSharedUserId() != null) {
                ParseResult<ParsingPackage> parseResult = input.error(-107, "sharedUserId not allowed in SDK library");
                return parseResult;
            }
            if (pkg.getSdkLibraryName() != null) {
                ParseResult<ParsingPackage> parseResult = input.error("Multiple SDKs for package " + pkg.getPackageName());
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setSdkLibraryName(lname.intern()).setSdkLibVersionMajor(versionMajor).setSdkLibrary(true));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseStaticLibrary(ParsingPackage pkg, Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestStaticLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            int version = sa.getInt(1, -1);
            int versionMajor = sa.getInt(2, 0);
            if (lname == null || version < 0) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad static-library declaration name: " + lname + " version: " + version);
                return parseResult;
            }
            if (pkg.getSharedUserId() != null) {
                ParseResult<ParsingPackage> parseResult = input.error(-107, "sharedUserId not allowed in static shared library");
                return parseResult;
            }
            if (pkg.getStaticSharedLibraryName() != null) {
                ParseResult<ParsingPackage> parseResult = input.error("Multiple static-shared libs for package " + pkg.getPackageName());
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setStaticSharedLibraryName(lname.intern()).setStaticSharedLibraryVersion(PackageInfo.composeLongVersionCode(versionMajor, version)).setStaticSharedLibrary(true));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseLibrary(ParsingPackage pkg, Resources res, XmlResourceParser parser, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            if (lname != null) {
                lname = lname.intern();
                if (!ArrayUtils.contains(pkg.getLibraryNames(), lname)) {
                    pkg.addLibraryName(lname);
                }
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseUsesSdkLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesSdkLibrary);
        try {
            ParseResult<String[]> certResult;
            String lname = sa.getNonResourceString(0);
            int versionMajor = sa.getInt(2, -1);
            String certSha256Digest = sa.getNonResourceString(1);
            boolean optional = sa.getBoolean(3, false);
            if (lname == null || versionMajor < 0 || certSha256Digest == null) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad uses-sdk-library declaration name: " + lname + " version: " + versionMajor + " certDigest" + certSha256Digest);
                return parseResult;
            }
            List<String> usesSdkLibraries = pkg.getUsesSdkLibraries();
            if (usesSdkLibraries.contains(lname)) {
                ParseResult<ParsingPackage> parseResult = input.error("Depending on multiple versions of SDK library " + lname);
                return parseResult;
            }
            lname = lname.intern();
            if ("".equals(certSha256Digest = certSha256Digest.replace(":", "").toLowerCase())) {
                certSha256Digest = SystemProperties.get("debug.pm.uses_sdk_library_default_cert_digest", "");
                try {
                    HexEncoding.decode(certSha256Digest, false);
                }
                catch (IllegalArgumentException e) {
                    certSha256Digest = "";
                }
            }
            if ((certResult = ParsingPackageUtils.parseAdditionalCertificates(input, pkg, res, parser)).isError()) {
                ParseResult<ParsingPackage> parseResult = input.error(certResult);
                return parseResult;
            }
            String[] additionalCertSha256Digests = certResult.getResult();
            String[] certSha256Digests = new String[additionalCertSha256Digests.length + 1];
            certSha256Digests[0] = certSha256Digest;
            System.arraycopy(additionalCertSha256Digests, 0, certSha256Digests, 1, additionalCertSha256Digests.length);
            ParseResult<ParsingPackage> parseResult = input.success(pkg.addUsesSdkLibrary(lname, versionMajor, certSha256Digests, optional));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseUsesStaticLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesStaticLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            int version = sa.getInt(1, -1);
            String certSha256Digest = sa.getNonResourceString(2);
            if (lname == null || version < 0 || certSha256Digest == null) {
                ParseResult<ParsingPackage> parseResult = input.error("Bad uses-static-library declaration name: " + lname + " version: " + version + " certDigest" + certSha256Digest);
                return parseResult;
            }
            List<String> usesStaticLibraries = pkg.getUsesStaticLibraries();
            if (usesStaticLibraries.contains(lname)) {
                ParseResult<ParsingPackage> parseResult = input.error("Depending on multiple versions of static library " + lname);
                return parseResult;
            }
            lname = lname.intern();
            certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
            String[] additionalCertSha256Digests = EmptyArray.STRING;
            if (pkg.getTargetSdkVersion() >= 27) {
                ParseResult<String[]> certResult = ParsingPackageUtils.parseAdditionalCertificates(input, pkg, res, parser);
                if (certResult.isError()) {
                    ParseResult<ParsingPackage> parseResult = input.error(certResult);
                    return parseResult;
                }
                additionalCertSha256Digests = certResult.getResult();
            }
            String[] certSha256Digests = new String[additionalCertSha256Digests.length + 1];
            certSha256Digests[0] = certSha256Digest;
            System.arraycopy(additionalCertSha256Digests, 0, certSha256Digests, 1, additionalCertSha256Digests.length);
            ParseResult<ParsingPackage> parseResult = input.success(pkg.addUsesStaticLibrary(lname, version, certSha256Digests));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseUsesLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            boolean req = sa.getBoolean(1, true);
            if (lname != null) {
                lname = lname.intern();
                if (req) {
                    pkg.addUsesLibrary(lname).removeUsesOptionalLibrary(lname);
                } else if (!ArrayUtils.contains(pkg.getUsesLibraries(), lname)) {
                    pkg.addUsesOptionalLibrary(lname);
                }
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseUsesNativeLibrary(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestUsesNativeLibrary);
        try {
            String lname = sa.getNonResourceString(0);
            boolean req = sa.getBoolean(1, true);
            if (lname != null) {
                if (req) {
                    pkg.addUsesNativeLibrary(lname).removeUsesOptionalNativeLibrary(lname);
                } else if (!ArrayUtils.contains(pkg.getUsesNativeLibraries(), lname)) {
                    pkg.addUsesOptionalNativeLibrary(lname);
                }
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    @NonNull
    private static ParseResult<ParsingPackage> parseProcesses(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, String[] separateProcesses, int flags) throws IOException, XmlPullParserException {
        ParseResult<ArrayMap<String, ParsedProcess>> result = ParsedProcessUtils.parseProcesses(separateProcesses, pkg, res, parser, flags, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.setProcesses((Map<String, ParsedProcess>)result.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static ParseResult<ParsingPackage> parseProfileable(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProfileable);
        try {
            ParsingPackage newPkg = pkg.setProfileableByShell(pkg.isProfileableByShell() || ParsingPackageUtils.bool(false, 1, sa));
            ParseResult<ParsingPackage> parseResult = input.success(newPkg.setProfileable(newPkg.isProfileable() && ParsingPackageUtils.bool(true, 0, sa)));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<String[]> parseAdditionalCertificates(ParseInput input, ParsingPackage pkg, Resources resources, XmlResourceParser parser) throws XmlPullParserException, IOException {
        int type;
        String[] certSha256Digests = EmptyArray.STRING;
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            if (type != 2) continue;
            if (sAconfigFlags.skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            String nodeName = parser.getName();
            if (!nodeName.equals("additional-certificate")) continue;
            TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestAdditionalCertificate);
            try {
                String certSha256Digest = sa.getNonResourceString(0);
                if (TextUtils.isEmpty(certSha256Digest)) {
                    ParseResult<String[]> parseResult = input.error("Bad additional-certificate declaration with empty certDigest:" + certSha256Digest);
                    return parseResult;
                }
                certSha256Digest = certSha256Digest.replace(":", "").toLowerCase();
                certSha256Digests = ArrayUtils.appendElement(String.class, certSha256Digests, certSha256Digest);
            }
            finally {
                sa.recycle();
            }
        }
        return input.success(certSha256Digests);
    }

    @NonNull
    private static ParseResult<ParsedActivity> generateAppDetailsHiddenActivity(ParseInput input, ParsingPackage pkg) {
        String packageName = pkg.getPackageName();
        ParseResult<String> result = ComponentParseUtils.buildTaskAffinityName(packageName, packageName, ":app_details", input);
        if (result.isError()) {
            return input.error(result);
        }
        String taskAffinity = result.getResult();
        return input.success(ParsedActivityImpl.makeAppDetailsActivity(packageName, pkg.getProcessName(), pkg.getUiOptions(), taskAffinity, pkg.isHardwareAccelerated()));
    }

    private static boolean hasDomainURLs(ParsingPackage pkg) {
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            List<ParsedIntentInfo> filters = activity.getIntents();
            int filtersSize = filters.size();
            for (int filtersIndex = 0; filtersIndex < filtersSize; ++filtersIndex) {
                IntentFilter aii = filters.get(filtersIndex).getIntentFilter();
                if (!aii.hasAction("android.intent.action.VIEW") || !aii.hasAction("android.intent.action.VIEW") || !aii.hasDataScheme("http") && !aii.hasDataScheme("https")) continue;
                return true;
            }
        }
        return false;
    }

    private static void setMaxAspectRatio(ParsingPackage pkg) {
        float maxAspectRatio = pkg.getTargetSdkVersion() < 26 ? 1.86f : 0.0f;
        float packageMaxAspectRatio = pkg.getMaxAspectRatio();
        if (packageMaxAspectRatio != 0.0f) {
            maxAspectRatio = packageMaxAspectRatio;
        } else {
            Bundle appMetaData = pkg.getMetaData();
            if (appMetaData != null && appMetaData.containsKey(METADATA_MAX_ASPECT_RATIO)) {
                maxAspectRatio = appMetaData.getFloat(METADATA_MAX_ASPECT_RATIO, maxAspectRatio);
            }
        }
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (activity.getMaxAspectRatio() != -1.0f) continue;
            float activityAspectRatio = activity.getMetaData().getFloat(METADATA_MAX_ASPECT_RATIO, maxAspectRatio);
            ComponentMutateUtils.setMaxAspectRatio(activity, activity.getResizeMode(), activityAspectRatio);
        }
    }

    private void setMinAspectRatio(ParsingPackage pkg) {
        float minAspectRatio = pkg.getMinAspectRatio();
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (activity.getMinAspectRatio() != -1.0f) continue;
            ComponentMutateUtils.setMinAspectRatio(activity, activity.getResizeMode(), minAspectRatio);
        }
    }

    private void setSupportsSizeChanges(ParsingPackage pkg) {
        Bundle appMetaData = pkg.getMetaData();
        boolean supportsSizeChanges = appMetaData != null && appMetaData.getBoolean(METADATA_SUPPORTS_SIZE_CHANGES, false);
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            if (!supportsSizeChanges && !activity.getMetaData().getBoolean(METADATA_SUPPORTS_SIZE_CHANGES, false)) continue;
            ComponentMutateUtils.setSupportsSizeChanges(activity, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseOverlay(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestResourceOverlay);
        try {
            String propValue;
            String target = sa.getString(1);
            int priority = ParsingPackageUtils.anInt(0, 0, sa);
            if (target == null) {
                ParseResult<ParsingPackage> parseResult = input.error("<overlay> does not specify a target package");
                return parseResult;
            }
            if (priority < 0 || priority > 9999) {
                ParseResult<ParsingPackage> parseResult = input.error("<overlay> priority must be between 0 and 9999");
                return parseResult;
            }
            String propName = sa.getString(5);
            if (!FrameworkParsingPackageUtils.checkRequiredSystemProperties(propName, propValue = sa.getString(6))) {
                String message = "Skipping target and overlay pair " + target + " and " + pkg.getBaseApkPath() + ": overlay ignored due to required system property: " + propName + " with value: " + propValue;
                Slog.i(TAG, message);
                ParseResult<ParsingPackage> parseResult = input.skip(message);
                return parseResult;
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setResourceOverlay(true).setOverlayTarget(target).setOverlayPriority(priority).setOverlayTargetOverlayableName(sa.getString(3)).setOverlayCategory(sa.getString(2)).setOverlayIsStatic(ParsingPackageUtils.bool(false, 4, sa)));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseProtectedBroadcast(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestProtectedBroadcast);
        try {
            String name = ParsingPackageUtils.nonResString(0, sa);
            if (name != null) {
                pkg.addProtectedBroadcast(name);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseSupportScreens(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestSupportsScreens);
        try {
            int requiresSmallestWidthDp = ParsingPackageUtils.anInt(0, 6, sa);
            int compatibleWidthLimitDp = ParsingPackageUtils.anInt(0, 7, sa);
            int largestWidthLimitDp = ParsingPackageUtils.anInt(0, 8, sa);
            ParseResult<ParsingPackage> parseResult = input.success(pkg.setSmallScreensSupported(ParsingPackageUtils.anInt(1, 1, sa)).setNormalScreensSupported(ParsingPackageUtils.anInt(1, 2, sa)).setLargeScreensSupported(ParsingPackageUtils.anInt(1, 3, sa)).setExtraLargeScreensSupported(ParsingPackageUtils.anInt(1, 5, sa)).setResizeable(ParsingPackageUtils.anInt(1, 4, sa)).setAnyDensity(ParsingPackageUtils.anInt(1, 0, sa)).setRequiresSmallestWidthDp(requiresSmallestWidthDp).setCompatibleWidthLimitDp(compatibleWidthLimitDp).setLargestWidthLimitDp(largestWidthLimitDp));
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static ParseResult<ParsingPackage> parseInstrumentation(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        ParseResult<ParsedInstrumentation> result = ParsedInstrumentationUtils.parseInstrumentation(pkg, res, parser, sUseRoundIcon, input);
        if (result.isError()) {
            return input.error(result);
        }
        return input.success(pkg.addInstrumentation(result.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseOriginalPackage(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestOriginalPackage);
        try {
            String orig = sa.getNonConfigurationString(0, 0);
            if (!pkg.getPackageName().equals(orig)) {
                pkg.addOriginalPackage(orig);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsingPackage> parseAdoptPermissions(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestAdoptPermissions);
        try {
            String name = ParsingPackageUtils.nonConfigString(0, 0, sa);
            if (name != null) {
                pkg.addAdoptPermission(name);
            }
            ParseResult<ParsingPackage> parseResult = input.success(pkg);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static void convertCompatPermissions(ParsingPackage pkg) {
        for (CompatibilityPermissionInfo info : CompatibilityPermissionInfo.COMPAT_PERMS) {
            if (pkg.getTargetSdkVersion() >= info.getSdkVersion()) break;
            if (pkg.getRequestedPermissions().contains(info.getName())) continue;
            pkg.addImplicitPermission(info.getName());
        }
    }

    private void convertSplitPermissions(ParsingPackage pkg) {
        int listSize = this.mSplitPermissionInfos.size();
        for (int is = 0; is < listSize; ++is) {
            PermissionManager.SplitPermissionInfo spi = this.mSplitPermissionInfos.get(is);
            Set<String> requestedPermissions = pkg.getRequestedPermissions();
            if (pkg.getTargetSdkVersion() >= spi.getTargetSdk() || !requestedPermissions.contains(spi.getSplitPermission())) continue;
            List<String> newPerms = spi.getNewPermissions();
            for (int in = 0; in < newPerms.size(); ++in) {
                String perm = newPerms.get(in);
                if (requestedPermissions.contains(perm)) continue;
                pkg.addImplicitPermission(perm);
            }
        }
    }

    private static void adjustPackageToBeUnresizeableAndUnpipable(ParsingPackage pkg) {
        List<ParsedActivity> activities = pkg.getActivities();
        int activitiesSize = activities.size();
        for (int index = 0; index < activitiesSize; ++index) {
            ParsedActivity activity = activities.get(index);
            ComponentMutateUtils.setResizeMode(activity, 0);
            ComponentMutateUtils.setExactFlags(activity, activity.getFlags() & 0xFFBFFFFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<PackageManager.Property> parseMetaData(ParsingPackage pkg, ParsedComponent component, Resources res, XmlResourceParser parser, String tagName, ParseInput input) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestMetaData);
        try {
            PackageManager.Property property;
            String name = TextUtils.safeIntern(ParsingPackageUtils.nonConfigString(0, 0, sa));
            if (name == null) {
                ParseResult<PackageManager.Property> parseResult = input.error(tagName + " requires an android:name attribute");
                return parseResult;
            }
            String packageName = pkg.getPackageName();
            String className = component != null ? component.getName() : null;
            TypedValue v = sa.peekValue(2);
            if (v != null && v.resourceId != 0) {
                property = new PackageManager.Property(name, v.resourceId, true, packageName, className);
            } else {
                v = sa.peekValue(1);
                if (v != null) {
                    if (v.type == 3) {
                        CharSequence cs = v.coerceToString();
                        String stringValue = cs != null ? cs.toString() : null;
                        property = new PackageManager.Property(name, stringValue, packageName, className);
                    } else if (v.type == 18) {
                        property = new PackageManager.Property(name, v.data != 0, packageName, className);
                    } else if (v.type >= 16 && v.type <= 31) {
                        property = new PackageManager.Property(name, v.data, false, packageName, className);
                    } else if (v.type == 4) {
                        property = new PackageManager.Property(name, v.getFloat(), packageName, className);
                    } else {
                        Slog.w(TAG, tagName + " only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
                        property = null;
                    }
                } else {
                    ParseResult<PackageManager.Property> parseResult = input.error(tagName + " requires an android:value or android:resource attribute");
                    return parseResult;
                }
            }
            ParseResult<PackageManager.Property> parseResult = input.success(property);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    public static ParseResult<SigningDetails> getSigningDetails(ParseInput input, ParsedPackage pkg, boolean skipVerify) {
        return ParsingPackageUtils.getSigningDetails(input, pkg.getBaseApkPath(), pkg.isStaticSharedLibrary(), pkg.getTargetSdkVersion(), pkg.getSplitCodePaths(), skipVerify);
    }

    private static ParseResult<SigningDetails> getSigningDetails(ParseInput input, ParsingPackage pkg, boolean skipVerify) {
        return ParsingPackageUtils.getSigningDetails(input, pkg.getBaseApkPath(), pkg.isStaticSharedLibrary(), pkg.getTargetSdkVersion(), pkg.getSplitCodePaths(), skipVerify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<SigningDetails> getSigningDetails(ParseInput input, String baseApkPath, boolean isStaticSharedLibrary, int targetSdkVersion, String[] splitCodePaths, boolean skipVerify) {
        SigningDetails signingDetails = SigningDetails.UNKNOWN;
        Trace.traceBegin(262144L, "collectCertificates");
        try {
            ParseResult<SigningDetails> result = ParsingPackageUtils.getSigningDetails(input, baseApkPath, skipVerify, isStaticSharedLibrary, signingDetails, targetSdkVersion);
            if (result.isError()) {
                ParseResult<SigningDetails> parseResult = input.error(result);
                return parseResult;
            }
            signingDetails = result.getResult();
            File frameworkRes = new File(Environment.getRootDirectory(), "framework/framework-res.apk");
            boolean isFrameworkResSplit = frameworkRes.getAbsolutePath().equals(baseApkPath);
            if (!ArrayUtils.isEmpty(splitCodePaths) && !isFrameworkResSplit) {
                for (int i = 0; i < splitCodePaths.length; ++i) {
                    result = ParsingPackageUtils.getSigningDetails(input, splitCodePaths[i], skipVerify, isStaticSharedLibrary, signingDetails, targetSdkVersion);
                    if (!result.isError()) continue;
                    ParseResult<SigningDetails> parseResult = input.error(result);
                    return parseResult;
                }
            }
            ParseResult<SigningDetails> parseResult = result;
            return parseResult;
        }
        finally {
            Trace.traceEnd(262144L);
        }
    }

    public static ParseResult<SigningDetails> getSigningDetails(ParseInput input, String baseCodePath, boolean skipVerify, boolean isStaticSharedLibrary, @NonNull SigningDetails existingSigningDetails, int targetSdk) {
        ParseResult<SigningDetails> verified;
        int minSignatureScheme = ApkSignatureVerifier.getMinimumSignatureSchemeVersionForTargetSdk(targetSdk);
        if (isStaticSharedLibrary) {
            minSignatureScheme = 2;
        }
        if ((verified = skipVerify ? ApkSignatureVerifier.unsafeGetCertsWithoutVerification(input, baseCodePath, minSignatureScheme) : ApkSignatureVerifier.verify(input, baseCodePath, minSignatureScheme)).isError()) {
            return input.error(verified);
        }
        if (existingSigningDetails == SigningDetails.UNKNOWN) {
            return verified;
        }
        if (!Signature.areExactMatch(existingSigningDetails, verified.getResult())) {
            return input.error(-104, baseCodePath + " has mismatched certificates");
        }
        return input.success(existingSigningDetails);
    }

    public static void setCompatibilityModeEnabled(boolean compatibilityModeEnabled) {
        sCompatibilityModeEnabled = compatibilityModeEnabled;
    }

    public static void readConfigUseRoundIcon(Resources r) {
        ApplicationInfo androidAppInfo;
        if (r != null) {
            sUseRoundIcon = r.getBoolean(17891998);
            return;
        }
        try {
            androidAppInfo = ActivityThread.getPackageManager().getApplicationInfo("android", 0L, UserHandle.myUserId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        Resources systemResources = Resources.getSystem();
        Resources overlayableRes = ResourcesManager.getInstance().getResources(null, null, null, androidAppInfo.resourceDirs, androidAppInfo.overlayPaths, androidAppInfo.sharedLibraryFiles, null, null, systemResources.getCompatibilityInfo(), systemResources.getClassLoader(), null);
        sUseRoundIcon = overlayableRes.getBoolean(17891998);
    }

    private static boolean bool(boolean defaultValue, int attribute, TypedArray sa) {
        return sa.getBoolean(attribute, defaultValue);
    }

    private static float aFloat(float defaultValue, int attribute, TypedArray sa) {
        return sa.getFloat(attribute, defaultValue);
    }

    private static float aFloat(int attribute, TypedArray sa) {
        return sa.getFloat(attribute, 0.0f);
    }

    private static int anInt(int defaultValue, int attribute, TypedArray sa) {
        return sa.getInt(attribute, defaultValue);
    }

    private static int anInteger(int defaultValue, int attribute, TypedArray sa) {
        return sa.getInteger(attribute, defaultValue);
    }

    private static int anInt(int attribute, TypedArray sa) {
        return sa.getInt(attribute, 0);
    }

    private static int resId(int attribute, TypedArray sa) {
        return sa.getResourceId(attribute, 0);
    }

    private static ParseResult<int[]> drawableResIdArray(ParseInput input, @NonNull TypedArray sa, @NonNull Resources res, int resourceId, int maxSize) {
        return ParsingPackageUtils.resIdArray(input, sa, res, resourceId, TYPE_DRAWABLE, maxSize);
    }

    private static ParseResult<int[]> stringResIdArray(ParseInput input, @NonNull TypedArray sa, @NonNull Resources res, int resourceId, int maxSize) {
        return ParsingPackageUtils.resIdArray(input, sa, res, resourceId, TYPE_STRING, maxSize);
    }

    private static ParseResult<int[]> resIdArray(ParseInput input, @NonNull TypedArray sa, @NonNull Resources res, int resourceId, @Nullable String expectedTypeName, int maxSize) {
        if (!sa.hasValue(resourceId)) {
            return input.success(null);
        }
        int typeArrayResId = sa.getResourceId(resourceId, 0);
        if (typeArrayResId == 0) {
            return input.success(null);
        }
        try (TypedArray typedArray = res.obtainTypedArray(typeArrayResId);){
            String typedArrayName = res.getResourceName(typeArrayResId);
            int length = typedArray.length();
            if (maxSize > 0 && length > maxSize) {
                ParseResult<int[]> parseResult = input.error(TextUtils.formatSimple("The length of the typedArray (%s) is larger than %d.", typedArrayName, maxSize));
                return parseResult;
            }
            ArraySet<Integer> resourceIdSet = new ArraySet<Integer>();
            for (int i2 = 0; i2 < length; ++i2) {
                ParseResult<Object> parseResult;
                int id2 = typedArray.getResourceId(i2, 0);
                if (id2 == 0) {
                    parseResult = input.error(TextUtils.formatSimple("There is an item that is not a resource id in the typedArray (%s).", typedArrayName));
                    return parseResult;
                }
                if (resourceIdSet.contains(id2)) {
                    parseResult = input.error(TextUtils.formatSimple("There is a duplicated resource (%s) in the typedArray (%s).", res.getResourceName(id2), typedArrayName));
                    return parseResult;
                }
                String typeName = res.getResourceTypeName(id2);
                if (expectedTypeName != null && !TextUtils.equals(typeName, expectedTypeName)) {
                    ParseResult<int[]> parseResult2 = input.error(TextUtils.formatSimple("There is a resource (%s) in the typedArray (%s) that is not a %s type.", res.getResourceName(id2), typedArrayName, expectedTypeName));
                    return parseResult2;
                }
                resourceIdSet.add(id2);
            }
            if (resourceIdSet.isEmpty()) {
                ParseResult<Object> parseResult = input.success(null);
                return parseResult;
            }
            ParseResult<int[]> parseResult = input.success(resourceIdSet.stream().mapToInt(i -> i).toArray());
            return parseResult;
        }
    }

    private static String string(int attribute, TypedArray sa) {
        return sa.getString(attribute);
    }

    private static String nonConfigString(int allowedChangingConfigs, int attribute, TypedArray sa) {
        return sa.getNonConfigurationString(attribute, allowedChangingConfigs);
    }

    private static String nonResString(int index, TypedArray sa) {
        return sa.getNonResourceString(index);
    }

    public static void writeKeySetMapping(@NonNull Parcel dest, @NonNull Map<String, ArraySet<PublicKey>> keySetMapping) {
        if (keySetMapping == null) {
            dest.writeInt(-1);
            return;
        }
        int N2 = keySetMapping.size();
        dest.writeInt(N2);
        for (String key : keySetMapping.keySet()) {
            dest.writeString(key);
            ArraySet<PublicKey> keys = keySetMapping.get(key);
            if (keys == null) {
                dest.writeInt(-1);
                continue;
            }
            int M = keys.size();
            dest.writeInt(M);
            for (int j = 0; j < M; ++j) {
                dest.writeSerializable(keys.valueAt(j));
            }
        }
    }

    @NonNull
    public static ArrayMap<String, ArraySet<PublicKey>> readKeySetMapping(@NonNull Parcel in) {
        int N2 = in.readInt();
        if (N2 == -1) {
            return null;
        }
        ArrayMap<String, ArraySet<PublicKey>> keySetMapping = new ArrayMap<String, ArraySet<PublicKey>>();
        for (int i = 0; i < N2; ++i) {
            String key = in.readString();
            int M = in.readInt();
            if (M == -1) {
                keySetMapping.put(key, null);
                continue;
            }
            ArraySet<PublicKey> keys = new ArraySet<PublicKey>(M);
            for (int j = 0; j < M; ++j) {
                PublicKey pk = in.readSerializable(PublicKey.class.getClassLoader(), PublicKey.class);
                keys.add(pk);
            }
            keySetMapping.put(key, keys);
        }
        return keySetMapping;
    }

    @RavenwoodKeep
    public static AconfigFlags getAconfigFlags() {
        return sAconfigFlags;
    }

    public static interface Callback {
        public boolean hasFeature(String var1);

        public ParsingPackage startParsingPackage(@NonNull String var1, @NonNull String var2, @NonNull String var3, @NonNull TypedArray var4, boolean var5);

        @NonNull
        public Set<String> getHiddenApiWhitelistedApps();

        @NonNull
        public Set<String> getInstallConstraintsAllowlist();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ParseFlags {
    }
}

