/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.pm.PathPermission;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PatternMatcher;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedMainComponentImpl;
import com.android.internal.pm.pkg.component.ParsedProvider;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ParsedProviderImpl
extends ParsedMainComponentImpl
implements ParsedProvider,
Parcelable {
    @Nullable
    private String authority;
    private boolean syncable;
    @Nullable
    private String readPermission;
    @Nullable
    private String writePermission;
    private boolean grantUriPermissions;
    private boolean forceUriPermissions;
    private boolean multiProcess;
    private int initOrder;
    @NonNull
    private List<PatternMatcher> uriPermissionPatterns = Collections.emptyList();
    @NonNull
    private List<PathPermission> pathPermissions = Collections.emptyList();
    @NonNull
    public static final Parcelable.Creator<ParsedProviderImpl> CREATOR = new Parcelable.Creator<ParsedProviderImpl>(){

        @Override
        public ParsedProviderImpl createFromParcel(Parcel source) {
            return new ParsedProviderImpl(source);
        }

        public ParsedProviderImpl[] newArray(int size) {
            return new ParsedProviderImpl[size];
        }
    };

    public ParsedProviderImpl(ParsedProvider other) {
        super(other);
        this.authority = other.getAuthority();
        this.syncable = other.isSyncable();
        this.readPermission = other.getReadPermission();
        this.writePermission = other.getWritePermission();
        this.grantUriPermissions = other.isGrantUriPermissions();
        this.forceUriPermissions = other.isForceUriPermissions();
        this.multiProcess = other.isMultiProcess();
        this.initOrder = other.getInitOrder();
        this.uriPermissionPatterns = new ArrayList<PatternMatcher>(other.getUriPermissionPatterns());
        this.pathPermissions = new ArrayList<PathPermission>(other.getPathPermissions());
    }

    public ParsedProviderImpl setReadPermission(String readPermission) {
        this.readPermission = TextUtils.isEmpty(readPermission) ? null : readPermission.intern();
        return this;
    }

    public ParsedProviderImpl setWritePermission(String writePermission) {
        this.writePermission = TextUtils.isEmpty(writePermission) ? null : writePermission.intern();
        return this;
    }

    @NonNull
    public ParsedProviderImpl addUriPermissionPattern(@NonNull PatternMatcher value) {
        this.uriPermissionPatterns = CollectionUtils.add(this.uriPermissionPatterns, value);
        return this;
    }

    @NonNull
    public ParsedProviderImpl addPathPermission(@NonNull PathPermission value) {
        this.pathPermissions = CollectionUtils.add(this.pathPermissions, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Provider{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.authority);
        dest.writeBoolean(this.syncable);
        PackageImpl.sForInternedString.parcel(this.readPermission, dest, flags);
        PackageImpl.sForInternedString.parcel(this.writePermission, dest, flags);
        dest.writeBoolean(this.grantUriPermissions);
        dest.writeBoolean(this.forceUriPermissions);
        dest.writeBoolean(this.multiProcess);
        dest.writeInt(this.initOrder);
        dest.writeTypedList(this.uriPermissionPatterns, flags);
        dest.writeTypedList(this.pathPermissions, flags);
    }

    public ParsedProviderImpl() {
    }

    protected ParsedProviderImpl(Parcel in) {
        super(in);
        this.authority = in.readString();
        this.syncable = in.readBoolean();
        this.readPermission = PackageImpl.sForInternedString.unparcel(in);
        this.writePermission = PackageImpl.sForInternedString.unparcel(in);
        this.grantUriPermissions = in.readBoolean();
        this.forceUriPermissions = in.readBoolean();
        this.multiProcess = in.readBoolean();
        this.initOrder = in.readInt();
        this.uriPermissionPatterns = in.createTypedArrayList(PatternMatcher.CREATOR);
        this.pathPermissions = in.createTypedArrayList(PathPermission.CREATOR);
    }

    public ParsedProviderImpl(@Nullable String authority, boolean syncable, @Nullable String readPermission, @Nullable String writePermission, boolean grantUriPermissions, boolean forceUriPermissions, boolean multiProcess, int initOrder, @NonNull List<PatternMatcher> uriPermissionPatterns, @NonNull List<PathPermission> pathPermissions) {
        this.authority = authority;
        this.syncable = syncable;
        this.readPermission = readPermission;
        this.writePermission = writePermission;
        this.grantUriPermissions = grantUriPermissions;
        this.forceUriPermissions = forceUriPermissions;
        this.multiProcess = multiProcess;
        this.initOrder = initOrder;
        this.uriPermissionPatterns = uriPermissionPatterns;
        AnnotationValidations.validate(NonNull.class, null, uriPermissionPatterns);
        this.pathPermissions = pathPermissions;
        AnnotationValidations.validate(NonNull.class, null, pathPermissions);
    }

    @Override
    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public boolean isSyncable() {
        return this.syncable;
    }

    @Override
    @Nullable
    public String getReadPermission() {
        return this.readPermission;
    }

    @Override
    @Nullable
    public String getWritePermission() {
        return this.writePermission;
    }

    @Override
    public boolean isGrantUriPermissions() {
        return this.grantUriPermissions;
    }

    @Override
    public boolean isForceUriPermissions() {
        return this.forceUriPermissions;
    }

    @Override
    public boolean isMultiProcess() {
        return this.multiProcess;
    }

    @Override
    public int getInitOrder() {
        return this.initOrder;
    }

    @Override
    @NonNull
    public List<PatternMatcher> getUriPermissionPatterns() {
        return this.uriPermissionPatterns;
    }

    @Override
    @NonNull
    public List<PathPermission> getPathPermissions() {
        return this.pathPermissions;
    }

    @NonNull
    public ParsedProviderImpl setAuthority(@NonNull String value) {
        this.authority = value;
        return this;
    }

    @NonNull
    public ParsedProviderImpl setSyncable(boolean value) {
        this.syncable = value;
        return this;
    }

    @NonNull
    public ParsedProviderImpl setGrantUriPermissions(boolean value) {
        this.grantUriPermissions = value;
        return this;
    }

    @NonNull
    public ParsedProviderImpl setForceUriPermissions(boolean value) {
        this.forceUriPermissions = value;
        return this;
    }

    @NonNull
    public ParsedProviderImpl setMultiProcess(boolean value) {
        this.multiProcess = value;
        return this;
    }

    @NonNull
    public ParsedProviderImpl setInitOrder(int value) {
        this.initOrder = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

