/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.IntentFilter;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.security.Flags;
import com.android.internal.pm.pkg.component.ComponentParseUtils;
import com.android.internal.pm.pkg.component.ParsedComponentUtils;
import com.android.internal.pm.pkg.component.ParsedIntentInfo;
import com.android.internal.pm.pkg.component.ParsedIntentInfoImpl;
import com.android.internal.pm.pkg.component.ParsedIntentInfoUtils;
import com.android.internal.pm.pkg.component.ParsedMainComponent;
import com.android.internal.pm.pkg.component.ParsedMainComponentImpl;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ParsedMainComponentUtils {
    private static final String TAG = "PackageParsing";

    @NonNull
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    static <Component extends ParsedMainComponentImpl> ParseResult<Component> parseMainComponent(Component component, String tag, String[] separateProcesses, ParsingPackage pkg, TypedArray array2, int flags, boolean useRoundIcon, @Nullable String defaultSplitName, @NonNull ParseInput input, int bannerAttr, int descriptionAttr, int directBootAwareAttr, int enabledAttr, int iconAttr, int labelAttr, int logoAttr, int nameAttr, int processAttr, int roundIconAttr, int splitNameAttr, int attributionTagsAttr, int intentMatchingFlagsAttr) {
        String attributionTags;
        ParseResult<Component> result = ParsedComponentUtils.parseComponent(component, tag, pkg, array2, useRoundIcon, input, bannerAttr, descriptionAttr, iconAttr, labelAttr, logoAttr, nameAttr, roundIconAttr);
        if (result.isError()) {
            return result;
        }
        if (directBootAwareAttr != -1) {
            component.setDirectBootAware(array2.getBoolean(directBootAwareAttr, false));
            if (component.isDirectBootAware()) {
                pkg.setPartiallyDirectBootAware(true);
            }
        }
        if (enabledAttr != -1) {
            component.setEnabled(array2.getBoolean(enabledAttr, true));
        }
        if (processAttr != -1) {
            String processName = pkg.getTargetSdkVersion() >= 8 ? array2.getNonConfigurationString(processAttr, 1024) : array2.getNonResourceString(processAttr);
            ParseResult<String> processNameResult = ComponentParseUtils.buildProcessName(pkg.getPackageName(), pkg.getProcessName(), processName, flags, separateProcesses, input);
            if (processNameResult.isError()) {
                return input.error(processNameResult);
            }
            component.setProcessName(processNameResult.getResult());
        }
        if (splitNameAttr != -1) {
            component.setSplitName(array2.getNonConfigurationString(splitNameAttr, 0));
        }
        if (defaultSplitName != null && component.getSplitName() == null) {
            component.setSplitName(defaultSplitName);
        }
        if (attributionTagsAttr != -1 && (attributionTags = array2.getNonConfigurationString(attributionTagsAttr, 0)) != null) {
            component.setAttributionTags(attributionTags.split("\\|"));
        }
        if (Flags.enableIntentMatchingFlags()) {
            int resolvedFlags = ParsedMainComponentUtils.resolveIntentMatchingFlags(pkg.getIntentMatchingFlags(), array2.getInt(intentMatchingFlagsAttr, 0));
            component.setIntentMatchingFlags(resolvedFlags);
        }
        return input.success(component);
    }

    static ParseResult<ParsedIntentInfoImpl> parseIntentFilter(ParsedMainComponent mainComponent, ParsingPackage pkg, Resources resources, XmlResourceParser parser, boolean visibleToEphemeral, boolean allowGlobs, boolean allowAutoVerify, boolean allowImplicitEphemeralVisibility, boolean failOnNoActions, ParseInput input) throws IOException, XmlPullParserException {
        ParseResult<ParsedIntentInfoImpl> intentResult = ParsedIntentInfoUtils.parseIntentInfo(mainComponent.getName(), pkg, resources, parser, allowGlobs, allowAutoVerify, input);
        if (intentResult.isError()) {
            return input.error(intentResult);
        }
        ParsedIntentInfo intent = intentResult.getResult();
        IntentFilter intentFilter = intent.getIntentFilter();
        int actionCount = intentFilter.countActions();
        if (actionCount == 0 && failOnNoActions) {
            Slog.w(TAG, "No actions in " + parser.getName() + " at " + pkg.getBaseApkPath() + " " + parser.getPositionDescription());
            return input.success(null);
        }
        int intentVisibility = visibleToEphemeral ? 1 : (allowImplicitEphemeralVisibility && ComponentParseUtils.isImplicitlyExposedIntent(intent) ? 2 : 0);
        intentFilter.setVisibilityToInstantApp(intentVisibility);
        return input.success(intentResult.getResult());
    }

    @FlaggedApi(value="android.security.enable_intent_matching_flags")
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static int resolveIntentMatchingFlags(int applicationFlags, int componentFlags) {
        if (componentFlags == 0) {
            return applicationFlags;
        }
        return componentFlags;
    }
}

