/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedComponentImpl;
import com.android.internal.pm.pkg.component.ParsedInstrumentation;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class ParsedInstrumentationImpl
extends ParsedComponentImpl
implements ParsedInstrumentation,
Parcelable {
    @Nullable
    private String targetPackage;
    @Nullable
    private String targetProcesses;
    private boolean handleProfiling;
    private boolean functionalTest;
    @NonNull
    public static final Parcelable.Creator<ParsedInstrumentationImpl> CREATOR = new Parcelable.Creator<ParsedInstrumentationImpl>(){

        @Override
        public ParsedInstrumentationImpl createFromParcel(Parcel source) {
            return new ParsedInstrumentationImpl(source);
        }

        public ParsedInstrumentationImpl[] newArray(int size) {
            return new ParsedInstrumentationImpl[size];
        }
    };

    public ParsedInstrumentationImpl() {
    }

    public ParsedInstrumentationImpl setTargetPackage(@Nullable String targetPackage) {
        this.targetPackage = TextUtils.safeIntern(targetPackage);
        return this;
    }

    public ParsedInstrumentationImpl setTargetProcesses(@Nullable String targetProcesses) {
        this.targetProcesses = TextUtils.safeIntern(targetProcesses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Instrumentation{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        PackageImpl.sForInternedString.parcel(this.targetPackage, dest, flags);
        PackageImpl.sForInternedString.parcel(this.targetProcesses, dest, flags);
        dest.writeBoolean(this.handleProfiling);
        dest.writeBoolean(this.functionalTest);
    }

    protected ParsedInstrumentationImpl(Parcel in) {
        super(in);
        this.targetPackage = PackageImpl.sForInternedString.unparcel(in);
        this.targetProcesses = PackageImpl.sForInternedString.unparcel(in);
        this.handleProfiling = in.readByte() != 0;
        this.functionalTest = in.readByte() != 0;
    }

    public ParsedInstrumentationImpl(@Nullable String targetPackage, @Nullable String targetProcesses, boolean handleProfiling, boolean functionalTest) {
        this.targetPackage = targetPackage;
        this.targetProcesses = targetProcesses;
        this.handleProfiling = handleProfiling;
        this.functionalTest = functionalTest;
    }

    @Override
    @Nullable
    public String getTargetPackage() {
        return this.targetPackage;
    }

    @Override
    @Nullable
    public String getTargetProcesses() {
        return this.targetProcesses;
    }

    @Override
    public boolean isHandleProfiling() {
        return this.handleProfiling;
    }

    @Override
    public boolean isFunctionalTest() {
        return this.functionalTest;
    }

    @NonNull
    public ParsedInstrumentationImpl setHandleProfiling(boolean value) {
        this.handleProfiling = value;
        return this;
    }

    @NonNull
    public ParsedInstrumentationImpl setFunctionalTest(boolean value) {
        this.functionalTest = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

