/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityTaskManager;
import android.content.ComponentName;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArraySet;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.pkg.component.ParsedActivity;
import com.android.internal.pm.pkg.component.ParsedActivityUtils;
import com.android.internal.pm.pkg.component.ParsedMainComponentImpl;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;

public class ParsedActivityImpl
extends ParsedMainComponentImpl
implements ParsedActivity,
Parcelable {
    private int theme;
    private int uiOptions;
    @Nullable
    private String targetActivity;
    @Nullable
    private String parentActivityName;
    @Nullable
    private String taskAffinity;
    private int privateFlags;
    @Nullable
    private String permission;
    @Nullable
    private Set<String> mKnownActivityEmbeddingCerts;
    private int launchMode;
    private int documentLaunchMode;
    private int maxRecents;
    private int configChanges;
    private int softInputMode;
    private int persistableMode;
    private int lockTaskLaunchMode;
    private int screenOrientation = -1;
    private int resizeMode = 2;
    private float maxAspectRatio = -1.0f;
    private float minAspectRatio = -1.0f;
    private boolean supportsSizeChanges;
    @Nullable
    private String requestedVrComponent;
    private int rotationAnimation = -1;
    private int colorMode;
    @Nullable
    private ActivityInfo.WindowLayout windowLayout;
    @Nullable
    private String mRequiredDisplayCategory;
    private int mRequireContentUriPermissionFromCaller;
    @NonNull
    public static final Parcelable.Creator<ParsedActivityImpl> CREATOR = new Parcelable.Creator<ParsedActivityImpl>(){

        @Override
        public ParsedActivityImpl createFromParcel(Parcel source) {
            return new ParsedActivityImpl(source);
        }

        public ParsedActivityImpl[] newArray(int size) {
            return new ParsedActivityImpl[size];
        }
    };

    public ParsedActivityImpl(ParsedActivityImpl other) {
        super(other);
        this.theme = other.theme;
        this.uiOptions = other.uiOptions;
        this.targetActivity = other.targetActivity;
        this.parentActivityName = other.parentActivityName;
        this.taskAffinity = other.taskAffinity;
        this.privateFlags = other.privateFlags;
        this.permission = other.permission;
        this.launchMode = other.launchMode;
        this.documentLaunchMode = other.documentLaunchMode;
        this.maxRecents = other.maxRecents;
        this.configChanges = other.configChanges;
        this.softInputMode = other.softInputMode;
        this.persistableMode = other.persistableMode;
        this.lockTaskLaunchMode = other.lockTaskLaunchMode;
        this.screenOrientation = other.screenOrientation;
        this.resizeMode = other.resizeMode;
        this.maxAspectRatio = other.maxAspectRatio;
        this.minAspectRatio = other.minAspectRatio;
        this.supportsSizeChanges = other.supportsSizeChanges;
        this.requestedVrComponent = other.requestedVrComponent;
        this.rotationAnimation = other.rotationAnimation;
        this.colorMode = other.colorMode;
        this.windowLayout = other.windowLayout;
        this.mKnownActivityEmbeddingCerts = other.mKnownActivityEmbeddingCerts;
        this.mRequiredDisplayCategory = other.mRequiredDisplayCategory;
        this.mRequireContentUriPermissionFromCaller = other.mRequireContentUriPermissionFromCaller;
    }

    @NonNull
    public static ParsedActivityImpl makeAppDetailsActivity(String packageName, String processName, int uiOptions, String taskAffinity, boolean hardwareAccelerated) {
        ParsedActivityImpl activity = new ParsedActivityImpl();
        activity.setPackageName(packageName);
        activity.theme = 16973909;
        activity.setExported(true);
        activity.setName(PackageManager.APP_DETAILS_ACTIVITY_CLASS_NAME);
        activity.setProcessName(processName);
        activity.uiOptions = uiOptions;
        activity.taskAffinity = taskAffinity;
        activity.launchMode = 0;
        activity.documentLaunchMode = 0;
        activity.maxRecents = ActivityTaskManager.getDefaultAppRecentsLimitStatic();
        activity.configChanges = ParsedActivityUtils.getActivityConfigChanges(0, 0);
        activity.softInputMode = 0;
        activity.persistableMode = 1;
        activity.screenOrientation = -1;
        activity.resizeMode = 4;
        activity.lockTaskLaunchMode = 0;
        activity.setDirectBootAware(false);
        activity.rotationAnimation = -1;
        activity.colorMode = 0;
        if (hardwareAccelerated) {
            activity.setFlags(activity.getFlags() | 0x200);
        }
        return activity;
    }

    @NonNull
    static ParsedActivityImpl makeAlias(String targetActivityName, ParsedActivity target) {
        ParsedActivityImpl alias = new ParsedActivityImpl();
        alias.setPackageName(target.getPackageName());
        alias.setTargetActivity(targetActivityName);
        alias.configChanges = target.getConfigChanges();
        alias.setFlags(target.getFlags());
        alias.privateFlags = target.getPrivateFlags();
        alias.setIcon(target.getIcon());
        alias.setLogo(target.getLogo());
        alias.setBanner(target.getBanner());
        alias.setLabelRes(target.getLabelRes());
        alias.setNonLocalizedLabel(target.getNonLocalizedLabel());
        alias.launchMode = target.getLaunchMode();
        alias.lockTaskLaunchMode = target.getLockTaskLaunchMode();
        alias.documentLaunchMode = target.getDocumentLaunchMode();
        alias.setDescriptionRes(target.getDescriptionRes());
        alias.screenOrientation = target.getScreenOrientation();
        alias.taskAffinity = target.getTaskAffinity();
        alias.theme = target.getTheme();
        alias.softInputMode = target.getSoftInputMode();
        alias.uiOptions = target.getUiOptions();
        alias.parentActivityName = target.getParentActivityName();
        alias.maxRecents = target.getMaxRecents();
        alias.windowLayout = target.getWindowLayout();
        alias.resizeMode = target.getResizeMode();
        alias.maxAspectRatio = target.getMaxAspectRatio();
        alias.minAspectRatio = target.getMinAspectRatio();
        alias.supportsSizeChanges = target.isSupportsSizeChanges();
        alias.requestedVrComponent = target.getRequestedVrComponent();
        alias.setDirectBootAware(target.isDirectBootAware());
        alias.setProcessName(target.getProcessName());
        alias.setRequiredDisplayCategory(target.getRequiredDisplayCategory());
        alias.setRequireContentUriPermissionFromCaller(target.getRequireContentUriPermissionFromCaller());
        return alias;
    }

    public ParsedActivityImpl setMaxAspectRatio(int resizeMode, float maxAspectRatio) {
        if (resizeMode == 2 || resizeMode == 1) {
            return this;
        }
        if (maxAspectRatio < 1.0f && maxAspectRatio != 0.0f) {
            return this;
        }
        this.maxAspectRatio = maxAspectRatio;
        return this;
    }

    public ParsedActivityImpl setMinAspectRatio(int resizeMode, float minAspectRatio) {
        if (resizeMode == 2 || resizeMode == 1) {
            return this;
        }
        if (minAspectRatio < 1.0f && minAspectRatio != 0.0f) {
            return this;
        }
        this.minAspectRatio = minAspectRatio;
        return this;
    }

    public ParsedActivityImpl setTargetActivity(String targetActivity) {
        this.targetActivity = TextUtils.safeIntern(targetActivity);
        return this;
    }

    public ParsedActivityImpl setPermission(String permission2) {
        this.permission = TextUtils.isEmpty(permission2) ? null : permission2.intern();
        return this;
    }

    @Override
    @NonNull
    public Set<String> getKnownActivityEmbeddingCerts() {
        return this.mKnownActivityEmbeddingCerts == null ? Collections.emptySet() : this.mKnownActivityEmbeddingCerts;
    }

    public void setKnownActivityEmbeddingCerts(@NonNull Set<String> knownActivityEmbeddingCerts) {
        this.mKnownActivityEmbeddingCerts = new ArraySet<String>();
        for (String knownCert : knownActivityEmbeddingCerts) {
            this.mKnownActivityEmbeddingCerts.add(knownCert.toUpperCase(Locale.US));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Activity{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.theme);
        dest.writeInt(this.uiOptions);
        dest.writeString(this.targetActivity);
        dest.writeString(this.parentActivityName);
        dest.writeString(this.taskAffinity);
        dest.writeInt(this.privateFlags);
        PackageImpl.sForInternedString.parcel(this.permission, dest, flags);
        dest.writeInt(this.launchMode);
        dest.writeInt(this.documentLaunchMode);
        dest.writeInt(this.maxRecents);
        dest.writeInt(this.configChanges);
        dest.writeInt(this.softInputMode);
        dest.writeInt(this.persistableMode);
        dest.writeInt(this.lockTaskLaunchMode);
        dest.writeInt(this.screenOrientation);
        dest.writeInt(this.resizeMode);
        dest.writeValue(Float.valueOf(this.maxAspectRatio));
        dest.writeValue(Float.valueOf(this.minAspectRatio));
        dest.writeBoolean(this.supportsSizeChanges);
        dest.writeString(this.requestedVrComponent);
        dest.writeInt(this.rotationAnimation);
        dest.writeInt(this.colorMode);
        dest.writeBundle(this.getMetaData());
        if (this.windowLayout != null) {
            dest.writeInt(1);
            this.windowLayout.writeToParcel(dest);
        } else {
            dest.writeBoolean(false);
        }
        PackageImpl.sForStringSet.parcel(this.mKnownActivityEmbeddingCerts, dest, flags);
        dest.writeString8(this.mRequiredDisplayCategory);
        dest.writeInt(this.mRequireContentUriPermissionFromCaller);
    }

    public ParsedActivityImpl() {
    }

    protected ParsedActivityImpl(Parcel in) {
        super(in);
        this.theme = in.readInt();
        this.uiOptions = in.readInt();
        this.targetActivity = in.readString();
        this.parentActivityName = in.readString();
        this.taskAffinity = in.readString();
        this.privateFlags = in.readInt();
        this.permission = PackageImpl.sForInternedString.unparcel(in);
        this.launchMode = in.readInt();
        this.documentLaunchMode = in.readInt();
        this.maxRecents = in.readInt();
        this.configChanges = in.readInt();
        this.softInputMode = in.readInt();
        this.persistableMode = in.readInt();
        this.lockTaskLaunchMode = in.readInt();
        this.screenOrientation = in.readInt();
        this.resizeMode = in.readInt();
        this.maxAspectRatio = ((Float)in.readValue(Float.class.getClassLoader())).floatValue();
        this.minAspectRatio = ((Float)in.readValue(Float.class.getClassLoader())).floatValue();
        this.supportsSizeChanges = in.readBoolean();
        this.requestedVrComponent = in.readString();
        this.rotationAnimation = in.readInt();
        this.colorMode = in.readInt();
        this.setMetaData(in.readBundle());
        if (in.readBoolean()) {
            this.windowLayout = new ActivityInfo.WindowLayout(in);
        }
        this.mKnownActivityEmbeddingCerts = PackageImpl.sForStringSet.unparcel(in);
        this.mRequiredDisplayCategory = in.readString8();
        this.mRequireContentUriPermissionFromCaller = in.readInt();
    }

    public ParsedActivityImpl(int theme, int uiOptions, @Nullable String targetActivity, @Nullable String parentActivityName, @Nullable String taskAffinity, int privateFlags, @Nullable String permission2, @Nullable Set<String> knownActivityEmbeddingCerts, int launchMode, int documentLaunchMode, int maxRecents, int configChanges, int softInputMode, int persistableMode, int lockTaskLaunchMode, int screenOrientation, int resizeMode, float maxAspectRatio, float minAspectRatio, boolean supportsSizeChanges, @Nullable String requestedVrComponent, int rotationAnimation, int colorMode, @Nullable ActivityInfo.WindowLayout windowLayout, @Nullable String requiredDisplayCategory, int requireContentUriPermissionFromCaller) {
        this.theme = theme;
        this.uiOptions = uiOptions;
        this.targetActivity = targetActivity;
        this.parentActivityName = parentActivityName;
        this.taskAffinity = taskAffinity;
        this.privateFlags = privateFlags;
        this.permission = permission2;
        this.mKnownActivityEmbeddingCerts = knownActivityEmbeddingCerts;
        this.launchMode = launchMode;
        this.documentLaunchMode = documentLaunchMode;
        this.maxRecents = maxRecents;
        this.configChanges = configChanges;
        this.softInputMode = softInputMode;
        this.persistableMode = persistableMode;
        this.lockTaskLaunchMode = lockTaskLaunchMode;
        this.screenOrientation = screenOrientation;
        this.resizeMode = resizeMode;
        this.maxAspectRatio = maxAspectRatio;
        this.minAspectRatio = minAspectRatio;
        this.supportsSizeChanges = supportsSizeChanges;
        this.requestedVrComponent = requestedVrComponent;
        this.rotationAnimation = rotationAnimation;
        this.colorMode = colorMode;
        this.windowLayout = windowLayout;
        this.mRequiredDisplayCategory = requiredDisplayCategory;
        this.mRequireContentUriPermissionFromCaller = requireContentUriPermissionFromCaller;
    }

    @Override
    public int getTheme() {
        return this.theme;
    }

    @Override
    public int getUiOptions() {
        return this.uiOptions;
    }

    @Override
    @Nullable
    public String getTargetActivity() {
        return this.targetActivity;
    }

    @Override
    @Nullable
    public String getParentActivityName() {
        return this.parentActivityName;
    }

    @Override
    @Nullable
    public String getTaskAffinity() {
        return this.taskAffinity;
    }

    @Override
    public int getPrivateFlags() {
        return this.privateFlags;
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.permission;
    }

    @Override
    public int getLaunchMode() {
        return this.launchMode;
    }

    @Override
    public int getDocumentLaunchMode() {
        return this.documentLaunchMode;
    }

    @Override
    public int getMaxRecents() {
        return this.maxRecents;
    }

    @Override
    public int getConfigChanges() {
        return this.configChanges;
    }

    @Override
    public int getSoftInputMode() {
        return this.softInputMode;
    }

    @Override
    public int getPersistableMode() {
        return this.persistableMode;
    }

    @Override
    public int getLockTaskLaunchMode() {
        return this.lockTaskLaunchMode;
    }

    @Override
    public int getScreenOrientation() {
        return this.screenOrientation;
    }

    @Override
    public int getResizeMode() {
        return this.resizeMode;
    }

    @Override
    public float getMaxAspectRatio() {
        return this.maxAspectRatio;
    }

    @Override
    public float getMinAspectRatio() {
        return this.minAspectRatio;
    }

    @Override
    public boolean isSupportsSizeChanges() {
        return this.supportsSizeChanges;
    }

    @Override
    @Nullable
    public String getRequestedVrComponent() {
        return this.requestedVrComponent;
    }

    @Override
    public int getRotationAnimation() {
        return this.rotationAnimation;
    }

    @Override
    public int getColorMode() {
        return this.colorMode;
    }

    @Override
    @Nullable
    public ActivityInfo.WindowLayout getWindowLayout() {
        return this.windowLayout;
    }

    @Override
    @Nullable
    public String getRequiredDisplayCategory() {
        return this.mRequiredDisplayCategory;
    }

    @Override
    public int getRequireContentUriPermissionFromCaller() {
        return this.mRequireContentUriPermissionFromCaller;
    }

    @NonNull
    public ParsedActivityImpl setTheme(int value) {
        this.theme = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setUiOptions(int value) {
        this.uiOptions = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setParentActivityName(@NonNull String value) {
        this.parentActivityName = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setTaskAffinity(@NonNull String value) {
        this.taskAffinity = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setPrivateFlags(int value) {
        this.privateFlags = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setLaunchMode(int value) {
        this.launchMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setDocumentLaunchMode(int value) {
        this.documentLaunchMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setMaxRecents(int value) {
        this.maxRecents = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setConfigChanges(int value) {
        this.configChanges = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setSoftInputMode(int value) {
        this.softInputMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setPersistableMode(int value) {
        this.persistableMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setLockTaskLaunchMode(int value) {
        this.lockTaskLaunchMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setScreenOrientation(int value) {
        this.screenOrientation = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setResizeMode(int value) {
        this.resizeMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setMaxAspectRatio(float value) {
        this.maxAspectRatio = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setMinAspectRatio(float value) {
        this.minAspectRatio = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setSupportsSizeChanges(boolean value) {
        this.supportsSizeChanges = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setRequestedVrComponent(@NonNull String value) {
        this.requestedVrComponent = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setRotationAnimation(int value) {
        this.rotationAnimation = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setColorMode(int value) {
        this.colorMode = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setWindowLayout(@NonNull ActivityInfo.WindowLayout value) {
        this.windowLayout = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setRequiredDisplayCategory(@NonNull String value) {
        this.mRequiredDisplayCategory = value;
        return this;
    }

    @NonNull
    public ParsedActivityImpl setRequireContentUriPermissionFromCaller(int value) {
        this.mRequireContentUriPermissionFromCaller = value;
        return this;
    }

    @Deprecated
    private void __metadata() {
    }
}

