/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os._Original_Build;
import android.util.ArraySet;
import com.android.internal.R;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public class InstallConstraintsTagParser {
    private static final String TAG_FINGERPRINT_PREFIX = "fingerprint-prefix";

    public static ParseResult<ParsingPackage> parseInstallConstraints(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser, Set<String> allowlist) throws XmlPullParserException, IOException {
        if (!allowlist.contains(pkg.getPackageName())) {
            return input.skip("install-constraints cannot be used by this package");
        }
        ParseResult<Set<String>> prefixes = InstallConstraintsTagParser.parseFingerprintPrefixes(input, pkg, res, parser);
        if (prefixes.isSuccess()) {
            if (InstallConstraintsTagParser.validateFingerprintPrefixes(prefixes.getResult())) {
                return input.success(pkg);
            }
            return input.skip("Install of this package is restricted on this device; device fingerprint does not start with one of the allowed prefixes");
        }
        return input.skip(prefixes.getErrorMessage());
    }

    private static ParseResult<Set<String>> parseFingerprintPrefixes(ParseInput input, ParsingPackage pkg, Resources res, XmlResourceParser parser) throws XmlPullParserException, IOException {
        int type;
        ArraySet<String> prefixes = new ArraySet<String>();
        while (true) {
            ParseResult<String> parsedPrefix;
            if ((type = parser.next()) == 3) {
                if (prefixes.size() == 0) {
                    return input.error("install-constraints must contain at least one constraint");
                }
                return input.success(prefixes);
            }
            if (type != 2) continue;
            if (ParsingPackageUtils.getAconfigFlags().skipCurrentElement(pkg, parser)) {
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (parser.getName().equals(TAG_FINGERPRINT_PREFIX)) {
                parsedPrefix = InstallConstraintsTagParser.readFingerprintPrefixValue(input, res, parser);
                if (!parsedPrefix.isSuccess()) {
                    return input.error(parsedPrefix.getErrorMessage());
                }
            } else {
                return input.error("Unexpected tag: " + parser.getName());
            }
            prefixes.add(parsedPrefix.getResult());
            type = parser.next();
            if (type != 3) break;
        }
        return input.error("Expected end tag; instead got " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<String> readFingerprintPrefixValue(ParseInput input, Resources res, XmlResourceParser parser) {
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestInstallConstraintsFingerprintPrefix);
        try {
            String value = sa.getString(0);
            if (value == null) {
                ParseResult<String> parseResult = input.error("Failed to specify prefix value");
                return parseResult;
            }
            ParseResult<String> parseResult = input.success(value);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }

    private static boolean validateFingerprintPrefixes(Set<String> prefixes) {
        String fingerprint = _Original_Build.FINGERPRINT;
        for (String prefix : prefixes) {
            if (!fingerprint.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

