/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.parsing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.content.pm.parsing.PackageLite;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.pm.parsing.result.ParseTypeImpl;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.os._Original_Build;
import android.permission.PermissionManager;
import android.util.DisplayMetrics;
import android.util.Slog;
import com.android.internal.pm.parsing.IPackageCacher;
import com.android.internal.pm.parsing.PackageParserException;
import com.android.internal.pm.parsing.pkg.PackageImpl;
import com.android.internal.pm.parsing.pkg.ParsedPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackage;
import com.android.internal.pm.pkg.parsing.ParsingPackageUtils;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.util.ArrayList;

public class PackageParser2
implements AutoCloseable {
    private static final String TAG = "PackageParsing";
    private static final boolean LOG_PARSE_TIMINGS = _Original_Build.IS_DEBUGGABLE;
    private static final int LOG_PARSE_TIMINGS_THRESHOLD_MS = 100;
    private final ThreadLocal<ApplicationInfo> mSharedAppInfo = ThreadLocal.withInitial(() -> {
        ApplicationInfo appInfo = new ApplicationInfo();
        appInfo.uid = -1;
        return appInfo;
    });
    private final ThreadLocal<ParseTypeImpl> mSharedResult;
    @Nullable
    protected IPackageCacher mCacher;
    private final ParsingPackageUtils mParsingUtils;

    public PackageParser2(String[] separateProcesses, DisplayMetrics displayMetrics, @Nullable IPackageCacher cacher, @NonNull Callback callback) {
        PermissionManager permissionManager;
        if (displayMetrics == null) {
            displayMetrics = new DisplayMetrics();
            displayMetrics.setToDefaults();
        }
        ArrayList<PermissionManager.SplitPermissionInfo> splitPermissions = null;
        Application application = ActivityThread.currentApplication();
        if (application != null && (permissionManager = application.getSystemService(PermissionManager.class)) != null) {
            splitPermissions = permissionManager.getSplitPermissions();
        }
        if (splitPermissions == null) {
            splitPermissions = new ArrayList();
        }
        this.mCacher = cacher;
        this.mParsingUtils = new ParsingPackageUtils(separateProcesses, displayMetrics, splitPermissions, callback);
        ParseInput.Callback enforcementCallback = (changeId, packageName, targetSdkVersion) -> {
            ApplicationInfo appInfo = this.mSharedAppInfo.get();
            appInfo.packageName = packageName;
            appInfo.targetSdkVersion = targetSdkVersion;
            return callback.isChangeEnabled(changeId, appInfo);
        };
        this.mSharedResult = ThreadLocal.withInitial(() -> new ParseTypeImpl(enforcementCallback));
    }

    public ParsedPackage parsePackage(File packageFile, int flags, boolean useCaches) throws PackageParserException {
        long cacheTime;
        ParsedPackage parsed;
        Object[] files = ((File)packageFile).listFiles();
        if (ArrayUtils.size(files) == 1 && ((File)files[0]).isDirectory()) {
            packageFile = files[0];
        }
        if (useCaches && this.mCacher != null && (parsed = this.mCacher.getCachedResult((File)packageFile, flags)) != null) {
            return parsed;
        }
        long parseTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        ParseInput input = this.mSharedResult.get().reset();
        ParseResult<ParsingPackage> result = this.mParsingUtils.parsePackage(input, (File)packageFile, flags);
        if (result.isError()) {
            throw new PackageParserException(result.getErrorCode(), result.getErrorMessage(), result.getException());
        }
        ParsedPackage parsed2 = result.getResult().hideAsParsed();
        long l = cacheTime = LOG_PARSE_TIMINGS ? SystemClock.uptimeMillis() : 0L;
        if (this.mCacher != null) {
            this.mCacher.cacheResult((File)packageFile, flags, parsed2);
        }
        if (LOG_PARSE_TIMINGS && (parseTime = cacheTime - parseTime) + (cacheTime = SystemClock.uptimeMillis() - cacheTime) > 100L) {
            Slog.i(TAG, "Parse times for '" + packageFile + "': parse=" + parseTime + "ms, update_cache=" + cacheTime + " ms");
        }
        return parsed2;
    }

    public ParsedPackage parsePackageFromPackageLite(PackageLite packageLite, int flags) throws PackageParserException {
        ParseInput input = this.mSharedResult.get().reset();
        ParseResult<ParsingPackage> result = this.mParsingUtils.parsePackageFromPackageLite(input, packageLite, flags);
        if (result.isError()) {
            throw new PackageParserException(result.getErrorCode(), result.getErrorMessage(), result.getException());
        }
        return result.getResult().hideAsParsed();
    }

    @Override
    public void close() {
        this.mSharedResult.remove();
        this.mSharedAppInfo.remove();
    }

    public static abstract class Callback
    implements ParsingPackageUtils.Callback {
        @Override
        public ParsingPackage startParsingPackage(@NonNull String packageName, @NonNull String baseCodePath, @NonNull String codePath, @NonNull TypedArray manifestArray, boolean isCoreApp) {
            return PackageImpl.forParsing(packageName, baseCodePath, codePath, manifestArray, isCoreApp, this);
        }

        public abstract boolean isChangeEnabled(long var1, @NonNull ApplicationInfo var3);
    }
}

