/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.SystemClock;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.HeavyHitterSketch;
import java.util.ArrayList;
import java.util.List;

@RavenwoodKeepWholeClass
public class BinderCallHeavyHitterWatcher {
    private static final String TAG = "BinderCallHeavyHitterWatcher";
    @GuardedBy(value={"mLock"})
    private boolean mEnabled;
    @GuardedBy(value={"mLock"})
    private BinderCallHeavyHitterListener mListener;
    @GuardedBy(value={"mLock"})
    private HeavyHitterSketch<Integer> mHeavyHitterSketch;
    @GuardedBy(value={"mLock"})
    private final SparseArray<HeavyHitterContainer> mHeavyHitterCandiates = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayList<Integer> mCachedCandidateList = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final ArrayList<Float> mCachedCandidateFrequencies = new ArrayList();
    @GuardedBy(value={"mLock"})
    private ArraySet<Integer> mCachedCandidateSet = new ArraySet();
    @GuardedBy(value={"mLock"})
    private HeavyHitterContainer[] mCachedCandidateContainers;
    @GuardedBy(value={"mLock"})
    private int mCachedCandidateContainersIndex;
    @GuardedBy(value={"mLock"})
    private int mInputSize;
    @GuardedBy(value={"mLock"})
    private int mTotalInputSize;
    @GuardedBy(value={"mLock"})
    private int mCurrentInputSize;
    @GuardedBy(value={"mLock"})
    private float mThreshold;
    @GuardedBy(value={"mLock"})
    private long mBatchStartTimeStamp;
    private final Object mLock = new Object();
    private static final float EPSILON = 1.0E-5f;
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static BinderCallHeavyHitterWatcher sInstance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinderCallHeavyHitterWatcher getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new BinderCallHeavyHitterWatcher();
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(boolean enable, int batchSize, float threshold, @Nullable BinderCallHeavyHitterListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (!enable) {
                if (this.mEnabled) {
                    this.resetInternalLocked(null, null, 0, 0, 0.0f, 0);
                    this.mEnabled = false;
                }
                return;
            }
            this.mEnabled = true;
            if (threshold < 1.0E-5f || threshold > 1.0f) {
                return;
            }
            if (batchSize == this.mTotalInputSize && Math.abs(threshold - this.mThreshold) < 1.0E-5f) {
                this.mListener = listener;
                return;
            }
            int capacity = (int)(1.0f / threshold);
            HeavyHitterSketch<Integer> sketch = HeavyHitterSketch.newDefault();
            float validationRatio = sketch.getRequiredValidationInputRatio();
            int inputSize = batchSize;
            if (!Float.isNaN(validationRatio)) {
                inputSize = (int)((float)batchSize * (1.0f - validationRatio));
            }
            try {
                sketch.setConfig(batchSize, capacity);
            }
            catch (IllegalArgumentException e) {
                Log.w(TAG, "Invalid parameter to heavy hitter watcher: " + batchSize + ", " + capacity);
                return;
            }
            this.resetInternalLocked(listener, sketch, inputSize, batchSize, threshold, capacity);
        }
    }

    @GuardedBy(value={"mLock"})
    private void resetInternalLocked(@Nullable BinderCallHeavyHitterListener listener, @Nullable HeavyHitterSketch<Integer> sketch, int inputSize, int batchSize, float threshold, int capacity) {
        this.mListener = listener;
        this.mHeavyHitterSketch = sketch;
        this.mHeavyHitterCandiates.clear();
        this.mCachedCandidateList.clear();
        this.mCachedCandidateFrequencies.clear();
        this.mCachedCandidateSet.clear();
        this.mInputSize = inputSize;
        this.mTotalInputSize = batchSize;
        this.mCurrentInputSize = 0;
        this.mThreshold = threshold;
        this.mBatchStartTimeStamp = SystemClock.elapsedRealtime();
        this.initCachedCandidateContainersLocked(capacity);
    }

    @GuardedBy(value={"mLock"})
    private void initCachedCandidateContainersLocked(int capacity) {
        if (capacity > 0) {
            this.mCachedCandidateContainers = new HeavyHitterContainer[capacity];
            for (int i = 0; i < this.mCachedCandidateContainers.length; ++i) {
                this.mCachedCandidateContainers[i] = new HeavyHitterContainer();
            }
        } else {
            this.mCachedCandidateContainers = null;
        }
        this.mCachedCandidateContainersIndex = 0;
    }

    @GuardedBy(value={"mLock"})
    @NonNull
    private HeavyHitterContainer acquireHeavyHitterContainerLocked() {
        return this.mCachedCandidateContainers[this.mCachedCandidateContainersIndex++];
    }

    @GuardedBy(value={"mLock"})
    private void releaseHeavyHitterContainerLocked(@NonNull HeavyHitterContainer container) {
        this.mCachedCandidateContainers[--this.mCachedCandidateContainersIndex] = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTransaction(int callerUid, @NonNull Class clazz, int code) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEnabled) {
                return;
            }
            HeavyHitterSketch<Integer> sketch = this.mHeavyHitterSketch;
            if (sketch == null) {
                return;
            }
            int hashCode = HeavyHitterContainer.hashCode(callerUid, clazz, code);
            sketch.add(hashCode);
            ++this.mCurrentInputSize;
            if (this.mCurrentInputSize == this.mInputSize) {
                sketch.getCandidates(this.mCachedCandidateList);
                this.mCachedCandidateSet.addAll(this.mCachedCandidateList);
                this.mCachedCandidateList.clear();
            } else if (this.mCurrentInputSize > this.mInputSize && this.mCurrentInputSize < this.mTotalInputSize) {
                int index;
                if (this.mCachedCandidateSet.contains(hashCode) && (index = this.mHeavyHitterCandiates.indexOfKey(hashCode)) < 0) {
                    HeavyHitterContainer container = this.acquireHeavyHitterContainerLocked();
                    container.mUid = callerUid;
                    container.mClass = clazz;
                    container.mCode = code;
                    this.mHeavyHitterCandiates.put(hashCode, container);
                }
            } else if (this.mCurrentInputSize == this.mTotalInputSize) {
                int size;
                List<Integer> result;
                if (this.mListener != null && (result = sketch.getTopHeavyHitters(0, this.mCachedCandidateList, this.mCachedCandidateFrequencies)) != null && (size = result.size()) > 0) {
                    ArrayList<HeavyHitterContainer> hitters = new ArrayList<HeavyHitterContainer>();
                    for (int i = 0; i < size; ++i) {
                        HeavyHitterContainer container = this.mHeavyHitterCandiates.get(result.get(i));
                        if (container == null) continue;
                        HeavyHitterContainer cont = new HeavyHitterContainer(container);
                        cont.mFrequency = this.mCachedCandidateFrequencies.get(i).floatValue();
                        hitters.add(cont);
                    }
                    this.mListener.onHeavyHit(hitters, this.mTotalInputSize, this.mThreshold, SystemClock.elapsedRealtime() - this.mBatchStartTimeStamp);
                }
                this.mHeavyHitterSketch.reset();
                this.mHeavyHitterCandiates.clear();
                this.mCachedCandidateList.clear();
                this.mCachedCandidateFrequencies.clear();
                this.mCachedCandidateSet.clear();
                this.mCachedCandidateContainersIndex = 0;
                this.mCurrentInputSize = 0;
                this.mBatchStartTimeStamp = SystemClock.elapsedRealtime();
            }
        }
    }

    public static interface BinderCallHeavyHitterListener {
        public void onHeavyHit(List<HeavyHitterContainer> var1, int var2, float var3, long var4);
    }

    public static class HeavyHitterContainer {
        public int mUid;
        public Class mClass;
        public int mCode;
        public float mFrequency;

        public HeavyHitterContainer() {
        }

        public HeavyHitterContainer(@NonNull HeavyHitterContainer other) {
            this.mUid = other.mUid;
            this.mClass = other.mClass;
            this.mCode = other.mCode;
            this.mFrequency = other.mFrequency;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof HeavyHitterContainer)) {
                return false;
            }
            HeavyHitterContainer o = (HeavyHitterContainer)other;
            return this.mUid == o.mUid && this.mClass == o.mClass && this.mCode == o.mCode && Math.abs(this.mFrequency - o.mFrequency) < 1.0E-5f;
        }

        public int hashCode() {
            return HeavyHitterContainer.hashCode(this.mUid, this.mClass, this.mCode);
        }

        static int hashCode(int uid, @NonNull Class clazz, int code) {
            int hash = uid;
            hash = 31 * hash + clazz.hashCode();
            hash = 31 * hash + code;
            return hash;
        }
    }
}

