/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import java.io.FileDescriptor;
import java.io.IOException;
import java.time.DateTimeException;
import libcore.io.IoUtils;

public class ApplicationSharedMemory
implements AutoCloseable {
    public static final long INVALID_NETWORK_TIME = -1L;
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "ApplicationSharedMemory";
    @VisibleForTesting
    public static ApplicationSharedMemory sInstance;
    private final boolean mMutable;
    private FileDescriptor mFileDescriptor;
    private volatile long mPtr;

    public static ApplicationSharedMemory getInstance() {
        ApplicationSharedMemory instance = sInstance;
        if (instance == null) {
            throw new IllegalStateException("ApplicationSharedMemory not initialized");
        }
        return instance;
    }

    public static void setInstance(ApplicationSharedMemory instance) {
        if (sInstance != null) {
            throw new IllegalStateException("ApplicationSharedMemory already initialized");
        }
        sInstance = instance;
    }

    public static ApplicationSharedMemory create() {
        int fd = ApplicationSharedMemory.nativeCreate();
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.setInt$(fd);
        boolean mutable = true;
        long ptr = ApplicationSharedMemory.nativeMap(fd, true);
        ApplicationSharedMemory.nativeInit(ptr);
        return new ApplicationSharedMemory(fileDescriptor, true, ptr);
    }

    public static ApplicationSharedMemory fromFileDescriptor(@NonNull FileDescriptor fileDescriptor, boolean mutable) {
        long ptr = ApplicationSharedMemory.nativeMap(fileDescriptor.getInt$(), mutable);
        return new ApplicationSharedMemory(fileDescriptor, mutable, ptr);
    }

    private static int nativeCreate() {
        return OverrideMethod.invokeI("com.android.internal.os.ApplicationSharedMemory#nativeCreate()I", true, null);
    }

    private static long nativeMap(int n, boolean bl) {
        return OverrideMethod.invokeL("com.android.internal.os.ApplicationSharedMemory#nativeMap(IZ)J", true, null);
    }

    private static void nativeInit(long l) {
        OverrideMethod.invokeV("com.android.internal.os.ApplicationSharedMemory#nativeInit(J)V", true, null);
    }

    private static void nativeUnmap(long l) {
        OverrideMethod.invokeV("com.android.internal.os.ApplicationSharedMemory#nativeUnmap(J)V", true, null);
    }

    ApplicationSharedMemory(@NonNull FileDescriptor fileDescriptor, boolean mutable, long ptr) {
        this.mFileDescriptor = fileDescriptor;
        this.mMutable = mutable;
        this.mPtr = ptr;
    }

    public FileDescriptor getFileDescriptor() {
        this.checkFileOpen();
        return this.mFileDescriptor;
    }

    public FileDescriptor getReadOnlyFileDescriptor() throws IOException {
        this.checkFileOpen();
        FileDescriptor readOnlyFileDescriptor = new FileDescriptor();
        int readOnlyFd = ApplicationSharedMemory.nativeDupAsReadOnly(this.mFileDescriptor.getInt$());
        readOnlyFileDescriptor.setInt$(readOnlyFd);
        return readOnlyFileDescriptor;
    }

    private static int nativeDupAsReadOnly(int n) {
        return OverrideMethod.invokeI("com.android.internal.os.ApplicationSharedMemory#nativeDupAsReadOnly(I)I", true, null);
    }

    public void setLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(long offset) {
        this.checkMutable();
        ApplicationSharedMemory.nativeSetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(this.mPtr, offset);
    }

    public void clearLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis() {
        this.checkMutable();
        ApplicationSharedMemory.nativeSetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(this.mPtr, -1L);
    }

    @CriticalNative
    private static void nativeSetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(long l, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.ApplicationSharedMemory#nativeSetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(JJ)V", true, null);
    }

    public long getLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis() throws DateTimeException {
        this.checkMapped();
        long offset = ApplicationSharedMemory.nativeGetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(this.mPtr);
        if (offset == -1L) {
            throw new DateTimeException("No network time available");
        }
        return offset;
    }

    @CriticalNative
    public static long nativeGetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(long l) {
        return OverrideMethod.invokeL("com.android.internal.os.ApplicationSharedMemory#nativeGetLatestNetworkTimeUnixEpochMillisAtZeroElapsedRealtimeMillis(J)J", true, null);
    }

    public void closeFileDescriptor() {
        if (this.mFileDescriptor != null) {
            IoUtils.closeQuietly(this.mFileDescriptor);
            this.mFileDescriptor = null;
        }
    }

    @Override
    public void close() {
        if (this.mPtr != 0L) {
            ApplicationSharedMemory.nativeUnmap(this.mPtr);
            this.mPtr = 0L;
        }
        if (this.mFileDescriptor != null) {
            IoUtils.closeQuietly(this.mFileDescriptor);
            this.mFileDescriptor = null;
        }
    }

    private void checkFileOpen() {
        if (this.mFileDescriptor == null) {
            throw new IllegalStateException("File descriptor is closed");
        }
    }

    private void checkMapped() {
        if (this.mPtr == 0L) {
            throw new IllegalStateException("Instance is closed");
        }
    }

    private void checkMutable() {
        this.checkMapped();
        if (!this.mMutable) {
            throw new IllegalStateException("Not mutable");
        }
    }

    public boolean isMapped() {
        return this.mPtr != 0L;
    }

    public boolean isMutable() {
        return this.isMapped() && this.mMutable;
    }

    public long getSystemNonceBlock() {
        return this.isMapped() ? ApplicationSharedMemory.nativeGetSystemNonceBlock(this.mPtr) : 0L;
    }

    @FastNative
    private static long nativeGetSystemNonceBlock(long l) {
        return OverrideMethod.invokeL("com.android.internal.os.ApplicationSharedMemory#nativeGetSystemNonceBlock(J)J", true, null);
    }

    public void writeSystemFeaturesCache(@NonNull int[] featureVersions) {
        this.checkMutable();
        ApplicationSharedMemory.nativeWriteSystemFeaturesCache(this.mPtr, featureVersions);
    }

    @NonNull
    public int[] readSystemFeaturesCache() {
        this.checkMapped();
        return ApplicationSharedMemory.nativeReadSystemFeaturesCache(this.mPtr);
    }

    public void setCurrentAnimatorScale(float scale) {
        this.checkMutable();
        ApplicationSharedMemory.nativeSetCurrentAnimatorScale(this.mPtr, scale);
    }

    public float getCurrentAnimatorScale() {
        this.checkMapped();
        return ApplicationSharedMemory.nativeGetCurrentAnimatorScale(this.mPtr);
    }

    @FastNative
    private static void nativeWriteSystemFeaturesCache(long l, int[] nArray) {
        OverrideMethod.invokeV("com.android.internal.os.ApplicationSharedMemory#nativeWriteSystemFeaturesCache(J[I)V", true, null);
    }

    @FastNative
    private static int[] nativeReadSystemFeaturesCache(long l) {
        return (int[])OverrideMethod.invokeA("com.android.internal.os.ApplicationSharedMemory#nativeReadSystemFeaturesCache(J)[I", true, null);
    }

    @FastNative
    private static void nativeSetCurrentAnimatorScale(long l, float f) {
        OverrideMethod.invokeV("com.android.internal.os.ApplicationSharedMemory#nativeSetCurrentAnimatorScale(JF)V", true, null);
    }

    @FastNative
    private static float nativeGetCurrentAnimatorScale(long l) {
        return OverrideMethod.invokeF("com.android.internal.os.ApplicationSharedMemory#nativeGetCurrentAnimatorScale(J)F", true, null);
    }
}

