/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.notification;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.util.ArrayMap;
import com.android.internal.hidden_from_bootclasspath.android.service.notification.Flags;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NotificationChannelGroupsHelper {
    @Nullable
    public static NotificationChannelGroup getGroupWithChannels(@NonNull String groupId, @NonNull Collection<NotificationChannel> allChannels, @NonNull Map<String, NotificationChannelGroup> allGroups, boolean includeDeleted) {
        NotificationChannelGroup group = null;
        if (allGroups.containsKey(groupId)) {
            group = allGroups.get(groupId).clone();
            group.setChannels(new ArrayList<NotificationChannel>());
            for (NotificationChannel nc : allChannels) {
                if (!includeDeleted && nc.isDeleted() || !groupId.equals(nc.getGroup())) continue;
                group.addChannel(nc);
            }
        }
        return group;
    }

    @NonNull
    public static List<NotificationChannelGroup> getGroupsWithChannels(@NonNull Collection<NotificationChannel> allChannels, @NonNull Map<String, NotificationChannelGroup> allGroups, Params params) {
        ArrayMap<String, NotificationChannelGroup> outputGroups = new ArrayMap<String, NotificationChannelGroup>();
        NotificationChannelGroup nonGrouped = new NotificationChannelGroup(null, null);
        for (NotificationChannel nc : allChannels) {
            boolean includeChannel = !(!params.includeDeleted && nc.isDeleted() || params.channelFilter != null && (!params.includeAllBlockedWithFilter || nc.getImportance() != 0) && !params.channelFilter.contains(nc.getId()) || Flags.notificationClassification() && NotificationChannel.SYSTEM_RESERVED_IDS.contains(nc.getId()));
            if (!includeChannel) continue;
            if (nc.getGroup() != null) {
                if (allGroups.get(nc.getGroup()) == null) continue;
                NotificationChannelGroup ncg = (NotificationChannelGroup)outputGroups.get(nc.getGroup());
                if (ncg == null) {
                    ncg = allGroups.get(nc.getGroup()).clone();
                    ncg.setChannels(new ArrayList<NotificationChannel>());
                    outputGroups.put(nc.getGroup(), ncg);
                }
                ncg.addChannel(nc);
                continue;
            }
            nonGrouped.addChannel(nc);
        }
        if (params.includeNonGrouped && nonGrouped.getChannels().size() > 0) {
            outputGroups.put(null, nonGrouped);
        }
        if (params.includeEmpty) {
            for (NotificationChannelGroup group : allGroups.values()) {
                if (outputGroups.containsKey(group.getId())) continue;
                outputGroups.put(group.getId(), group);
            }
        }
        return new ArrayList<NotificationChannelGroup>(outputGroups.values());
    }

    public static class Params
    extends Record {
        private final boolean includeDeleted;
        private final boolean includeNonGrouped;
        private final boolean includeEmpty;
        private final boolean includeAllBlockedWithFilter;
        private final Set<String> channelFilter;

        public Params(boolean includeDeleted, boolean includeNonGrouped, boolean includeEmpty, boolean includeAllBlockedWithFilter, Set<String> channelFilter) {
            this.includeDeleted = includeDeleted;
            this.includeNonGrouped = includeNonGrouped;
            this.includeEmpty = includeEmpty;
            this.includeAllBlockedWithFilter = includeAllBlockedWithFilter;
            this.channelFilter = channelFilter;
        }

        public static Params forAllGroups() {
            return new Params(false, false, true, true, null);
        }

        public static Params forAllChannels(boolean includeDeleted) {
            return new Params(includeDeleted, true, false, true, null);
        }

        public static Params onlySpecifiedOrBlockedChannels(Set<String> channelFilter) {
            return new Params(false, true, false, true, channelFilter);
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Params.class, "includeDeleted;includeNonGrouped;includeEmpty;includeAllBlockedWithFilter;channelFilter", "includeDeleted", "includeNonGrouped", "includeEmpty", "includeAllBlockedWithFilter", "channelFilter"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Params.class, "includeDeleted;includeNonGrouped;includeEmpty;includeAllBlockedWithFilter;channelFilter", "includeDeleted", "includeNonGrouped", "includeEmpty", "includeAllBlockedWithFilter", "channelFilter"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Params.class, "includeDeleted;includeNonGrouped;includeEmpty;includeAllBlockedWithFilter;channelFilter", "includeDeleted", "includeNonGrouped", "includeEmpty", "includeAllBlockedWithFilter", "channelFilter"}, this, o);
        }

        public boolean includeDeleted() {
            return this.includeDeleted;
        }

        public boolean includeNonGrouped() {
            return this.includeNonGrouped;
        }

        public boolean includeEmpty() {
            return this.includeEmpty;
        }

        public boolean includeAllBlockedWithFilter() {
            return this.includeAllBlockedWithFilter;
        }

        public Set<String> channelFilter() {
            return this.channelFilter;
        }
    }
}

