/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.utils;

import com.android.internal.net.ipsec.ike.utils.IkeMetricsInterface;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class IkeMetrics {
    public static final int IKE_CALLER_UNKNOWN = 0;
    public static final int IKE_CALLER_IWLAN = 1;
    public static final int IKE_CALLER_VCN = 2;
    public static final int IKE_CALLER_VPN = 3;
    public static final int IKE_SESSION_TYPE_UNKNOWN = 0;
    public static final int IKE_SESSION_TYPE_IKE = 1;
    public static final int IKE_SESSION_TYPE_CHILD = 2;
    public static final int DH_GROUP_UNSPECIFIED = 0;
    public static final int DH_GROUP_NONE = 1;
    public static final int DH_GROUP_1024_BIT_MODP = 2;
    public static final int DH_GROUP_1536_BIT_MODP = 5;
    public static final int DH_GROUP_2048_BIT_MODP = 14;
    public static final int DH_GROUP_3072_BIT_MODP = 15;
    public static final int DH_GROUP_4096_BIT_MODP = 16;
    public static final int DH_GROUP_CURVE_25519 = 31;
    public static final int INTEGRITY_ALGORITHM_UNSPECIFIED = 0;
    public static final int INTEGRITY_ALGORITHM_NONE = 1;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA1_96 = 2;
    public static final int INTEGRITY_ALGORITHM_AES_XCBC_96 = 5;
    public static final int INTEGRITY_ALGORITHM_AES_CMAC_96 = 8;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_256_128 = 12;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_384_192 = 13;
    public static final int INTEGRITY_ALGORITHM_HMAC_SHA2_512_256 = 14;
    public static final int PSEUDORANDOM_FUNCTION_UNSPECIFIED = 0;
    public static final int PSEUDORANDOM_FUNCTION_HMAC_SHA1 = 2;
    public static final int PSEUDORANDOM_FUNCTION_AES128_XCBC = 4;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_256 = 5;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_384 = 6;
    public static final int PSEUDORANDOM_FUNCTION_SHA2_512 = 7;
    public static final int PSEUDORANDOM_FUNCTION_AES128_CMAC = 8;
    public static final int ENCRYPTION_ALGORITHM_UNSPECIFIED = 0;
    public static final int ENCRYPTION_ALGORITHM_3DES = 3;
    public static final int ENCRYPTION_ALGORITHM_AES_CBC = 12;
    public static final int ENCRYPTION_ALGORITHM_AES_CTR = 13;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_8 = 18;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_12 = 19;
    public static final int ENCRYPTION_ALGORITHM_AES_GCM_16 = 20;
    public static final int ENCRYPTION_ALGORITHM_CHACHA20_POLY1305 = 28;
    public static final int KEY_LEN_UNSPECIFIED = 0;
    public static final int KEY_LEN_UNUSED = 1;
    public static final int KEY_LEN_AES_128 = 128;
    public static final int KEY_LEN_AES_192 = 192;
    public static final int KEY_LEN_AES_256 = 256;
    public static final int IKE_STATE_UNKNOWN = 0;
    public static final int IKE_STATE_IKE_KILL = 1;
    public static final int IKE_STATE_IKE_INITIAL = 2;
    public static final int IKE_STATE_IKE_CREATE_LOCAL_IKE_INIT = 3;
    public static final int IKE_STATE_IKE_CREATE_LOCAL_IKE_AUTH = 4;
    public static final int IKE_STATE_IKE_CREATE_LOCAL_IKE_AUTH_IN_EAP = 5;
    public static final int IKE_STATE_IKE_CREATE_LOCAL_IKE_AUTH_POST_EAP = 6;
    public static final int IKE_STATE_IKE_IDLE = 7;
    public static final int IKE_STATE_IKE_CHILD_PROCEDURE_ONGOING = 8;
    public static final int IKE_STATE_IKE_RECEIVING = 9;
    public static final int IKE_STATE_IKE_REKEY_LOCAL_CREATE = 10;
    public static final int IKE_STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_CREATE = 11;
    public static final int IKE_STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE_REMOTE_DELETE = 12;
    public static final int IKE_STATE_IKE_SIMULTANEOUS_REKEY_LOCAL_DELETE = 13;
    public static final int IKE_STATE_IKE_SIMULTANEOUS_REKEY_REMOTE_DELETE = 14;
    public static final int IKE_STATE_IKE_REKEY_LOCAL_DELETE = 15;
    public static final int IKE_STATE_IKE_REKEY_REMOTE_DELETE = 16;
    public static final int IKE_STATE_IKE_DELETE_LOCAL_DELETE = 17;
    public static final int IKE_STATE_IKE_DPD_LOCAL_INFO = 18;
    public static final int IKE_STATE_IKE_MOBIKE_LOCAL_INFO = 19;
    public static final int IKE_STATE_IKE_DPD_ON_DEMAND_LOCAL_INFO = 20;
    public static final int IKE_STATE_CHILD_KILL = 101;
    public static final int IKE_STATE_CHILD_INITIAL = 102;
    public static final int IKE_STATE_CHILD_CREATE_LOCAL_CREATE = 103;
    public static final int IKE_STATE_CHILD_IDLE = 104;
    public static final int IKE_STATE_CHILD_IDLE_WITH_DEFERRED_REQUEST = 105;
    public static final int IKE_STATE_CHILD_CLOSE_AND_AWAIT_RESPONSE = 106;
    public static final int IKE_STATE_CHILD_DELETE_LOCAL_DELETE = 107;
    public static final int IKE_STATE_CHILD_DELETE_REMOTE_DELETE = 108;
    public static final int IKE_STATE_CHILD_REKEY_LOCAL_CREATE = 109;
    public static final int IKE_STATE_CHILD_MOBIKE_REKEY_LOCAL_CREATE = 110;
    public static final int IKE_STATE_CHILD_REKEY_REMOTE_CREATE = 111;
    public static final int IKE_STATE_CHILD_REKEY_LOCAL_DELETE = 112;
    public static final int IKE_STATE_CHILD_REKEY_REMOTE_DELETE = 113;
    public static final int IKE_ERROR_UNKNOWN = 0xFFFFFFF;
    public static final int IKE_ERROR_NONE = 0;
    public static final int IKE_ERROR_INTERNAL = 65536;
    public static final int IKE_ERROR_NETWORK_LOST = 131072;
    public static final int IKE_ERROR_IO_GENERAL = 196608;
    public static final int IKE_ERROR_IO_TIMEOUT = 196609;
    public static final int IKE_ERROR_IO_DNS_FAILURE = 196610;
    public static final int IKE_ERROR_PROTOCOL_UNKNOWN = 262144;
    public static final int IKE_ERROR_PROTOCOL_UNSUPPORTED_CRITICAL_PAYLOAD = 262145;
    public static final int IKE_ERROR_PROTOCOL_INVALID_IKE_SPI = 262148;
    public static final int IKE_ERROR_PROTOCOL_INVALID_MAJOR_VERSION = 262149;
    public static final int IKE_ERROR_PROTOCOL_INVALID_SYNTAX = 262151;
    public static final int IKE_ERROR_PROTOCOL_INVALID_MESSAGE_ID = 262153;
    public static final int IKE_ERROR_PROTOCOL_NO_PROPOSAL_CHOSEN = 262158;
    public static final int IKE_ERROR_PROTOCOL_INVALID_KE_PAYLOAD = 262161;
    public static final int IKE_ERROR_PROTOCOL_AUTHENTICATION_FAILED = 262168;
    public static final int IKE_ERROR_PROTOCOL_SINGLE_PAIR_REQUIRED = 262178;
    public static final int IKE_ERROR_PROTOCOL_NO_ADDITIONAL_SAS = 262179;
    public static final int IKE_ERROR_PROTOCOL_INTERNAL_ADDRESS_FAILURE = 262180;
    public static final int IKE_ERROR_PROTOCOL_FAILED_CP_REQUIRED = 262181;
    public static final int IKE_ERROR_PROTOCOL_TS_UNACCEPTABLE = 262182;
    public static final int IKE_ERROR_PROTOCOL_INVALID_SELECTORS = 262183;
    public static final int IKE_ERROR_PROTOCOL_TEMPORARY_FAILURE = 262187;
    public static final int IKE_ERROR_PROTOCOL_CHILD_SA_NOT_FOUND = 262188;
    public static final int IKE_TASK_UNSPECIFIED = 0;
    public static final int IKE_UNDERLYING_NETWORK_TYPE_UNSPECIFIED = 0;
    public static final int IKE_UNDERLYING_NETWORK_TYPE_WIFI = 1;
    public static final int IKE_UNDERLYING_NETWORK_TYPE_CELLULAR = 2;

    public void logSessionTerminated(int ikeCaller, int ikeSessionType, int ikeState, int ikeError) {
        IkeMetricsInterface.write(678, ikeCaller, ikeSessionType, ikeState, ikeError);
    }

    public void logLivenessCheckCompleted(int ikeCaller, int ikeState, int ikeUnderlyingNetworkType, int elapsedTimeInMillis, int numberOfOnGoing, boolean resultSuccess) {
        IkeMetricsInterface.write(760, ikeCaller, 0, ikeUnderlyingNetworkType, elapsedTimeInMillis, numberOfOnGoing, resultSuccess, ikeState);
    }

    public void logSaNegotiation(int ikeCaller, int ikeSessionType, int ikeState, int dhGroup, int encryptionAlgorithm, int keyLength, int integrityAlgorithm, int prfAlgorithm, int ikeError) {
        IkeMetricsInterface.write(821, ikeCaller, ikeSessionType, ikeState, dhGroup, encryptionAlgorithm, keyLength, integrityAlgorithm, prfAlgorithm, ikeError);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeUnderlyingNetworkType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface KeyLengths {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EncryptionAlgorithms {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrfAlgorithms {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntegrityAlgorithms {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DhGroups {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeSessionType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IkeCaller {
    }
}

