/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.animation.AnimationHandler;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.HardwareRendererObserver;
import android.os.Handler;
import android.os.Trace;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.FrameMetrics;
import android.view.SurfaceControl;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowCallbacks;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.com.android.internal.jank.Flags;
import com.android.internal.jank.DisplayRefreshRate;
import com.android.internal.jank.DisplayResolutionTracker;
import com.android.internal.jank.InteractionJankMonitor;
import com.android.internal.util.FrameworkStatsLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FrameTracker
implements HardwareRendererObserver.OnFrameMetricsAvailableListener,
SurfaceControl.OnJankDataListener {
    private static final String TAG = "FrameTracker";
    private static final long INVALID_ID = -1L;
    public static final int NANOS_IN_MILLISECOND = 1000000;
    private static final int MAX_LENGTH_EVENT_DESC = 127;
    private static final int MAX_FLUSH_ATTEMPTS = 3;
    private static final int FLUSH_DELAY_MILLISECOND = 60;
    static final int REASON_END_UNKNOWN = -1;
    static final int REASON_END_NORMAL = 0;
    static final int REASON_END_SURFACE_DESTROYED = 1;
    static final int REASON_CANCEL_NORMAL = 16;
    static final int REASON_CANCEL_NOT_BEGUN = 17;
    static final int REASON_CANCEL_SAME_VSYNC = 18;
    static final int REASON_CANCEL_TIMEOUT = 19;
    private final HardwareRendererObserver mObserver;
    private final int mTraceThresholdMissedFrames;
    private final int mTraceThresholdFrameTimeMillis;
    private final ThreadedRendererWrapper mRendererWrapper;
    private final FrameMetricsWrapper mMetricsWrapper;
    private final SparseArray<JankInfo> mJankInfos = new SparseArray();
    private final InteractionJankMonitor.Configuration mConfig;
    private final ViewRootWrapper mViewRoot;
    private final SurfaceControlWrapper mSurfaceControlWrapper;
    private final int mDisplayId;
    private final ViewRootImpl.SurfaceChangedCallback mSurfaceChangedCallback;
    private final Handler mHandler;
    private final ChoreographerWrapper mChoreographer;
    private final StatsLogWrapper mStatsLog;
    private final boolean mDeferMonitoring;
    private final FrameTrackerListener mListener;
    @VisibleForTesting
    public final boolean mSurfaceOnly;
    private SurfaceControl mSurfaceControl;
    private SurfaceControl.OnJankDataListenerRegistration mJankDataListenerRegistration;
    private long mBeginVsyncId = -1L;
    private long mEndVsyncId = -1L;
    private boolean mMetricsFinalized;
    private boolean mCancelled = false;
    private boolean mTracingStarted = false;
    private Runnable mWaitForFinishTimedOut;

    public FrameTracker(@NonNull InteractionJankMonitor.Configuration config, @Nullable ThreadedRendererWrapper renderer, @Nullable ViewRootWrapper viewRootWrapper, @NonNull SurfaceControlWrapper surfaceControlWrapper, @NonNull ChoreographerWrapper choreographer, @Nullable FrameMetricsWrapper metrics, @NonNull StatsLogWrapper statsLog, int traceThresholdMissedFrames, int traceThresholdFrameTimeMillis, @Nullable FrameTrackerListener listener) {
        this.mSurfaceOnly = config.isSurfaceOnly();
        this.mConfig = config;
        this.mHandler = config.getHandler();
        this.mChoreographer = choreographer;
        this.mSurfaceControlWrapper = surfaceControlWrapper;
        this.mStatsLog = statsLog;
        this.mDeferMonitoring = config.shouldDeferMonitor();
        this.mRendererWrapper = this.mSurfaceOnly ? null : renderer;
        this.mMetricsWrapper = this.mSurfaceOnly ? null : metrics;
        this.mViewRoot = this.mSurfaceOnly ? null : viewRootWrapper;
        this.mObserver = this.mSurfaceOnly || Flags.useSfFrameDuration() && Flags.ignoreHwuiIsFirstFrame() ? null : new HardwareRendererObserver(this, this.mMetricsWrapper.getTiming(), this.mHandler, false);
        this.mTraceThresholdMissedFrames = traceThresholdMissedFrames;
        this.mTraceThresholdFrameTimeMillis = traceThresholdFrameTimeMillis;
        this.mListener = listener;
        this.mDisplayId = config.getDisplayId();
        if (this.mSurfaceOnly) {
            this.mSurfaceControl = config.getSurfaceControl();
            this.mSurfaceChangedCallback = null;
        } else {
            if (this.mViewRoot.getSurfaceControl().isValid()) {
                this.mSurfaceControl = this.mViewRoot.getSurfaceControl();
            }
            this.mSurfaceChangedCallback = new ViewRootImpl.SurfaceChangedCallback(){

                @Override
                public void surfaceCreated(SurfaceControl.Transaction t) {
                    Trace.beginSection("FrameTracker#surfaceCreated");
                    FrameTracker.this.mHandler.runWithScissors(() -> {
                        if (FrameTracker.this.mSurfaceControl == null) {
                            FrameTracker.this.mSurfaceControl = FrameTracker.this.mViewRoot.getSurfaceControl();
                            if (FrameTracker.this.mBeginVsyncId != -1L) {
                                FrameTracker.this.begin();
                            }
                        }
                    }, 500L);
                    Trace.endSection();
                }

                @Override
                public void surfaceReplaced(SurfaceControl.Transaction t) {
                }

                @Override
                public void surfaceDestroyed() {
                    FrameTracker.this.mHandler.post(() -> {
                        if (!FrameTracker.this.mMetricsFinalized) {
                            FrameTracker.this.end(1);
                        }
                    });
                }
            };
            this.mViewRoot.addSurfaceChangedCallback(this.mSurfaceChangedCallback);
        }
    }

    public void begin() {
        long currentVsync = this.mChoreographer.getVsyncId();
        if (this.mBeginVsyncId == -1L) {
            long l = this.mBeginVsyncId = this.mDeferMonitoring ? currentVsync + 1L : currentVsync;
        }
        if (this.mSurfaceControl != null) {
            if (this.mDeferMonitoring && currentVsync < this.mBeginVsyncId) {
                this.markEvent("FT#deferMonitoring", 0L);
                this.postTraceStartMarker(this::beginInternal);
            } else {
                this.beginInternal();
            }
        }
    }

    @VisibleForTesting
    public void postTraceStartMarker(Runnable action) {
        this.mChoreographer.mChoreographer.postCallback(0, action, null);
    }

    private void beginInternal() {
        if (this.mCancelled || this.mEndVsyncId != -1L) {
            return;
        }
        this.mTracingStarted = true;
        String name = this.mConfig.getSessionName();
        Trace.asyncTraceForTrackBegin(4096L, name, name, (int)this.mBeginVsyncId);
        this.markEvent("FT#beginVsync", this.mBeginVsyncId);
        this.markEvent("FT#layerId", this.mSurfaceControl.getLayerId());
        this.markCujUiThread();
        this.mJankDataListenerRegistration = this.mSurfaceControlWrapper.addJankStatsListener(this, this.mSurfaceControl);
        if (!this.mSurfaceOnly) {
            this.mRendererWrapper.addObserver(this.mObserver);
        }
    }

    public boolean end(int reason) {
        if (this.mCancelled || this.mEndVsyncId != -1L) {
            return false;
        }
        this.mEndVsyncId = AnimationHandler.getInstance().getLastAnimationFrameVsyncId(this.mChoreographer.getVsyncId());
        if (this.mBeginVsyncId == -1L) {
            return this.cancel(17);
        }
        if (this.mEndVsyncId <= this.mBeginVsyncId) {
            return this.cancel(18);
        }
        final String name = this.mConfig.getSessionName();
        this.markEvent("FT#end", reason);
        this.markEvent("FT#endVsync", this.mEndVsyncId);
        Trace.asyncTraceForTrackEnd(4096L, name, (int)this.mBeginVsyncId);
        if (this.mJankDataListenerRegistration != null) {
            this.mJankDataListenerRegistration.removeAfter(this.mEndVsyncId);
        }
        this.mWaitForFinishTimedOut = new Runnable(){
            private int mFlushAttempts = 0;

            @Override
            public void run() {
                long delay;
                if (FrameTracker.this.mWaitForFinishTimedOut == null || FrameTracker.this.mMetricsFinalized) {
                    return;
                }
                if (FrameTracker.this.mSurfaceControl != null && FrameTracker.this.mSurfaceControl.isValid()) {
                    SurfaceControl.Transaction.sendSurfaceFlushJankData(FrameTracker.this.mSurfaceControl);
                }
                if (FrameTracker.this.mJankDataListenerRegistration != null) {
                    FrameTracker.this.mJankDataListenerRegistration.flush();
                }
                if (this.mFlushAttempts < 3) {
                    delay = 60L;
                    ++this.mFlushAttempts;
                } else {
                    FrameTracker.this.mWaitForFinishTimedOut = () -> {
                        Log.e(FrameTracker.TAG, "force finish cuj, time out: " + name);
                        FrameTracker.this.finish();
                    };
                    delay = TimeUnit.SECONDS.toMillis(10L);
                }
                FrameTracker.this.mHandler.postDelayed(FrameTracker.this.mWaitForFinishTimedOut, delay);
            }
        };
        this.mHandler.postDelayed(this.mWaitForFinishTimedOut, 60L);
        this.notifyCujEvent(InteractionJankMonitor.ACTION_SESSION_END, reason);
        return true;
    }

    public boolean cancel(int reason) {
        boolean cancelFromEnd;
        boolean bl = cancelFromEnd = reason == 17 || reason == 18;
        if (this.mCancelled || this.mEndVsyncId != -1L && !cancelFromEnd) {
            return false;
        }
        this.mCancelled = true;
        this.markEvent("FT#cancel", reason);
        if (this.mTracingStarted) {
            Trace.asyncTraceForTrackEnd(4096L, this.mConfig.getSessionName(), (int)this.mBeginVsyncId);
        }
        this.removeObservers();
        this.notifyCujEvent(InteractionJankMonitor.ACTION_SESSION_CANCEL, reason);
        return true;
    }

    private void markEvent(@NonNull String eventName, long eventValue) {
        if (Trace.isTagEnabled(4096L)) {
            String event = TextUtils.formatSimple("%s#%s", eventName, eventValue);
            if (event.length() > 127) {
                throw new IllegalArgumentException(TextUtils.formatSimple("The length of the trace event description <%s> exceeds %d", event, 127));
            }
            Trace.instantForTrack(4096L, this.mConfig.getSessionName(), event);
        }
    }

    private void markCujUiThread() {
        if (Trace.isTagEnabled(4096L)) {
            Trace.instant(4096L, this.mConfig.getSessionName() + "#UIThread");
        }
    }

    private void notifyCujEvent(String action, int reason) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onCujEvents(this, action, reason);
    }

    @Override
    public void onJankDataAvailable(List<SurfaceControl.JankData> jankData) {
        this.postCallback(() -> {
            try {
                Trace.beginSection("FrameTracker#onJankDataAvailable");
                if (this.mCancelled || this.mMetricsFinalized) {
                    return;
                }
                for (SurfaceControl.JankData jankStat : jankData) {
                    if (!this.isInRange(jankStat.getVsyncId())) continue;
                    JankInfo info = this.findJankInfo(jankStat.getVsyncId());
                    if (info != null) {
                        info.update(jankStat);
                        continue;
                    }
                    this.mJankInfos.put((int)jankStat.getVsyncId(), JankInfo.createFromSurfaceControlCallback(jankStat));
                }
                this.processJankInfos();
            }
            finally {
                Trace.endSection();
            }
        });
    }

    @VisibleForTesting
    public void postCallback(Runnable callback) {
        this.mHandler.post(callback);
    }

    @Nullable
    private JankInfo findJankInfo(long frameVsyncId) {
        return this.mJankInfos.get((int)frameVsyncId);
    }

    private boolean isInRange(long vsyncId) {
        return vsyncId >= this.mBeginVsyncId;
    }

    @Override
    public void onFrameMetricsAvailable(int dropCountSinceLastInvocation) {
        this.postCallback(() -> {
            try {
                Trace.beginSection("FrameTracker#onFrameMetricsAvailable");
                if (this.mCancelled || this.mMetricsFinalized) {
                    return;
                }
                long totalDurationNanos = this.mMetricsWrapper.getMetric(8);
                boolean isFirstFrame = this.mMetricsWrapper.getMetric(9) == 1L;
                long frameVsyncId = this.mMetricsWrapper.getTiming()[1];
                if (!this.isInRange(frameVsyncId)) {
                    return;
                }
                JankInfo info = this.findJankInfo(frameVsyncId);
                if (info != null) {
                    info.update(totalDurationNanos, isFirstFrame);
                } else {
                    this.mJankInfos.put((int)frameVsyncId, JankInfo.createFromHwuiCallback(frameVsyncId, totalDurationNanos, isFirstFrame));
                }
                this.processJankInfos();
            }
            finally {
                Trace.endSection();
            }
        });
    }

    private boolean hasReceivedCallbacksAfterEnd() {
        JankInfo last;
        if (this.mEndVsyncId == -1L) {
            return false;
        }
        JankInfo jankInfo = last = this.mJankInfos.size() == 0 ? null : this.mJankInfos.valueAt(this.mJankInfos.size() - 1);
        if (last == null) {
            return false;
        }
        if (last.frameVsyncId < this.mEndVsyncId) {
            return false;
        }
        for (int i = this.mJankInfos.size() - 1; i >= 0; --i) {
            JankInfo info = this.mJankInfos.valueAt(i);
            if (info.frameVsyncId < this.mEndVsyncId || !this.callbacksReceived(info)) continue;
            return true;
        }
        return false;
    }

    private void processJankInfos() {
        if (this.mMetricsFinalized) {
            return;
        }
        if (!this.hasReceivedCallbacksAfterEnd()) {
            return;
        }
        this.finish();
    }

    private boolean callbacksReceived(JankInfo info) {
        return this.mObserver == null ? info.surfaceControlCallbackFired : info.hwuiCallbackFired && info.surfaceControlCallbackFired;
    }

    private void finish() {
        Trace.beginSection("FrameTracker#finish");
        this.finishTraced();
        Trace.endSection();
    }

    private void finishTraced() {
        if (this.mMetricsFinalized || this.mCancelled) {
            return;
        }
        this.mMetricsFinalized = true;
        this.mHandler.removeCallbacks(this.mWaitForFinishTimedOut);
        this.mWaitForFinishTimedOut = null;
        this.markEvent("FT#finish", this.mJankInfos.size());
        this.removeObservers();
        String name = this.mConfig.getSessionName();
        int totalFramesCount = 0;
        long maxFrameTimeNanos = 0L;
        int missedFramesCount = 0;
        int missedAppFramesCount = 0;
        int missedSfFramesCount = 0;
        int maxSuccessiveMissedFramesCount = 0;
        int successiveMissedFramesCount = 0;
        int refreshRate = 0;
        for (int i = 0; i < this.mJankInfos.size(); ++i) {
            boolean isFirstDrawn;
            JankInfo info = this.mJankInfos.valueAt(i);
            boolean bl = isFirstDrawn = !this.mSurfaceOnly && info.isFirstFrame;
            if (isFirstDrawn && !Flags.ignoreHwuiIsFirstFrame()) continue;
            if (info.frameVsyncId > this.mEndVsyncId) break;
            if (info.surfaceControlCallbackFired) {
                ++totalFramesCount;
                boolean missedFrame = false;
                if ((info.jankType & 2) != 0) {
                    Log.w(TAG, "Missed App frame:" + info + ", CUJ=" + name);
                    ++missedAppFramesCount;
                    missedFrame = true;
                }
                if ((info.jankType & 1) != 0) {
                    Log.w(TAG, "Missed SF frame:" + info + ", CUJ=" + name);
                    ++missedSfFramesCount;
                    missedFrame = true;
                }
                if (missedFrame) {
                    ++missedFramesCount;
                    ++successiveMissedFramesCount;
                } else {
                    maxSuccessiveMissedFramesCount = Math.max(maxSuccessiveMissedFramesCount, successiveMissedFramesCount);
                    successiveMissedFramesCount = 0;
                }
                if (info.refreshRate != 0 && info.refreshRate != refreshRate) {
                    int n = refreshRate = refreshRate == 0 ? info.refreshRate : 1;
                }
                if (this.mObserver != null && !info.hwuiCallbackFired) {
                    this.markEvent("FT#MissedHWUICallback", info.frameVsyncId);
                    Log.w(TAG, "Missing HWUI jank callback for vsyncId: " + info.frameVsyncId + ", CUJ=" + name);
                }
            }
            if (!this.mSurfaceOnly && info.hwuiCallbackFired) {
                maxFrameTimeNanos = Math.max(info.totalDurationNanos, maxFrameTimeNanos);
                if (info.surfaceControlCallbackFired) continue;
                this.markEvent("FT#MissedSFCallback", info.frameVsyncId);
                Log.w(TAG, "Missing SF jank callback for vsyncId: " + info.frameVsyncId + ", CUJ=" + name);
                continue;
            }
            if (!Flags.useSfFrameDuration() || !info.surfaceControlCallbackFired) continue;
            maxFrameTimeNanos = Math.max(info.totalDurationNanos, maxFrameTimeNanos);
        }
        maxSuccessiveMissedFramesCount = Math.max(maxSuccessiveMissedFramesCount, successiveMissedFramesCount);
        Trace.traceCounter(4096L, name + "#missedFrames", missedFramesCount);
        Trace.traceCounter(4096L, name + "#missedAppFrames", missedAppFramesCount);
        Trace.traceCounter(4096L, name + "#missedSfFrames", missedSfFramesCount);
        Trace.traceCounter(4096L, name + "#totalFrames", totalFramesCount);
        Trace.traceCounter(4096L, name + "#maxFrameTimeMillis", (int)(maxFrameTimeNanos / 1000000L));
        Trace.traceCounter(4096L, name + "#maxSuccessiveMissedFrames", maxSuccessiveMissedFramesCount);
        if (this.mListener != null && this.shouldTriggerPerfetto(missedFramesCount, (int)maxFrameTimeNanos)) {
            this.mListener.triggerPerfetto(this.mConfig);
        }
        if (this.mConfig.logToStatsd()) {
            this.mStatsLog.write(305, this.mDisplayId, refreshRate, this.mConfig.getStatsdInteractionType(), totalFramesCount, missedFramesCount, maxFrameTimeNanos, missedSfFramesCount, missedAppFramesCount, maxSuccessiveMissedFramesCount);
        }
    }

    private boolean shouldTriggerPerfetto(int missedFramesCount, int maxFrameTimeNanos) {
        boolean overMissedFramesThreshold = this.mTraceThresholdMissedFrames != -1 && missedFramesCount >= this.mTraceThresholdMissedFrames;
        boolean overFrameTimeThreshold = !this.mSurfaceOnly && this.mTraceThresholdFrameTimeMillis != -1 && maxFrameTimeNanos >= this.mTraceThresholdFrameTimeMillis * 1000000;
        return overMissedFramesThreshold || overFrameTimeThreshold;
    }

    @VisibleForTesting
    public void removeObservers() {
        if (this.mJankDataListenerRegistration != null) {
            this.mJankDataListenerRegistration.release();
            this.mJankDataListenerRegistration = null;
        }
        if (!this.mSurfaceOnly) {
            this.mRendererWrapper.removeObserver(this.mObserver);
            if (this.mSurfaceChangedCallback != null) {
                this.mViewRoot.removeSurfaceChangedCallback(this.mSurfaceChangedCallback);
            }
        }
    }

    public static class ChoreographerWrapper {
        private final Choreographer mChoreographer;

        public ChoreographerWrapper(Choreographer choreographer) {
            this.mChoreographer = choreographer;
        }

        public long getVsyncId() {
            return this.mChoreographer.getVsyncId();
        }
    }

    public static class SurfaceControlWrapper {
        public SurfaceControl.OnJankDataListenerRegistration addJankStatsListener(SurfaceControl.OnJankDataListener listener, SurfaceControl surfaceControl) {
            return surfaceControl.addOnJankDataListener(listener);
        }
    }

    public static class StatsLogWrapper {
        private final DisplayResolutionTracker mDisplayResolutionTracker;

        public StatsLogWrapper(DisplayResolutionTracker displayResolutionTracker) {
            this.mDisplayResolutionTracker = displayResolutionTracker;
        }

        public void write(int code, int displayId, int refreshRate, int arg1, long arg2, long arg3, long arg4, long arg5, long arg6, long arg7) {
            FrameworkStatsLog.write(code, arg1, arg2, arg3, arg4, arg5, arg6, arg7, this.mDisplayResolutionTracker.getResolution(displayId), refreshRate);
        }
    }

    public static class ThreadedRendererWrapper {
        private final ThreadedRenderer mRenderer;

        public ThreadedRendererWrapper(ThreadedRenderer renderer) {
            this.mRenderer = renderer;
        }

        public void addObserver(HardwareRendererObserver observer) {
            if (observer != null) {
                this.mRenderer.addObserver(observer);
            }
        }

        public void removeObserver(HardwareRendererObserver observer) {
            if (observer != null) {
                this.mRenderer.removeObserver(observer);
            }
        }
    }

    public static class FrameMetricsWrapper {
        private final FrameMetrics mFrameMetrics = new FrameMetrics();

        public long[] getTiming() {
            return this.mFrameMetrics.mTimingData;
        }

        public long getMetric(int index) {
            return this.mFrameMetrics.getMetric(index);
        }
    }

    public static class ViewRootWrapper {
        private final ViewRootImpl mViewRoot;

        public ViewRootWrapper(ViewRootImpl viewRoot) {
            this.mViewRoot = viewRoot;
        }

        public void addSurfaceChangedCallback(ViewRootImpl.SurfaceChangedCallback callback) {
            this.mViewRoot.addSurfaceChangedCallback(callback);
        }

        public void removeSurfaceChangedCallback(ViewRootImpl.SurfaceChangedCallback callback) {
            this.mViewRoot.removeSurfaceChangedCallback(callback);
        }

        public SurfaceControl getSurfaceControl() {
            return this.mViewRoot.getSurfaceControl();
        }

        void requestInvalidateRootRenderNode() {
            this.mViewRoot.requestInvalidateRootRenderNode();
        }

        void addWindowCallbacks(WindowCallbacks windowCallbacks) {
            this.mViewRoot.addWindowCallbacks(windowCallbacks);
        }

        void removeWindowCallbacks(WindowCallbacks windowCallbacks) {
            this.mViewRoot.removeWindowCallbacks(windowCallbacks);
        }

        View getView() {
            return this.mViewRoot.getView();
        }

        int dipToPx(int dip) {
            DisplayMetrics displayMetrics = this.mViewRoot.mContext.getResources().getDisplayMetrics();
            return (int)(displayMetrics.density * (float)dip + 0.5f);
        }
    }

    public static interface FrameTrackerListener {
        public void onCujEvents(FrameTracker var1, String var2, int var3);

        public void triggerPerfetto(InteractionJankMonitor.Configuration var1);
    }

    private static class JankInfo {
        final long frameVsyncId;
        long totalDurationNanos;
        boolean isFirstFrame;
        boolean hwuiCallbackFired;
        boolean surfaceControlCallbackFired;
        int jankType;
        int refreshRate;

        static JankInfo createFromHwuiCallback(long frameVsyncId, long totalDurationNanos, boolean isFirstFrame) {
            return new JankInfo(frameVsyncId).update(totalDurationNanos, isFirstFrame);
        }

        static JankInfo createFromSurfaceControlCallback(SurfaceControl.JankData jankStat) {
            return new JankInfo(jankStat.getVsyncId()).update(jankStat);
        }

        private JankInfo(long frameVsyncId) {
            this.frameVsyncId = frameVsyncId;
            this.hwuiCallbackFired = false;
            this.surfaceControlCallbackFired = false;
            this.jankType = 0;
            this.refreshRate = 0;
            this.totalDurationNanos = 0L;
            this.isFirstFrame = false;
        }

        private JankInfo update(SurfaceControl.JankData jankStat) {
            this.surfaceControlCallbackFired = true;
            this.jankType = jankStat.getJankType();
            this.refreshRate = DisplayRefreshRate.getRefreshRate(jankStat.getFrameIntervalNanos());
            if (Flags.useSfFrameDuration()) {
                this.totalDurationNanos = jankStat.getActualAppFrameTimeNanos();
            }
            return this;
        }

        private JankInfo update(long totalDurationNanos, boolean isFirstFrame) {
            this.hwuiCallbackFired = true;
            if (!Flags.useSfFrameDuration()) {
                this.totalDurationNanos = totalDurationNanos;
            }
            this.isFirstFrame = isFirstFrame;
            return this;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            switch (this.jankType) {
                case 0: {
                    str.append("JANK_NONE");
                    break;
                }
                case 2: {
                    str.append("JANK_APPLICATION");
                    break;
                }
                case 1: {
                    str.append("JANK_COMPOSER");
                    break;
                }
                default: {
                    str.append("UNKNOWN: ").append(this.jankType);
                }
            }
            str.append(", ").append(this.frameVsyncId);
            str.append(", ").append(this.totalDurationNanos);
            return str.toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Reasons {
    }
}

