/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import com.android.internal.inputmethod.IRemoteInputConnection;

public interface IInputMethodSession
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.inputmethod.IInputMethodSession";

    public void updateExtractedText(int var1, ExtractedText var2) throws RemoteException;

    public void updateSelection(int var1, int var2, int var3, int var4, int var5, int var6) throws RemoteException;

    public void viewClicked(boolean var1) throws RemoteException;

    public void updateCursor(Rect var1) throws RemoteException;

    public void displayCompletions(CompletionInfo[] var1) throws RemoteException;

    public void appPrivateCommand(String var1, Bundle var2) throws RemoteException;

    public void finishSession() throws RemoteException;

    public void updateCursorAnchorInfo(CursorAnchorInfo var1) throws RemoteException;

    public void removeImeSurface() throws RemoteException;

    public void finishInput() throws RemoteException;

    public void invalidateInput(EditorInfo var1, IRemoteInputConnection var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInputMethodSession {
        static final int TRANSACTION_updateExtractedText = 1;
        static final int TRANSACTION_updateSelection = 2;
        static final int TRANSACTION_viewClicked = 3;
        static final int TRANSACTION_updateCursor = 4;
        static final int TRANSACTION_displayCompletions = 5;
        static final int TRANSACTION_appPrivateCommand = 6;
        static final int TRANSACTION_finishSession = 7;
        static final int TRANSACTION_updateCursorAnchorInfo = 8;
        static final int TRANSACTION_removeImeSurface = 9;
        static final int TRANSACTION_finishInput = 10;
        static final int TRANSACTION_invalidateInput = 11;

        public Stub() {
            this.attachInterface(this, IInputMethodSession.DESCRIPTOR);
        }

        public static IInputMethodSession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IInputMethodSession.DESCRIPTOR);
            if (iin != null && iin instanceof IInputMethodSession) {
                return (IInputMethodSession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "updateExtractedText";
                }
                case 2: {
                    return "updateSelection";
                }
                case 3: {
                    return "viewClicked";
                }
                case 4: {
                    return "updateCursor";
                }
                case 5: {
                    return "displayCompletions";
                }
                case 6: {
                    return "appPrivateCommand";
                }
                case 7: {
                    return "finishSession";
                }
                case 8: {
                    return "updateCursorAnchorInfo";
                }
                case 9: {
                    return "removeImeSurface";
                }
                case 10: {
                    return "finishInput";
                }
                case 11: {
                    return "invalidateInput";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IInputMethodSession.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    ExtractedText _arg1 = data.readTypedObject(ExtractedText.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateExtractedText(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateSelection(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.viewClicked(_arg0);
                    break;
                }
                case 4: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateCursor(_arg0);
                    break;
                }
                case 5: {
                    CompletionInfo[] _arg0 = data.createTypedArray(CompletionInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.displayCompletions(_arg0);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.appPrivateCommand(_arg0, _arg1);
                    break;
                }
                case 7: {
                    this.finishSession();
                    break;
                }
                case 8: {
                    CursorAnchorInfo _arg0 = data.readTypedObject(CursorAnchorInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateCursorAnchorInfo(_arg0);
                    break;
                }
                case 9: {
                    this.removeImeSurface();
                    break;
                }
                case 10: {
                    this.finishInput();
                    break;
                }
                case 11: {
                    EditorInfo _arg0 = data.readTypedObject(EditorInfo.CREATOR);
                    IRemoteInputConnection _arg1 = IRemoteInputConnection.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.invalidateInput(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IInputMethodSession {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IInputMethodSession.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateExtractedText(int token, ExtractedText text) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeInt(token);
                    _data.writeTypedObject(text, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeInt(oldSelStart);
                    _data.writeInt(oldSelEnd);
                    _data.writeInt(newSelStart);
                    _data.writeInt(newSelEnd);
                    _data.writeInt(candidatesStart);
                    _data.writeInt(candidatesEnd);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void viewClicked(boolean focusChanged) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeBoolean(focusChanged);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCursor(Rect newCursor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeTypedObject(newCursor, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void displayCompletions(CompletionInfo[] completions) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeTypedArray(completions, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appPrivateCommand(String action, Bundle data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeString(action);
                    _data.writeTypedObject(data, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finishSession() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeTypedObject(cursorAnchorInfo, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void removeImeSurface() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void finishInput() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateInput(EditorInfo editorInfo, IRemoteInputConnection inputConnection, int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IInputMethodSession.DESCRIPTOR);
                    _data.writeTypedObject(editorInfo, 0);
                    _data.writeStrongInterface(inputConnection);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IInputMethodSession {
        @Override
        public void updateExtractedText(int token, ExtractedText text) throws RemoteException {
        }

        @Override
        public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) throws RemoteException {
        }

        @Override
        public void viewClicked(boolean focusChanged) throws RemoteException {
        }

        @Override
        public void updateCursor(Rect newCursor) throws RemoteException {
        }

        @Override
        public void displayCompletions(CompletionInfo[] completions) throws RemoteException {
        }

        @Override
        public void appPrivateCommand(String action, Bundle data) throws RemoteException {
        }

        @Override
        public void finishSession() throws RemoteException {
        }

        @Override
        public void updateCursorAnchorInfo(CursorAnchorInfo cursorAnchorInfo) throws RemoteException {
        }

        @Override
        public void removeImeSurface() throws RemoteException {
        }

        @Override
        public void finishInput() throws RemoteException {
        }

        @Override
        public void invalidateInput(EditorInfo editorInfo, IRemoteInputConnection inputConnection, int sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

