/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class ResolverAppPredictorCallback {
    private volatile Consumer<List<AppTarget>> mCallback;

    public ResolverAppPredictorCallback(Consumer<List<AppTarget>> callback) {
        this.mCallback = callback;
    }

    private void notifyCallback(List<AppTarget> list) {
        Consumer<List<AppTarget>> callback = this.mCallback;
        if (callback != null) {
            callback.accept(Objects.requireNonNullElseGet(list, List::of));
        }
    }

    public Consumer<List<AppTarget>> asConsumer() {
        return this::notifyCallback;
    }

    public AppPredictor.Callback asCallback() {
        return this::notifyCallback;
    }

    public void destroy() {
        this.mCallback = null;
    }
}

