/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.SearchView;
import com.android.internal.app.AppLocaleCollector;
import com.android.internal.app.LocaleCollectorBase;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocaleStore;
import com.android.internal.app.SuggestedLocaleAdapter;
import com.android.internal.app.SystemLocaleCollector;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;
import java.util.Set;

@Deprecated
public class LocalePickerWithRegion
extends ListFragment
implements SearchView.OnQueryTextListener {
    private static final String TAG = LocalePickerWithRegion.class.getSimpleName();
    private static final String PARENT_FRAGMENT_NAME = "localeListEditor";
    private SuggestedLocaleAdapter mAdapter;
    private LocaleSelectedListener mListener;
    private LocaleCollectorBase mLocalePickerCollector;
    private Set<LocaleStore.LocaleInfo> mLocaleList;
    private LocaleStore.LocaleInfo mParentLocale;
    private boolean mTranslatedOnly = false;
    private SearchView mSearchView = null;
    private CharSequence mPreviousSearch = null;
    private boolean mPreviousSearchHadFocus = false;
    private int mFirstVisiblePosition = 0;
    private int mTopDistance = 0;
    private CharSequence mTitle = null;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;
    private boolean mIsNumberingSystem = false;

    private static LocalePickerWithRegion createNumberingSystemPicker(LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly, MenuItem.OnActionExpandListener onActionExpandListener, LocaleCollectorBase localePickerCollector) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setOnActionExpandListener(onActionExpandListener);
        localePicker.setIsNumberingSystem(true);
        boolean shouldShowTheList = localePicker.setListener(listener, parent, translatedOnly, localePickerCollector);
        return shouldShowTheList ? localePicker : null;
    }

    private static LocalePickerWithRegion createCountryPicker(LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly, MenuItem.OnActionExpandListener onActionExpandListener, LocaleCollectorBase localePickerCollector) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setOnActionExpandListener(onActionExpandListener);
        boolean shouldShowTheList = localePicker.setListener(listener, parent, translatedOnly, localePickerCollector);
        return shouldShowTheList ? localePicker : null;
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly) {
        return LocalePickerWithRegion.createLanguagePicker(context, listener, translatedOnly, null, null, null);
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly, LocaleList explicitLocales) {
        return LocalePickerWithRegion.createLanguagePicker(context, listener, translatedOnly, explicitLocales, null, null);
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly, LocaleList explicitLocales, String appPackageName, MenuItem.OnActionExpandListener onActionExpandListener) {
        LocaleCollectorBase localePickerController = TextUtils.isEmpty(appPackageName) ? new SystemLocaleCollector(context, explicitLocales) : new AppLocaleCollector(context, appPackageName);
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setOnActionExpandListener(onActionExpandListener);
        localePicker.setListener(listener, null, translatedOnly, localePickerController);
        return localePicker;
    }

    private void setIsNumberingSystem(boolean isNumberingSystem) {
        this.mIsNumberingSystem = isNumberingSystem;
    }

    private boolean setListener(LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly, LocaleCollectorBase localePickerController) {
        this.mParentLocale = parent;
        this.mListener = listener;
        this.mTranslatedOnly = translatedOnly;
        this.mLocalePickerCollector = localePickerController;
        this.setRetainInstance(true);
        this.mLocaleList = localePickerController.getSupportedLocaleList(parent, translatedOnly, parent != null);
        if (parent != null && listener != null && this.mLocaleList.size() == 1) {
            listener.onLocaleSelected(this.mLocaleList.iterator().next());
            return false;
        }
        return true;
    }

    private void returnToParentFrame() {
        this.getFragmentManager().popBackStack(PARENT_FRAGMENT_NAME, 1);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.mLocaleList == null) {
            this.returnToParentFrame();
            return;
        }
        this.mTitle = this.getActivity().getTitle();
        boolean countryMode = this.mParentLocale != null;
        Locale sortingLocale = countryMode ? this.mParentLocale.getLocale() : AndroidLocale.getDefault();
        boolean hasSpecificPackageName = this.mLocalePickerCollector != null && this.mLocalePickerCollector.hasSpecificPackageName();
        this.mAdapter = new SuggestedLocaleAdapter(this.mLocaleList, countryMode, hasSpecificPackageName);
        this.mAdapter.setNumberingSystemMode(this.mIsNumberingSystem);
        LocaleHelper.LocaleInfoComparator comp = new LocaleHelper.LocaleInfoComparator(sortingLocale, countryMode);
        this.mAdapter.sort(comp);
        this.setListAdapter(this.mAdapter);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getListView().setNestedScrollingEnabled(true);
        this.getListView().setDivider(null);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int id2 = menuItem.getItemId();
        switch (id2) {
            case 16908332: {
                this.getFragmentManager().popBackStack();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mParentLocale != null) {
            this.getActivity().setTitle(this.mParentLocale.getFullNameNative());
        } else {
            this.getActivity().setTitle(this.mTitle);
        }
        this.getListView().requestFocus();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mSearchView != null) {
            this.mPreviousSearchHadFocus = this.mSearchView.hasFocus();
            this.mPreviousSearch = this.mSearchView.getQuery();
        } else {
            this.mPreviousSearchHadFocus = false;
            this.mPreviousSearch = null;
        }
        ListView list = this.getListView();
        View firstChild = list.getChildAt(0);
        this.mFirstVisiblePosition = list.getFirstVisiblePosition();
        this.mTopDistance = firstChild == null ? 0 : firstChild.getTop() - list.getPaddingTop();
    }

    @Override
    public void onListItemClick(ListView parent, View v, int position, long id2) {
        LocaleStore.LocaleInfo locale = (LocaleStore.LocaleInfo)parent.getAdapter().getItem(position);
        if (locale == null) {
            Log.d(TAG, "Can not get the locale.");
            return;
        }
        boolean isSystemLocale = locale.isSystemLocale();
        boolean isRegionLocale = locale.getParent() != null;
        boolean mayHaveDifferentNumberingSystem = locale.hasNumberingSystems();
        if (isSystemLocale || locale.isSuggested() || isRegionLocale && !mayHaveDifferentNumberingSystem || this.mIsNumberingSystem) {
            if (this.mListener != null) {
                this.mListener.onLocaleSelected(locale);
            } else {
                this.returnToParentFrame();
            }
        } else {
            LocalePickerWithRegion selector = mayHaveDifferentNumberingSystem ? LocalePickerWithRegion.createNumberingSystemPicker(this.mListener, locale, this.mTranslatedOnly, this.mOnActionExpandListener, this.mLocalePickerCollector) : LocalePickerWithRegion.createCountryPicker(this.mListener, locale, this.mTranslatedOnly, this.mOnActionExpandListener, this.mLocalePickerCollector);
            this.mListener.onParentLocaleSelected(locale);
            if (selector != null) {
                this.getFragmentManager().beginTransaction().setTransition(4097).replace(this.getId(), selector).addToBackStack(null).commit();
            } else {
                this.returnToParentFrame();
            }
        }
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        if (this.mParentLocale == null) {
            inflater.inflate(0x1140000, menu2);
            MenuItem searchMenuItem = menu2.findItem(16909260);
            if (this.mOnActionExpandListener != null) {
                searchMenuItem.setOnActionExpandListener(this.mOnActionExpandListener);
            }
            this.mSearchView = (SearchView)searchMenuItem.getActionView();
            this.mSearchView.setQueryHint(this.getText(17041810));
            this.mSearchView.setOnQueryTextListener(this);
            if (!TextUtils.isEmpty(this.mPreviousSearch)) {
                searchMenuItem.expandActionView();
                this.mSearchView.setIconified(false);
                this.mSearchView.setActivated(true);
                if (this.mPreviousSearchHadFocus) {
                    this.mSearchView.requestFocus();
                }
                this.mSearchView.setQuery(this.mPreviousSearch, true);
            } else {
                this.mSearchView.setQuery(null, false);
            }
            this.getListView().setSelectionFromTop(this.mFirstVisiblePosition, this.mTopDistance);
        }
    }

    @Override
    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    @Override
    public boolean onQueryTextChange(String newText) {
        if (this.mAdapter != null) {
            this.mAdapter.getFilter().filter(newText);
        }
        return false;
    }

    public void setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
    }

    public static interface LocaleSelectedListener {
        public void onLocaleSelected(LocaleStore.LocaleInfo var1);

        default public void onParentLocaleSelected(LocaleStore.LocaleInfo locale) {
        }
    }
}

