/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.ImsService;
import android.telephony.ims.aidl.IImsConfig;
import android.telephony.ims.aidl.IImsRegistration;
import android.telephony.ims.aidl.ISipTransport;
import android.telephony.ims.feature.ImsFeature;
import java.util.Objects;

public class ImsFeatureContainer
implements Parcelable {
    public final IBinder imsFeature;
    public final IImsConfig imsConfig;
    public final IImsRegistration imsRegistration;
    public final ISipTransport sipTransport;
    private int mState = 0;
    private long mCapabilities;
    public static final Parcelable.Creator<ImsFeatureContainer> CREATOR = new Parcelable.Creator<ImsFeatureContainer>(){

        @Override
        public ImsFeatureContainer createFromParcel(Parcel source) {
            return new ImsFeatureContainer(source);
        }

        public ImsFeatureContainer[] newArray(int size) {
            return new ImsFeatureContainer[size];
        }
    };

    public ImsFeatureContainer(@NonNull IBinder iFace, @NonNull IImsConfig iConfig, @NonNull IImsRegistration iReg, @Nullable ISipTransport transport, long initialCaps) {
        this.imsFeature = iFace;
        this.imsConfig = iConfig;
        this.imsRegistration = iReg;
        this.sipTransport = transport;
        this.mCapabilities = initialCaps;
    }

    private ImsFeatureContainer(Parcel in) {
        this.imsFeature = in.readStrongBinder();
        this.imsConfig = IImsConfig.Stub.asInterface(in.readStrongBinder());
        this.imsRegistration = IImsRegistration.Stub.asInterface(in.readStrongBinder());
        this.sipTransport = ISipTransport.Stub.asInterface(in.readStrongBinder());
        this.mState = in.readInt();
        this.mCapabilities = in.readLong();
    }

    public long getCapabilities() {
        return this.mCapabilities;
    }

    public void setCapabilities(long caps) {
        this.mCapabilities = caps;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImsFeatureContainer that = (ImsFeatureContainer)o;
        return this.imsFeature.equals(that.imsFeature) && this.imsConfig.equals(that.imsConfig) && this.imsRegistration.equals(that.imsRegistration) && this.sipTransport.equals(that.sipTransport) && this.mState == that.getState() && this.mCapabilities == that.getCapabilities();
    }

    public int hashCode() {
        return Objects.hash(this.imsFeature, this.imsConfig, this.imsRegistration, this.sipTransport, this.mState, this.mCapabilities);
    }

    public String toString() {
        return "FeatureContainer{imsFeature=" + this.imsFeature + ", imsConfig=" + this.imsConfig + ", imsRegistration=" + this.imsRegistration + ", sipTransport=" + this.sipTransport + ", state=" + ImsFeature.STATE_LOG_MAP.get(this.mState) + ", capabilities = " + ImsService.getCapabilitiesString(this.mCapabilities) + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeStrongBinder(this.imsFeature);
        dest.writeStrongInterface(this.imsConfig);
        dest.writeStrongInterface(this.imsRegistration);
        dest.writeStrongInterface(this.sipTransport);
        dest.writeInt(this.mState);
        dest.writeLong(this.mCapabilities);
    }
}

