/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import android.icu.util.TimeZone;
import com.android.i18n.timezone.ZoneInfoDb;
import com.android.i18n.util.Log;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class CountryTimeZones {
    private final String countryIso;
    private final String defaultTimeZoneId;
    private final boolean defaultTimeZoneBoosted;
    private final List<TimeZoneMapping> timeZoneMappings;
    private final boolean everUsesUtc;
    private TimeZone defaultTimeZone;

    private CountryTimeZones(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoosted, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings) {
        this.countryIso = Objects.requireNonNull(countryIso);
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.defaultTimeZoneBoosted = defaultTimeZoneBoosted;
        this.everUsesUtc = everUsesUtc;
        this.timeZoneMappings = Collections.unmodifiableList(new ArrayList<TimeZoneMapping>(timeZoneMappings));
    }

    public static CountryTimeZones createValidated(String countryIso, String defaultTimeZoneId, boolean defaultTimeZoneBoosted, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings, String debugInfo) {
        String[] validTimeZoneIdsArray = ZoneInfoDb.getInstance().getAvailableIDs();
        HashSet<String> validTimeZoneIdsSet = new HashSet<String>(Arrays.asList(validTimeZoneIdsArray));
        ArrayList<TimeZoneMapping> validCountryTimeZoneMappings = new ArrayList<TimeZoneMapping>();
        for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            String timeZoneId = timeZoneMapping.timeZoneId;
            if (!validTimeZoneIdsSet.contains(timeZoneId)) {
                Log.w("Skipping invalid zone: " + timeZoneId + " at " + debugInfo);
                continue;
            }
            validCountryTimeZoneMappings.add(timeZoneMapping);
        }
        if (!validTimeZoneIdsSet.contains(defaultTimeZoneId)) {
            Log.w("Invalid default time zone ID: " + defaultTimeZoneId + " at " + debugInfo);
            defaultTimeZoneId = null;
        }
        String normalizedCountryIso = CountryTimeZones.normalizeCountryIso(countryIso);
        return new CountryTimeZones(normalizedCountryIso, defaultTimeZoneId, defaultTimeZoneBoosted, everUsesUtc, validCountryTimeZoneMappings);
    }

    public String getCountryIso() {
        return this.countryIso;
    }

    public boolean matchesCountryCode(String countryIso) {
        return this.countryIso.equals(CountryTimeZones.normalizeCountryIso(countryIso));
    }

    public String getDefaultTimeZoneId() {
        return this.defaultTimeZoneId;
    }

    public synchronized TimeZone getDefaultTimeZone() {
        if (this.defaultTimeZone == null) {
            TimeZone timeZone = this.defaultTimeZoneId == null ? TimeZone.UNKNOWN_ZONE : TimeZone.getFrozenTimeZone(this.defaultTimeZoneId);
            this.defaultTimeZone = timeZone;
        }
        return "Etc/Unknown".equals(this.defaultTimeZone.getID()) ? null : this.defaultTimeZone;
    }

    public boolean isDefaultTimeZoneBoosted() {
        return this.defaultTimeZoneBoosted;
    }

    public List<TimeZoneMapping> getTimeZoneMappings() {
        return this.timeZoneMappings;
    }

    public boolean hasUtcZone(long whenMillis) {
        if (!this.everUsesUtc) {
            return false;
        }
        for (TimeZoneMapping timeZoneMapping : this.getEffectiveTimeZoneMappingsAt(whenMillis)) {
            TimeZone timeZone = timeZoneMapping.getTimeZone();
            if (timeZone == null || timeZone.getOffset(whenMillis) != 0) continue;
            return true;
        }
        return false;
    }

    public OffsetResult lookupByOffsetWithBias(long whenMillis, TimeZone bias, int totalOffsetMillis, boolean isDst) {
        return this.lookupByOffsetWithBiasInternal(whenMillis, bias, totalOffsetMillis, isDst);
    }

    public OffsetResult lookupByOffsetWithBias(long whenMillis, TimeZone bias, int totalOffsetMillis) {
        Boolean isDst = null;
        return this.lookupByOffsetWithBiasInternal(whenMillis, bias, totalOffsetMillis, isDst);
    }

    public List<TimeZoneMapping> getEffectiveTimeZoneMappingsAt(long whenMillis) {
        ArrayList<TimeZoneMapping> filteredList = new ArrayList<TimeZoneMapping>(this.timeZoneMappings.size());
        for (TimeZoneMapping timeZoneMapping : this.timeZoneMappings) {
            if (!timeZoneMapping.isEffectiveAt(whenMillis)) continue;
            filteredList.add(timeZoneMapping);
        }
        return Collections.unmodifiableList(filteredList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryTimeZones that = (CountryTimeZones)o;
        return this.defaultTimeZoneBoosted == that.defaultTimeZoneBoosted && this.everUsesUtc == that.everUsesUtc && this.countryIso.equals(that.countryIso) && Objects.equals(this.defaultTimeZoneId, that.defaultTimeZoneId) && this.timeZoneMappings.equals(that.timeZoneMappings);
    }

    public int hashCode() {
        return Objects.hash(this.countryIso, this.defaultTimeZoneId, this.defaultTimeZoneBoosted, this.timeZoneMappings, this.everUsesUtc);
    }

    public String toString() {
        return "CountryTimeZones{countryIso='" + this.countryIso + '\'' + ", defaultTimeZoneId='" + this.defaultTimeZoneId + '\'' + ", defaultTimeZoneBoosted=" + this.defaultTimeZoneBoosted + ", timeZoneMappings=" + this.timeZoneMappings + ", everUsesUtc=" + this.everUsesUtc + '}';
    }

    private OffsetResult lookupByOffsetWithBiasInternal(long whenMillis, TimeZone bias, int totalOffsetMillis, Boolean isDst) {
        List<TimeZoneMapping> timeZoneMappings = this.getEffectiveTimeZoneMappingsAt(whenMillis);
        if (timeZoneMappings.isEmpty()) {
            return null;
        }
        TimeZone firstMatch = null;
        boolean biasMatched = false;
        boolean oneMatch = true;
        for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            TimeZone match = timeZoneMapping.getTimeZone();
            if (match == null || !CountryTimeZones.offsetMatchesAtTime(whenMillis, match, totalOffsetMillis, isDst)) continue;
            if (firstMatch == null) {
                firstMatch = match;
            } else {
                oneMatch = false;
            }
            if (bias != null && match.getID().equals(bias.getID())) {
                biasMatched = true;
            }
            if (firstMatch == null || oneMatch || bias != null && !biasMatched) continue;
            break;
        }
        if (firstMatch == null) {
            return null;
        }
        TimeZone toReturn = biasMatched ? bias : firstMatch;
        return new OffsetResult(toReturn, oneMatch);
    }

    private static boolean offsetMatchesAtTime(long whenMillis, TimeZone timeZone, int totalOffsetMillis, Boolean isDst) {
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        if (totalOffsetMillis != offsets[0] + offsets[1]) {
            return false;
        }
        return isDst == null || isDst == (offsets[1] != 0);
    }

    private static String normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    public static class TimeZoneMapping {
        private final String timeZoneId;
        private final boolean shownInPicker;
        private final Long notUsedAfter;
        private final List<String> alternativeIds;
        private TimeZone timeZone;

        TimeZoneMapping(String timeZoneId, boolean shownInPicker, Long notUsedAfter, List<String> alternativeIds) {
            this.timeZoneId = Objects.requireNonNull(timeZoneId);
            this.shownInPicker = shownInPicker;
            this.notUsedAfter = notUsedAfter;
            this.alternativeIds = Collections.unmodifiableList(new ArrayList<String>(alternativeIds));
        }

        public String getTimeZoneId() {
            return this.timeZoneId;
        }

        public boolean isShownInPickerAt(Instant time) {
            return this.shownInPicker && (this.notUsedAfter == null || this.notUsedAfter >= time.toEpochMilli());
        }

        public List<String> getAlternativeIds() {
            return this.alternativeIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeZone getTimeZone() {
            TimeZoneMapping timeZoneMapping = this;
            synchronized (timeZoneMapping) {
                if (this.timeZone == null) {
                    TimeZone tz;
                    this.timeZone = tz = TimeZone.getFrozenTimeZone(this.timeZoneId);
                    if ("Etc/Unknown".equals(this.timeZone.getID())) {
                        throw new IllegalStateException("Invalid zone in TimeZoneMapping: " + this);
                    }
                }
            }
            return "Etc/Unknown".equals(this.timeZone.getID()) ? null : this.timeZone;
        }

        boolean isEffectiveAt(long whenMillis) {
            return this.notUsedAfter == null || whenMillis <= this.notUsedAfter;
        }

        public static TimeZoneMapping createForTests(String timeZoneId, boolean showInPicker, Long notUsedAfter, List<String> alternativeIds) {
            return new TimeZoneMapping(timeZoneId, showInPicker, notUsedAfter, alternativeIds);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeZoneMapping that = (TimeZoneMapping)o;
            return this.shownInPicker == that.shownInPicker && Objects.equals(this.timeZoneId, that.timeZoneId) && Objects.equals(this.notUsedAfter, that.notUsedAfter) && Objects.equals(this.alternativeIds, that.alternativeIds);
        }

        public int hashCode() {
            return Objects.hash(this.timeZoneId, this.shownInPicker, this.notUsedAfter, this.alternativeIds);
        }

        public String toString() {
            return "TimeZoneMapping{timeZoneId='" + this.timeZoneId + '\'' + ", shownInPicker=" + this.shownInPicker + ", notUsedAfter=" + this.notUsedAfter + ", alternativeIds=" + this.alternativeIds + '}';
        }

        static boolean containsTimeZoneId(List<TimeZoneMapping> timeZoneMappings, String timeZoneId) {
            for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
                if (!timeZoneMapping.timeZoneId.equals(timeZoneId)) continue;
                return true;
            }
            return false;
        }
    }

    public static class OffsetResult {
        private final TimeZone timeZone;
        private final boolean isOnlyMatch;

        public OffsetResult(TimeZone timeZone, boolean isOnlyMatch) {
            this.timeZone = Objects.requireNonNull(timeZone);
            this.isOnlyMatch = isOnlyMatch;
        }

        public TimeZone getTimeZone() {
            return this.timeZone;
        }

        public boolean isOnlyMatch() {
            return this.isOnlyMatch;
        }

        public String toString() {
            return "OffsetResult{timeZone(ID)='" + this.timeZone.getID() + '\'' + ", isOnlyMatch=" + this.isOnlyMatch + '}';
        }
    }
}

