/*
 * Decompiled with CFR 0.152.
 */
package com.android.healthfitness.flags;

import com.android.healthfitness.flags.DatabaseVersionSupplier;
import com.android.healthfitness.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;

public class AconfigFlagHelper {
    private static final DatabaseVersionSupplier sDatabaseVersionSupplier = new DatabaseVersionSupplier(15, AconfigFlagHelper.getDbVersionToDbFlagMap());

    public static int getDbVersion() {
        return sDatabaseVersionSupplier.get();
    }

    private static boolean isDbFlagEnabled(int dbVersion) {
        return AconfigFlagHelper.getDbVersion() >= dbVersion;
    }

    private AconfigFlagHelper() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static SortedMap<Integer, BooleanSupplier> getDbVersionToDbFlagMap() {
        TreeMap<Integer, BooleanSupplier> map = new TreeMap<Integer, BooleanSupplier>();
        map.put(16, Flags::activityIntensityDb);
        map.put(17, Flags::ecosystemMetricsDbChanges);
        map.put(18, Flags::cloudBackupAndRestoreDb);
        map.put(19, Flags::exerciseSegmentImprovementsDb);
        map.put(20, Flags::phrChangeLogsDb);
        map.put(21, Flags::smokingDb);
        return map;
    }

    public static boolean isActivityIntensityEnabled() {
        return Flags.activityIntensity() && AconfigFlagHelper.isDbFlagEnabled(16);
    }

    public static boolean isEcosystemMetricsEnabled() {
        return Flags.ecosystemMetrics() && AconfigFlagHelper.isDbFlagEnabled(17);
    }

    public static boolean isCloudBackupRestoreEnabled() {
        return Flags.cloudBackupAndRestore() && AconfigFlagHelper.isDbFlagEnabled(18);
    }

    public static boolean isNicotineIntakeEnabled() {
        return Flags.smoking() && AconfigFlagHelper.isDbFlagEnabled(21);
    }

    public static boolean isExerciseSegmentImprovementsEnabled() {
        return Flags.exerciseSegmentImprovements() && AconfigFlagHelper.isDbFlagEnabled(19);
    }

    public static boolean isPhrChangeLogsEnabled() {
        return Flags.phrChangeLogs() && AconfigFlagHelper.isDbFlagEnabled(20);
    }
}

