/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.annotation.Nullable;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.text.TextUtils;
import com.android.adservices.AdServicesCommon;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.adservices.shared.common.exception.ServiceUnavailableException;
import com.android.internal.annotations.GuardedBy;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class AndroidServiceBinder<T>
extends ServiceBinder<T> {
    private static final int BIND_FLAGS = 65;
    private static final int DEFAULT_BINDER_CONNECTION_TIMEOUT_MS = 5000;
    private final String mServiceIntentAction;
    private final Function<IBinder, T> mBinderConverter;
    private final Context mContext;
    private final int mBinderTimeout;
    private CountDownLatch mConnectionCountDownLatch;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private T mService;
    @GuardedBy(value={"mLock"})
    private ServiceConnection mServiceConnection;
    private final boolean mSimulatingLowRamDevice;
    private static final boolean IS_DEBUGGABLE = AndroidServiceBinder.computeIsDebuggable();

    protected AndroidServiceBinder(Context context, String serviceIntentAction, Function<IBinder, T> converter) {
        this.mServiceIntentAction = serviceIntentAction;
        this.mContext = context;
        this.mBinderConverter = converter;
        if (!AndroidServiceBinder.isDebuggable()) {
            this.mSimulatingLowRamDevice = false;
        } else {
            String propValue = SystemProperties.get("debug.adservices.low_ram_device");
            boolean bl = this.mSimulatingLowRamDevice = !TextUtils.isEmpty(propValue) && Boolean.valueOf(propValue) != false;
        }
        if (this.mSimulatingLowRamDevice) {
            LogUtil.w("Service %s disabled because of system property %s", serviceIntentAction, "debug.adservices.low_ram_device");
        }
        this.mBinderTimeout = SystemProperties.getInt("debug.adservices.binder_timeout", 5000);
        LogUtil.d("AndroidServiceBinder(): serviceIntentAction=%s, fromUser=%d, toUser=%s", serviceIntentAction, Process.myUserHandle().getIdentifier(), this.getUserIdForLogging());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getService() {
        if (this.mSimulatingLowRamDevice) {
            throw new ServiceUnavailableException("Service is not bound (because of SystemProperty debug.adservices.low_ram_device)");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService != null) {
                return this.mService;
            }
            if (this.mServiceConnection == null) {
                ComponentName componentName = this.getServiceComponentName();
                if (componentName == null) {
                    return null;
                }
                Intent intent = new Intent(this.mServiceIntentAction).setComponent(componentName);
                LogUtil.d("getService(): binding (on user %d) to %s (on user %s)", Process.myUserHandle().getIdentifier(), this.mServiceIntentAction, this.getUserIdForLogging());
                this.mConnectionCountDownLatch = new CountDownLatch(1);
                this.mServiceConnection = new AdServicesServiceConnection();
                try {
                    boolean success = this.mContext.bindService(intent, 65, Runnable::run, this.mServiceConnection);
                    if (!success) {
                        LogUtil.e("getService(): failed to bind to %s on user %s", this.mServiceIntentAction, this.getUserIdForLogging());
                        this.mServiceConnection = null;
                        return null;
                    }
                    LogUtil.d("getService(): bound!");
                }
                catch (Exception e) {
                    LogUtil.e("getService(): caught unexpected exception during service binding to %s on user %s: %s", this.mServiceIntentAction, this.getUserIdForLogging(), e);
                    this.mServiceConnection = null;
                    return null;
                }
            } else {
                LogUtil.d("getService(): There is already a pending connection!");
            }
        }
        try {
            LogUtil.v("getService(): waiting up to %dms for binder connection", this.mBinderTimeout);
            if (!this.mConnectionCountDownLatch.await(this.mBinderTimeout, TimeUnit.MILLISECONDS)) {
                LogUtil.e("getService(): timed out (%dms) waiting for binder connection", this.mBinderTimeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted", e);
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mService == null) {
                throw new ServiceUnavailableException("Service is not available.");
            }
            return this.mService;
        }
    }

    @Nullable
    private ComponentName getServiceComponentName() {
        if (!(this.mServiceIntentAction.equals("android.adservices.TOPICS_SERVICE") || this.mServiceIntentAction.equals("android.adservices.MEASUREMENT_SERVICE") || this.mServiceIntentAction.equals("android.adservices.customaudience.CUSTOM_AUDIENCE_SERVICE") || this.mServiceIntentAction.equals("android.adservices.adselection.AD_SELECTION_SERVICE") || this.mServiceIntentAction.equals("android.adservices.ADID_SERVICE") || this.mServiceIntentAction.equals("android.adservices.adid.AdIdProviderService") || this.mServiceIntentAction.equals("android.adservices.APPSETID_SERVICE") || this.mServiceIntentAction.equals("android.adservices.appsetid.AppSetIdProviderService") || this.mServiceIntentAction.equals("android.adservices.cobalt.AdServicesCobaltUploadService") || this.mServiceIntentAction.equals("android.adservices.AD_SERVICES_COMMON_SERVICE") || this.mServiceIntentAction.equals("android.adservices.SHELL_COMMAND_SERVICE") || this.mServiceIntentAction.equals("android.adservices.signals.PROTECTED_SIGNALS_SERVICE"))) {
            LogUtil.e("Bad service intent action: %s", this.mServiceIntentAction);
            return null;
        }
        Intent intent = new Intent(this.mServiceIntentAction);
        List<ResolveInfo> resolveInfos = this.mContext.getPackageManager().queryIntentServices(intent, 0x100000);
        ServiceInfo serviceInfo = AdServicesCommon.resolveAdServicesService(resolveInfos, this.mServiceIntentAction);
        if (serviceInfo == null) {
            LogUtil.e("Failed to find serviceInfo for adServices service on user %s using intent %s", this.getUserIdForLogging(), this.mServiceIntentAction);
            return null;
        }
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    private String getUserIdForLogging() {
        return _Original_Build.VERSION.SDK_INT > 30 ? String.valueOf(this.mContext.getUser().getIdentifier()) : "N/A";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFromService() {
        if (this.mSimulatingLowRamDevice) {
            LogUtil.d("unbindFromService(): ignored because it's disabled by system property %s", "debug.adservices.low_ram_device");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                LogUtil.d("unbinding...");
                this.mContext.unbindService(this.mServiceConnection);
            }
            this.mServiceConnection = null;
            this.mService = null;
        }
    }

    private static boolean isDebuggable() {
        return IS_DEBUGGABLE;
    }

    private static boolean computeIsDebuggable() {
        if (_Original_Build.VERSION.SDK_INT >= 31) {
            return _Original_Build.isDebuggable();
        }
        return SystemProperties.getInt("ro.debuggable", 0) == 1;
    }

    private class AdServicesServiceConnection
    implements ServiceConnection {
        private AdServicesServiceConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.onCallback("onServiceConnected", name, () -> {
                Object object = AndroidServiceBinder.this.mLock;
                synchronized (object) {
                    AndroidServiceBinder.this.mService = AndroidServiceBinder.this.mBinderConverter.apply(service);
                }
            });
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.onCallback("onServiceDisconnected", name, () -> AndroidServiceBinder.this.unbindFromService());
        }

        @Override
        public void onBindingDied(ComponentName name) {
            this.onCallback("onBindingDied", name, () -> AndroidServiceBinder.this.unbindFromService());
        }

        @Override
        public void onNullBinding(ComponentName name) {
            this.onCallback("onNullBinding", name, () -> AndroidServiceBinder.this.unbindFromService());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onCallback(String callback, @Nullable ComponentName name, Runnable runnable) {
            String service = name == null ? "N/A" : name.flattenToShortString();
            LogUtil.d("%s(userId=%s, action=%s, service=%s)", callback, AndroidServiceBinder.this.getUserIdForLogging(), AndroidServiceBinder.this.mServiceIntentAction, service);
            try {
                runnable.run();
            }
            finally {
                AndroidServiceBinder.this.mConnectionCountDownLatch.countDown();
            }
        }
    }
}

