/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.IOnBackInvokedCallback;

public class OnBackInvokedCallbackInfo
implements Parcelable {
    @NonNull
    private final IOnBackInvokedCallback mCallback;
    private int mPriority;
    private final boolean mIsAnimationCallback;
    private final int mOverrideBehavior;
    public static final Parcelable.Creator<OnBackInvokedCallbackInfo> CREATOR = new Parcelable.Creator<OnBackInvokedCallbackInfo>(){

        @Override
        public OnBackInvokedCallbackInfo createFromParcel(Parcel in) {
            return new OnBackInvokedCallbackInfo(in);
        }

        public OnBackInvokedCallbackInfo[] newArray(int size) {
            return new OnBackInvokedCallbackInfo[size];
        }
    };

    public OnBackInvokedCallbackInfo(@NonNull IOnBackInvokedCallback callback, int priority, boolean isAnimationCallback, int overrideBehavior) {
        this.mCallback = callback;
        this.mPriority = priority;
        this.mIsAnimationCallback = isAnimationCallback;
        this.mOverrideBehavior = overrideBehavior;
    }

    private OnBackInvokedCallbackInfo(@NonNull Parcel in) {
        this.mCallback = IOnBackInvokedCallback.Stub.asInterface(in.readStrongBinder());
        this.mPriority = in.readInt();
        this.mIsAnimationCallback = in.readBoolean();
        this.mOverrideBehavior = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStrongInterface(this.mCallback);
        dest.writeInt(this.mPriority);
        dest.writeBoolean(this.mIsAnimationCallback);
        dest.writeInt(this.mOverrideBehavior);
    }

    public boolean isSystemCallback() {
        return this.mPriority == -1 || this.mOverrideBehavior != 0;
    }

    @NonNull
    public IOnBackInvokedCallback getCallback() {
        return this.mCallback;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public boolean isAnimationCallback() {
        return this.mIsAnimationCallback;
    }

    public int getOverrideBehavior() {
        return this.mOverrideBehavior;
    }

    public String toString() {
        return "OnBackInvokedCallbackInfo{mCallback=" + this.mCallback + ", mPriority=" + this.mPriority + ", mIsAnimationCallback=" + this.mIsAnimationCallback + ", mOverrideBehavior=" + this.mOverrideBehavior + '}';
    }
}

