/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;

public interface ITransactionReadyCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITransactionReadyCallback";

    public void onTransactionReady(SurfaceControl.Transaction var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransactionReadyCallback {
        static final int TRANSACTION_onTransactionReady = 1;

        public Stub() {
            this.attachInterface(this, ITransactionReadyCallback.DESCRIPTOR);
        }

        public static ITransactionReadyCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransactionReadyCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITransactionReadyCallback) {
                return (ITransactionReadyCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTransactionReady";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransactionReadyCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SurfaceControl.Transaction _arg0 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTransactionReady(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements ITransactionReadyCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransactionReadyCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTransactionReady(SurfaceControl.Transaction t) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransactionReadyCallback.DESCRIPTOR);
                    _data.writeTypedObject(t, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransactionReadyCallback {
        @Override
        public void onTransactionReady(SurfaceControl.Transaction t) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

