/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.RequiresPermission;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IMultitaskingDelegate
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IMultitaskingDelegate";

    @RequiresPermission(value="android.permission.REQUEST_SYSTEM_MULTITASKING_CONTROLS")
    public void createBubble(IBinder var1, Intent var2, boolean var3) throws RemoteException;

    @RequiresPermission(value="android.permission.REQUEST_SYSTEM_MULTITASKING_CONTROLS")
    public void updateBubbleState(IBinder var1, boolean var2) throws RemoteException;

    @RequiresPermission(value="android.permission.REQUEST_SYSTEM_MULTITASKING_CONTROLS")
    public void updateBubbleMessage(IBinder var1, String var2) throws RemoteException;

    @RequiresPermission(value="android.permission.REQUEST_SYSTEM_MULTITASKING_CONTROLS")
    public void removeBubble(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMultitaskingDelegate {
        static final int TRANSACTION_createBubble = 1;
        static final int TRANSACTION_updateBubbleState = 2;
        static final int TRANSACTION_updateBubbleMessage = 3;
        static final int TRANSACTION_removeBubble = 4;

        public Stub() {
            this.attachInterface(this, IMultitaskingDelegate.DESCRIPTOR);
        }

        public static IMultitaskingDelegate asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMultitaskingDelegate.DESCRIPTOR);
            if (iin != null && iin instanceof IMultitaskingDelegate) {
                return (IMultitaskingDelegate)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createBubble";
                }
                case 2: {
                    return "updateBubbleState";
                }
                case 3: {
                    return "updateBubbleMessage";
                }
                case 4: {
                    return "removeBubble";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMultitaskingDelegate.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.createBubble(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.updateBubbleState(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.updateBubbleMessage(_arg0, _arg1);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.removeBubble(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IMultitaskingDelegate {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMultitaskingDelegate.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createBubble(IBinder token, Intent intent, boolean collapsed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMultitaskingDelegate.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(intent, 0);
                    _data.writeBoolean(collapsed);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateBubbleState(IBinder token, boolean collapsed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMultitaskingDelegate.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(collapsed);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateBubbleMessage(IBinder token, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMultitaskingDelegate.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeBubble(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMultitaskingDelegate.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMultitaskingDelegate {
        @Override
        public void createBubble(IBinder token, Intent intent, boolean collapsed) throws RemoteException {
        }

        @Override
        public void updateBubbleState(IBinder token, boolean collapsed) throws RemoteException {
        }

        @Override
        public void updateBubbleMessage(IBinder token, String message) throws RemoteException {
        }

        @Override
        public void removeBubble(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

