/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.os.SystemProperties;
import android.os._Original_Build;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;

public enum DesktopExperienceFlags {
    BASE_DENSITY_FOR_EXTERNAL_DISPLAYS(com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags::baseDensityForExternalDisplays, true, "com.android.server.display.feature.flags.base_density_for_external_displays"),
    CONNECTED_DISPLAYS_CURSOR(com.android.internal.hidden_from_bootclasspath.com.android.input.flags.Flags::connectedDisplaysCursor, true, "com.android.input.flags.connected_displays_cursor"),
    DISPLAY_TOPOLOGY(com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags::displayTopology, true, "com.android.server.display.feature.flags.display_topology"),
    ENABLE_ACTIVITY_EMBEDDING_SUPPORT_FOR_CONNECTED_DISPLAYS(Flags::enableActivityEmbeddingSupportForConnectedDisplays, true, "com.android.window.flags.enable_activity_embedding_support_for_connected_displays"),
    ENABLE_APP_HANDLE_POSITION_REPORTING(Flags::enableAppHandlePositionReporting, false, "com.android.window.flags.enable_app_handle_position_reporting"),
    ENABLE_BLOCK_NON_DESKTOP_DISPLAY_WINDOW_DRAG_BUGFIX(Flags::enableBlockNonDesktopDisplayWindowDragBugfix, false, "com.android.window.flags.enable_block_non_desktop_display_window_drag_bugfix"),
    ENABLE_BUG_FIXES_FOR_SECONDARY_DISPLAY(Flags::enableBugFixesForSecondaryDisplay, true, "com.android.window.flags.enable_bug_fixes_for_secondary_display"),
    ENABLE_CONNECTED_DISPLAYS_DND(Flags::enableConnectedDisplaysDnd, true, "com.android.window.flags.enable_connected_displays_dnd"),
    ENABLE_CONNECTED_DISPLAYS_PIP(Flags::enableConnectedDisplaysPip, true, "com.android.window.flags.enable_connected_displays_pip"),
    ENABLE_CONNECTED_DISPLAYS_WALLPAPER(com.android.internal.hidden_from_bootclasspath.android.app.Flags::enableConnectedDisplaysWallpaper, true, "android.app.enable_connected_displays_wallpaper"),
    ENABLE_CONNECTED_DISPLAYS_WINDOW_DRAG(Flags::enableConnectedDisplaysWindowDrag, true, "com.android.window.flags.enable_connected_displays_window_drag"),
    ENABLE_DEFAULT_DESK_WITHOUT_WARMUP_MIGRATION(Flags::defaultDeskWithoutWarmupMigration, false, "com.android.window.flags.default_desk_without_warmup_migration"),
    ENABLE_DEFAULT_DISPLAY_IN_TOPOLOGY_SWITCH(com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags::enableDefaultDisplayInTopologySwitch, true, "com.android.server.display.feature.flags.enable_default_display_in_topology_switch"),
    ENABLE_DESKTOP_APP_HEADER_STATE_CHANGE_ANNOUNCEMENTS(Flags::enableDesktopAppHeaderStateChangeAnnouncements, false, "com.android.window.flags.enable_desktop_app_header_state_change_announcements"),
    ENABLE_DESKTOP_APP_LAUNCH_BUGFIX(Flags::enableDesktopAppLaunchBugfix, true, "com.android.window.flags.enable_desktop_app_launch_bugfix"),
    ENABLE_DESKTOP_CLOSE_TASK_ANIMATION_IN_DTC_BUGFIX(Flags::enableDesktopCloseTaskAnimationInDtcBugfix, true, "com.android.window.flags.enable_desktop_close_task_animation_in_dtc_bugfix"),
    ENABLE_DESKTOP_FIRST_BASED_DEFAULT_TO_DESKTOP_BUGFIX(Flags::enableDesktopFirstBasedDefaultToDesktopBugfix, true, "com.android.window.flags.enable_desktop_first_based_default_to_desktop_bugfix"),
    ENABLE_DESKTOP_FIRST_BASED_DRAG_TO_MAXIMIZE(Flags::enableDesktopFirstBasedDragToMaximize, true, "com.android.window.flags.enable_desktop_first_based_drag_to_maximize"),
    ENABLE_DESKTOP_FIRST_FULLSCREEN_REFOCUS_BUGFIX(Flags::enableDesktopFirstFullscreenRefocusBugfix, false, "com.android.window.flags.enable_desktop_first_fullscreen_refocus_bugfix"),
    ENABLE_DESKTOP_FIRST_LISTENER(Flags::enableDesktopFirstListener, false, "com.android.window.flags.enable_desktop_first_listener"),
    ENABLE_DESKTOP_IME_BUGFIX(Flags::enableDesktopImeBugfix, true, "com.android.window.flags.enable_desktop_ime_bugfix"),
    ENABLE_DESKTOP_SPLITSCREEN_TRANSITION_BUGFIX(Flags::enableDesktopSplitscreenTransitionBugfix, false, "com.android.window.flags.enable_desktop_splitscreen_transition_bugfix"),
    ENABLE_DESKTOP_TAB_TEARING_LAUNCH_ANIMATION(Flags::enableDesktopTabTearingLaunchAnimation, true, "com.android.window.flags.enable_desktop_tab_tearing_launch_animation"),
    ENABLE_DESKTOP_TASKBAR_ON_FREEFORM_DISPLAYS(Flags::enableDesktopTaskbarOnFreeformDisplays, true, "com.android.window.flags.enable_desktop_taskbar_on_freeform_displays"),
    ENABLE_DESKTOP_TASK_LIMIT_SEPARATE_TRANSITION(Flags::enableDesktopTaskLimitSeparateTransition, true, "com.android.window.flags.enable_desktop_task_limit_separate_transition"),
    ENABLE_DESKTOP_WINDOWING_PIP(Flags::enableDesktopWindowingPip, true, "com.android.window.flags.enable_desktop_windowing_pip"),
    ENABLE_DESKTOP_WINDOWING_PIP_IN_OVERVIEW_BUGFIX(Flags::enableDesktopWindowingPipInOverviewBugfix, false, "com.android.window.flags.enable_desktop_windowing_pip_in_overview_bugfix"),
    ENABLE_DISPLAY_COMPAT_MODE(Flags::enableDisplayCompatMode, false, "com.android.window.flags.enable_display_compat_mode"),
    ENABLE_DISPLAY_CONTENT_MODE_MANAGEMENT(com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags::enableDisplayContentModeManagement, true, "com.android.server.display.feature.flags.enable_display_content_mode_management"),
    ENABLE_DISPLAY_DISCONNECT_INTERACTION(Flags::enableDisplayDisconnectInteraction, true, "com.android.window.flags.enable_display_disconnect_interaction"),
    ENABLE_DISPLAY_FOCUS_IN_SHELL_TRANSITIONS(Flags::enableDisplayFocusInShellTransitions, true, "com.android.window.flags.enable_display_focus_in_shell_transitions"),
    ENABLE_DISPLAY_RECONNECT_INTERACTION(Flags::enableDisplayReconnectInteraction, false, "com.android.window.flags.enable_display_reconnect_interaction"),
    ENABLE_DISPLAY_WINDOWING_MODE_SWITCHING(Flags::enableDisplayWindowingModeSwitching, true, "com.android.window.flags.enable_display_windowing_mode_switching"),
    ENABLE_DRAGGING_PIP_ACROSS_DISPLAYS(Flags::enableDraggingPipAcrossDisplays, false, "com.android.window.flags.enable_dragging_pip_across_displays"),
    ENABLE_DRAG_TO_MAXIMIZE(Flags::enableDragToMaximize, true, "com.android.window.flags.enable_drag_to_maximize"),
    ENABLE_DYNAMIC_RADIUS_COMPUTATION_BUGFIX(Flags::enableDynamicRadiusComputationBugfix, true, "com.android.window.flags.enable_dynamic_radius_computation_bugfix"),
    ENABLE_EMPTY_DESK_ON_MINIMIZE(Flags::enableEmptyDeskOnMinimize, true, "com.android.window.flags.enable_empty_desk_on_minimize"),
    ENABLE_FREEFORM_BOX_SHADOWS(Flags::enableFreeformBoxShadows, false, "com.android.window.flags.enable_freeform_box_shadows"),
    ENABLE_FREEFORM_DISPLAY_LAUNCH_PARAMS(Flags::enableFreeformDisplayLaunchParams, true, "com.android.window.flags.enable_freeform_display_launch_params"),
    ENABLE_FULLSCREEN_WINDOW_CONTROLS(Flags::enableFullscreenWindowControls, false, "com.android.window.flags.enable_fullscreen_window_controls"),
    ENABLE_INDEPENDENT_BACK_IN_PROJECTED(Flags::enableIndependentBackInProjected, true, "com.android.window.flags.enable_independent_back_in_projected"),
    ENABLE_KEYBOARD_SHORTCUTS_TO_SWITCH_DESKS(Flags::keyboardShortcutsToSwitchDesks, true, "com.android.window.flags.keyboard_shortcuts_to_switch_desks"),
    ENABLE_MODALS_FULLSCREEN_WITH_PLATFORM_SIGNATURE(Flags::enableModalsFullscreenWithPlatformSignature, true, "com.android.window.flags.enable_modals_fullscreen_with_platform_signature"),
    ENABLE_MOVE_TO_NEXT_DISPLAY_SHORTCUT(Flags::enableMoveToNextDisplayShortcut, true, "com.android.window.flags.enable_move_to_next_display_shortcut"),
    ENABLE_MULTIDISPLAY_TRACKPAD_BACK_GESTURE(Flags::enableMultidisplayTrackpadBackGesture, true, "com.android.window.flags.enable_multidisplay_trackpad_back_gesture"),
    ENABLE_MULTIPLE_DESKTOPS_ACTIVATION_IN_DESKTOP_FIRST_DISPLAYS(Flags::enableMultipleDesktopsDefaultActivationInDesktopFirstDisplays, false, "com.android.window.flags.enable_multiple_desktops_default_activation_in_desktop_first_displays"),
    ENABLE_MULTIPLE_DESKTOPS_BACKEND(Flags::enableMultipleDesktopsBackend, true, "com.android.window.flags.enable_multiple_desktops_backend"),
    ENABLE_MULTIPLE_DESKTOPS_FRONTEND(Flags::enableMultipleDesktopsFrontend, true, "com.android.window.flags.enable_multiple_desktops_frontend"),
    ENABLE_NESTED_TASKS_WITH_INDEPENDENT_BOUNDS_BUGFIX(Flags::nestedTasksWithIndependentBoundsBugfix, true, "com.android.window.flags.nested_tasks_with_independent_bounds_bugfix"),
    ENABLE_NON_DEFAULT_DISPLAY_SPLIT(Flags::enableNonDefaultDisplaySplit, true, "com.android.window.flags.enable_non_default_display_split"),
    ENABLE_NO_WINDOW_DECORATION_FOR_DESKS(Flags::enableNoWindowDecorationForDesks, true, "com.android.window.flags.enable_no_window_decoration_for_desks"),
    ENABLE_PARALLEL_CD_TRANSITIONS_DURING_RECENTS(Flags::parallelCdTransitionsDuringRecents, true, "com.android.window.flags.parallel_cd_transitions_during_recents"),
    ENABLE_PERSISTING_DISPLAY_SIZE_FOR_CONNECTED_DISPLAYS(Flags::enablePersistingDisplaySizeForConnectedDisplays, true, "com.android.window.flags.enable_persisting_display_size_for_connected_displays"),
    ENABLE_PER_DISPLAY_DESKTOP_WALLPAPER_ACTIVITY(Flags::enablePerDisplayDesktopWallpaperActivity, true, "com.android.window.flags.enable_per_display_desktop_wallpaper_activity"),
    ENABLE_PINNING_APP_WITH_CONTEXT_MENU(Flags::enablePinningAppWithContextMenu, true, "com.android.window.flags.enable_pinning_app_with_context_menu"),
    ENABLE_PRESENTATION_FOR_CONNECTED_DISPLAYS(Flags::enablePresentationForConnectedDisplays, true, "com.android.window.flags.enable_presentation_for_connected_displays"),
    ENABLE_PROJECTED_DISPLAY_DESKTOP_MODE(Flags::enableProjectedDisplayDesktopMode, true, "com.android.window.flags.enable_projected_display_desktop_mode"),
    ENABLE_REJECT_HOME_TRANSITION(Flags::enableRejectHomeTransition, true, "com.android.window.flags.enable_reject_home_transition"),
    ENABLE_REQUEST_FULLSCREEN_REFACTOR(Flags::enableRequestFullscreenRefactor, false, "com.android.window.flags.enable_request_fullscreen_refactor"),
    ENABLE_RESTART_MENU_FOR_CONNECTED_DISPLAYS(Flags::enableRestartMenuForConnectedDisplays, true, "com.android.window.flags.enable_restart_menu_for_connected_displays"),
    ENABLE_RESTRICT_FREEFORM_HIDDEN_SYSTEM_BARS_TO_FILLING_TASKS(Flags::restrictFreeformHiddenSystemBarsToFillingTasks, true, "com.android.window.flags.restrict_freeform_hidden_system_bars_to_filling_tasks"),
    ENABLE_SEE_THROUGH_TASK_FRAGMENTS(Flags::enableSeeThroughTaskFragments, true, "com.android.window.flags.enable_see_through_task_fragments"),
    ENABLE_SIZE_COMPAT_MODE_IMPROVEMENTS_FOR_CONNECTED_DISPLAYS(Flags::enableSizeCompatModeImprovementsForConnectedDisplays, true, "com.android.window.flags.enable_size_compat_mode_improvements_for_connected_displays"),
    ENABLE_SYS_DECORS_CALLBACKS_VIA_WM(Flags::enableSysDecorsCallbacksViaWm, true, "com.android.window.flags.enable_sys_decors_callbacks_via_wm"),
    ENABLE_TALL_APP_HEADERS(Flags::enableTallAppHeaders, false, "com.android.window.flags.enable_tall_app_headers"),
    ENABLE_TASKBAR_CONNECTED_DISPLAYS(Flags::enableTaskbarConnectedDisplays, true, "com.android.window.flags.enable_taskbar_connected_displays"),
    ENABLE_TASKBAR_RECENT_TASKS_THROTTLE_BUGFIX(Flags::enableTaskbarRecentTasksThrottleBugfix, true, "com.android.window.flags.enable_taskbar_recent_tasks_throttle_bugfix"),
    ENABLE_TILE_RESIZING(Flags::enableTileResizing, true, "com.android.window.flags.enable_tile_resizing"),
    ENABLE_WINDOWING_TASK_STACK_ORDER_BUGFIX(Flags::enableWindowingTaskStackOrderBugfix, true, "com.android.window.flags.enable_windowing_task_stack_order_bugfix"),
    ENABLE_WINDOWING_TRANSITION_HANDLERS_OBSERVERS(Flags::enableWindowingTransitionHandlersObservers, true, "com.android.window.flags.enable_windowing_transition_handlers_observers"),
    ENABLE_WINDOW_DECORATION_REFACTOR(Flags::enableWindowDecorationRefactor, false, "com.android.window.flags.enable_window_decoration_refactor"),
    ENABLE_WINDOW_REPOSITIONING_API(Flags::enableWindowRepositioningApi, false, "com.android.window.flags.enable_window_repositioning_api"),
    ENTER_DESKTOP_BY_DEFAULT_ON_FREEFORM_DISPLAYS(Flags::enterDesktopByDefaultOnFreeformDisplays, true, "com.android.window.flags.enter_desktop_by_default_on_freeform_displays"),
    EXCLUDE_DESK_ROOTS_FROM_DESKTOP_TASKS(Flags::excludeDeskRootsFromDesktopTasks, false, "com.android.window.flags.exclude_desk_roots_from_desktop_tasks"),
    FORCE_CLOSE_TOP_TRANSPARENT_FULLSCREEN_TASK(Flags::forceCloseTopTransparentFullscreenTask, true, "com.android.window.flags.force_close_top_transparent_fullscreen_task"),
    FORM_FACTOR_BASED_DESKTOP_FIRST_SWITCH(Flags::formFactorBasedDesktopFirstSwitch, true, "com.android.window.flags.form_factor_based_desktop_first_switch"),
    PRESERVE_RECENTS_TASK_CONFIGURATION_ON_RELAUNCH(Flags::preserveRecentsTaskConfigurationOnRelaunch, true, "com.android.window.flags.preserve_recents_task_configuration_on_relaunch"),
    REPARENT_WINDOW_TOKEN_API(Flags::reparentWindowTokenApi, true, "com.android.window.flags.reparent_window_token_api"),
    RESPECT_FULLSCREEN_ACTIVITY_OPTION_IN_DESKTOP_LAUNCH_PARAMS(Flags::respectFullscreenActivityOptionInDesktopLaunchParams, true, "com.android.window.flags.respect_fullscreen_activity_option_in_desktop_launch_params"),
    SKIP_DEACTIVATION_OF_DESK_WITH_NOTHING_IN_FRONT(Flags::skipDeactivationOfDeskWithNothingInFront, true, "com.android.window.flags.skip_deactivation_of_desk_with_nothing_in_front"),
    USE_RESOURCES_FROM_CONTEXT_TO_CREATE_DRAWABLE_ICONS(com.android.internal.hidden_from_bootclasspath.com.android.graphics.flags.Flags::useResourcesFromContextToCreateDrawableIcons, true, "com.android.graphics.flags.use_resources_from_context_to_create_drawable_icons");

    private static final String TAG = "DesktopExperienceFlags";
    private final BooleanSupplier mFlagFunction;
    private final String mFlagName;
    private final boolean mShouldOverrideByDevOptionDefault;
    private Boolean mCachedIsOverrideByDevOption;
    @Nullable
    private static Boolean sCachedToggleOverride;
    @Nullable
    private static Context sApplicationContext;
    private static Map<String, DesktopExperienceFlag> sDynamicFlags;
    public static final String SYSTEM_PROPERTY_NAME = "persist.wm.debug.desktop_experience_devopts";
    public static final String SYSTEM_PROPERTY_OVERRIDE_PREFIX = "persist.wm.debug.desktop_experience.add_dev_option.";

    static boolean isDesktopExperienceDevOptionSupported() {
        if (!Flags.showDesktopExperienceDevOption()) {
            return false;
        }
        boolean shouldEnforceDeviceRestrictions = SystemProperties.getBoolean("persist.wm.debug.desktop_mode_enforce_device_restrictions", true);
        if (!shouldEnforceDeviceRestrictions) {
            return true;
        }
        Context context = DesktopExperienceFlags.getApplicationContext();
        if (context == null) {
            return false;
        }
        return context.getResources().getBoolean(0x11101D0);
    }

    private DesktopExperienceFlags(@NonNull BooleanSupplier flagFunction, boolean shouldOverrideByDevOption, String flagName) {
        this.mFlagFunction = flagFunction;
        this.mFlagName = flagName;
        this.mShouldOverrideByDevOptionDefault = shouldOverrideByDevOption;
    }

    public boolean isTrue() {
        if (this.mCachedIsOverrideByDevOption == null) {
            this.mCachedIsOverrideByDevOption = DesktopExperienceFlags.checkIfFlagShouldBeOverridden(this.mFlagName, this.mShouldOverrideByDevOptionDefault);
        }
        return DesktopExperienceFlags.isFlagTrue(this.mFlagFunction, this.mCachedIsOverrideByDevOption);
    }

    public boolean getFlagValue() {
        return this.mFlagFunction.getAsBoolean();
    }

    public String getFlagName() {
        return this.mFlagName;
    }

    public boolean isOverridable() {
        return this.mShouldOverrideByDevOptionDefault;
    }

    private static boolean isFlagTrue(BooleanSupplier flagFunction, boolean shouldOverrideByDevOption) {
        if (shouldOverrideByDevOption && DesktopExperienceFlags.getToggleOverride()) {
            return true;
        }
        return flagFunction.getAsBoolean();
    }

    private static void registerFlag(String name, DesktopExperienceFlag flag) {
        sDynamicFlags.put(name, flag);
    }

    public static List<DesktopExperienceFlag> getRegisteredFlags() {
        return new ArrayList<DesktopExperienceFlag>(sDynamicFlags.values());
    }

    private static boolean checkIfFlagShouldBeOverridden(@Nullable String flagName, boolean defaultValue) {
        if (!_Original_Build.IS_ENG && !_Original_Build.IS_USERDEBUG) {
            return defaultValue;
        }
        if (!Flags.showDesktopExperienceDevOption() || com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags.enableDisplayContentModeManagement()) {
            return false;
        }
        if (flagName == null || flagName.isEmpty()) {
            return defaultValue;
        }
        int lastDot = flagName.lastIndexOf(46);
        String baseName = lastDot >= 0 ? flagName.substring(lastDot + 1) : flagName;
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_OVERRIDE_PREFIX + baseName, defaultValue);
    }

    public static boolean getToggleOverride() {
        if (sCachedToggleOverride != null) {
            return sCachedToggleOverride;
        }
        boolean override = DesktopExperienceFlags.isToggleOverriddenBySystem();
        sCachedToggleOverride = override;
        Log.d(TAG, "Toggle override initialized to: " + override);
        return override;
    }

    static Context getApplicationContext() {
        if (sApplicationContext == null) {
            Application application = ActivityThread.currentApplication();
            if (application == null) {
                Log.w(TAG, "Could not get the current application.");
                return null;
            }
            sApplicationContext = application;
        }
        return sApplicationContext;
    }

    private static boolean isToggleOverriddenBySystem() {
        if (com.android.internal.hidden_from_bootclasspath.com.android.server.display.feature.flags.Flags.enableDisplayContentModeManagement() || !Flags.showDesktopExperienceDevOption()) {
            return false;
        }
        return SystemProperties.getBoolean(SYSTEM_PROPERTY_NAME, false);
    }

    static {
        sDynamicFlags = new ArrayMap<String, DesktopExperienceFlag>(10);
    }

    public static class DesktopExperienceFlag {
        private final BooleanSupplier mFlagFunction;
        private final String mFlagName;
        private final boolean mShouldOverrideByDevOptionDefault;
        private Boolean mCachedIsOverrideByDevOption;

        public DesktopExperienceFlag(BooleanSupplier flagFunction, boolean shouldOverrideByDevOption, @Nullable String flagName) {
            this.mFlagFunction = flagFunction;
            this.mFlagName = flagName;
            this.mShouldOverrideByDevOptionDefault = shouldOverrideByDevOption;
            if (Flags.showDesktopExperienceDevOption()) {
                DesktopExperienceFlags.registerFlag(flagName, this);
            }
        }

        public boolean isTrue() {
            if (this.mCachedIsOverrideByDevOption == null) {
                this.mCachedIsOverrideByDevOption = DesktopExperienceFlags.checkIfFlagShouldBeOverridden(this.mFlagName, this.mShouldOverrideByDevOptionDefault);
            }
            return DesktopExperienceFlags.isFlagTrue(this.mFlagFunction, this.mCachedIsOverrideByDevOption);
        }

        public String getFlagName() {
            return this.mFlagName;
        }

        public boolean getFlagValue() {
            return this.mFlagFunction.getAsBoolean();
        }

        public boolean isOverridable() {
            return this.mShouldOverrideByDevOptionDefault;
        }
    }
}

