/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SequenceUtils;
import java.util.Objects;

public class ClientWindowFrames
implements Parcelable {
    @NonNull
    public final Rect frame = new Rect();
    @NonNull
    public final Rect displayFrame = new Rect();
    @NonNull
    public final Rect parentFrame = new Rect();
    @Nullable
    public Rect attachedFrame;
    public boolean isParentFrameClippedByDisplayCutout;
    public float compatScale = 1.0f;
    public int seq = SequenceUtils.getInitSeq();
    public static final Parcelable.Creator<ClientWindowFrames> CREATOR = new Parcelable.Creator<ClientWindowFrames>(){

        @Override
        public ClientWindowFrames createFromParcel(Parcel in) {
            return new ClientWindowFrames(in);
        }

        public ClientWindowFrames[] newArray(int size) {
            return new ClientWindowFrames[size];
        }
    };

    public ClientWindowFrames() {
    }

    public ClientWindowFrames(@NonNull ClientWindowFrames other) {
        this.setTo(other);
    }

    private ClientWindowFrames(@NonNull Parcel in) {
        this.readFromParcel(in);
    }

    public void setTo(@NonNull ClientWindowFrames other) {
        this.frame.set(other.frame);
        this.displayFrame.set(other.displayFrame);
        this.parentFrame.set(other.parentFrame);
        if (other.attachedFrame != null) {
            this.attachedFrame = new Rect(other.attachedFrame);
        }
        this.isParentFrameClippedByDisplayCutout = other.isParentFrameClippedByDisplayCutout;
        this.compatScale = other.compatScale;
        this.seq = other.seq;
    }

    public void readFromParcel(Parcel in) {
        this.frame.readFromParcel(in);
        this.displayFrame.readFromParcel(in);
        this.parentFrame.readFromParcel(in);
        this.attachedFrame = in.readTypedObject(Rect.CREATOR);
        this.isParentFrameClippedByDisplayCutout = in.readBoolean();
        this.compatScale = in.readFloat();
        this.seq = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.frame.writeToParcel(dest, flags);
        this.displayFrame.writeToParcel(dest, flags);
        this.parentFrame.writeToParcel(dest, flags);
        dest.writeTypedObject(this.attachedFrame, flags);
        dest.writeBoolean(this.isParentFrameClippedByDisplayCutout);
        dest.writeFloat(this.compatScale);
        dest.writeInt(this.seq);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        return "ClientWindowFrames{frame=" + this.frame.toShortString(sb) + " display=" + this.displayFrame.toShortString(sb) + " parentFrame=" + this.parentFrame.toShortString(sb) + (this.attachedFrame != null ? " attachedFrame=" + this.attachedFrame.toShortString() : "") + (this.isParentFrameClippedByDisplayCutout ? " parentClippedByDisplayCutout" : "") + (this.compatScale != 1.0f ? " sizeCompatScale=" + this.compatScale : "") + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientWindowFrames other = (ClientWindowFrames)o;
        return this.frame.equals(other.frame) && this.displayFrame.equals(other.displayFrame) && this.parentFrame.equals(other.parentFrame) && Objects.equals(this.attachedFrame, other.attachedFrame) && this.isParentFrameClippedByDisplayCutout == other.isParentFrameClippedByDisplayCutout && this.compatScale == other.compatScale;
    }

    public int hashCode() {
        return Objects.hash(this.frame, this.displayFrame, this.parentFrame, this.attachedFrame, this.isParentFrameClippedByDisplayCutout, Float.valueOf(this.compatScale));
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

