/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.util.FloatProperty;
import android.view.Choreographer;
import android.window.BackEvent;
import android.window.BackMotionEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.dynamicanimation.animation.DynamicAnimation;
import com.android.internal.dynamicanimation.animation.FlingAnimation;
import com.android.internal.dynamicanimation.animation.FloatValueHolder;
import com.android.internal.dynamicanimation.animation.SpringAnimation;
import com.android.internal.dynamicanimation.animation.SpringForce;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import com.android.internal.lang.System_Delegate;

public class BackProgressAnimator
implements DynamicAnimation.OnAnimationUpdateListener {
    private static final float SCALE_FACTOR = 100.0f;
    private static final float FLING_FRICTION = 8.0f;
    private static final float BUTTON_SPRING_STIFFNESS = 100.0f;
    private final SpringAnimation mSpring;
    private ProgressCallback mCallback;
    private float mProgress = 0.0f;
    private float mVelocity = 0.0f;
    private BackMotionEvent mLastBackEvent;
    private boolean mBackAnimationInProgress = false;
    @Nullable
    private Runnable mBackCancelledFinishRunnable;
    @Nullable
    private Runnable mBackInvokedFinishRunnable;
    private FlingAnimation mBackInvokedFlingAnim;
    private final SpringForce mGestureSpringForce = new SpringForce().setStiffness(1500.0f).setDampingRatio(1.0f);
    private final SpringForce mButtonSpringForce = new SpringForce().setDampingRatio(1.0f);
    private final DynamicAnimation.OnAnimationEndListener mOnAnimationEndListener = (animation, canceled, value, velocity) -> {
        if (this.mBackCancelledFinishRunnable != null) {
            this.invokeBackCancelledRunnable();
        }
        if (this.mBackInvokedFinishRunnable != null) {
            this.invokeBackInvokedRunnable();
        }
        this.reset();
    };
    private final DynamicAnimation.OnAnimationUpdateListener mOnBackInvokedFlingUpdateListener = (animation, progress, velocity) -> this.updateProgressValue(progress, velocity, animation.getLastFrameTime());
    private static final FloatProperty<BackProgressAnimator> PROGRESS_PROP = new FloatProperty<BackProgressAnimator>("progress"){

        @Override
        public void setValue(BackProgressAnimator animator2, float value) {
            animator2.setProgress(value);
        }

        @Override
        public Float get(BackProgressAnimator object) {
            return Float.valueOf(object.getProgress());
        }
    };

    private void setProgress(float progress) {
        this.mProgress = progress;
    }

    private float getProgress() {
        return this.mProgress;
    }

    @Override
    public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
        if (this.mBackInvokedFinishRunnable == null) {
            this.updateProgressValue(value, velocity, animation.getLastFrameTime());
        }
    }

    public BackProgressAnimator() {
        this.mSpring = new SpringAnimation(this, PROGRESS_PROP);
        this.mSpring.addUpdateListener(this);
        this.mSpring.setSpring(this.mGestureSpringForce);
    }

    public void onBackProgressed(BackMotionEvent event) {
        if (!this.mBackAnimationInProgress) {
            return;
        }
        if (Flags.predictiveBackSwipeEdgeNoneApi() && event.getSwipeEdge() == 2) {
            return;
        }
        this.mLastBackEvent = event;
        if (this.mSpring == null) {
            return;
        }
        this.mSpring.animateToFinalPosition(event.getProgress() * 100.0f);
    }

    public void onBackStarted(BackMotionEvent event, ProgressCallback callback) {
        this.mLastBackEvent = event;
        this.mCallback = callback;
        this.mBackAnimationInProgress = true;
        this.updateProgressValue(0.0f, 0.0f, System_Delegate.nanoTime() / 1000000L);
        if (Flags.predictiveBackSwipeEdgeNoneApi()) {
            if (event.getSwipeEdge() == 2) {
                this.mButtonSpringForce.setStiffness(100.0f);
                this.mSpring.setSpring(this.mButtonSpringForce);
                this.mSpring.animateToFinalPosition(100.0f);
            } else {
                this.mSpring.setSpring(this.mGestureSpringForce);
                this.onBackProgressed(event);
            }
        } else {
            this.onBackProgressed(event);
        }
    }

    public void reset() {
        if (this.mBackCancelledFinishRunnable != null) {
            this.updateProgressValue(0.0f, 0.0f, System_Delegate.nanoTime() / 1000000L);
            this.invokeBackCancelledRunnable();
        } else if (this.mBackInvokedFinishRunnable != null) {
            this.invokeBackInvokedRunnable();
        }
        if (this.mBackInvokedFlingAnim != null) {
            this.mBackInvokedFlingAnim.cancel();
            this.mBackInvokedFlingAnim = null;
        }
        this.mSpring.animateToFinalPosition(0.0f);
        if (this.mSpring.canSkipToEnd()) {
            this.mSpring.skipToEnd();
        } else {
            this.mSpring.cancel();
        }
        this.mBackAnimationInProgress = false;
        this.mLastBackEvent = null;
        this.mCallback = null;
        this.mProgress = 0.0f;
    }

    public void onBackInvoked(@NonNull Runnable finishCallback) {
        this.mBackInvokedFinishRunnable = finishCallback;
        this.mSpring.animateToFinalPosition(0.0f);
        this.mBackInvokedFlingAnim = ((FlingAnimation)new FlingAnimation(new FloatValueHolder()).setStartValue(this.mProgress)).setFriction(8.0f).setStartVelocity(this.mVelocity).setMinValue(0.0f).setMaxValue(100.0f);
        this.mBackInvokedFlingAnim.addUpdateListener(this.mOnBackInvokedFlingUpdateListener);
        this.mBackInvokedFlingAnim.addEndListener(this.mOnAnimationEndListener);
        this.mBackInvokedFlingAnim.start();
        this.mBackInvokedFlingAnim.doAnimationFrame(Choreographer.getInstance().getLastFrameTimeNanos() / 1000000L);
    }

    public void onBackCancelled(@NonNull Runnable finishCallback) {
        this.mButtonSpringForce.setStiffness(1500.0f);
        this.mBackCancelledFinishRunnable = finishCallback;
        this.mSpring.addEndListener(this.mOnAnimationEndListener);
        this.mSpring.animateToFinalPosition(0.0f);
    }

    public void removeOnBackCancelledFinishCallback() {
        this.mSpring.removeEndListener(this.mOnAnimationEndListener);
        this.mBackCancelledFinishRunnable = null;
    }

    public void removeOnBackInvokedFinishCallback() {
        if (this.mBackInvokedFlingAnim != null) {
            this.mBackInvokedFlingAnim.removeUpdateListener(this.mOnBackInvokedFlingUpdateListener);
            this.mBackInvokedFlingAnim.removeEndListener(this.mOnAnimationEndListener);
        }
        this.mBackInvokedFinishRunnable = null;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean isBackAnimationInProgress() {
        return this.mBackAnimationInProgress;
    }

    public float getVelocity() {
        return this.mVelocity / 100.0f;
    }

    private void updateProgressValue(float progress, float velocity, long frameTime) {
        this.mVelocity = velocity;
        if (this.mLastBackEvent == null || this.mCallback == null || !this.mBackAnimationInProgress) {
            return;
        }
        BackEvent backEvent = Flags.predictiveBackTimestampApi() ? new BackEvent(this.mLastBackEvent.getTouchX(), this.mLastBackEvent.getTouchY(), progress / 100.0f, this.mLastBackEvent.getSwipeEdge(), frameTime) : new BackEvent(this.mLastBackEvent.getTouchX(), this.mLastBackEvent.getTouchY(), progress / 100.0f, this.mLastBackEvent.getSwipeEdge());
        this.mCallback.onProgressUpdate(backEvent);
    }

    private void invokeBackCancelledRunnable() {
        this.mSpring.removeEndListener(this.mOnAnimationEndListener);
        this.mBackCancelledFinishRunnable.run();
        this.mBackCancelledFinishRunnable = null;
    }

    private void invokeBackInvokedRunnable() {
        this.mBackInvokedFlingAnim.removeUpdateListener(this.mOnBackInvokedFlingUpdateListener);
        this.mBackInvokedFlingAnim.removeEndListener(this.mOnAnimationEndListener);
        this.mBackInvokedFinishRunnable.run();
        this.mBackInvokedFinishRunnable = null;
    }

    public static interface ProgressCallback {
        public void onProgressUpdate(BackEvent var1);
    }
}

