/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Activity;
import android.app.ActivityThread;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class ActivityWindowInfo
implements Parcelable {
    private boolean mIsEmbedded;
    @NonNull
    private final Rect mTaskBounds = new Rect();
    @NonNull
    private final Rect mTaskFragmentBounds = new Rect();
    @NonNull
    public static final Parcelable.Creator<ActivityWindowInfo> CREATOR = new Parcelable.Creator<ActivityWindowInfo>(){

        @Override
        public ActivityWindowInfo createFromParcel(@NonNull Parcel in) {
            return new ActivityWindowInfo(in);
        }

        public ActivityWindowInfo[] newArray(int size) {
            return new ActivityWindowInfo[size];
        }
    };

    public ActivityWindowInfo() {
    }

    public ActivityWindowInfo(@NonNull ActivityWindowInfo info) {
        this.set(info);
    }

    public void set(@NonNull ActivityWindowInfo info) {
        this.set(info.mIsEmbedded, info.mTaskBounds, info.mTaskFragmentBounds);
    }

    public void set(boolean isEmbedded, @NonNull Rect taskBounds, @NonNull Rect taskFragmentBounds) {
        this.mIsEmbedded = isEmbedded;
        this.mTaskBounds.set(taskBounds);
        this.mTaskFragmentBounds.set(taskFragmentBounds);
    }

    public boolean isEmbedded() {
        return this.mIsEmbedded;
    }

    @NonNull
    public Rect getTaskBounds() {
        return this.mTaskBounds;
    }

    @NonNull
    public Rect getTaskFragmentBounds() {
        return this.mTaskFragmentBounds;
    }

    private ActivityWindowInfo(@NonNull Parcel in) {
        this.mIsEmbedded = in.readBoolean();
        this.mTaskBounds.readFromParcel(in);
        this.mTaskFragmentBounds.readFromParcel(in);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mIsEmbedded);
        this.mTaskBounds.writeToParcel(dest, flags);
        this.mTaskFragmentBounds.writeToParcel(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityWindowInfo other = (ActivityWindowInfo)o;
        return this.mIsEmbedded == other.mIsEmbedded && this.mTaskBounds.equals(other.mTaskBounds) && this.mTaskFragmentBounds.equals(other.mTaskFragmentBounds);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mIsEmbedded ? 1 : 0);
        result = 31 * result + this.mTaskBounds.hashCode();
        result = 31 * result + this.mTaskFragmentBounds.hashCode();
        return result;
    }

    public String toString() {
        return "ActivityWindowInfo{isEmbedded=" + this.mIsEmbedded + ", taskBounds=" + this.mTaskBounds + ", taskFragmentBounds=" + this.mTaskFragmentBounds + "}";
    }

    @Nullable
    public static ActivityWindowInfo getActivityWindowInfo(@NonNull Activity activity) {
        if (activity.isFinishing()) {
            return null;
        }
        ActivityThread.ActivityClientRecord record = ActivityThread.currentActivityThread().getActivityClient(activity.getActivityToken());
        return record != null ? record.getActivityWindowInfo() : null;
    }
}

