/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import android.window.AppCompatTransitionInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class ActivityTransitionInfo
implements Parcelable {
    @NonNull
    private final ComponentName mComponent;
    private final int mTaskId;
    @Nullable
    private final AppCompatTransitionInfo mAppCompatTransitionInfo;
    @NonNull
    public static final Parcelable.Creator<ActivityTransitionInfo> CREATOR = new Parcelable.Creator<ActivityTransitionInfo>(){

        public ActivityTransitionInfo[] newArray(int size) {
            return new ActivityTransitionInfo[size];
        }

        @Override
        public ActivityTransitionInfo createFromParcel(@NonNull Parcel in) {
            return new ActivityTransitionInfo(in);
        }
    };

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PROTECTED)
    public ActivityTransitionInfo(@NonNull ActivityTransitionInfo other) {
        this(other.mComponent.clone(), other.mTaskId, other.mAppCompatTransitionInfo);
    }

    public ActivityTransitionInfo(@NonNull ComponentName component, int taskId) {
        this(component, taskId, null);
    }

    public ActivityTransitionInfo(@NonNull ComponentName component, int taskId, @Nullable AppCompatTransitionInfo appCompatTransitionInfo) {
        this.mComponent = component;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mComponent);
        this.mTaskId = taskId;
        this.mAppCompatTransitionInfo = appCompatTransitionInfo;
    }

    @NonNull
    public ComponentName getComponent() {
        return this.mComponent;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    @Nullable
    public AppCompatTransitionInfo getAppCompatTransitionInfo() {
        return this.mAppCompatTransitionInfo;
    }

    public String toString() {
        return "ActivityTransitionInfo { component = " + this.mComponent + ", taskId = " + this.mTaskId + ", appCompatTransitionInfo = " + this.mAppCompatTransitionInfo + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityTransitionInfo that = (ActivityTransitionInfo)o;
        return Objects.equals(this.mComponent, that.mComponent) && this.mTaskId == that.mTaskId && Objects.equals(this.mAppCompatTransitionInfo, that.mAppCompatTransitionInfo);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mComponent);
        _hash = 31 * _hash + this.mTaskId;
        _hash = 31 * _hash + Objects.hashCode(this.mAppCompatTransitionInfo);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mAppCompatTransitionInfo != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mComponent, flags);
        dest.writeInt(this.mTaskId);
        if (this.mAppCompatTransitionInfo != null) {
            dest.writeTypedObject(this.mAppCompatTransitionInfo, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ActivityTransitionInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        ComponentName component = in.readTypedObject(ComponentName.CREATOR);
        int taskId = in.readInt();
        AppCompatTransitionInfo appCompatTransitionInfo = (flg & 4) == 0 ? null : in.readTypedObject(AppCompatTransitionInfo.CREATOR);
        this.mComponent = component;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mComponent);
        this.mTaskId = taskId;
        this.mAppCompatTransitionInfo = appCompatTransitionInfo;
    }

    @Deprecated
    private void __metadata() {
    }
}

