/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.om.FabricatedOverlay;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManager;
import android.content.om.OverlayManagerTransaction;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.loader.ResourcesLoader;
import android.content.res.loader.ResourcesProvider;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BlendMode;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.RippleDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.os.UserHandle;
import android.os._Original_Build;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DisplayMetrics;
import android.util.IntArray;
import android.util.Log;
import android.util.LongArray;
import android.util.LongSparseArray;
import android.util.Pair;
import android.util.SizeF;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TypedValue;
import android.util.proto.ProtoInputStream;
import android.util.proto.ProtoOutputStream;
import android.util.proto.ProtoStream;
import android.util.proto.ProtoUtils;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewManager;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.ViewStub;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.RadioGroup;
import android.widget.RemoteCollectionItemsAdapter;
import android.widget.RemoteViewsSerializers;
import android.widget.RemoteViews_Delegate;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.hidden_from_bootclasspath.android.appwidget.flags.Flags;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.IRemoteViewsFactory;
import com.android.internal.widget.remotecompose.core.CoreDocument;
import com.android.internal.widget.remotecompose.player.RemoteComposeDocument;
import com.android.internal.widget.remotecompose.player.RemoteComposePlayer;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter {
    private static final String LOG_TAG = "RemoteViews";
    public static final String EXTRA_CHECKED = "android.widget.extra.CHECKED";
    static final String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    static final String EXTRA_REMOTEADAPTER_ON_LIGHT_BACKGROUND = "remoteAdapterOnLightBackground";
    public static final String EXTRA_SHARED_ELEMENT_BOUNDS = "android.widget.extra.SHARED_ELEMENT_BOUNDS";
    private static final int MAX_NESTED_VIEWS = 10;
    private static final int MAX_INIT_VIEW_COUNT = 16;
    private static final int SET_ON_CLICK_RESPONSE_TAG = 1;
    private static final int REFLECTION_ACTION_TAG = 2;
    private static final int SET_DRAWABLE_TINT_TAG = 3;
    private static final int VIEW_GROUP_ACTION_ADD_TAG = 4;
    private static final int VIEW_CONTENT_NAVIGATION_TAG = 5;
    private static final int SET_EMPTY_VIEW_ACTION_TAG = 6;
    private static final int VIEW_GROUP_ACTION_REMOVE_TAG = 7;
    private static final int SET_PENDING_INTENT_TEMPLATE_TAG = 8;
    private static final int SET_REMOTE_VIEW_ADAPTER_INTENT_TAG = 10;
    private static final int TEXT_VIEW_DRAWABLE_ACTION_TAG = 11;
    private static final int BITMAP_REFLECTION_ACTION_TAG = 12;
    private static final int TEXT_VIEW_SIZE_ACTION_TAG = 13;
    private static final int VIEW_PADDING_ACTION_TAG = 14;
    private static final int SET_REMOTE_INPUTS_ACTION_TAG = 18;
    private static final int LAYOUT_PARAM_ACTION_TAG = 19;
    private static final int SET_RIPPLE_DRAWABLE_COLOR_TAG = 21;
    private static final int SET_INT_TAG_TAG = 22;
    private static final int REMOVE_FROM_PARENT_ACTION_TAG = 23;
    private static final int RESOURCE_REFLECTION_ACTION_TAG = 24;
    private static final int COMPLEX_UNIT_DIMENSION_REFLECTION_ACTION_TAG = 25;
    private static final int SET_COMPOUND_BUTTON_CHECKED_TAG = 26;
    private static final int SET_RADIO_GROUP_CHECKED = 27;
    private static final int SET_VIEW_OUTLINE_RADIUS_TAG = 28;
    private static final int SET_ON_CHECKED_CHANGE_RESPONSE_TAG = 29;
    private static final int NIGHT_MODE_REFLECTION_ACTION_TAG = 30;
    private static final int SET_REMOTE_COLLECTION_ITEMS_ADAPTER_TAG = 31;
    private static final int ATTRIBUTE_REFLECTION_ACTION_TAG = 32;
    private static final int SET_REMOTE_ADAPTER_TAG = 33;
    private static final int SET_ON_STYLUS_HANDWRITING_RESPONSE_TAG = 34;
    private static final int SET_DRAW_INSTRUCTION_TAG = 35;
    public static final int MARGIN_LEFT = 0;
    public static final int MARGIN_TOP = 1;
    public static final int MARGIN_RIGHT = 2;
    public static final int MARGIN_BOTTOM = 3;
    public static final int MARGIN_START = 4;
    public static final int MARGIN_END = 5;
    static final int VALUE_TYPE_RAW = 1;
    static final int VALUE_TYPE_COMPLEX_UNIT = 2;
    static final int VALUE_TYPE_RESOURCE = 3;
    static final int VALUE_TYPE_ATTRIBUTE = 4;
    public static final int FLAG_REAPPLY_DISALLOWED = 1;
    public static final int FLAG_WIDGET_IS_COLLECTION_CHILD = 2;
    public static final int FLAG_USE_LIGHT_BACKGROUND_LAYOUT = 4;
    static final int FLAG_MASK_TO_PROPAGATE = 6;
    private static final Parcel.ReadWriteHelper ALTERNATIVE_DEFAULT = new Parcel.ReadWriteHelper();
    private static final LayoutInflater.Filter INFLATER_FILTER = clazz -> clazz.isAnnotationPresent(RemoteView.class);
    @UnsupportedAppUsage
    public ApplicationInfo mApplication;
    @UnsupportedAppUsage
    private int mLayoutId;
    private int mLightBackgroundLayoutId = 0;
    @UnsupportedAppUsage
    private ArrayList<Action> mActions;
    @UnsupportedAppUsage
    private BitmapCache mBitmapCache = new BitmapCache();
    @NonNull
    private RemoteCollectionCache mCollectionCache = new RemoteCollectionCache();
    private ApplicationInfoCache mApplicationInfoCache = new ApplicationInfoCache();
    private boolean mIsRoot = true;
    private static final int MODE_NORMAL = 0;
    private static final int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private static final int MODE_HAS_SIZED_REMOTEVIEWS = 2;
    private RemoteViews mLandscape = null;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private RemoteViews mPortrait = null;
    private List<RemoteViews> mSizedRemoteViews = null;
    private SizeF mIdealSize = null;
    private int mApplyFlags = 0;
    private int mViewId = -1;
    private long mProviderInstanceId = -1L;
    private Map<Class, Object> mClassCookies;
    @Nullable
    private LayoutInflater.Factory2 mLayoutInflaterFactory2;
    private boolean mHasDrawInstructions;
    @Nullable
    private SparseArray<PendingIntent> mPendingIntentTemplate;
    @Nullable
    private SparseArray<Intent> mFillInIntent;
    private static final InteractionHandler DEFAULT_INTERACTION_HANDLER = (view, pendingIntent, response) -> RemoteViews.startPendingIntent(view, pendingIntent, response.getLaunchOptions(view));
    private static final ArrayMap<MethodKey, MethodArgs> sMethods = new ArrayMap();
    private static final MethodKey sLookupKey = new MethodKey();
    private static final Action ACTION_NOOP = new RuntimeAction(){

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
        }
    };
    private static final int MAX_SINGLE_PARCEL_SIZE = 800000;
    @NonNull
    public static final Parcelable.Creator<RemoteViews> CREATOR = new Parcelable.Creator<RemoteViews>(){

        @Override
        public RemoteViews createFromParcel(Parcel parcel) {
            return new RemoteViews(parcel);
        }

        public RemoteViews[] newArray(int size) {
            return new RemoteViews[size];
        }
    };

    public void setRemoteInputs(int viewId, RemoteInput[] remoteInputs) {
        this.mActions.add(new SetRemoteInputsAction(viewId, remoteInputs));
    }

    public void setLayoutInflaterFactory(@Nullable LayoutInflater.Factory2 factory) {
        this.mLayoutInflaterFactory2 = factory;
    }

    @Nullable
    public LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this.mLayoutInflaterFactory2;
    }

    public void reduceImageSizes(int maxWidth, int maxHeight) {
        ArrayList<Bitmap> cache = this.mBitmapCache.mBitmaps;
        for (int i = 0; i < cache.size(); ++i) {
            Bitmap bitmap = cache.get(i);
            cache.set(i, Icon.scaleDownIfNecessary(bitmap, maxWidth, maxHeight));
        }
    }

    public void setIntTag(int viewId, int key, int tag) {
        this.addAction(new SetIntTagAction(viewId, key, tag));
    }

    @FlaggedApi(value="android.appwidget.flags.engagement_metrics")
    public void setUsageEventTag(int viewId, int tag) {
        this.addAction(new SetIntTagAction(viewId, 16909485, tag));
    }

    public void addFlags(int flags) {
        this.mApplyFlags |= flags;
        int flagsToPropagate = flags & 6;
        if (flagsToPropagate != 0) {
            if (this.hasSizedRemoteViews()) {
                for (RemoteViews remoteView : this.mSizedRemoteViews) {
                    remoteView.addFlags(flagsToPropagate);
                }
            } else if (this.hasLandscapeAndPortraitLayouts()) {
                this.mLandscape.addFlags(flagsToPropagate);
                this.mPortrait.addFlags(flagsToPropagate);
            }
        }
    }

    public boolean hasFlags(int flag) {
        return (this.mApplyFlags & flag) == flag;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void mergeRemoteViews(RemoteViews newRv) {
        if (newRv == null) {
            return;
        }
        RemoteViews copy = new RemoteViews(newRv);
        HashMap<String, Action> map = new HashMap<String, Action>();
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        int count = this.mActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            map.put(a.getUniqueKey(), a);
        }
        ArrayList<Action> newActions = copy.mActions;
        if (newActions == null) {
            return;
        }
        count = newActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = newActions.get(i);
            String key = newActions.get(i).getUniqueKey();
            int mergeBehavior = newActions.get(i).mergeBehavior();
            if (map.containsKey(key) && mergeBehavior == 0) {
                this.mActions.remove(map.get(key));
                map.remove(key);
            }
            if (mergeBehavior != 0 && mergeBehavior != 1) continue;
            this.mActions.add(a);
        }
        this.reconstructCaches();
    }

    public boolean isLegacyListRemoteViews() {
        return this.mCollectionCache.mIdToUriMapping.size() > 0;
    }

    public void visitUris(@NonNull Consumer<Uri> visitor) {
        int i;
        if (this.mActions != null) {
            for (i = 0; i < this.mActions.size(); ++i) {
                this.mActions.get(i).visitUris(visitor);
            }
        }
        if (this.mSizedRemoteViews != null) {
            for (i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                this.mSizedRemoteViews.get(i).visitUris(visitor);
            }
        }
        if (this.mLandscape != null) {
            this.mLandscape.visitUris(visitor);
        }
        if (this.mPortrait != null) {
            this.mPortrait.visitUris(visitor);
        }
    }

    public void visitIcons(@NonNull Consumer<Icon> visitor) {
        int i;
        if (this.mActions != null) {
            for (i = 0; i < this.mActions.size(); ++i) {
                this.mActions.get(i).visitIcons(visitor);
            }
        }
        if (this.mSizedRemoteViews != null) {
            for (i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                this.mSizedRemoteViews.get(i).visitIcons(visitor);
            }
        }
        if (this.mLandscape != null) {
            this.mLandscape.visitIcons(visitor);
        }
        if (this.mPortrait != null) {
            this.mPortrait.visitIcons(visitor);
        }
    }

    public boolean replaceRemoteCollections(int viewId) {
        int i;
        boolean isActionReplaced = false;
        if (this.mActions != null) {
            for (i = 0; i < this.mActions.size(); ++i) {
                Action action = this.mActions.get(i);
                if (action instanceof SetRemoteCollectionItemListAdapterAction) {
                    SetRemoteCollectionItemListAdapterAction itemsAction = (SetRemoteCollectionItemListAdapterAction)action;
                    if (itemsAction.mViewId == viewId && itemsAction.mServiceIntent != null) {
                        SetRemoteCollectionItemListAdapterAction newCollectionAction = new SetRemoteCollectionItemListAdapterAction(itemsAction.mViewId, itemsAction.mServiceIntent);
                        newCollectionAction.mIntentId = itemsAction.mIntentId;
                        newCollectionAction.mIsReplacedIntoAction = true;
                        this.mActions.set(i, newCollectionAction);
                        isActionReplaced = true;
                        continue;
                    }
                }
                if (action instanceof SetRemoteViewsAdapterIntent) {
                    SetRemoteViewsAdapterIntent intentAction = (SetRemoteViewsAdapterIntent)action;
                    if (intentAction.mViewId == viewId) {
                        this.mActions.set(i, new SetRemoteCollectionItemListAdapterAction(intentAction.mViewId, intentAction.mIntent));
                        isActionReplaced = true;
                        continue;
                    }
                }
                if (!(action instanceof ViewGroupActionAdd)) continue;
                ViewGroupActionAdd groupAction = (ViewGroupActionAdd)action;
                if (groupAction.mNestedViews == null) continue;
                isActionReplaced |= groupAction.mNestedViews.replaceRemoteCollections(viewId);
            }
        }
        if (this.mSizedRemoteViews != null) {
            for (i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                isActionReplaced |= this.mSizedRemoteViews.get(i).replaceRemoteCollections(viewId);
            }
        }
        if (this.mLandscape != null) {
            isActionReplaced |= this.mLandscape.replaceRemoteCollections(viewId);
        }
        if (this.mPortrait != null) {
            isActionReplaced |= this.mPortrait.replaceRemoteCollections(viewId);
        }
        return isActionReplaced;
    }

    public boolean hasLegacyLists() {
        int i;
        block7: {
            if (this.mActions == null) break block7;
            for (i = 0; i < this.mActions.size(); ++i) {
                block9: {
                    Action action;
                    block10: {
                        block8: {
                            action = this.mActions.get(i);
                            if (!(action instanceof SetRemoteCollectionItemListAdapterAction)) break block8;
                            SetRemoteCollectionItemListAdapterAction itemsAction = (SetRemoteCollectionItemListAdapterAction)action;
                            if (itemsAction.mServiceIntent != null) break block9;
                        }
                        if (!(action instanceof SetRemoteViewsAdapterIntent)) break block10;
                        SetRemoteViewsAdapterIntent intentAction = (SetRemoteViewsAdapterIntent)action;
                        if (intentAction.mIntent != null) break block9;
                    }
                    if (!(action instanceof ViewGroupActionAdd)) continue;
                    ViewGroupActionAdd groupAction = (ViewGroupActionAdd)action;
                    if (groupAction.mNestedViews == null || !groupAction.mNestedViews.hasLegacyLists()) continue;
                }
                return true;
            }
        }
        if (this.mSizedRemoteViews != null) {
            for (i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                if (!this.mSizedRemoteViews.get(i).hasLegacyLists()) continue;
                return true;
            }
        }
        if (this.mLandscape != null && this.mLandscape.hasLegacyLists()) {
            return true;
        }
        return this.mPortrait != null && this.mPortrait.hasLegacyLists();
    }

    private static void visitIconUri(Icon icon, @NonNull Consumer<Uri> visitor) {
        if (icon != null && (icon.getType() == 4 || icon.getType() == 6)) {
            visitor.accept(icon.getUri());
        }
    }

    private PendingResources<Action> createSetRemoteCollectionItemListAdapterActionFromProto(ProtoInputStream in) throws Exception {
        LongSparseArray<Object> values = new LongSparseArray<Object>();
        long token = in.start(1146756268046L);
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    values.put(0x10900000001L, in.readString(0x10900000001L));
                    continue block4;
                }
                case 2: {
                    long itemsToken = in.start(1146756268034L);
                    values.put(1146756268034L, RemoteCollectionItems.createFromProto(in));
                    in.end(itemsToken);
                    continue block4;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        in.end(token);
        RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1146756268034L});
        return (context, resources, rootData, depth) -> {
            int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
            return new SetRemoteCollectionItemListAdapterAction(viewId, (RemoteCollectionItems)((PendingResources)values.get(1146756268034L)).create(context, resources, rootData, depth));
        };
    }

    public CompletableFuture<Void> collectAllIntents(int bitmapSizeLimit, boolean invalidateData, @NonNull AppWidgetManager.ServiceCollectionCache collectionCache) {
        return this.mCollectionCache.collectAllIntentsNoComplete(this, bitmapSizeLimit, invalidateData, collectionCache);
    }

    public void replaceAllIntentsWithEmptyList() {
        this.mCollectionCache.replaceAllIntentsWithEmptyList(this);
    }

    private PendingResources<RemoteCollectionCache> populateRemoteCollectionCacheFromProto(ProtoInputStream in) throws Exception {
        ArrayList entries = new ArrayList();
        long token = in.start(1146756268047L);
        block8: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    LongSparseArray<Object> entry = new LongSparseArray<Object>();
                    long entryToken = in.start(2246267895809L);
                    block9: while (in.nextField() != -1) {
                        switch (in.getFieldNumber()) {
                            case 1: {
                                entry.put(0x10300000001L, in.readInt(0x10300000001L));
                                continue block9;
                            }
                            case 2: {
                                entry.put(1138166333442L, in.readString(1138166333442L));
                                continue block9;
                            }
                            case 3: {
                                long itemsToken = in.start(1146756268035L);
                                entry.put(1146756268035L, RemoteCollectionItems.createFromProto(in));
                                in.end(itemsToken);
                                continue block9;
                            }
                        }
                        Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
                    }
                    in.end(entryToken);
                    RemoteViews.checkContainsKeys(entry, new long[]{0x10300000001L, 1138166333442L, 1146756268035L});
                    entries.add(entry);
                    continue block8;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        in.end(token);
        return (context, resources, rootData, depth) -> {
            for (LongSparseArray entry : entries) {
                int id2 = (Integer)entry.get(0x10300000001L);
                String uri = (String)entry.get(1138166333442L);
                RemoteCollectionItems items = (RemoteCollectionItems)((PendingResources)entry.get(1146756268035L)).create(context, resources, rootData, depth);
                rootData.mRemoteCollectionCache.addMapping(id2, uri, items);
            }
            return rootData.mRemoteCollectionCache;
        };
    }

    public static Rect getSourceBounds(View v) {
        float appScale = v.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        Rect rect = new Rect();
        rect.left = (int)((float)pos[0] * appScale + 0.5f);
        rect.top = (int)((float)pos[1] * appScale + 0.5f);
        rect.right = (int)((float)(pos[0] + v.getWidth()) * appScale + 0.5f);
        rect.bottom = (int)((float)(pos[1] + v.getHeight()) * appScale + 0.5f);
        return rect;
    }

    @Nullable
    private static Class<?> getParameterType(int type) {
        switch (type) {
            case 1: {
                return Boolean.TYPE;
            }
            case 2: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Long.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return Character.TYPE;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return CharSequence.class;
            }
            case 11: {
                return Uri.class;
            }
            case 12: {
                return Bitmap.class;
            }
            case 13: {
                return Bundle.class;
            }
            case 14: {
                return Intent.class;
            }
            case 15: {
                return ColorStateList.class;
            }
            case 16: {
                return Icon.class;
            }
            case 17: {
                return BlendMode.class;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static MethodHandle getMethod(View view, String methodName, Class<?> paramType, boolean async) {
        Class<?> klass = view.getClass();
        ArrayMap<MethodKey, MethodArgs> arrayMap = sMethods;
        synchronized (arrayMap) {
            sLookupKey.set(klass, paramType, methodName);
            MethodArgs result = sMethods.get(sLookupKey);
            if (result == null) {
                try {
                    Method method = paramType == null ? klass.getMethod(methodName, new Class[0]) : klass.getMethod(methodName, paramType);
                    if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                        throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + methodName + RemoteViews.getParameters(paramType));
                    }
                    result = new MethodArgs();
                    result.syncMethod = MethodHandles.publicLookup().unreflect(method);
                    result.asyncMethodName = method.getAnnotation(RemotableViewMethod.class).asyncImpl();
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("view: " + klass.getName() + " doesn't have method: " + methodName + RemoteViews.getParameters(paramType));
                }
                MethodKey key = new MethodKey();
                key.set(klass, paramType, methodName);
                sMethods.put(key, result);
            }
            if (!async) {
                return result.syncMethod;
            }
            if (result.asyncMethodName.isEmpty()) {
                return null;
            }
            if (result.asyncMethod == null) {
                MethodType asyncType = result.syncMethod.type().dropParameterTypes(0, 1).changeReturnType(Runnable.class);
                try {
                    result.asyncMethod = MethodHandles.publicLookup().findVirtual(klass, result.asyncMethodName, asyncType);
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    throw new ActionException("Async implementation declared as " + result.asyncMethodName + " but not defined for " + methodName + ": public Runnable " + result.asyncMethodName + " (" + TextUtils.join((CharSequence)",", asyncType.parameterArray()) + ")");
                }
            }
            return result.asyncMethod;
        }
    }

    private static String getParameters(Class<?> paramType) {
        if (paramType == null) {
            return "()";
        }
        return "(" + paramType + ")";
    }

    @NonNull
    BitmapCache getBitmapCache() {
        return this.mBitmapCache;
    }

    private PendingResources<Action> createFromBitmapReflectionActionFromProto(ProtoInputStream in) throws Exception {
        LongSparseArray<Object> values = new LongSparseArray<Object>();
        long token = in.start(1146756268034L);
        block5: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    values.put(0x10900000001L, in.readString(0x10900000001L));
                    continue block5;
                }
                case 2: {
                    values.put(1138166333442L, in.readString(1138166333442L));
                    continue block5;
                }
                case 3: {
                    values.put(1120986464259L, in.readInt(1120986464259L));
                    continue block5;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        in.end(token);
        RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L});
        return (context, resources, rootData, depth) -> {
            int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
            return new BitmapReflectionAction(this, viewId, (String)values.get(1138166333442L), rootData.mBitmapCache.getBitmapForId(values.get(1120986464259L, 0)));
        };
    }

    private static boolean hasStableId(View view) {
        Object tag = view.getTag(16909494);
        return tag != null;
    }

    private static int getStableId(View view) {
        Integer id2 = (Integer)view.getTag(16909494);
        return id2 == null ? -1 : id2;
    }

    private static void setStableId(View view, int stableId) {
        view.setTagInternal(16909494, stableId);
    }

    private static int getNextRecyclableChild(ViewGroup vg) {
        Integer tag = (Integer)vg.getTag(16909492);
        return tag == null ? -1 : tag;
    }

    private static int getViewLayoutId(View v) {
        return (Integer)v.getTag(16908312);
    }

    private static void setNextRecyclableChild(ViewGroup vg, int nextChild, int numChildren) {
        if (nextChild < 0 || nextChild >= numChildren) {
            vg.setTagInternal(16909492, -1);
        } else {
            vg.setTagInternal(16909492, nextChild);
        }
    }

    private void finalizeViewRecycling(ViewGroup root) {
        int nextChild = RemoteViews.getNextRecyclableChild(root);
        if (nextChild >= 0 && nextChild < root.getChildCount()) {
            root.removeViews(nextChild, root.getChildCount() - nextChild);
        }
        RemoteViews.setNextRecyclableChild(root, -1, 0);
        for (int i = 0; i < root.getChildCount(); ++i) {
            View child = root.getChildAt(i);
            if (!(child instanceof ViewGroup) || child.isRootNamespace()) continue;
            this.finalizeViewRecycling((ViewGroup)child);
        }
    }

    private PendingResources<Action> createViewGroupActionAddFromProto(ProtoInputStream in) throws Exception {
        LongSparseArray<Object> values = new LongSparseArray<Object>();
        long token = in.start(1146756268051L);
        block6: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    values.put(0x10900000001L, in.readString(0x10900000001L));
                    continue block6;
                }
                case 2: {
                    long nvToken = in.start(1146756268034L);
                    values.put(1146756268034L, RemoteViews.createFromProto(in));
                    in.end(nvToken);
                    continue block6;
                }
                case 3: {
                    values.put(1120986464259L, in.readInt(1120986464259L));
                    continue block6;
                }
                case 4: {
                    values.put(1120986464260L, in.readInt(1120986464260L));
                    continue block6;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        in.end(token);
        RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1146756268034L});
        return (context, resources, rootData, depth) -> {
            int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
            return new ViewGroupActionAdd(viewId, (RemoteViews)((PendingResources)values.get(1146756268034L)).create(context, resources, rootData, depth), values.get(1120986464259L, 0), values.get(1120986464260L, 0));
        };
    }

    @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
    private PendingResources<Action> createSetDrawInstructionActionFromProto(ProtoInputStream in) throws Exception {
        ArrayList<byte[]> instructions = new ArrayList<byte[]>();
        long token = in.start(1146756268054L);
        block3: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    instructions.add(in.readBytes(2250562863105L));
                    continue block3;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        in.end(token);
        return (context, resources, rootData, depth) -> new SetDrawInstructionAction(new DrawInstructions.Builder(instructions).build());
    }

    public RemoteViews(String packageName, int layoutId) {
        this(RemoteViews.getApplicationInfo(packageName, UserHandle.myUserId()), layoutId);
    }

    public RemoteViews(@NonNull String packageName, int layoutId, int viewId) {
        this(packageName, layoutId);
        this.mViewId = viewId;
    }

    protected RemoteViews(ApplicationInfo application, int layoutId) {
        this.mApplication = application;
        this.mLayoutId = layoutId;
        this.mApplicationInfoCache.put(application);
    }

    private boolean hasMultipleLayouts() {
        return this.hasLandscapeAndPortraitLayouts() || this.hasSizedRemoteViews();
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    private boolean hasSizedRemoteViews() {
        return this.mSizedRemoteViews != null;
    }

    @Nullable
    private SizeF getIdealSize() {
        return this.mIdealSize;
    }

    private void setIdealSize(@Nullable SizeF size) {
        this.mIdealSize = size;
    }

    private RemoteViews findSmallestRemoteView() {
        return this.mSizedRemoteViews.get(this.mSizedRemoteViews.size() - 1);
    }

    public RemoteViews(RemoteViews landscape, RemoteViews portrait) {
        if (landscape == null || portrait == null) {
            throw new IllegalArgumentException("Both RemoteViews must be non-null");
        }
        if (!landscape.hasSameAppInfo(portrait.mApplication)) {
            throw new IllegalArgumentException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = portrait.mApplication;
        this.mLayoutId = portrait.mLayoutId;
        this.mViewId = portrait.mViewId;
        this.mLightBackgroundLayoutId = portrait.mLightBackgroundLayoutId;
        this.mLandscape = landscape;
        this.mPortrait = portrait;
        this.mClassCookies = portrait.mClassCookies != null ? portrait.mClassCookies : landscape.mClassCookies;
        this.configureDescendantsAsChildren();
    }

    public RemoteViews(@NonNull Map<SizeF, RemoteViews> remoteViews) {
        if (remoteViews.isEmpty()) {
            throw new IllegalArgumentException("The set of RemoteViews cannot be empty");
        }
        if (remoteViews.size() > 16) {
            throw new IllegalArgumentException("Too many RemoteViews in constructor");
        }
        if (remoteViews.size() == 1) {
            RemoteViews single = remoteViews.values().iterator().next();
            this.initializeFrom(single, single);
            return;
        }
        this.mClassCookies = this.initializeSizedRemoteViews(remoteViews.entrySet().stream().map(entry -> {
            ((RemoteViews)entry.getValue()).setIdealSize((SizeF)entry.getKey());
            return (RemoteViews)entry.getValue();
        }).iterator());
        RemoteViews smallestView = this.findSmallestRemoteView();
        this.mApplication = smallestView.mApplication;
        this.mLayoutId = smallestView.mLayoutId;
        this.mViewId = smallestView.mViewId;
        this.mLightBackgroundLayoutId = smallestView.mLightBackgroundLayoutId;
        this.configureDescendantsAsChildren();
    }

    private Map<Class, Object> initializeSizedRemoteViews(Iterator<RemoteViews> remoteViews) {
        ArrayList<RemoteViews> sizedRemoteViews = new ArrayList<RemoteViews>();
        Map<Class, Object> classCookies = null;
        float viewArea = Float.MAX_VALUE;
        RemoteViews smallestView = null;
        while (remoteViews.hasNext()) {
            RemoteViews view = remoteViews.next();
            SizeF size = view.getIdealSize();
            if (size == null) {
                throw new IllegalStateException("Expected RemoteViews to have ideal size");
            }
            float newViewArea = size.getWidth() * size.getHeight();
            if (smallestView != null && !view.hasSameAppInfo(smallestView.mApplication)) {
                throw new IllegalArgumentException("All RemoteViews must share the same package and user");
            }
            if (smallestView == null || newViewArea < viewArea) {
                if (smallestView != null) {
                    sizedRemoteViews.add(smallestView);
                }
                viewArea = newViewArea;
                smallestView = view;
            } else {
                sizedRemoteViews.add(view);
            }
            view.setIdealSize(size);
            if (classCookies != null) continue;
            classCookies = view.mClassCookies;
        }
        sizedRemoteViews.add(smallestView);
        this.mSizedRemoteViews = sizedRemoteViews;
        return classCookies;
    }

    public RemoteViews(RemoteViews src) {
        this.initializeFrom(src, null);
    }

    private RemoteViews() {
    }

    private static RemoteViews createInitializedFrom(@NonNull RemoteViews src, @Nullable RemoteViews hierarchyRoot) {
        RemoteViews child = new RemoteViews();
        child.initializeFrom(src, hierarchyRoot);
        return child;
    }

    private void initializeFrom(@NonNull RemoteViews src, @Nullable RemoteViews hierarchyRoot) {
        if (hierarchyRoot == null) {
            this.mBitmapCache = src.mBitmapCache;
            this.mCollectionCache = new RemoteCollectionCache(src.mCollectionCache);
            this.mApplicationInfoCache = src.mApplicationInfoCache;
        } else {
            this.mBitmapCache = hierarchyRoot.mBitmapCache;
            this.mCollectionCache = hierarchyRoot.mCollectionCache;
            this.mApplicationInfoCache = hierarchyRoot.mApplicationInfoCache;
        }
        if (hierarchyRoot == null || src.mIsRoot) {
            this.mIsRoot = true;
            hierarchyRoot = this;
        } else {
            this.mIsRoot = false;
        }
        this.mApplication = src.mApplication;
        this.mLayoutId = src.mLayoutId;
        this.mLightBackgroundLayoutId = src.mLightBackgroundLayoutId;
        this.mApplyFlags = src.mApplyFlags;
        this.mClassCookies = src.mClassCookies;
        this.mIdealSize = src.mIdealSize;
        this.mProviderInstanceId = src.mProviderInstanceId;
        this.mHasDrawInstructions = src.mHasDrawInstructions;
        if (src.hasLandscapeAndPortraitLayouts()) {
            this.mLandscape = RemoteViews.createInitializedFrom(src.mLandscape, hierarchyRoot);
            this.mPortrait = RemoteViews.createInitializedFrom(src.mPortrait, hierarchyRoot);
        }
        if (src.hasSizedRemoteViews()) {
            this.mSizedRemoteViews = new ArrayList<RemoteViews>(src.mSizedRemoteViews.size());
            for (RemoteViews srcView : src.mSizedRemoteViews) {
                this.mSizedRemoteViews.add(RemoteViews.createInitializedFrom(srcView, hierarchyRoot));
            }
        }
        if (src.mActions != null) {
            Parcel p = Parcel.obtain();
            p.putClassCookies(this.mClassCookies);
            src.writeActionsToParcel(p, 0);
            p.setDataPosition(0);
            this.readActionsFromParcel(p, 0);
            p.recycle();
        }
        if (this.mIsRoot) {
            this.reconstructCaches();
        }
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null, null, 0);
    }

    @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
    public RemoteViews(@NonNull DrawInstructions drawInstructions) {
        Objects.requireNonNull(drawInstructions);
        this.mHasDrawInstructions = true;
        this.addAction(new SetDrawInstructionAction(drawInstructions));
    }

    private RemoteViews(@NonNull Parcel parcel, @Nullable HierarchyRootData rootData, @Nullable ApplicationInfo info, int depth) {
        if (depth > 10 && UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            throw new IllegalArgumentException("Too many nested views.");
        }
        ++depth;
        int mode = parcel.readInt();
        if (rootData == null) {
            this.mBitmapCache = new BitmapCache(parcel);
            this.mClassCookies = parcel.copyClassCookies();
            this.mCollectionCache = new RemoteCollectionCache(parcel);
        } else {
            this.configureAsChild(rootData);
        }
        if (mode == 0) {
            this.mApplication = parcel.readTypedObject(ApplicationInfo.CREATOR);
            this.mIdealSize = parcel.readInt() == 0 ? null : SizeF.CREATOR.createFromParcel(parcel);
            this.mLayoutId = parcel.readInt();
            this.mViewId = parcel.readInt();
            this.mLightBackgroundLayoutId = parcel.readInt();
            this.readActionsFromParcel(parcel, depth);
        } else if (mode == 2) {
            int numViews = parcel.readInt();
            if (numViews > 16) {
                throw new IllegalArgumentException("Too many views in mapping from size to RemoteViews.");
            }
            ArrayList<RemoteViews> remoteViews = new ArrayList<RemoteViews>(numViews);
            for (int i = 0; i < numViews; ++i) {
                RemoteViews view = new RemoteViews(parcel, this.getHierarchyRootData(), info, depth);
                info = view.mApplication;
                remoteViews.add(view);
            }
            this.initializeSizedRemoteViews(remoteViews.iterator());
            RemoteViews smallestView = this.findSmallestRemoteView();
            this.mApplication = smallestView.mApplication;
            this.mLayoutId = smallestView.mLayoutId;
            this.mViewId = smallestView.mViewId;
            this.mLightBackgroundLayoutId = smallestView.mLightBackgroundLayoutId;
        } else {
            this.mLandscape = new RemoteViews(parcel, this.getHierarchyRootData(), info, depth);
            this.mPortrait = new RemoteViews(parcel, this.getHierarchyRootData(), this.mLandscape.mApplication, depth);
            this.mApplication = this.mPortrait.mApplication;
            this.mLayoutId = this.mPortrait.mLayoutId;
            this.mViewId = this.mPortrait.mViewId;
            this.mLightBackgroundLayoutId = this.mPortrait.mLightBackgroundLayoutId;
        }
        this.mApplyFlags = parcel.readInt();
        this.mProviderInstanceId = parcel.readLong();
        this.mHasDrawInstructions = parcel.readBoolean();
        if (this.mIsRoot) {
            this.configureDescendantsAsChildren();
        }
    }

    private void readActionsFromParcel(Parcel parcel, int depth) {
        int count = parcel.readInt();
        if (count > 0) {
            this.mActions = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                this.mActions.add(this.getActionFromParcel(parcel, depth));
            }
        }
    }

    private Action getActionFromParcel(Parcel parcel, int depth) {
        int tag = parcel.readInt();
        switch (tag) {
            case 1: {
                return new SetOnClickResponse(parcel);
            }
            case 3: {
                return new SetDrawableTint(parcel);
            }
            case 2: {
                return new ReflectionAction(parcel);
            }
            case 4: {
                return new ViewGroupActionAdd(parcel, this.mApplication, depth);
            }
            case 7: {
                return new ViewGroupActionRemove(parcel);
            }
            case 5: {
                return new ViewContentNavigation(this, parcel);
            }
            case 6: {
                return new SetEmptyView(parcel);
            }
            case 8: {
                return new SetPendingIntentTemplate(parcel);
            }
            case 10: {
                return new SetRemoteViewsAdapterIntent(parcel);
            }
            case 11: {
                return new TextViewDrawableAction(parcel);
            }
            case 13: {
                return new TextViewSizeAction(parcel);
            }
            case 14: {
                return new ViewPaddingAction(parcel);
            }
            case 12: {
                return new BitmapReflectionAction(this, parcel);
            }
            case 18: {
                return new SetRemoteInputsAction(parcel);
            }
            case 19: {
                return new LayoutParamAction(parcel);
            }
            case 21: {
                return new SetRippleDrawableColor(parcel);
            }
            case 22: {
                return new SetIntTagAction(parcel);
            }
            case 23: {
                return new RemoveFromParentAction(parcel);
            }
            case 24: {
                return new ResourceReflectionAction(parcel);
            }
            case 25: {
                return new ComplexUnitDimensionReflectionAction(parcel);
            }
            case 26: {
                return new SetCompoundButtonCheckedAction(parcel);
            }
            case 27: {
                return new SetRadioGroupCheckedAction(parcel);
            }
            case 28: {
                return new SetViewOutlinePreferredRadiusAction(parcel);
            }
            case 29: {
                return new SetOnCheckedChangeResponse(parcel);
            }
            case 30: {
                return new NightModeReflectionAction(parcel);
            }
            case 31: {
                return new SetRemoteCollectionItemListAdapterAction(parcel);
            }
            case 32: {
                return new AttributeReflectionAction(parcel);
            }
            case 34: {
                return new SetOnStylusHandwritingResponse(parcel);
            }
            case 35: {
                return new SetDrawInstructionAction(parcel);
            }
        }
        throw new ActionException("Tag " + tag + " not found");
    }

    @Deprecated
    public RemoteViews clone() {
        Preconditions.checkState(this.mIsRoot, "RemoteView has been attached to another RemoteView. May only clone the root of a RemoteView hierarchy.");
        return new RemoteViews(this);
    }

    public String getPackage() {
        return this.mApplication != null ? this.mApplication.packageName : null;
    }

    public int getLayoutId() {
        return this.hasFlags(4) && this.mLightBackgroundLayoutId != 0 ? this.mLightBackgroundLayoutId : this.mLayoutId;
    }

    private void configureAsChild(@NonNull HierarchyRootData rootData) {
        this.mIsRoot = false;
        this.mBitmapCache = rootData.mBitmapCache;
        this.mCollectionCache = rootData.mRemoteCollectionCache;
        this.mApplicationInfoCache = rootData.mApplicationInfoCache;
        this.mClassCookies = rootData.mClassCookies;
        this.configureDescendantsAsChildren();
    }

    private void configureDescendantsAsChildren() {
        block3: {
            HierarchyRootData rootData;
            block4: {
                block2: {
                    this.mApplication = this.mApplicationInfoCache.getOrPut(this.mApplication);
                    rootData = this.getHierarchyRootData();
                    if (!this.hasSizedRemoteViews()) break block2;
                    for (RemoteViews remoteView : this.mSizedRemoteViews) {
                        remoteView.configureAsChild(rootData);
                    }
                    break block3;
                }
                if (!this.hasLandscapeAndPortraitLayouts()) break block4;
                this.mLandscape.configureAsChild(rootData);
                this.mPortrait.configureAsChild(rootData);
                break block3;
            }
            if (this.mActions == null) break block3;
            for (Action action : this.mActions) {
                action.setHierarchyRootData(rootData);
            }
        }
    }

    private void reconstructCaches() {
        if (!this.mIsRoot) {
            return;
        }
        this.mBitmapCache = new BitmapCache();
        this.mApplicationInfoCache = new ApplicationInfoCache();
        this.mApplication = this.mApplicationInfoCache.getOrPut(this.mApplication);
        this.configureDescendantsAsChildren();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public long estimateMemoryUsage() {
        return this.mBitmapCache.getBitmapMemory();
    }

    public long estimateIconMemoryUsage() {
        AtomicLong total = new AtomicLong(0L);
        this.visitIcons(icon -> {
            if (icon.getType() == 1 || icon.getType() == 5) {
                total.addAndGet(icon.getBitmap().getAllocationByteCount());
            }
        });
        return total.get();
    }

    public long estimateTotalBitmapMemoryUsage() {
        return this.estimateMemoryUsage() + this.estimateIconMemoryUsage();
    }

    private void addAction(Action a) {
        if (this.hasMultipleLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate layouts for orientation or size cannot be modified. Instead, fully configure each layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
    }

    public void addView(int viewId, RemoteViews nestedView) {
        this.addAction(nestedView == null ? new ViewGroupActionRemove(viewId) : new ViewGroupActionAdd(viewId, nestedView));
    }

    public void addStableView(int viewId, @NonNull RemoteViews nestedView, int stableId) {
        this.addAction(new ViewGroupActionAdd(viewId, nestedView, -1, stableId));
    }

    @UnsupportedAppUsage
    public void addView(int viewId, RemoteViews nestedView, int index) {
        this.addAction(new ViewGroupActionAdd(viewId, nestedView, index));
    }

    public void removeAllViews(int viewId) {
        this.addAction(new ViewGroupActionRemove(viewId));
    }

    public void removeAllViewsExceptId(int viewId, int viewIdToKeep) {
        this.addAction(new ViewGroupActionRemove(viewId, viewIdToKeep));
    }

    public void removeFromParent(int viewId) {
        this.addAction(new RemoveFromParentAction(viewId));
    }

    @Deprecated
    public void showNext(int viewId) {
        this.addAction(new ViewContentNavigation(this, viewId, true));
    }

    @Deprecated
    public void showPrevious(int viewId) {
        this.addAction(new ViewContentNavigation(this, viewId, false));
    }

    public void setDisplayedChild(int viewId, int childIndex) {
        this.setInt(viewId, "setDisplayedChild", childIndex);
    }

    public void setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    public void setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    public void setTextViewTextSize(int viewId, int units, float size) {
        this.addAction(new TextViewSizeAction(viewId, units, size));
    }

    public void setTextViewCompoundDrawables(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, int start, int top, int end, int bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setTextViewCompoundDrawables(int viewId, Icon left, Icon top, Icon right, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, false, left, top, right, bottom));
    }

    public void setTextViewCompoundDrawablesRelative(int viewId, Icon start, Icon top, Icon end, Icon bottom) {
        this.addAction(new TextViewDrawableAction(viewId, true, start, top, end, bottom));
    }

    public void setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    public void setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    public void setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    public void setImageViewIcon(int viewId, Icon icon) {
        this.setIcon(viewId, "setImageIcon", icon);
    }

    public void setEmptyView(int viewId, int emptyViewId) {
        this.addAction(new SetEmptyView(viewId, emptyViewId));
    }

    public void setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    public void setChronometerCountDown(int viewId, boolean isCountDown) {
        this.setBoolean(viewId, "setCountDown", isCountDown);
    }

    public void setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    public void setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.setOnClickResponse(viewId, RemoteResponse.fromPendingIntent(pendingIntent));
    }

    public void setOnClickResponse(int viewId, @NonNull RemoteResponse response) {
        this.addAction(new SetOnClickResponse(viewId, response));
    }

    public void setPendingIntentTemplate(int viewId, PendingIntent pendingIntentTemplate) {
        if (this.hasDrawInstructions()) {
            this.getPendingIntentTemplate().set(viewId, pendingIntentTemplate);
            this.tryAddRemoteResponse(viewId);
        } else {
            this.addAction(new SetPendingIntentTemplate(viewId, pendingIntentTemplate));
        }
    }

    public void setOnClickFillInIntent(int viewId, Intent fillInIntent) {
        if (this.hasDrawInstructions()) {
            this.getFillInIntent().set(viewId, fillInIntent);
            this.tryAddRemoteResponse(viewId);
        } else {
            this.setOnClickResponse(viewId, RemoteResponse.fromFillInIntent(fillInIntent));
        }
    }

    public void setOnCheckedChangeResponse(int viewId, @NonNull RemoteResponse response) {
        this.addAction(new SetOnCheckedChangeResponse(viewId, response.setInteractionType(1)));
    }

    @FlaggedApi(value="android.view.inputmethod.home_screen_handwriting_delegator")
    public void setOnStylusHandwritingPendingIntent(int viewId, @Nullable PendingIntent pendingIntent) {
        this.addAction(new SetOnStylusHandwritingResponse(viewId, pendingIntent));
    }

    public void setDrawableTint(int viewId, boolean targetBackground, int colorFilter, @NonNull PorterDuff.Mode mode) {
        this.addAction(new SetDrawableTint(viewId, targetBackground, colorFilter, mode));
    }

    public void setRippleDrawableColor(int viewId, ColorStateList colorStateList) {
        this.addAction(new SetRippleDrawableColor(viewId, colorStateList));
    }

    public void setProgressTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressTintList", 15, tint));
    }

    public void setProgressBackgroundTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setProgressBackgroundTintList", 15, tint));
    }

    public void setProgressIndeterminateTintList(int viewId, ColorStateList tint) {
        this.addAction(new ReflectionAction(viewId, "setIndeterminateTintList", 15, tint));
    }

    public void setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    public void setTextColor(int viewId, ColorStateList colors) {
        this.addAction(new ReflectionAction(viewId, "setTextColor", 15, colors));
    }

    @Deprecated
    public void setRemoteAdapter(int appWidgetId, int viewId, Intent intent) {
        this.setRemoteAdapter(viewId, intent);
    }

    @Deprecated
    public void setRemoteAdapter(int viewId, Intent intent) {
        if (Flags.remoteAdapterConversion()) {
            this.addAction(new SetRemoteCollectionItemListAdapterAction(viewId, intent));
        } else {
            this.addAction(new SetRemoteViewsAdapterIntent(viewId, intent));
        }
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setRemoteAdapter(int viewId, ArrayList<RemoteViews> list, int viewTypeCount) {
        RemoteCollectionItems.Builder b = new RemoteCollectionItems.Builder();
        for (int i = 0; i < list.size(); ++i) {
            b.addItem(i, list.get(i));
        }
        this.setRemoteAdapter(viewId, b.setViewTypeCount(viewTypeCount).build());
    }

    public void setRemoteAdapter(int viewId, @NonNull RemoteCollectionItems items) {
        this.addAction(new SetRemoteCollectionItemListAdapterAction(viewId, items));
    }

    public void setScrollPosition(int viewId, int position) {
        this.setInt(viewId, "smoothScrollToPosition", position);
    }

    public void setRelativeScrollPosition(int viewId, int offset) {
        this.setInt(viewId, "smoothScrollByOffset", offset);
    }

    public void setViewPadding(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new ViewPaddingAction(viewId, left, top, right, bottom));
    }

    public void setViewLayoutMarginDimen(int viewId, int type, int dimen2) {
        this.addAction(new LayoutParamAction(viewId, type, dimen2, 3));
    }

    public void setViewLayoutMarginAttr(int viewId, int type, int attr2) {
        this.addAction(new LayoutParamAction(viewId, type, attr2, 4));
    }

    public void setViewLayoutMargin(int viewId, int type, float value, int units) {
        this.addAction(new LayoutParamAction(viewId, type, value, units));
    }

    public void setViewLayoutWidth(int viewId, float width, int units) {
        this.addAction(new LayoutParamAction(viewId, 8, width, units));
    }

    public void setViewLayoutWidthDimen(int viewId, int widthDimen) {
        this.addAction(new LayoutParamAction(viewId, 8, widthDimen, 3));
    }

    public void setViewLayoutWidthAttr(int viewId, int widthAttr) {
        this.addAction(new LayoutParamAction(viewId, 8, widthAttr, 4));
    }

    public void setViewLayoutHeight(int viewId, float height, int units) {
        this.addAction(new LayoutParamAction(viewId, 9, height, units));
    }

    public void setViewLayoutHeightDimen(int viewId, int heightDimen) {
        this.addAction(new LayoutParamAction(viewId, 9, heightDimen, 3));
    }

    public void setViewLayoutHeightAttr(int viewId, int heightAttr) {
        this.addAction(new LayoutParamAction(viewId, 9, heightAttr, 4));
    }

    public void setViewOutlinePreferredRadius(int viewId, float radius, int units) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, radius, units));
    }

    public void setViewOutlinePreferredRadiusDimen(int viewId, int resId) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, resId, 3));
    }

    public void setViewOutlinePreferredRadiusAttr(int viewId, int attrId) {
        this.addAction(new SetViewOutlinePreferredRadiusAction(viewId, attrId, 4));
    }

    public void setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(viewId, methodName, 1, value));
    }

    public void setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(viewId, methodName, 2, value));
    }

    public void setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(viewId, methodName, 3, value));
    }

    public void setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(viewId, methodName, 4, value));
    }

    public void setIntDimen(int viewId, @NonNull String methodName, int dimenResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 4, 1, dimenResource));
    }

    public void setIntDimen(int viewId, @NonNull String methodName, float value, int unit) {
        this.addAction(new ComplexUnitDimensionReflectionAction(viewId, methodName, 4, value, unit));
    }

    public void setIntDimenAttr(int viewId, @NonNull String methodName, int dimenAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 4, 1, dimenAttr));
    }

    public void setColor(int viewId, @NonNull String methodName, int colorResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 4, 2, colorResource));
    }

    public void setColorAttr(int viewId, @NonNull String methodName, int colorAttribute) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 4, 2, colorAttribute));
    }

    public void setColorInt(int viewId, @NonNull String methodName, int notNight, int night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 4, notNight, night));
    }

    public void setColorStateList(int viewId, @NonNull String methodName, @Nullable ColorStateList value) {
        this.addAction(new ReflectionAction(viewId, methodName, 15, value));
    }

    public void setColorStateList(int viewId, @NonNull String methodName, @Nullable ColorStateList notNight, @Nullable ColorStateList night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 15, notNight, night));
    }

    public void setColorStateList(int viewId, @NonNull String methodName, int colorResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 15, 2, colorResource));
    }

    public void setColorStateListAttr(int viewId, @NonNull String methodName, int colorAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 15, 2, colorAttr));
    }

    public void setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(viewId, methodName, 5, value));
    }

    public void setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(viewId, methodName, 6, Float.valueOf(value)));
    }

    public void setFloatDimen(int viewId, @NonNull String methodName, int dimenResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 6, 1, dimenResource));
    }

    public void setFloatDimen(int viewId, @NonNull String methodName, float value, int unit) {
        this.addAction(new ComplexUnitDimensionReflectionAction(viewId, methodName, 6, value, unit));
    }

    public void setFloatDimenAttr(int viewId, @NonNull String methodName, int dimenAttr) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 6, 1, dimenAttr));
    }

    public void setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(viewId, methodName, 7, value));
    }

    public void setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(viewId, methodName, 8, Character.valueOf(value)));
    }

    public void setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(viewId, methodName, 9, value));
    }

    public void setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(viewId, methodName, 10, value));
    }

    public void setCharSequence(int viewId, @NonNull String methodName, int stringResource) {
        this.addAction(new ResourceReflectionAction(viewId, methodName, 10, 3, stringResource));
    }

    public void setCharSequenceAttr(int viewId, @NonNull String methodName, int stringAttribute) {
        this.addAction(new AttributeReflectionAction(viewId, methodName, 10, 3, stringAttribute));
    }

    public void setUri(int viewId, String methodName, Uri value) {
        if (value != null) {
            value = value.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                value.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(viewId, methodName, 11, value));
    }

    public void setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new BitmapReflectionAction(this, viewId, methodName, value));
    }

    public void setBlendMode(int viewId, @NonNull String methodName, @Nullable BlendMode value) {
        this.addAction(new ReflectionAction(viewId, methodName, 17, (Object)value));
    }

    public void setBundle(int viewId, String methodName, Bundle value) {
        this.addAction(new ReflectionAction(viewId, methodName, 13, value));
    }

    public void setIntent(int viewId, String methodName, Intent value) {
        this.addAction(new ReflectionAction(viewId, methodName, 14, value));
    }

    public void setIcon(int viewId, String methodName, Icon value) {
        this.addAction(new ReflectionAction(viewId, methodName, 16, value));
    }

    public void setIcon(int viewId, @NonNull String methodName, @Nullable Icon notNight, @Nullable Icon night) {
        this.addAction(new NightModeReflectionAction(viewId, methodName, 16, notNight, night));
    }

    public void setContentDescription(int viewId, CharSequence contentDescription) {
        this.setCharSequence(viewId, "setContentDescription", contentDescription);
    }

    public void setAccessibilityTraversalBefore(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalBefore", nextId);
    }

    public void setAccessibilityTraversalAfter(int viewId, int nextId) {
        this.setInt(viewId, "setAccessibilityTraversalAfter", nextId);
    }

    public void setLabelFor(int viewId, int labeledId) {
        this.setInt(viewId, "setLabelFor", labeledId);
    }

    public void setCompoundButtonChecked(int viewId, boolean checked) {
        this.addAction(new SetCompoundButtonCheckedAction(viewId, checked));
    }

    public void setRadioGroupChecked(int viewId, int checkedId) {
        this.addAction(new SetRadioGroupCheckedAction(viewId, checkedId));
    }

    public void setLightBackgroundLayoutId(int layoutId) {
        this.mLightBackgroundLayoutId = layoutId;
    }

    public RemoteViews getDarkTextViews() {
        if (this.hasFlags(4)) {
            return this;
        }
        try {
            this.addFlags(4);
            RemoteViews remoteViews = new RemoteViews(this);
            return remoteViews;
        }
        finally {
            this.mApplyFlags &= 0xFFFFFFFB;
        }
    }

    private boolean hasDrawInstructions() {
        return this.mHasDrawInstructions;
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                return this.mLandscape;
            }
            return this.mPortrait;
        }
        if (this.hasSizedRemoteViews()) {
            return this.findSmallestRemoteView();
        }
        return this;
    }

    private static float squareDistance(SizeF p1, SizeF p2) {
        float dx = p1.getWidth() - p2.getWidth();
        float dy = p1.getHeight() - p2.getHeight();
        return dx * dx + dy * dy;
    }

    private static boolean fitsIn(SizeF sizeLayout, @Nullable SizeF sizeWidget) {
        return sizeWidget != null && Math.ceil(sizeWidget.getWidth()) + 1.0 > (double)sizeLayout.getWidth() && Math.ceil(sizeWidget.getHeight()) + 1.0 > (double)sizeLayout.getHeight();
    }

    private RemoteViews findBestFitLayout(@NonNull SizeF widgetSize) {
        RemoteViews bestFit = null;
        float bestSqDist = Float.MAX_VALUE;
        for (RemoteViews layout2 : this.mSizedRemoteViews) {
            SizeF layoutSize = layout2.getIdealSize();
            if (layoutSize == null) {
                throw new IllegalStateException("Expected RemoteViews to have ideal size");
            }
            if (!RemoteViews.fitsIn(layoutSize, widgetSize)) continue;
            if (bestFit == null) {
                bestFit = layout2;
                bestSqDist = RemoteViews.squareDistance(layoutSize, widgetSize);
                continue;
            }
            float newSqDist = RemoteViews.squareDistance(layoutSize, widgetSize);
            if (!(newSqDist < bestSqDist)) continue;
            bestFit = layout2;
            bestSqDist = newSqDist;
        }
        if (bestFit == null) {
            Log.w(LOG_TAG, "Could not find a RemoteViews fitting the current size: " + widgetSize);
            return this.findSmallestRemoteView();
        }
        return bestFit;
    }

    public RemoteViews getRemoteViewsToApply(@NonNull Context context, @Nullable SizeF widgetSize) {
        if (!this.hasSizedRemoteViews() || widgetSize == null) {
            return this.getRemoteViewsToApply(context);
        }
        return this.findBestFitLayout(widgetSize);
    }

    @Nullable
    public RemoteViews getRemoteViewsToApplyIfDifferent(@Nullable SizeF oldSize, @NonNull SizeF newSize) {
        RemoteViews newBestFit;
        if (!this.hasSizedRemoteViews()) {
            return null;
        }
        RemoteViews oldBestFit = oldSize == null ? this.findSmallestRemoteView() : this.findBestFitLayout(oldSize);
        if (oldBestFit != (newBestFit = this.findBestFitLayout(newSize))) {
            return newBestFit;
        }
        return null;
    }

    public View apply(Context context, ViewGroup parent) {
        return this.apply(context, parent, null);
    }

    public View apply(Context context, ViewGroup parent, InteractionHandler handler) {
        return this.apply(context, parent, handler, null);
    }

    public View apply(@NonNull Context context, @NonNull ViewGroup parent, @Nullable InteractionHandler handler, @Nullable SizeF size) {
        return this.apply(context, parent, size, new ActionApplyParams().withInteractionHandler(handler));
    }

    public View applyWithTheme(@NonNull Context context, @NonNull ViewGroup parent, @Nullable InteractionHandler handler, int applyThemeResId) {
        return this.apply(context, parent, null, new ActionApplyParams().withInteractionHandler(handler).withThemeResId(applyThemeResId));
    }

    public View apply(Context context, ViewGroup parent, InteractionHandler handler, @Nullable SizeF size, @Nullable ColorResources colorResources) {
        return this.apply(context, parent, size, new ActionApplyParams().withInteractionHandler(handler).withColorResources(colorResources));
    }

    public View apply(Context context, ViewGroup parent, @Nullable SizeF size, ActionApplyParams params) {
        return this.apply(context, parent, parent, size, params);
    }

    private View apply(Context context, ViewGroup directParent, ViewGroup rootParent, @Nullable SizeF size, ActionApplyParams params) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        View result = this.inflateView(context, rvToApply, directParent, params.applyThemeResId, params.colorResources);
        rvToApply.performApply(result, rootParent, params);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View inflateView(Context context, RemoteViews rv, @Nullable ViewGroup parent, int applyThemeResId, @Nullable ColorResources colorResources) {
        try {
            Trace.beginSection(rv.hasDrawInstructions() ? "RemoteViews#inflateViewWithDrawInstructions" : "RemoteViews#inflateView");
            View view = this.inflateViewInternal(context, rv, parent, applyThemeResId, colorResources);
            return view;
        }
        finally {
            Trace.endSection();
        }
    }

    private View inflateViewInternal(Context context, RemoteViews rv, @Nullable ViewGroup parent, int applyThemeResId, @Nullable ColorResources colorResources) {
        View v;
        Context contextForResources = this.getContextForResourcesEnsuringCorrectCachedApkPaths(context);
        if (colorResources != null) {
            colorResources.apply(contextForResources);
        }
        ContextWrapper inflationContext = new RemoteViewsContextWrapper(context, contextForResources);
        if (applyThemeResId != 0) {
            inflationContext = new ContextThemeWrapper((Context)inflationContext, applyThemeResId);
        }
        if (rv.hasDrawInstructions()) {
            RemoteComposePlayer player = new RemoteComposePlayer(inflationContext);
            player.setDebug(_Original_Build.IS_USERDEBUG || _Original_Build.IS_ENG ? 1 : 0);
            v = player;
        } else {
            LayoutInflater inflater = LayoutInflater.from(context);
            inflater = inflater.cloneInContext(inflationContext);
            inflater.setFilter(this.shouldUseStaticFilter() ? INFLATER_FILTER : this);
            if (this.mLayoutInflaterFactory2 != null) {
                inflater.setFactory2(this.mLayoutInflaterFactory2);
            }
            v = inflater.inflate(rv.getLayoutId(), parent, false);
        }
        if (this.mViewId != -1) {
            v.setId(this.mViewId);
            v.setTagInternal(16909493, this.mViewId);
        }
        v.setTagInternal(16908312, rv.getLayoutId());
        return v;
    }

    protected boolean shouldUseStaticFilter() {
        return this.getClass().equals(RemoteViews.class);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener) {
        return this.applyAsync(context, parent, executor, listener, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler) {
        return this.applyAsync(context, parent, executor, listener, handler, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size) {
        return this.applyAsync(context, parent, executor, listener, handler, size, null);
    }

    public CancellationSignal applyAsync(Context context, ViewGroup parent, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        ActionApplyParams params = new ActionApplyParams().withInteractionHandler(handler).withColorResources(colorResources).withExecutor(executor);
        return new AsyncApplyTask(this.getRemoteViewsToApply(context, size), parent, context, listener, params, null, true).startTaskOnExecutor(executor);
    }

    private AsyncApplyTask getInternalAsyncApplyTask(Context context, ViewGroup parent, OnViewAppliedListener listener, ActionApplyParams params, SizeF size, View result) {
        return new AsyncApplyTask(this.getRemoteViewsToApply(context, size), parent, context, listener, params, result, false);
    }

    public void reapply(Context context, View v) {
        this.reapply(context, v, null, new ActionApplyParams());
    }

    public void reapply(Context context, View v, InteractionHandler handler) {
        this.reapply(context, v, null, new ActionApplyParams().withInteractionHandler(handler));
    }

    public void reapply(Context context, View v, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        this.reapply(context, v, size, new ActionApplyParams().withInteractionHandler(handler).withColorResources(colorResources));
    }

    public void reapply(Context context, View v, @Nullable SizeF size, ActionApplyParams params) {
        this.reapply(context, v, (ViewGroup)v.getParent(), size, params, true);
    }

    private void reapplyNestedViews(Context context, View v, ViewGroup rootParent, ActionApplyParams params) {
        this.reapply(context, v, rootParent, null, params, false);
    }

    private void reapply(Context context, View v, ViewGroup rootParent, @Nullable SizeF size, ActionApplyParams params, boolean topLevel) {
        RemoteViews rvToApply = this.getRemoteViewsToReapply(context, v, size);
        rvToApply.performApply(v, rootParent, params);
        if (topLevel && v instanceof ViewGroup) {
            this.finalizeViewRecycling((ViewGroup)v);
        }
    }

    public boolean canRecycleView(@Nullable View v) {
        if (v == null || this.hasDrawInstructions()) {
            return false;
        }
        Integer previousLayoutId = (Integer)v.getTag(16908312);
        if (previousLayoutId == null) {
            return false;
        }
        Integer overrideIdTag = (Integer)v.getTag(16909493);
        int overrideId = overrideIdTag == null ? -1 : overrideIdTag;
        return previousLayoutId.intValue() == this.getLayoutId() && this.mViewId == overrideId;
    }

    private RemoteViews getRemoteViewsToReapply(Context context, View v, @Nullable SizeF size) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context, size);
        if ((this.hasMultipleLayouts() || rvToApply.mViewId != -1 || v.getTag(16909493) != null) && !rvToApply.canRecycleView(v)) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        return rvToApply;
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener) {
        return this.reapplyAsync(context, v, executor, listener, null);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, InteractionHandler handler) {
        return this.reapplyAsync(context, v, executor, listener, handler, null, null);
    }

    public CancellationSignal reapplyAsync(Context context, View v, Executor executor, OnViewAppliedListener listener, InteractionHandler handler, SizeF size, ColorResources colorResources) {
        RemoteViews rvToApply = this.getRemoteViewsToReapply(context, v, size);
        ActionApplyParams params = new ActionApplyParams().withColorResources(colorResources).withInteractionHandler(handler).withExecutor(executor);
        return new AsyncApplyTask(rvToApply, (ViewGroup)v.getParent(), context, listener, params, v, true).startTaskOnExecutor(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performApply(View v, ViewGroup parent, ActionApplyParams params) {
        params = params.clone();
        if (params.handler == null) {
            params.handler = DEFAULT_INTERACTION_HANDLER;
        }
        if (v instanceof RemoteComposePlayer) {
            RemoteComposePlayer player = (RemoteComposePlayer)v;
            player.setTheme(v.getResources().getConfiguration().isNightModeActive() ? -2 : -3);
        }
        if (this.mActions != null) {
            int count = this.mActions.size();
            try {
                Trace.beginSection(this.hasDrawInstructions() ? "RemoteViews#applyActionsWithDrawInstructions" : "RemoteViews#applyActions");
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).apply(v, parent, params);
                }
            }
            finally {
                Trace.endSection();
            }
        }
    }

    public boolean prefersAsyncApply() {
        if (this.mActions != null) {
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                if (!this.mActions.get(i).prefersAsyncApply()) continue;
                return true;
            }
        }
        return false;
    }

    public void updateAppInfo(@NonNull ApplicationInfo info) {
        ApplicationInfo existing = this.mApplicationInfoCache.get(info);
        if (existing != null && !existing.sourceDir.equals(info.sourceDir)) {
            return;
        }
        this.mApplicationInfoCache.put(info);
        this.configureDescendantsAsChildren();
    }

    private Context getContextForResourcesEnsuringCorrectCachedApkPaths(Context context) {
        if (this.mApplication != null) {
            if (context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
                return context;
            }
            try {
                ApplicationInfo sanitizedApplication = this.mApplication;
                try {
                    sanitizedApplication = context.getPackageManager().getApplicationInfoAsUser(this.mApplication.packageName, 0, UserHandle.getUserId(this.mApplication.uid));
                }
                catch (SecurityException se) {
                    Log.d(LOG_TAG, "Unable to fetch appInfo for " + this.mApplication.packageName);
                }
                Context applicationContext = context.createApplicationContext(sanitizedApplication, 4);
                return applicationContext.createConfigurationContext(context.getResources().getConfiguration());
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Package name " + this.mApplication.packageName + " not found");
            }
        }
        return context;
    }

    @NonNull
    private SparseArray<PendingIntent> getPendingIntentTemplate() {
        if (this.mPendingIntentTemplate == null) {
            this.mPendingIntentTemplate = new SparseArray();
        }
        return this.mPendingIntentTemplate;
    }

    @NonNull
    private SparseArray<Intent> getFillInIntent() {
        if (this.mFillInIntent == null) {
            this.mFillInIntent = new SparseArray();
        }
        return this.mFillInIntent;
    }

    private void tryAddRemoteResponse(int viewId) {
        PendingIntent pendingIntent = this.getPendingIntentTemplate().get(viewId);
        Intent intent = this.getFillInIntent().get(viewId);
        if (pendingIntent != null && intent != null) {
            this.addAction(new SetOnClickResponse(viewId, RemoteResponse.fromPendingIntentTemplateAndFillInIntent(pendingIntent, intent)));
        }
    }

    public int getSequenceNumber() {
        return this.mActions == null ? 0 : this.mActions.size();
    }

    @Override
    @Deprecated
    public boolean onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcel(dest, flags, null);
    }

    private void writeToParcel(Parcel dest, int flags, @Nullable SparseArray<Intent> intentsToIgnore) {
        boolean prevSquashingAllowed = dest.allowSquashing();
        if (!this.hasMultipleLayouts()) {
            dest.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
                this.mCollectionCache.writeToParcel(dest, flags, intentsToIgnore);
            }
            dest.writeTypedObject(this.mApplication, flags);
            if (this.mIsRoot || this.mIdealSize == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                this.mIdealSize.writeToParcel(dest, flags);
            }
            dest.writeInt(this.mLayoutId);
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mLightBackgroundLayoutId);
            this.writeActionsToParcel(dest, flags);
        } else if (this.hasSizedRemoteViews()) {
            dest.writeInt(2);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
                this.mCollectionCache.writeToParcel(dest, flags, intentsToIgnore);
            }
            dest.writeInt(this.mSizedRemoteViews.size());
            for (RemoteViews view : this.mSizedRemoteViews) {
                view.writeToParcel(dest, flags);
            }
        } else {
            dest.writeInt(1);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
                this.mCollectionCache.writeToParcel(dest, flags, intentsToIgnore);
            }
            this.mLandscape.writeToParcel(dest, flags);
            this.mPortrait.writeToParcel(dest, flags);
        }
        dest.writeInt(this.mApplyFlags);
        dest.writeLong(this.mProviderInstanceId);
        dest.writeBoolean(this.mHasDrawInstructions);
        dest.restoreAllowSquashing(prevSquashingAllowed);
    }

    private void writeActionsToParcel(Parcel parcel, int flags) {
        int count = this.mActions != null ? this.mActions.size() : 0;
        parcel.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            parcel.writeInt(a.getActionTag());
            a.writeToParcel(parcel, flags);
        }
    }

    @Nullable
    static ApplicationInfo getApplicationInfo_Original(@Nullable String packageName, int userId) {
        if (packageName == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) != userId || !applicationInfo.packageName.equals(packageName)) {
            try {
                Context context = application.getBaseContext().createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                applicationInfo = context.getApplicationInfo();
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                throw new IllegalArgumentException("No such package " + packageName);
            }
        }
        return applicationInfo;
    }

    @LayoutlibDelegate
    private static ApplicationInfo getApplicationInfo(String string2, int n) {
        return RemoteViews_Delegate.getApplicationInfo(string2, n);
    }

    public boolean hasSameAppInfo(ApplicationInfo info) {
        return this.mApplication == null || this.mApplication.packageName.equals(info.packageName) && this.mApplication.uid == info.uid;
    }

    public static boolean startPendingIntent(View view, PendingIntent pendingIntent, Pair<Intent, ActivityOptions> options) {
        try {
            Context context = view.getContext();
            context.startIntentSender(pendingIntent.getIntentSender(), (Intent)options.first, 0, 0, 0, ((ActivityOptions)options.second).toBundle());
        }
        catch (IntentSender.SendIntentException e) {
            Log.e(LOG_TAG, "Cannot send pending intent: ", e);
            return false;
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Cannot send pending intent due to unknown exception: ", e);
            return false;
        }
        return true;
    }

    private int getBitmapMemoryUsedByActions() {
        Set<Integer> bitmapIdSet = this.getBitmapIdsUsedByActions(new HashSet<Integer>());
        int result = 0;
        for (int bitmapId : bitmapIdSet) {
            Bitmap currentBitmap = this.mBitmapCache.getBitmapForId(bitmapId);
            if (currentBitmap == null) continue;
            result += currentBitmap.getAllocationByteCount();
        }
        return result;
    }

    private Set<Integer> getBitmapIdsUsedByActions(@NonNull Set<Integer> intSet) {
        block5: {
            block6: {
                block4: {
                    if (!this.hasSizedRemoteViews()) break block4;
                    for (RemoteViews views : this.mSizedRemoteViews) {
                        views.getBitmapIdsUsedByActions(intSet);
                    }
                    break block5;
                }
                if (!this.hasLandscapeAndPortraitLayouts()) break block6;
                this.mLandscape.getBitmapIdsUsedByActions(intSet);
                this.mPortrait.getBitmapIdsUsedByActions(intSet);
                break block5;
            }
            if (this.mActions == null) break block5;
            for (Action action : this.mActions) {
                if (action instanceof ViewGroupActionAdd) {
                    ViewGroupActionAdd vgaa = (ViewGroupActionAdd)action;
                    if (vgaa.mNestedViews != null) {
                        vgaa.mNestedViews.getBitmapIdsUsedByActions(intSet);
                        continue;
                    }
                }
                if (!(action instanceof BitmapReflectionAction)) continue;
                BitmapReflectionAction bitmapAction = (BitmapReflectionAction)action;
                intSet.add(bitmapAction.mBitmapId);
            }
        }
        return intSet;
    }

    public int getViewId() {
        return this.mViewId;
    }

    public void setProviderInstanceId(long id2) {
        this.mProviderInstanceId = id2;
    }

    public long getProviderInstanceId() {
        return this.mProviderInstanceId;
    }

    private int getChildId(@NonNull RemoteViews child) {
        if (child == this) {
            return 0;
        }
        if (this.hasSizedRemoteViews()) {
            for (int i = 0; i < this.mSizedRemoteViews.size(); ++i) {
                if (this.mSizedRemoteViews.get(i) != child) continue;
                return i + 1;
            }
        }
        if (this.hasLandscapeAndPortraitLayouts()) {
            if (this.mLandscape == child) {
                return 1;
            }
            if (this.mPortrait == child) {
                return 2;
            }
        }
        return 0;
    }

    public long computeUniqueId(@Nullable RemoteViews parent) {
        if (this.mIsRoot) {
            long viewId = this.getProviderInstanceId();
            if (viewId != -1L) {
                viewId <<= 8;
            }
            return viewId;
        }
        if (parent == null) {
            return -1L;
        }
        long viewId = parent.getProviderInstanceId();
        if (viewId == -1L) {
            return -1L;
        }
        int childId = parent.getChildId(this);
        if (childId == -1) {
            return -1L;
        }
        viewId <<= 8;
        return viewId |= (long)childId;
    }

    @Nullable
    private static Pair<String, Integer> getPackageUserKey(@Nullable ApplicationInfo info) {
        if (info == null || info.packageName == null) {
            return null;
        }
        return Pair.create(info.packageName, info.uid);
    }

    private HierarchyRootData getHierarchyRootData() {
        return new HierarchyRootData(this.mBitmapCache, this.mCollectionCache, this.mApplicationInfoCache, this.mClassCookies);
    }

    @FlaggedApi(value="android.appwidget.flags.remote_views_proto")
    public void writePreviewToProto(@NonNull Context context, @NonNull ProtoOutputStream out) {
        if (this.mApplication != null) {
            out.write(1138166333442L, this.mApplication.packageName);
            out.write(0x10500000011L, this.mApplication.uid);
        }
        Resources appResources = this.getContextForResourcesEnsuringCorrectCachedApkPaths(context).getResources();
        if (this.mLayoutId != 0) {
            out.write(1138166333443L, appResources.getResourceName(this.mLayoutId));
        }
        if (this.mLightBackgroundLayoutId != 0) {
            out.write(1138166333444L, appResources.getResourceName(this.mLightBackgroundLayoutId));
        }
        if (this.mViewId != 0 && this.mViewId != -1) {
            out.write(1138166333445L, appResources.getResourceName(this.mViewId));
        }
        if (this.mIsRoot) {
            this.mBitmapCache.writeBitmapsToProto(out);
            this.mCollectionCache.writeToProto(context, out);
        }
        out.write(1133871366156L, this.mIsRoot);
        out.write(1120986464263L, this.mApplyFlags);
        out.write(1133871366157L, this.mHasDrawInstructions);
        if (this.mProviderInstanceId != -1L) {
            out.write(1112396529672L, this.mProviderInstanceId);
        }
        if (!this.hasMultipleLayouts()) {
            out.write(0x10500000001L, 0);
            if (this.mIdealSize != null) {
                long token = out.start(1146756268038L);
                out.write(0x10200000001L, this.mIdealSize.getWidth());
                out.write(0x10200000002L, this.mIdealSize.getHeight());
                out.end(token);
            }
            if (this.mActions != null) {
                for (Action action : this.mActions) {
                    if (!action.canWriteToProto()) continue;
                    long token = out.start(2246267895824L);
                    action.writeToProto(out, context, appResources);
                    out.end(token);
                }
            }
        } else if (this.hasSizedRemoteViews()) {
            out.write(0x10500000001L, 2);
            for (RemoteViews view : this.mSizedRemoteViews) {
                long sizedViewToken = out.start(2246267895817L);
                view.writePreviewToProto(context, out);
                out.end(sizedViewToken);
            }
        } else {
            out.write(0x10500000001L, 1);
            long landscapeViewToken = out.start(0x10B0000000BL);
            this.mLandscape.writePreviewToProto(context, out);
            out.end(landscapeViewToken);
            long portraitViewToken = out.start(1146756268042L);
            this.mPortrait.writePreviewToProto(context, out);
            out.end(portraitViewToken);
        }
    }

    @FlaggedApi(value="android.appwidget.flags.remote_views_proto")
    public static RemoteViews createPreviewFromProto(Context context, ProtoInputStream in) throws Exception {
        return RemoteViews.createFromProto(in).create(context, context.getResources(), null, 0);
    }

    private static PendingResources<RemoteViews> createFromProto(ProtoInputStream in) throws Exception {
        var ref = new Object(){
            final RemoteViews mRv = new RemoteViews();
            int mMode = 0;
            int mApplyFlags = 0;
            long mProviderInstanceId = -1L;
            String mPackageName = null;
            Integer mUid = null;
            SizeF mIdealSize = null;
            String mLayoutResName = null;
            String mLightBackgroundResName = null;
            String mViewResName = null;
            final List<PendingResources<Action>> mActions = new ArrayList<PendingResources<Action>>();
            final List<PendingResources<RemoteViews>> mSizedRemoteViews = new ArrayList<PendingResources<RemoteViews>>();
            PendingResources<RemoteViews> mLandscapeViews = null;
            PendingResources<RemoteViews> mPortraitViews = null;
            PendingResources<RemoteCollectionCache> mPopulateRemoteCollectionCache = null;
            boolean mIsRoot = false;
            boolean mHasDrawInstructions = false;
        };
        try {
            block21: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        ref.mMode = in.readInt(0x10500000001L);
                        continue block21;
                    }
                    case 2: {
                        ref.mPackageName = in.readString(1138166333442L);
                        continue block21;
                    }
                    case 17: {
                        ref.mUid = in.readInt(0x10500000011L);
                        continue block21;
                    }
                    case 6: {
                        long idealSizeToken = in.start(1146756268038L);
                        ref.mIdealSize = RemoteViews.createSizeFFromProto(in);
                        in.end(idealSizeToken);
                        continue block21;
                    }
                    case 3: {
                        ref.mLayoutResName = in.readString(1138166333443L);
                        continue block21;
                    }
                    case 4: {
                        ref.mLightBackgroundResName = in.readString(1138166333444L);
                        continue block21;
                    }
                    case 5: {
                        ref.mViewResName = in.readString(1138166333445L);
                        continue block21;
                    }
                    case 7: {
                        ref.mApplyFlags = in.readInt(1120986464263L);
                        continue block21;
                    }
                    case 8: {
                        ref.mProviderInstanceId = in.readInt(1112396529672L);
                        continue block21;
                    }
                    case 16: {
                        long actionsToken = in.start(2246267895824L);
                        PendingResources<Action> action = RemoteViews.createActionFromProto(ref.mRv, in);
                        if (action != null) {
                            ref.mActions.add(action);
                        }
                        in.end(actionsToken);
                        continue block21;
                    }
                    case 9: {
                        long sizedToken = in.start(2246267895817L);
                        ref.mSizedRemoteViews.add(RemoteViews.createFromProto(in));
                        in.end(sizedToken);
                        continue block21;
                    }
                    case 11: {
                        long landscapeToken = in.start(0x10B0000000BL);
                        ref.mLandscapeViews = RemoteViews.createFromProto(in);
                        in.end(landscapeToken);
                        continue block21;
                    }
                    case 10: {
                        long portraitToken = in.start(1146756268042L);
                        ref.mPortraitViews = RemoteViews.createFromProto(in);
                        in.end(portraitToken);
                        continue block21;
                    }
                    case 14: {
                        byte[] src = in.readBytes(2250562863118L);
                        Bitmap bitmap = BitmapFactory.decodeByteArray(src, 0, src.length);
                        ref.mRv.mBitmapCache.getBitmapId(bitmap);
                        continue block21;
                    }
                    case 15: {
                        long collectionToken = in.start(1146756268047L);
                        ref.mPopulateRemoteCollectionCache = ref.mRv.populateRemoteCollectionCacheFromProto(in);
                        in.end(collectionToken);
                        continue block21;
                    }
                    case 12: {
                        ref.mIsRoot = in.readBoolean(1133871366156L);
                        continue block21;
                    }
                    case 13: {
                        ref.mHasDrawInstructions = in.readBoolean(1133871366157L);
                        continue block21;
                    }
                }
                Log.w(LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (context, resources, rootData, depth) -> {
            if (depth > 10 && UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
                throw new IllegalArgumentException("Too many nested views.");
            }
            ++depth;
            RemoteViews rv = ref.mRv;
            rv.mApplyFlags = ref.mApplyFlags;
            rv.mIsRoot = ref.mIsRoot;
            rv.mHasDrawInstructions = ref.mHasDrawInstructions;
            if (rootData == null) {
                if (!rv.mIsRoot || depth != 1) {
                    throw new IllegalStateException("A nested view did not receive HierarchyRootData");
                }
                rootData = rv.getHierarchyRootData();
            } else {
                rv.configureAsChild(rootData);
            }
            Context appContext = null;
            Resources appResources = null;
            if (!ref.mHasDrawInstructions) {
                RemoteViews.checkProtoResultNotNull(ref.mPackageName, "No application info");
                RemoteViews.checkProtoResultNotNull(ref.mUid, "No uid");
                rv.mApplication = context.getPackageManager().getApplicationInfoAsUser(ref.mPackageName, 0, UserHandle.getUserId(ref.mUid));
                appContext = rv.getContextForResourcesEnsuringCorrectCachedApkPaths(context);
                appResources = appContext.getResources();
                RemoteViews.checkProtoResultNotNull(ref.mLayoutResName, "No layout id");
                rv.mLayoutId = appResources.getIdentifier(ref.mLayoutResName, null, null);
                RemoteViews.checkValidResource(rv.mLayoutId, "Invalid layout id", ref.mLayoutResName);
                if (ref.mViewResName != null) {
                    rv.mViewId = appResources.getIdentifier(ref.mViewResName, null, null);
                    RemoteViews.checkValidResource(rv.mViewId, "Invalid view id", ref.mViewResName);
                }
                if (ref.mLightBackgroundResName != null) {
                    int lightBackgroundLayoutId = appResources.getIdentifier(ref.mLightBackgroundResName, null, null);
                    RemoteViews.checkValidResource(lightBackgroundLayoutId, "Invalid light background layout id", ref.mLightBackgroundResName);
                    rv.setLightBackgroundLayoutId(lightBackgroundLayoutId);
                }
            }
            if (ref.mPopulateRemoteCollectionCache != null) {
                ref.mPopulateRemoteCollectionCache.create(appContext, appResources, rootData, depth);
            }
            if (ref.mProviderInstanceId != -1L) {
                rv.mProviderInstanceId = ref.mProviderInstanceId;
            }
            if (ref.mMode == 0) {
                rv.setIdealSize(ref.mIdealSize);
                boolean hasDrawInstructionAction = false;
                for (PendingResources<Action> pendingAction : ref.mActions) {
                    Action action = pendingAction.create(appContext, appResources, rootData, depth);
                    if (action == null) continue;
                    if (action instanceof SetDrawInstructionAction) {
                        hasDrawInstructionAction = true;
                    }
                    rv.addAction(action);
                }
                if (rv.mHasDrawInstructions && !hasDrawInstructionAction) {
                    throw new InvalidProtoException("RemoteViews proto is missing DrawInstructions");
                }
                return rv;
            }
            if (ref.mMode == 2) {
                ArrayList<RemoteViews> sizedViews = new ArrayList<RemoteViews>();
                for (PendingResources<RemoteViews> pendingViews : ref.mSizedRemoteViews) {
                    RemoteViews views = pendingViews.create(appContext, appResources, rootData, depth);
                    sizedViews.add(views);
                }
                rv.initializeSizedRemoteViews(sizedViews.iterator());
                return rv;
            }
            if (ref.mMode == 1) {
                RemoteViews.checkProtoResultNotNull(ref.mLandscapeViews, "Missing landscape views");
                RemoteViews.checkProtoResultNotNull(ref.mPortraitViews, "Missing portrait views");
                RemoteViews parentRv = new RemoteViews(ref.mLandscapeViews.create(appContext, appResources, rootData, depth), ref.mPortraitViews.create(appContext, appResources, rootData, depth));
                parentRv.initializeFrom(rv, rv);
                return parentRv;
            }
            throw new InvalidProtoException(ref.mMode + " is not a valid mode.");
        };
    }

    @Nullable
    private static PendingResources<Action> createActionFromProto(RemoteViews rv, ProtoInputStream in) throws Exception {
        int actionFieldId = in.nextField();
        if (actionFieldId == -1) {
            return null;
        }
        switch (actionFieldId) {
            case 1: {
                return AttributeReflectionAction.createFromProto(in);
            }
            case 2: {
                return rv.createFromBitmapReflectionActionFromProto(in);
            }
            case 3: {
                return ComplexUnitDimensionReflectionAction.createFromProto(in);
            }
            case 4: {
                return LayoutParamAction.createFromProto(in);
            }
            case 5: {
                return NightModeReflectionAction.createFromProto(in);
            }
            case 6: {
                return ReflectionAction.createFromProto(in);
            }
            case 7: {
                return RemoveFromParentAction.createFromProto(in);
            }
            case 8: {
                return ResourceReflectionAction.createFromProto(in);
            }
            case 9: {
                return SetCompoundButtonCheckedAction.createFromProto(in);
            }
            case 10: {
                return SetDrawableTint.createFromProto(in);
            }
            case 11: {
                return SetEmptyView.createFromProto(in);
            }
            case 12: {
                return SetIntTagAction.createFromProto(in);
            }
            case 13: {
                return SetRadioGroupCheckedAction.createFromProto(in);
            }
            case 14: {
                return rv.createSetRemoteCollectionItemListAdapterActionFromProto(in);
            }
            case 15: {
                return SetRippleDrawableColor.createFromProto(in);
            }
            case 16: {
                return SetViewOutlinePreferredRadiusAction.createFromProto(in);
            }
            case 17: {
                return TextViewDrawableAction.createFromProto(in);
            }
            case 18: {
                return TextViewSizeAction.createFromProto(in);
            }
            case 19: {
                return rv.createViewGroupActionAddFromProto(in);
            }
            case 20: {
                return ViewGroupActionRemove.createFromProto(in);
            }
            case 21: {
                return ViewPaddingAction.createFromProto(in);
            }
            case 22: {
                if (!Flags.drawDataParcel()) {
                    return null;
                }
                return rv.createSetDrawInstructionActionFromProto(in);
            }
        }
        throw new RuntimeException("Unhandled field while reading Action proto!\n" + ProtoUtils.currentFieldToString(in));
    }

    private static void checkValidResource(int id2, String message, String resName) throws Exception {
        if (id2 == 0) {
            throw new Exception(message + ": " + resName);
        }
    }

    private static void checkProtoResultNotNull(Object o, String message) throws InvalidProtoException {
        if (o == null) {
            throw new InvalidProtoException(message);
        }
    }

    private static void checkContainsKeys(LongSparseArray<?> array2, long[] requiredFields) {
        for (long requiredField : requiredFields) {
            if (array2.indexOfKey(requiredField) >= 0) continue;
            throw new IllegalArgumentException("RemoteViews proto missing field: " + ProtoStream.getFieldIdString(requiredField));
        }
    }

    private static int getAsIdentifier(Resources resources, LongSparseArray<?> array2, long fieldId) throws Exception {
        String resName = (String)array2.get(fieldId);
        int id2 = resources.getIdentifier(resName, null, null);
        RemoteViews.checkValidResource(id2, "Invalid id", resName);
        return id2;
    }

    private static int getAsIdentifier(Resources resources, SparseArray<?> array2, int key) throws Exception {
        String resName = (String)array2.get(key);
        int id2 = resources.getIdentifier(resName, null, null);
        RemoteViews.checkValidResource(id2, "Invalid id", resName);
        return id2;
    }

    private static SizeF createSizeFFromProto(ProtoInputStream in) throws Exception {
        float width = 0.0f;
        float height = 0.0f;
        block4: while (in.nextField() != -1) {
            switch (in.getFieldNumber()) {
                case 1: {
                    width = in.readFloat(0x10200000001L);
                    continue block4;
                }
                case 2: {
                    height = in.readFloat(0x10200000002L);
                    continue block4;
                }
            }
            Log.w(LOG_TAG, "Unhandled field while reading SizeF proto!\n" + ProtoUtils.currentFieldToString(in));
        }
        return new SizeF(width, height);
    }

    private static void writeIconToProto(ProtoOutputStream out, Resources appResources, Icon icon, long fieldId) {
        long token = out.start(fieldId);
        RemoteViewsSerializers.writeIconToProto(out, appResources, icon);
        out.end(token);
    }

    private static PendingResources<Icon> createIconFromProto(ProtoInputStream in, long fieldId) throws Exception {
        long token = in.start(fieldId);
        Function<Resources, Icon> icon = RemoteViewsSerializers.createIconFromProto(in);
        in.end(token);
        return (context, resources, rootData, depth) -> (Icon)icon.apply(resources);
    }

    private static void writeColorStateListToProto(ProtoOutputStream out, ColorStateList colorStateList, long fieldId) {
        long token = out.start(fieldId);
        colorStateList.writeToProto(out);
        out.end(token);
    }

    private static ColorStateList createColorStateListFromProto(ProtoInputStream in, long fieldId) throws Exception {
        long token = in.start(fieldId);
        ColorStateList colorStateList = ColorStateList.createFromProto(in);
        in.end(token);
        return colorStateList;
    }

    private static CharSequence createCharSequenceFromProto(ProtoInputStream in, long fieldId) throws Exception {
        long token = in.start(fieldId);
        CharSequence cs = RemoteViewsSerializers.createCharSequenceFromProto(in);
        in.end(token);
        return cs;
    }

    private static class SetRemoteInputsAction
    extends Action {
        final Parcelable[] mRemoteInputs;

        public SetRemoteInputsAction(int viewId, RemoteInput[] remoteInputs) {
            this.mViewId = viewId;
            this.mRemoteInputs = remoteInputs;
        }

        public SetRemoteInputsAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mRemoteInputs = parcel.createTypedArray(RemoteInput.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeTypedArray(this.mRemoteInputs, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(16909490, this.mRemoteInputs);
        }

        @Override
        public int getActionTag() {
            return 18;
        }
    }

    static class BitmapCache {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        ArrayList<Bitmap> mBitmaps;
        SparseIntArray mBitmapHashes;
        long mBitmapMemory = -1L;

        public BitmapCache() {
            this.mBitmaps = new ArrayList();
            this.mBitmapHashes = new SparseIntArray();
        }

        public BitmapCache(Parcel source) {
            this.mBitmaps = source.createTypedArrayList(Bitmap.CREATOR);
            this.mBitmapHashes = new SparseIntArray();
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                Bitmap b = this.mBitmaps.get(i);
                if (b == null) continue;
                this.mBitmapHashes.put(b.hashCode(), i);
            }
        }

        BitmapCache(BitmapCache other) {
            this.mBitmaps = new ArrayList<Bitmap>(other.mBitmaps);
            this.mBitmapHashes = other.mBitmapHashes.clone();
        }

        public int getBitmapId(Bitmap b) {
            if (b == null) {
                return -1;
            }
            int hash = b.hashCode();
            int hashId = this.mBitmapHashes.get(hash, -1);
            if (hashId != -1) {
                return hashId;
            }
            if (b.isMutable()) {
                b = b.asShared();
            }
            this.mBitmaps.add(b);
            this.mBitmapHashes.put(hash, this.mBitmaps.size() - 1);
            this.mBitmapMemory = -1L;
            return this.mBitmaps.size() - 1;
        }

        @Nullable
        public Bitmap getBitmapForId(int id2) {
            if (id2 == -1 || id2 >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(id2);
        }

        public void writeBitmapsToParcel(Parcel dest, int flags) {
            dest.writeTypedList(this.mBitmaps, flags);
        }

        public void writeBitmapsToProto(ProtoOutputStream out) {
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                Bitmap bitmap = this.mBitmaps.get(i);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.WEBP_LOSSLESS, 100, bytes);
                out.write(2250562863118L, bytes.toByteArray());
            }
        }

        public long getBitmapMemory() {
            if (this.mBitmapMemory < 0L) {
                this.mBitmapMemory = 0L;
                int count = this.mBitmaps.size();
                for (int i = 0; i < count; ++i) {
                    this.mBitmapMemory += (long)this.mBitmaps.get(i).getAllocationByteCount();
                }
            }
            return this.mBitmapMemory;
        }

        public void mergeWithCache(BitmapCache other) {
            for (int i = 0; i < other.mBitmaps.size(); ++i) {
                this.getBitmapId(other.mBitmaps.get(i));
            }
        }
    }

    private static class SetIntTagAction
    extends Action {
        private final int mViewId;
        private final int mKey;
        private final int mTag;

        SetIntTagAction(int viewId, int key, int tag) {
            this.mViewId = viewId;
            this.mKey = key;
            this.mTag = tag;
        }

        SetIntTagAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mKey = parcel.readInt();
            this.mTag = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mKey);
            dest.writeInt(this.mTag);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            ((View)target).setTagInternal(this.mKey, this.mTag);
        }

        @Override
        public int getActionTag() {
            return 22;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268044L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, appResources.getResourceName(this.mKey));
            out.write(1120986464259L, this.mTag);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268044L);
            block5: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block5;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block5;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block5;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int keyId = RemoteViews.getAsIdentifier(resources, values, 1138166333442L);
                return new SetIntTagAction(viewId, keyId, values.get(1120986464259L, 0));
            };
        }
    }

    private static abstract class Action {
        @UnsupportedAppUsage
        int mViewId;
        public static final int MERGE_REPLACE = 0;
        public static final int MERGE_APPEND = 1;
        public static final int MERGE_IGNORE = 2;

        private Action() {
        }

        public abstract void apply(View var1, ViewGroup var2, ActionApplyParams var3) throws ActionException;

        public void setHierarchyRootData(HierarchyRootData root) {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public int mergeBehavior() {
            return 0;
        }

        public abstract int getActionTag();

        public String getUniqueKey() {
            return this.getActionTag() + "_" + this.mViewId;
        }

        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            return this;
        }

        public boolean prefersAsyncApply() {
            return false;
        }

        public void visitUris(@NonNull Consumer<Uri> visitor) {
        }

        public void visitIcons(@NonNull Consumer<Icon> visitor) {
        }

        public abstract void writeToParcel(Parcel var1, int var2);

        public boolean canWriteToProto() {
            return false;
        }

        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            throw new UnsupportedOperationException();
        }
    }

    private class RemoteCollectionCache {
        private final SparseArray<String> mIdToUriMapping = new SparseArray();
        private final Map<String, RemoteCollectionItems> mUriToCollectionMapping = new HashMap<String, RemoteCollectionItems>();

        RemoteCollectionCache() {
        }

        RemoteCollectionCache(RemoteCollectionCache src) {
            for (int i = 0; i < src.mIdToUriMapping.size(); ++i) {
                String uri = src.mIdToUriMapping.valueAt(i);
                this.mIdToUriMapping.put(src.mIdToUriMapping.keyAt(i), uri);
                this.mUriToCollectionMapping.put(uri, src.mUriToCollectionMapping.get(uri));
            }
        }

        RemoteCollectionCache(Parcel in) {
            int cacheSize = in.readInt();
            HierarchyRootData currentRootData = new HierarchyRootData(RemoteViews.this.mBitmapCache, this, RemoteViews.this.mApplicationInfoCache, RemoteViews.this.mClassCookies);
            for (int i = 0; i < cacheSize; ++i) {
                int intentId = in.readInt();
                String intentUri = in.readString8();
                RemoteCollectionItems items = new RemoteCollectionItems(in, currentRootData);
                this.addMapping(intentId, intentUri, items);
            }
        }

        void addMapping(int intentId, String intentUri, RemoteCollectionItems items) {
            this.mIdToUriMapping.put(intentId, intentUri);
            this.mUriToCollectionMapping.put(intentUri, items);
        }

        void setHierarchyDataForId(int intentId, HierarchyRootData data) {
            String uri = this.mIdToUriMapping.get(intentId);
            if (this.mUriToCollectionMapping.get(uri) == null) {
                Log.e(RemoteViews.LOG_TAG, "Error setting hierarchy data for id=" + intentId);
                return;
            }
            RemoteCollectionItems items = this.mUriToCollectionMapping.get(uri);
            items.setHierarchyRootData(data);
        }

        RemoteCollectionItems getItemsForId(int intentId) {
            String uri = this.mIdToUriMapping.get(intentId);
            return this.mUriToCollectionMapping.get(uri);
        }

        public void replaceAllIntentsWithEmptyList(@NonNull RemoteViews inViews) {
            this.collectAllIntentsInternal(inViews, new SparseArray<Intent>());
            for (int i = 0; i < this.mIdToUriMapping.size(); ++i) {
                RemoteCollectionItems collection = new RemoteCollectionItems.Builder().build();
                collection.setHierarchyRootData(RemoteViews.this.getHierarchyRootData());
                this.mUriToCollectionMapping.put(this.mIdToUriMapping.valueAt(i), collection);
            }
        }

        @NonNull
        public CompletableFuture<Void> collectAllIntentsNoComplete(@NonNull RemoteViews inViews, int bitmapSizeLimit, boolean invalidateData, @NonNull AppWidgetManager.ServiceCollectionCache collectionCache) {
            SparseArray<Intent> idToIntentMapping = new SparseArray<Intent>();
            this.collectAllIntentsInternal(inViews, idToIntentMapping);
            int numOfIntents = idToIntentMapping.size();
            if (numOfIntents == 0) {
                Log.e(RemoteViews.LOG_TAG, "Possibly notifying updates for nonexistent view Id");
                return CompletableFuture.completedFuture(null);
            }
            Parcel sizeTestParcel = Parcel.obtain();
            RemoteViews.this.writeToParcel(sizeTestParcel, 0, idToIntentMapping);
            int remainingSize = 800000 - sizeTestParcel.dataSize();
            sizeTestParcel.recycle();
            int individualSize = remainingSize < 0 ? 0 : remainingSize / numOfIntents;
            int individualBitmapSizeLimit = (bitmapSizeLimit - RemoteViews.this.getBitmapMemoryUsedByActions()) / numOfIntents;
            return this.connectAllUniqueIntents(individualSize, individualBitmapSizeLimit, idToIntentMapping, invalidateData, collectionCache);
        }

        private void collectAllIntentsInternal(@NonNull RemoteViews inViews, @NonNull SparseArray<Intent> idToIntentMapping) {
            block8: {
                block9: {
                    block7: {
                        if (!inViews.hasSizedRemoteViews()) break block7;
                        for (RemoteViews remoteViews : inViews.mSizedRemoteViews) {
                            this.collectAllIntentsInternal(remoteViews, idToIntentMapping);
                        }
                        break block8;
                    }
                    if (!inViews.hasLandscapeAndPortraitLayouts()) break block9;
                    this.collectAllIntentsInternal(inViews.mLandscape, idToIntentMapping);
                    this.collectAllIntentsInternal(inViews.mPortrait, idToIntentMapping);
                    break block8;
                }
                if (inViews.mActions == null) break block8;
                for (Action action : inViews.mActions) {
                    if (action instanceof SetRemoteCollectionItemListAdapterAction) {
                        SetRemoteCollectionItemListAdapterAction rca = (SetRemoteCollectionItemListAdapterAction)action;
                        if (rca.mIntentId != -1 && !rca.mIsReplacedIntoAction) continue;
                        if (rca.mIntentId != -1 && rca.mIsReplacedIntoAction) {
                            rca.mIsReplacedIntoAction = false;
                            if (idToIntentMapping.contains(rca.mIntentId)) continue;
                            idToIntentMapping.put(rca.mIntentId, rca.mServiceIntent);
                            rca.mItems = null;
                            continue;
                        }
                        if (rca.mServiceIntent != null) {
                            int newIntentId;
                            String uri = rca.mServiceIntent.toUri(0);
                            int index = this.mIdToUriMapping.indexOfValueByValue(uri);
                            if (index != -1) {
                                rca.mIntentId = this.mIdToUriMapping.keyAt(index);
                                rca.mItems = null;
                                continue;
                            }
                            rca.mIntentId = newIntentId = this.mIdToUriMapping.size();
                            this.mIdToUriMapping.put(newIntentId, uri);
                            idToIntentMapping.put(rca.mIntentId, rca.mServiceIntent);
                            rca.mItems = null;
                            continue;
                        }
                        for (RemoteViews views : rca.mItems.mViews) {
                            this.collectAllIntentsInternal(views, idToIntentMapping);
                        }
                        continue;
                    }
                    if (!(action instanceof ViewGroupActionAdd)) continue;
                    ViewGroupActionAdd vgaa = (ViewGroupActionAdd)action;
                    if (vgaa.mNestedViews == null) continue;
                    this.collectAllIntentsInternal(vgaa.mNestedViews, idToIntentMapping);
                }
            }
        }

        @NonNull
        private CompletableFuture<Void> connectAllUniqueIntents(int individualSize, int individualBitmapSize, @NonNull SparseArray<Intent> idToIntentMapping, boolean invalidateData, @NonNull AppWidgetManager.ServiceCollectionCache collectionCache) {
            ArrayList<CompletionStage> intentFutureList = new ArrayList<CompletionStage>();
            for (int i = 0; i < idToIntentMapping.size(); ++i) {
                String currentIntentUri = this.mIdToUriMapping.get(idToIntentMapping.keyAt(i));
                Intent currentIntent = idToIntentMapping.valueAt(i);
                intentFutureList.add(RemoteCollectionCache.getItemsFutureFromIntent(currentIntent, individualSize, individualBitmapSize, invalidateData, collectionCache).thenAccept(items -> {
                    items.setHierarchyRootData(RemoteViews.this.getHierarchyRootData());
                    this.mUriToCollectionMapping.put(currentIntentUri, (RemoteCollectionItems)items);
                }));
            }
            return CompletableFuture.allOf((CompletableFuture[])intentFutureList.toArray(CompletableFuture[]::new));
        }

        private static CompletableFuture<RemoteCollectionItems> getItemsFutureFromIntent(Intent intent, int individualSize, int individualBitmapSize, boolean invalidateData, @NonNull AppWidgetManager.ServiceCollectionCache collectionCache) {
            if (intent == null) {
                Log.e(RemoteViews.LOG_TAG, "Null intent received when generating adapter future");
                return CompletableFuture.completedFuture(new RemoteCollectionItems.Builder().build());
            }
            Application context = ActivityThread.currentApplication();
            CompletableFuture<RemoteCollectionItems> result = new CompletableFuture<RemoteCollectionItems>();
            String contextPackageName = ((Context)context).getPackageName();
            ComponentName intentComponent = intent.getComponent();
            if (contextPackageName != null && intentComponent != null && !contextPackageName.equals(intentComponent.getPackageName())) {
                result.complete(new RemoteCollectionItems.Builder().build());
                return result;
            }
            collectionCache.connectAndConsume(intent, iBinder -> {
                try {
                    result.complete(IRemoteViewsFactory.Stub.asInterface(iBinder).getRemoteCollectionItems(individualSize, individualBitmapSize, invalidateData));
                }
                catch (Exception e) {
                    result.completeExceptionally(e);
                }
            });
            return result;
        }

        public void writeToParcel(Parcel out, int flags, @Nullable SparseArray<Intent> intentsToIgnore) {
            out.writeInt(this.mIdToUriMapping.size());
            for (int i = 0; i < this.mIdToUriMapping.size(); ++i) {
                int currentIntentId = this.mIdToUriMapping.keyAt(i);
                if (intentsToIgnore != null && intentsToIgnore.contains(currentIntentId)) continue;
                out.writeInt(currentIntentId);
                String intentUri = this.mIdToUriMapping.valueAt(i);
                out.writeString8(intentUri);
                this.mUriToCollectionMapping.get(intentUri).writeToParcel(out, flags, true);
            }
        }

        public void writeToProto(Context context, ProtoOutputStream out) {
            long token = out.start(1146756268047L);
            for (int i = 0; i < this.mIdToUriMapping.size(); ++i) {
                long entryToken = out.start(2246267895809L);
                out.write(0x10300000001L, this.mIdToUriMapping.keyAt(i));
                String intentUri = this.mIdToUriMapping.valueAt(i);
                out.write(1138166333442L, intentUri);
                long itemsToken = out.start(1146756268035L);
                this.mUriToCollectionMapping.get(intentUri).writeToProto(context, out, true);
                out.end(itemsToken);
                out.end(entryToken);
            }
            out.end(token);
        }
    }

    private class SetRemoteCollectionItemListAdapterAction
    extends Action {
        @Nullable
        private RemoteCollectionItems mItems;
        final Intent mServiceIntent;
        int mIntentId = -1;
        boolean mIsReplacedIntoAction = false;

        SetRemoteCollectionItemListAdapterAction(@NonNull int id2, RemoteCollectionItems items) {
            this.mViewId = id2;
            items.setHierarchyRootData(RemoteViews.this.getHierarchyRootData());
            this.mItems = items;
            this.mServiceIntent = null;
        }

        SetRemoteCollectionItemListAdapterAction(int id2, Intent intent) {
            this.mViewId = id2;
            this.mItems = null;
            this.mServiceIntent = intent;
        }

        SetRemoteCollectionItemListAdapterAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mIntentId = parcel.readInt();
            this.mIsReplacedIntoAction = parcel.readBoolean();
            this.mServiceIntent = parcel.readTypedObject(Intent.CREATOR);
            this.mItems = this.mServiceIntent != null ? null : new RemoteCollectionItems(parcel, RemoteViews.this.getHierarchyRootData());
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData rootData) {
            if (this.mItems != null) {
                this.mItems.setHierarchyRootData(rootData);
                return;
            }
            if (this.mIntentId != -1) {
                RemoteViews.this.mCollectionCache.setHierarchyDataForId(this.mIntentId, rootData);
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mIntentId);
            dest.writeBoolean(this.mIsReplacedIntoAction);
            dest.writeTypedObject(this.mServiceIntent, flags);
            if (this.mItems != null) {
                this.mItems.writeToParcel(dest, flags, true);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, final ActionApplyParams params) throws ActionException {
            RemoteCollectionItems items;
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            RemoteCollectionItems remoteCollectionItems = this.mIntentId == -1 ? (this.mItems == null ? new RemoteCollectionItems.Builder().build() : this.mItems) : (items = RemoteViews.this.mCollectionCache.getItemsForId(this.mIntentId));
            if (items.hasLegacyNullItems()) {
                Log.e(RemoteViews.LOG_TAG, "Legacy null RemoteViews encountered in RemoteViewsFactory#getRemoteCollectionItems. Widget should not provide null RemoteViews in collections. Use setRemoteAdapter(viewId, items) instead to provide items.");
                throw new ActionException("Null entries encountered in RemoteViewsFactory#getRemoteCollectionItems");
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "setRemoteAdapter can only be used for AppWidgets (root id: " + this.mViewId + ")");
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot call setRemoteAdapter on a view which is not an AdapterView (id: " + this.mViewId + ")");
                return;
            }
            AdapterView adapterView = (AdapterView)target;
            Object adapter = adapterView.getAdapter();
            boolean onLightBackground = RemoteViews.this.hasFlags(4);
            if (this.mIntentId != -1 && Looper.myLooper() != null) {
                new Handler(Looper.myLooper()).post(adapterView::checkFocus);
            }
            if (adapter instanceof RemoteCollectionItemsAdapter && adapter.getViewTypeCount() >= items.getViewTypeCount()) {
                try {
                    ((RemoteCollectionItemsAdapter)adapter).setData(items, params.handler, params.colorResources, onLightBackground);
                }
                catch (Throwable throwable) {
                    throw new ActionException(throwable);
                }
                return;
            }
            try {
                adapterView.setAdapter(new RemoteCollectionItemsAdapter(items, params.handler, params.colorResources, onLightBackground));
            }
            catch (Throwable throwable) {
                throw new ActionException(throwable);
            }
            if (adapterView instanceof AbsListView) {
                AbsListView listView = (AbsListView)adapterView;
                listView.setOnScrollListener(new AbsListView.OnScrollListener(){

                    @Override
                    public void onScrollStateChanged(AbsListView view, int scrollState) {
                        if (scrollState != 0) {
                            params.handler.onScroll(view);
                        }
                    }

                    @Override
                    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                    }
                });
            }
        }

        @Override
        public int getActionTag() {
            return 31;
        }

        @Override
        public String getUniqueKey() {
            return "33_" + this.mViewId;
        }

        @Override
        public void visitUris(@NonNull Consumer<Uri> visitor) {
            if (this.mItems == null) {
                RemoteCollectionItems cachedItems = RemoteViews.this.mCollectionCache.getItemsForId(this.mIntentId);
                if (cachedItems != null) {
                    cachedItems.visitUris(visitor);
                }
                return;
            }
            this.mItems.visitUris(visitor);
        }

        @Override
        public void visitIcons(Consumer<Icon> visitor) {
            if (this.mItems == null) {
                RemoteCollectionItems cachedItems = RemoteViews.this.mCollectionCache.getItemsForId(this.mIntentId);
                if (cachedItems != null) {
                    cachedItems.visitIcons(visitor);
                }
                return;
            }
            this.mItems.visitIcons(visitor);
        }

        @Override
        public boolean canWriteToProto() {
            return this.mItems != null;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            if (this.mItems == null) {
                return;
            }
            long token = out.start(1146756268046L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            long itemsToken = out.start(1146756268034L);
            this.mItems.writeToProto(context, out, true);
            out.end(itemsToken);
            out.end(token);
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action {
        Intent mIntent;
        boolean mIsAsync = false;

        public SetRemoteViewsAdapterIntent(int id2, Intent intent) {
            this.mViewId = id2;
            this.mIntent = intent;
        }

        public SetRemoteViewsAdapterIntent(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mIntent = parcel.readTypedObject(Intent.CREATOR);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeTypedObject(this.mIntent, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, final ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e(RemoteViews.LOG_TAG, "setRemoteAdapter can only be used for AppWidgets (root id: " + this.mViewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setRemoteAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.mViewId + ")");
                return;
            }
            AppWidgetHostView host = (AppWidgetHostView)rootParent;
            this.mIntent.putExtra(RemoteViews.EXTRA_REMOTEADAPTER_APPWIDGET_ID, host.getAppWidgetId()).putExtra(RemoteViews.EXTRA_REMOTEADAPTER_ON_LIGHT_BACKGROUND, RemoteViews.this.hasFlags(4));
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                v.setRemoteViewsAdapter(this.mIntent, this.mIsAsync);
                v.setRemoteViewsInteractionHandler(params.handler);
                v.setOnScrollListener(new AbsListView.OnScrollListener(){

                    @Override
                    public void onScrollStateChanged(AbsListView view, int scrollState) {
                        if (scrollState != 0) {
                            params.handler.onScroll(view);
                        }
                    }

                    @Override
                    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                    }
                });
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                v.setRemoteViewsAdapter(this.mIntent, this.mIsAsync);
                v.setRemoteViewsOnClickHandler(params.handler);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            SetRemoteViewsAdapterIntent copy = new SetRemoteViewsAdapterIntent(this.mViewId, this.mIntent);
            copy.mIsAsync = true;
            return copy;
        }

        @Override
        public int getActionTag() {
            return 10;
        }
    }

    private class ViewGroupActionAdd
    extends Action {
        static final int NO_ID = -1;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        private RemoteViews mNestedViews;
        private int mIndex;
        private int mStableId;

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews) {
            this(viewId, nestedViews, -1, -1);
        }

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews, int index) {
            this(viewId, nestedViews, index, -1);
        }

        ViewGroupActionAdd(int viewId, RemoteViews nestedViews, int index, int stableId) {
            this.mViewId = viewId;
            this.mNestedViews = nestedViews;
            this.mIndex = index;
            this.mStableId = stableId;
            nestedViews.configureAsChild(RemoteViews.this.getHierarchyRootData());
        }

        ViewGroupActionAdd(Parcel parcel, ApplicationInfo info, int depth) {
            this.mViewId = parcel.readInt();
            this.mIndex = parcel.readInt();
            this.mStableId = parcel.readInt();
            this.mNestedViews = new RemoteViews(parcel, RemoteViews.this.getHierarchyRootData(), info, depth);
            this.mNestedViews.addFlags(RemoteViews.this.mApplyFlags);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mIndex);
            dest.writeInt(this.mStableId);
            this.mNestedViews.writeToParcel(dest, flags);
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData root) {
            this.mNestedViews.configureAsChild(root);
        }

        private int findViewIndexToRecycle(ViewGroup target, RemoteViews newContent) {
            for (int nextChild = RemoteViews.getNextRecyclableChild(target); nextChild < target.getChildCount(); ++nextChild) {
                View child = target.getChildAt(nextChild);
                if (RemoteViews.getStableId(child) != this.mStableId) continue;
                return nextChild;
            }
            return -1;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            int recycledViewIndex;
            Context context = root.getContext();
            ViewGroup target = (ViewGroup)root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            int nextChild = RemoteViews.getNextRecyclableChild(target);
            RemoteViews rvToApply = this.mNestedViews.getRemoteViewsToApply(context);
            int flagsToPropagate = RemoteViews.this.mApplyFlags & 6;
            if (flagsToPropagate != 0) {
                rvToApply.addFlags(flagsToPropagate);
            }
            if (nextChild >= 0 && this.mStableId != -1 && (recycledViewIndex = this.findViewIndexToRecycle(target, rvToApply)) >= 0) {
                View child = target.getChildAt(recycledViewIndex);
                if (rvToApply.canRecycleView(child)) {
                    if (nextChild < recycledViewIndex) {
                        target.removeViews(nextChild, recycledViewIndex - nextChild);
                    }
                    RemoteViews.setNextRecyclableChild(target, nextChild + 1, target.getChildCount());
                    rvToApply.reapplyNestedViews(context, child, rootParent, params);
                    return;
                }
                target.removeViews(nextChild, recycledViewIndex - nextChild + 1);
            }
            View nestedView = rvToApply.apply(context, target, rootParent, null, params);
            if (this.mStableId != -1) {
                RemoteViews.setStableId(nestedView, this.mStableId);
            }
            target.addView(nestedView, this.mIndex >= 0 ? this.mIndex : nextChild);
            if (nextChild >= 0) {
                RemoteViews.setNextRecyclableChild(target, nextChild + 1, target.getChildCount());
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.mViewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            Context context = root.mRoot.getContext();
            final int nextChild = RemoteViews.getNextRecyclableChild(targetVg);
            if (nextChild >= 0 && this.mStableId != -1) {
                RemoteViews rvToApply = this.mNestedViews.getRemoteViewsToApply(context);
                final int recycledViewIndex = target.findChildIndex(nextChild, view -> RemoteViews.getStableId(view) == this.mStableId);
                if (recycledViewIndex >= 0) {
                    ViewTree recycled = target.mChildren.get(recycledViewIndex);
                    if (rvToApply.canRecycleView(recycled.mRoot)) {
                        if (recycledViewIndex > nextChild) {
                            target.removeChildren(nextChild, recycledViewIndex - nextChild);
                        }
                        RemoteViews.setNextRecyclableChild(targetVg, nextChild + 1, target.mChildren.size());
                        final AsyncApplyTask reapplyTask = rvToApply.getInternalAsyncApplyTask(context, targetVg, null, params, null, recycled.mRoot);
                        final ViewTree tree = reapplyTask.doInBackground(new Void[0]);
                        if (tree == null) {
                            throw new ActionException(reapplyTask.mError);
                        }
                        return new RuntimeAction(this){

                            @Override
                            public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
                                reapplyTask.onPostExecute(tree);
                                if (recycledViewIndex > nextChild) {
                                    targetVg.removeViews(nextChild, recycledViewIndex - nextChild);
                                }
                            }
                        };
                    }
                    target.removeChildren(nextChild, recycledViewIndex - nextChild + 1);
                    return this.insertNewView(context, target, params, () -> targetVg.removeViews(nextChild, recycledViewIndex - nextChild + 1));
                }
            }
            return this.insertNewView(context, target, params, () -> {});
        }

        private Action insertNewView(Context context, ViewTree target, ActionApplyParams params, final Runnable finalizeAction) {
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            int nextChild = RemoteViews.getNextRecyclableChild(targetVg);
            final AsyncApplyTask task = this.mNestedViews.getInternalAsyncApplyTask(context, targetVg, null, params, null, null);
            final ViewTree tree = task.doInBackground(new Void[0]);
            if (tree == null) {
                throw new ActionException(task.mError);
            }
            if (this.mStableId != -1) {
                RemoteViews.setStableId(task.mResult, this.mStableId);
            }
            final int insertIndex = this.mIndex >= 0 ? this.mIndex : nextChild;
            target.addChild(tree, insertIndex);
            if (nextChild >= 0) {
                RemoteViews.setNextRecyclableChild(targetVg, nextChild + 1, target.mChildren.size());
            }
            return new RuntimeAction(this){

                @Override
                public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
                    task.onPostExecute(tree);
                    finalizeAction.run();
                    targetVg.addView(task.mResult, insertIndex);
                }
            };
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.mNestedViews.prefersAsyncApply();
        }

        @Override
        public int getActionTag() {
            return 4;
        }

        @Override
        public void visitUris(@NonNull Consumer<Uri> visitor) {
            this.mNestedViews.visitUris(visitor);
        }

        @Override
        public void visitIcons(@NonNull Consumer<Icon> visitor) {
            this.mNestedViews.visitIcons(visitor);
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            if (!Flags.remoteViewsProto()) {
                return;
            }
            long token = out.start(1146756268051L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464259L, this.mIndex);
            out.write(1120986464260L, this.mStableId);
            long rvToken = out.start(1146756268034L);
            this.mNestedViews.writePreviewToProto(context, out);
            out.end(rvToken);
            out.end(token);
        }
    }

    public static class RemoteCollectionItems
    implements Parcelable {
        private final long[] mIds;
        private final RemoteViews[] mViews;
        private final boolean mHasStableIds;
        private final int mViewTypeCount;
        private final boolean mHasLegacyNullItems;
        private HierarchyRootData mHierarchyRootData;
        @NonNull
        public static final Parcelable.Creator<RemoteCollectionItems> CREATOR = new Parcelable.Creator<RemoteCollectionItems>(){

            @Override
            @NonNull
            public RemoteCollectionItems createFromParcel(@NonNull Parcel source) {
                return new RemoteCollectionItems(source, null);
            }

            @NonNull
            public RemoteCollectionItems[] newArray(int size) {
                return new RemoteCollectionItems[size];
            }
        };

        RemoteCollectionItems(long[] ids, RemoteViews[] views, boolean hasStableIds, int viewTypeCount) {
            this(ids, views, hasStableIds, viewTypeCount, false);
        }

        RemoteCollectionItems(long[] ids, RemoteViews[] views, boolean hasStableIds, int viewTypeCount, boolean hasLegacyNullItems) {
            this.mIds = ids;
            this.mViews = views;
            this.mHasStableIds = hasStableIds;
            this.mViewTypeCount = viewTypeCount;
            this.mHasLegacyNullItems = hasLegacyNullItems;
            if (ids.length != views.length) {
                throw new IllegalArgumentException("RemoteCollectionItems has different number of ids and views");
            }
            if (viewTypeCount < 1) {
                throw new IllegalArgumentException("View type count must be >= 1");
            }
            int layoutIdCount = (int)Arrays.stream(views).mapToInt(RemoteViews::getLayoutId).distinct().count();
            if (layoutIdCount > viewTypeCount) {
                throw new IllegalArgumentException("View type count is set to " + viewTypeCount + ", but the collection contains " + layoutIdCount + " different layout ids");
            }
            if (views.length > 0) {
                this.setHierarchyRootData(views[0].getHierarchyRootData());
                views[0].mIsRoot = true;
            }
        }

        RemoteCollectionItems(@NonNull Parcel in, @Nullable HierarchyRootData hierarchyRootData) {
            int firstChildIndex;
            this.mHasStableIds = in.readBoolean();
            this.mViewTypeCount = in.readInt();
            this.mHasLegacyNullItems = in.readBoolean();
            int length = in.readInt();
            this.mIds = new long[length];
            in.readLongArray(this.mIds);
            boolean attached = in.readBoolean();
            this.mViews = new RemoteViews[length];
            if (attached) {
                if (hierarchyRootData == null) {
                    throw new IllegalStateException("Cannot unparcel a RemoteCollectionItems that was parceled as attached without providing data for a root RemoteViews");
                }
                this.mHierarchyRootData = hierarchyRootData;
                firstChildIndex = 0;
            } else {
                this.mViews[0] = new RemoteViews(in);
                this.mHierarchyRootData = this.mViews[0].getHierarchyRootData();
                firstChildIndex = 1;
            }
            for (int i = firstChildIndex; i < length; ++i) {
                this.mViews[i] = new RemoteViews(in, this.mHierarchyRootData, null, 0);
            }
        }

        void setHierarchyRootData(@NonNull HierarchyRootData rootData) {
            this.mHierarchyRootData = rootData;
            for (RemoteViews view : this.mViews) {
                view.configureAsChild(rootData);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.writeToParcel(dest, flags, false);
        }

        private void writeToParcel(@NonNull Parcel dest, int flags, boolean attached) {
            boolean prevAllowSquashing = dest.allowSquashing();
            dest.writeBoolean(this.mHasStableIds);
            dest.writeInt(this.mViewTypeCount);
            dest.writeBoolean(this.mHasLegacyNullItems);
            dest.writeInt(this.mIds.length);
            dest.writeLongArray(this.mIds);
            if (attached && this.mHierarchyRootData == null) {
                throw new IllegalStateException("Cannot call writeToParcelAttached for a RemoteCollectionItems without first calling setHierarchyRootData()");
            }
            dest.writeBoolean(attached);
            boolean restoreRoot = false;
            if (!attached && this.mViews.length > 0 && !this.mViews[0].mIsRoot) {
                restoreRoot = true;
                this.mViews[0].mIsRoot = true;
            }
            for (RemoteViews view : this.mViews) {
                view.writeToParcel(dest, flags);
            }
            if (restoreRoot) {
                this.mViews[0].mIsRoot = false;
            }
            dest.restoreAllowSquashing(prevAllowSquashing);
        }

        public void writeToProto(Context context, ProtoOutputStream out) {
            this.writeToProto(context, out, false);
        }

        private void writeToProto(Context context, ProtoOutputStream out, boolean attached) {
            for (long id2 : this.mIds) {
                out.write(5510443040769L, id2);
            }
            boolean restoreRoot = false;
            out.write(1133871366149L, attached);
            if (!attached && this.mViews.length > 0 && !this.mViews[0].mIsRoot) {
                restoreRoot = true;
                this.mViews[0].mIsRoot = true;
            }
            for (RemoteViews view : this.mViews) {
                long viewsToken = out.start(0x20B00000002L);
                view.writePreviewToProto(context, out);
                out.end(viewsToken);
            }
            if (restoreRoot) {
                this.mViews[0].mIsRoot = false;
            }
            out.write(1133871366147L, this.mHasStableIds);
            out.write(1120986464260L, this.mViewTypeCount);
        }

        public static RemoteCollectionItems createFromProto(Context context, ProtoInputStream in) throws Exception {
            return RemoteCollectionItems.createFromProto(in).create(context, context.getResources(), null, 0);
        }

        public static PendingResources<RemoteCollectionItems> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Serializable> values = new LongSparseArray<Serializable>();
            values.put(5510443040769L, new ArrayList());
            values.put(0x20B00000002L, new ArrayList());
            block7: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        ((ArrayList)values.get(5510443040769L)).add(in.readLong(5510443040769L));
                        continue block7;
                    }
                    case 2: {
                        long viewsToken = in.start(0x20B00000002L);
                        ((ArrayList)values.get(0x20B00000002L)).add(RemoteViews.createFromProto(in));
                        in.end(viewsToken);
                        continue block7;
                    }
                    case 3: {
                        values.put(1133871366147L, Boolean.valueOf(in.readBoolean(1133871366147L)));
                        continue block7;
                    }
                    case 4: {
                        values.put(1120986464260L, Integer.valueOf(in.readInt(1120986464260L)));
                        continue block7;
                    }
                    case 5: {
                        values.put(1133871366149L, Boolean.valueOf(in.readBoolean(1133871366149L)));
                        continue block7;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            RemoteViews.checkContainsKeys(values, new long[]{1120986464260L});
            return (context, resources, rootData, depth) -> {
                List idList = (List)values.get(5510443040769L);
                long[] ids = new long[idList.size()];
                for (int i = 0; i < idList.size(); ++i) {
                    ids[i] = (Long)idList.get(i);
                }
                boolean attached = values.get(1133871366149L, (Serializable)false);
                List pendingViews = (List)values.get(0x20B00000002L);
                RemoteViews[] views = new RemoteViews[pendingViews.size()];
                if (attached && rootData == null) {
                    throw new IllegalStateException("Cannot create a RemoteCollectionItems from proto that was attached without providing HierarchyRootData");
                }
                int firstChildIndex = 0;
                if (!attached && pendingViews.size() > 0) {
                    views[0] = (RemoteViews)((PendingResources)pendingViews.get(0)).create(context, resources, null, 0);
                    rootData = views[0].getHierarchyRootData();
                    firstChildIndex = 1;
                }
                for (int i = firstChildIndex; i < views.length; ++i) {
                    views[i] = (RemoteViews)((PendingResources)pendingViews.get(i)).create(context, resources, rootData, 0);
                }
                return new RemoteCollectionItems(ids, views, values.get(1133871366147L, (Serializable)false), values.get(1120986464260L, (Serializable)0));
            };
        }

        public long getItemId(int position) {
            return this.mIds[position];
        }

        @NonNull
        public RemoteViews getItemView(int position) {
            return this.mViews[position];
        }

        public int getItemCount() {
            return this.mIds.length;
        }

        public int getViewTypeCount() {
            return this.mViewTypeCount;
        }

        public boolean hasStableIds() {
            return this.mHasStableIds;
        }

        boolean hasLegacyNullItems() {
            return this.mHasLegacyNullItems;
        }

        private void visitUris(@NonNull Consumer<Uri> visitor) {
            for (RemoteViews view : this.mViews) {
                view.visitUris(visitor);
            }
        }

        private void visitIcons(@NonNull Consumer<Icon> visitor) {
            for (RemoteViews view : this.mViews) {
                view.visitIcons(visitor);
            }
        }

        public static class Builder {
            private final LongArray mIds = new LongArray();
            private final List<RemoteViews> mViews = new ArrayList<RemoteViews>();
            private boolean mHasStableIds;
            private int mViewTypeCount;
            private boolean mHasLegacyNullItems;

            @NonNull
            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            public Builder addItem(long id2, @NonNull RemoteViews view) {
                if (view == null) {
                    throw new NullPointerException();
                }
                if (view.hasMultipleLayouts()) {
                    throw new IllegalArgumentException("RemoteViews used in a RemoteCollectionItems cannot specify separate layouts for orientations or sizes.");
                }
                this.mIds.add(id2);
                this.mViews.add(view);
                return this;
            }

            @NonNull
            public Builder setHasStableIds(boolean hasStableIds) {
                this.mHasStableIds = hasStableIds;
                return this;
            }

            @NonNull
            public Builder setViewTypeCount(int viewTypeCount) {
                this.mViewTypeCount = viewTypeCount;
                return this;
            }

            @NonNull
            public Builder setHasLegacyNullItems(boolean hasLegacyNullItems) {
                this.mHasLegacyNullItems = hasLegacyNullItems;
                return this;
            }

            @NonNull
            public RemoteCollectionItems build() {
                if (this.mViewTypeCount < 1) {
                    this.mViewTypeCount = (int)this.mViews.stream().mapToInt(RemoteViews::getLayoutId).distinct().count();
                }
                return new RemoteCollectionItems(this.mIds.toArray(), this.mViews.toArray(new RemoteViews[0]), this.mHasStableIds, Math.max(this.mViewTypeCount, 1), this.mHasLegacyNullItems);
            }
        }
    }

    static interface PendingResources<T> {
        public T create(Context var1, Resources var2, HierarchyRootData var3, int var4) throws Exception;
    }

    static class MethodKey {
        public Class targetClass;
        public Class paramClass;
        public String methodName;

        MethodKey() {
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey p = (MethodKey)o;
            return Objects.equals(p.targetClass, this.targetClass) && Objects.equals(p.paramClass, this.paramClass) && Objects.equals(p.methodName, this.methodName);
        }

        public int hashCode() {
            return Objects.hashCode(this.targetClass) ^ Objects.hashCode(this.paramClass) ^ Objects.hashCode(this.methodName);
        }

        public void set(Class targetClass, Class paramClass, String methodName) {
            this.targetClass = targetClass;
            this.paramClass = paramClass;
            this.methodName = methodName;
        }
    }

    static class MethodArgs {
        public MethodHandle syncMethod;
        public MethodHandle asyncMethod;
        public String asyncMethodName;

        MethodArgs() {
        }
    }

    public static class ActionException
    extends RuntimeException {
        public ActionException(Exception ex) {
            super(ex);
        }

        public ActionException(String message) {
            super(message);
        }

        public ActionException(Throwable t) {
            super(t);
        }
    }

    private static class ApplicationInfoCache {
        private final Map<Pair<String, Integer>, ApplicationInfo> mPackageUserToApplicationInfo = new ArrayMap<Pair<String, Integer>, ApplicationInfo>();

        ApplicationInfoCache() {
        }

        @Nullable
        ApplicationInfo getOrPut(@Nullable ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return null;
            }
            return this.mPackageUserToApplicationInfo.computeIfAbsent(key, ignored -> applicationInfo);
        }

        void put(@Nullable ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return;
            }
            this.mPackageUserToApplicationInfo.put(key, applicationInfo);
        }

        @Nullable
        ApplicationInfo get(@Nullable ApplicationInfo applicationInfo) {
            Pair<String, Integer> key = RemoteViews.getPackageUserKey(applicationInfo);
            if (key == null) {
                return null;
            }
            return this.mPackageUserToApplicationInfo.get(key);
        }
    }

    private static class HierarchyRootData {
        final BitmapCache mBitmapCache;
        final RemoteCollectionCache mRemoteCollectionCache;
        final ApplicationInfoCache mApplicationInfoCache;
        final Map<Class, Object> mClassCookies;

        HierarchyRootData(BitmapCache bitmapCache, RemoteCollectionCache remoteCollectionCache, ApplicationInfoCache applicationInfoCache, Map<Class, Object> classCookies) {
            this.mBitmapCache = bitmapCache;
            this.mRemoteCollectionCache = remoteCollectionCache;
            this.mApplicationInfoCache = applicationInfoCache;
            this.mClassCookies = classCookies;
        }
    }

    private class SetDrawInstructionAction
    extends Action {
        @Nullable
        private final DrawInstructions mInstructions;

        SetDrawInstructionAction(DrawInstructions instructions) {
            this.mInstructions = instructions;
        }

        SetDrawInstructionAction(Parcel in) {
            this.mInstructions = Flags.drawDataParcel() ? DrawInstructions.readFromParcel(in) : null;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            if (Flags.drawDataParcel()) {
                DrawInstructions.writeToParcel(this.mInstructions, dest, flags);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
            if (Flags.drawDataParcel() && this.mInstructions != null && root instanceof RemoteComposePlayer) {
                RemoteComposePlayer player = (RemoteComposePlayer)root;
                List<byte[]> bytes = this.mInstructions.mInstructions;
                if (bytes.isEmpty()) {
                    return;
                }
                try (ByteArrayInputStream is = new ByteArrayInputStream(bytes.get(0));){
                    player.setDocument(new RemoteComposeDocument(is));
                    player.addIdActionListener((viewId, metadata) -> RemoteViews.this.mActions.forEach(action -> {
                        if (viewId == action.mViewId && action instanceof SetOnClickResponse) {
                            SetOnClickResponse setOnClickResponse = (SetOnClickResponse)action;
                            RemoteResponse response = setOnClickResponse.mResponse;
                            if (response.mFillIntent == null) {
                                response.mFillIntent = new Intent();
                            }
                            response.mFillIntent.putExtra("remotecompose_metadata", metadata);
                            response.handleViewInteraction(player, params.handler);
                        }
                    }));
                }
                catch (IOException e) {
                    Log.e(RemoteViews.LOG_TAG, "Failed to render draw instructions", e);
                }
            }
        }

        @Override
        public int getActionTag() {
            return 35;
        }

        @Override
        public boolean canWriteToProto() {
            return Flags.drawDataParcel();
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            if (!Flags.drawDataParcel()) {
                return;
            }
            long token = out.start(1146756268054L);
            if (this.mInstructions != null) {
                for (byte[] bytes : this.mInstructions.mInstructions) {
                    out.write(2250562863105L, bytes);
                }
            }
            out.end(token);
        }
    }

    @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
    public static class DrawInstructions {
        private static final long VERSION = 1L;
        @NonNull
        final List<byte[]> mInstructions;

        private DrawInstructions() {
            throw new UnsupportedOperationException("DrawInstructions cannot be instantiate without instructions");
        }

        private DrawInstructions(@NonNull List<byte[]> instructions) {
            this.mInstructions = new ArrayList<byte[]>(instructions.size());
            for (byte[] instruction : instructions) {
                int len = instruction.length;
                byte[] target = new byte[len];
                System.arraycopy(instruction, 0, target, 0, len);
                this.mInstructions.add(target);
            }
        }

        @Nullable
        private static DrawInstructions readFromParcel(@NonNull Parcel in) {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            ArrayList<byte[]> instructions = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                byte[] instruction = in.readBlob();
                instructions.add(instruction);
            }
            return new DrawInstructions(instructions);
        }

        private static void writeToParcel(@Nullable DrawInstructions drawInstructions, @NonNull Parcel dest, int flags) {
            if (drawInstructions == null) {
                dest.writeInt(-1);
                return;
            }
            List<byte[]> instructions = drawInstructions.mInstructions;
            dest.writeInt(instructions.size());
            for (byte[] instruction : instructions) {
                dest.writeBlob(instruction);
            }
        }

        @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
        public static long getSupportedVersion() {
            return CoreDocument.getDocumentApiLevel();
        }

        @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
        public static class Builder {
            private final List<byte[]> mInstructions;

            @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
            public Builder(@NonNull List<byte[]> instructions) {
                this.mInstructions = new ArrayList<byte[]>(instructions);
            }

            @NonNull
            @FlaggedApi(value="android.appwidget.flags.draw_data_parcel")
            public DrawInstructions build() {
                return new DrawInstructions(this.mInstructions);
            }
        }
    }

    private class SetOnClickResponse
    extends Action {
        final RemoteResponse mResponse;

        SetOnClickResponse(int id2, RemoteResponse response) {
            this.mViewId = id2;
            this.mResponse = response;
        }

        SetOnClickResponse(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mResponse = new RemoteResponse();
            this.mResponse.readFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            this.mResponse.writeToParcel(dest, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            if (RemoteViews.this.hasDrawInstructions() && root instanceof RemoteComposePlayer) {
                return;
            }
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (this.mResponse.mPendingIntent != null) {
                if (RemoteViews.this.hasFlags(2)) {
                    Log.w(RemoteViews.LOG_TAG, "Cannot SetOnClickResponse for collection item (id: " + this.mViewId + ")");
                    ApplicationInfo appInfo = root.getContext().getApplicationInfo();
                    if (appInfo != null && appInfo.targetSdkVersion >= 16) {
                        return;
                    }
                }
                ((View)target).setTagInternal(16909414, this.mResponse.mPendingIntent);
            } else if (this.mResponse.mFillIntent != null) {
                if (!RemoteViews.this.hasFlags(2)) {
                    Log.e(RemoteViews.LOG_TAG, "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                    return;
                }
                if (target == root) {
                    ((View)target).setTagInternal(16909068, this.mResponse);
                    return;
                }
            } else {
                ((View)target).setOnClickListener(null);
                ((View)target).setTagInternal(16909414, null);
                ((View)target).setTagInternal(16909068, null);
                return;
            }
            ((View)target).setOnClickListener(v -> this.mResponse.handleViewInteraction(v, params.handler));
        }

        @Override
        public int getActionTag() {
            return 1;
        }
    }

    private static class SetDrawableTint
    extends Action {
        boolean mTargetBackground;
        int mColorFilter;
        PorterDuff.Mode mFilterMode;

        SetDrawableTint(int id2, boolean targetBackground, int colorFilter, @NonNull PorterDuff.Mode mode) {
            this.mViewId = id2;
            this.mTargetBackground = targetBackground;
            this.mColorFilter = colorFilter;
            this.mFilterMode = mode;
        }

        SetDrawableTint(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mTargetBackground = parcel.readInt() != 0;
            this.mColorFilter = parcel.readInt();
            this.mFilterMode = PorterDuff.intToMode(parcel.readInt());
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mTargetBackground ? 1 : 0);
            dest.writeInt(this.mColorFilter);
            dest.writeInt(PorterDuff.modeToInt(this.mFilterMode));
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.mTargetBackground) {
                targetDrawable = ((View)target).getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (targetDrawable != null) {
                targetDrawable.mutate().setColorFilter(this.mColorFilter, this.mFilterMode);
            }
        }

        @Override
        public int getActionTag() {
            return 3;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268042L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464259L, this.mColorFilter);
            out.write(1120986464260L, PorterDuff.modeToInt(this.mFilterMode));
            out.write(1133871366146L, this.mTargetBackground);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268042L);
            block6: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block6;
                    }
                    case 2: {
                        values.put(1133871366146L, in.readBoolean(1133871366146L));
                        continue block6;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block6;
                    }
                    case 4: {
                        values.put(1120986464260L, (Object)PorterDuff.intToMode(in.readInt(1120986464260L)));
                        continue block6;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new SetDrawableTint(viewId, values.get(1133871366146L, false), values.get(1120986464259L, 0), (PorterDuff.Mode)((Object)((Object)values.get(1120986464260L))));
            };
        }
    }

    private static class ReflectionAction
    extends BaseReflectionAction {
        @UnsupportedAppUsage
        Object mValue;

        ReflectionAction(int viewId, String methodName, int type, Object value) {
            super(viewId, methodName, type);
            this.mValue = value;
        }

        ReflectionAction(Parcel in) {
            super(in);
            switch (this.mType) {
                case 1: {
                    this.mValue = in.readBoolean();
                    break;
                }
                case 2: {
                    this.mValue = in.readByte();
                    break;
                }
                case 3: {
                    this.mValue = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.mValue = in.readInt();
                    break;
                }
                case 5: {
                    this.mValue = in.readLong();
                    break;
                }
                case 6: {
                    this.mValue = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.mValue = in.readDouble();
                    break;
                }
                case 8: {
                    this.mValue = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.mValue = in.readString8();
                    break;
                }
                case 10: {
                    this.mValue = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    this.mValue = in.readTypedObject(Uri.CREATOR);
                    break;
                }
                case 12: {
                    this.mValue = in.readTypedObject(Bitmap.CREATOR);
                    break;
                }
                case 13: {
                    if (in.hasReadWriteHelper()) {
                        this.mValue = in.readBundle();
                        break;
                    }
                    in.setReadWriteHelper(ALTERNATIVE_DEFAULT);
                    this.mValue = in.readBundle();
                    in.setReadWriteHelper(null);
                    break;
                }
                case 14: {
                    this.mValue = in.readTypedObject(Intent.CREATOR);
                    break;
                }
                case 15: {
                    this.mValue = in.readTypedObject(ColorStateList.CREATOR);
                    break;
                }
                case 16: {
                    this.mValue = in.readTypedObject(Icon.CREATOR);
                    break;
                }
                case 17: {
                    this.mValue = BlendMode.fromValue(in.readInt());
                    break;
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            switch (this.mType) {
                case 1: {
                    out.writeBoolean((Boolean)this.mValue);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.mValue);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.mValue).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.mValue);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.mValue);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.mValue).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.mValue);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.mValue).charValue());
                    break;
                }
                case 9: {
                    out.writeString8((String)this.mValue);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.mValue, out, flags);
                    break;
                }
                case 13: {
                    out.writeBundle((Bundle)this.mValue);
                    break;
                }
                case 17: {
                    out.writeInt(BlendMode.toValue((BlendMode)((Object)this.mValue)));
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    out.writeTypedObject((Parcelable)this.mValue, flags);
                    break;
                }
            }
        }

        @Override
        @Nullable
        protected Object getParameterValue(@Nullable View view) throws ActionException {
            return this.mValue;
        }

        @Override
        public int getActionTag() {
            return 2;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268038L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(1120986464259L, this.mType);
            if (this.mValue != null) {
                switch (this.mType) {
                    case 1: {
                        out.write(1133871366148L, (Boolean)this.mValue);
                        break;
                    }
                    case 2: {
                        out.write(1151051235333L, new byte[]{(Byte)this.mValue});
                        break;
                    }
                    case 3: {
                        out.write(1120986464262L, ((Short)this.mValue).shortValue());
                        break;
                    }
                    case 4: {
                        out.write(1120986464263L, (Integer)this.mValue);
                        break;
                    }
                    case 5: {
                        out.write(1112396529672L, (Long)this.mValue);
                        break;
                    }
                    case 6: {
                        out.write(1108101562377L, ((Float)this.mValue).floatValue());
                        break;
                    }
                    case 7: {
                        out.write(0x1010000000AL, (Double)this.mValue);
                        break;
                    }
                    case 8: {
                        out.write(1120986464267L, ((Character)this.mValue).charValue());
                        break;
                    }
                    case 9: {
                        out.write(1138166333452L, (String)this.mValue);
                        break;
                    }
                    case 10: {
                        long csToken = out.start(1146756268045L);
                        RemoteViewsSerializers.writeCharSequenceToProto(out, (CharSequence)this.mValue);
                        out.end(csToken);
                        break;
                    }
                    case 11: {
                        out.write(1138166333454L, ((Uri)this.mValue).toString());
                        break;
                    }
                    case 12: {
                        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                        ((Bitmap)this.mValue).compress(Bitmap.CompressFormat.WEBP_LOSSLESS, 100, bytes);
                        out.write(1151051235343L, bytes.toByteArray());
                        break;
                    }
                    case 17: {
                        out.write(1120986464274L, BlendMode.toValue((BlendMode)((Object)this.mValue)));
                        break;
                    }
                    case 15: {
                        RemoteViews.writeColorStateListToProto(out, (ColorStateList)this.mValue, 0x10B00000010L);
                        break;
                    }
                    case 16: {
                        RemoteViews.writeIconToProto(out, appResources, (Icon)this.mValue, 0x10B00000011L);
                        break;
                    }
                }
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268038L);
            block20: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block20;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block20;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block20;
                    }
                    case 4: {
                        values.put(1133871366148L, in.readBoolean(1133871366148L));
                        continue block20;
                    }
                    case 5: {
                        values.put(1151051235333L, in.readBytes(1151051235333L));
                        continue block20;
                    }
                    case 6: {
                        values.put(1120986464262L, (short)in.readInt(1120986464262L));
                        continue block20;
                    }
                    case 7: {
                        values.put(1120986464263L, in.readInt(1120986464263L));
                        continue block20;
                    }
                    case 8: {
                        values.put(1112396529672L, in.readLong(1112396529672L));
                        continue block20;
                    }
                    case 9: {
                        values.put(1108101562377L, Float.valueOf(in.readFloat(1108101562377L)));
                        continue block20;
                    }
                    case 10: {
                        values.put(0x1010000000AL, in.readDouble(0x1010000000AL));
                        continue block20;
                    }
                    case 11: {
                        values.put(1120986464267L, Character.valueOf((char)in.readInt(1120986464267L)));
                        continue block20;
                    }
                    case 12: {
                        values.put(1138166333452L, in.readString(1138166333452L));
                        continue block20;
                    }
                    case 13: {
                        values.put(1146756268045L, RemoteViews.createCharSequenceFromProto(in, 1146756268045L));
                        continue block20;
                    }
                    case 14: {
                        values.put(1138166333454L, in.readString(1138166333454L));
                        continue block20;
                    }
                    case 15: {
                        byte[] bitmapData = in.readBytes(1151051235343L);
                        values.put(1151051235343L, BitmapFactory.decodeByteArray(bitmapData, 0, bitmapData.length));
                        continue block20;
                    }
                    case 16: {
                        values.put(0x10B00000010L, RemoteViews.createColorStateListFromProto(in, 0x10B00000010L));
                        continue block20;
                    }
                    case 17: {
                        values.put(0x10B00000011L, RemoteViews.createIconFromProto(in, 0x10B00000011L));
                        continue block20;
                    }
                    case 18: {
                        values.put(1120986464274L, (Object)BlendMode.fromValue(in.readInt(1120986464274L)));
                        continue block20;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L, 1120986464259L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                Object value = null;
                int parameterType = (Integer)values.get(1120986464259L);
                switch (parameterType) {
                    case 1: {
                        value = (boolean)values.get(1133871366148L, false);
                        break;
                    }
                    case 2: {
                        byte[] bytes = (byte[])values.get(1151051235333L);
                        if (bytes == null || bytes.length <= 0) break;
                        value = bytes[0];
                        break;
                    }
                    case 3: {
                        value = (short)((Short)((Object)values.get(1120986464262L, 0)));
                        break;
                    }
                    case 4: {
                        value = (int)values.get(1120986464263L, 0);
                        break;
                    }
                    case 5: {
                        value = (long)((Long)((Object)values.get(1112396529672L, 0)));
                        break;
                    }
                    case 6: {
                        value = Float.valueOf(((Float)((Object)values.get(1108101562377L, 0))).floatValue());
                        break;
                    }
                    case 7: {
                        value = (double)((Double)((Object)values.get(0x1010000000AL, 0)));
                        break;
                    }
                    case 8: {
                        value = Character.valueOf(((Character)((Object)values.get(1120986464267L, 0))).charValue());
                        break;
                    }
                    case 9: {
                        value = (String)values.get(1138166333452L);
                        break;
                    }
                    case 10: {
                        value = (CharSequence)values.get(1146756268045L);
                        break;
                    }
                    case 11: {
                        value = Uri.parse((String)values.get(1138166333454L));
                        break;
                    }
                    case 12: {
                        value = (Bitmap)values.get(1151051235343L);
                        break;
                    }
                    case 17: {
                        value = (BlendMode)((Object)((Object)values.get(1120986464274L)));
                        break;
                    }
                    case 15: {
                        value = (ColorStateList)values.get(0x10B00000010L);
                        break;
                    }
                    case 16: {
                        value = ((PendingResources)values.get(0x10B00000011L)).create(context, resources, rootData, depth);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new ReflectionAction(viewId, (String)values.get(1138166333442L), parameterType, value);
            };
        }
    }

    private static class ViewGroupActionRemove
    extends Action {
        private static final int REMOVE_ALL_VIEWS_ID = -2;
        private int mViewIdToKeep;

        ViewGroupActionRemove(int viewId) {
            this(viewId, -2);
        }

        ViewGroupActionRemove(int viewId, int viewIdToKeep) {
            this.mViewId = viewId;
            this.mViewIdToKeep = viewIdToKeep;
        }

        ViewGroupActionRemove(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mViewIdToKeep = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mViewIdToKeep);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            ViewGroup target = (ViewGroup)root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (this.mViewIdToKeep == -2) {
                for (int i = target.getChildCount() - 1; i >= 0; --i) {
                    if (RemoteViews.hasStableId(target.getChildAt(i))) continue;
                    target.removeViewAt(i);
                }
                RemoteViews.setNextRecyclableChild(target, 0, target.getChildCount());
                return;
            }
            this.removeAllViewsExceptIdToKeep(target);
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            root.createTree();
            ViewTree target = root.findViewTreeById(this.mViewId);
            if (target == null || !(target.mRoot instanceof ViewGroup)) {
                return ACTION_NOOP;
            }
            final ViewGroup targetVg = (ViewGroup)target.mRoot;
            if (this.mViewIdToKeep == -2) {
                target.mChildren.removeIf(childTree -> !RemoteViews.hasStableId(childTree.mRoot));
                RemoteViews.setNextRecyclableChild(targetVg, 0, target.mChildren.size());
            } else {
                target.mChildren.removeIf(childTree -> childTree.mRoot.getId() != this.mViewIdToKeep);
                if (target.mChildren.isEmpty()) {
                    target.mChildren = null;
                }
            }
            return new RuntimeAction(){

                @Override
                public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
                    if (mViewIdToKeep == -2) {
                        for (int i = targetVg.getChildCount() - 1; i >= 0; --i) {
                            if (RemoteViews.hasStableId(targetVg.getChildAt(i))) continue;
                            targetVg.removeViewAt(i);
                        }
                        return;
                    }
                    this.removeAllViewsExceptIdToKeep(targetVg);
                }
            };
        }

        private void removeAllViewsExceptIdToKeep(ViewGroup viewGroup) {
            for (int index = viewGroup.getChildCount() - 1; index >= 0; --index) {
                if (viewGroup.getChildAt(index).getId() == this.mViewIdToKeep) continue;
                viewGroup.removeViewAt(index);
            }
        }

        @Override
        public int getActionTag() {
            return 7;
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268052L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            if (this.mViewIdToKeep != -2) {
                out.write(1138166333442L, appResources.getResourceName(this.mViewIdToKeep));
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<String> values = new LongSparseArray<String>();
            long token = in.start(1146756268052L);
            block4: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block4;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block4;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int viewIdToKeep = values.indexOfKey(1138166333442L) >= 0 ? RemoteViews.getAsIdentifier(resources, values, 1138166333442L) : -2;
                return new ViewGroupActionRemove(viewId, viewIdToKeep);
            };
        }
    }

    @Deprecated
    private class ViewContentNavigation
    extends Action {
        final boolean mNext;

        ViewContentNavigation(RemoteViews remoteViews, int viewId, boolean next) {
            this.mViewId = viewId;
            this.mNext = next;
        }

        ViewContentNavigation(RemoteViews remoteViews, Parcel in) {
            this.mViewId = in.readInt();
            this.mNext = in.readBoolean();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mViewId);
            out.writeBoolean(this.mNext);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object view = root.findViewById(this.mViewId);
            if (view == null) {
                return;
            }
            try {
                RemoteViews.getMethod(view, this.mNext ? "showNext" : "showPrevious", null, false).invoke((View)view);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public int mergeBehavior() {
            return 2;
        }

        @Override
        public int getActionTag() {
            return 5;
        }
    }

    private static class SetEmptyView
    extends Action {
        int mEmptyViewId;

        SetEmptyView(int viewId, int emptyViewId) {
            this.mViewId = viewId;
            this.mEmptyViewId = emptyViewId;
        }

        SetEmptyView(Parcel in) {
            this.mViewId = in.readInt();
            this.mEmptyViewId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mViewId);
            out.writeInt(this.mEmptyViewId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object view = root.findViewById(this.mViewId);
            if (!(view instanceof AdapterView)) {
                return;
            }
            AdapterView adapterView = (AdapterView)view;
            Object emptyView = root.findViewById(this.mEmptyViewId);
            if (emptyView == null) {
                return;
            }
            adapterView.setEmptyView((View)emptyView);
        }

        @Override
        public int getActionTag() {
            return 6;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(0x10B0000000BL);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, appResources.getResourceName(this.mEmptyViewId));
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<String> values = new LongSparseArray<String>();
            long token = in.start(0x10B0000000BL);
            block4: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block4;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block4;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int emptyViewId = RemoteViews.getAsIdentifier(resources, values, 1138166333442L);
                return new SetEmptyView(viewId, emptyViewId);
            };
        }
    }

    private static class SetPendingIntentTemplate
    extends Action {
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        PendingIntent mPendingIntentTemplate;

        public SetPendingIntentTemplate(int id2, PendingIntent pendingIntentTemplate) {
            this.mViewId = id2;
            this.mPendingIntentTemplate = pendingIntentTemplate;
        }

        public SetPendingIntentTemplate(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mPendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            PendingIntent.writePendingIntentOrNullToParcel(this.mPendingIntentTemplate, dest);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e(RemoteViews.LOG_TAG, "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.mViewId + ")");
                return;
            }
            AdapterView av = (AdapterView)target;
            AdapterView.OnItemClickListener listener = (parent, view, position, id2) -> {
                RemoteResponse response = this.findRemoteResponseTag(view);
                if (response != null) {
                    response.handleViewInteraction(view, params.handler);
                }
            };
            av.setOnItemClickListener(listener);
            av.setTag(this.mPendingIntentTemplate);
        }

        @Nullable
        private RemoteResponse findRemoteResponseTag(@Nullable View rootView) {
            if (rootView == null) {
                return null;
            }
            ArrayDeque<View> viewsToCheck = new ArrayDeque<View>();
            viewsToCheck.addLast(rootView);
            while (!viewsToCheck.isEmpty()) {
                View view = (View)viewsToCheck.removeFirst();
                Object tag = view.getTag(16909068);
                if (tag instanceof RemoteResponse) {
                    return (RemoteResponse)tag;
                }
                if (!(view instanceof ViewGroup)) continue;
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    viewsToCheck.addLast(viewGroup.getChildAt(i));
                }
            }
            return null;
        }

        @Override
        public int getActionTag() {
            return 8;
        }
    }

    private static class TextViewDrawableAction
    extends Action {
        boolean mIsRelative = false;
        boolean mUseIcons = false;
        int mD1;
        int mD2;
        int mD3;
        int mD4;
        Icon mI1;
        Icon mI2;
        Icon mI3;
        Icon mI4;
        boolean mDrawablesLoaded = false;
        Drawable mId1;
        Drawable mId2;
        Drawable mId3;
        Drawable mId4;

        public TextViewDrawableAction(int viewId, boolean isRelative, int d1, int d2, int d3, int d4) {
            this.mViewId = viewId;
            this.mIsRelative = isRelative;
            this.mUseIcons = false;
            this.mD1 = d1;
            this.mD2 = d2;
            this.mD3 = d3;
            this.mD4 = d4;
        }

        public TextViewDrawableAction(int viewId, boolean isRelative, Icon i1, Icon i2, Icon i3, Icon i4) {
            this.mViewId = viewId;
            this.mIsRelative = isRelative;
            this.mUseIcons = true;
            this.mI1 = i1;
            this.mI2 = i2;
            this.mI3 = i3;
            this.mI4 = i4;
        }

        public TextViewDrawableAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mIsRelative = parcel.readInt() != 0;
            boolean bl = this.mUseIcons = parcel.readInt() != 0;
            if (this.mUseIcons) {
                this.mI1 = parcel.readTypedObject(Icon.CREATOR);
                this.mI2 = parcel.readTypedObject(Icon.CREATOR);
                this.mI3 = parcel.readTypedObject(Icon.CREATOR);
                this.mI4 = parcel.readTypedObject(Icon.CREATOR);
            } else {
                this.mD1 = parcel.readInt();
                this.mD2 = parcel.readInt();
                this.mD3 = parcel.readInt();
                this.mD4 = parcel.readInt();
            }
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mIsRelative ? 1 : 0);
            dest.writeInt(this.mUseIcons ? 1 : 0);
            if (this.mUseIcons) {
                dest.writeTypedObject(this.mI1, 0);
                dest.writeTypedObject(this.mI2, 0);
                dest.writeTypedObject(this.mI3, 0);
                dest.writeTypedObject(this.mI4, 0);
            } else {
                dest.writeInt(this.mD1);
                dest.writeInt(this.mD2);
                dest.writeInt(this.mD3);
                dest.writeInt(this.mD4);
            }
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            TextView target = (TextView)root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (this.mDrawablesLoaded) {
                if (this.mIsRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.mId1, this.mId2, this.mId3, this.mId4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(this.mId1, this.mId2, this.mId3, this.mId4);
                }
            } else if (this.mUseIcons) {
                Drawable id4;
                Context ctx = target.getContext();
                Drawable id1 = this.mI1 == null ? null : this.mI1.loadDrawable(ctx);
                Drawable id2 = this.mI2 == null ? null : this.mI2.loadDrawable(ctx);
                Drawable id3 = this.mI3 == null ? null : this.mI3.loadDrawable(ctx);
                Drawable drawable2 = id4 = this.mI4 == null ? null : this.mI4.loadDrawable(ctx);
                if (this.mIsRelative) {
                    target.setCompoundDrawablesRelativeWithIntrinsicBounds(id1, id2, id3, id4);
                } else {
                    target.setCompoundDrawablesWithIntrinsicBounds(id1, id2, id3, id4);
                }
            } else if (this.mIsRelative) {
                target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.mD1, this.mD2, this.mD3, this.mD4);
            } else {
                target.setCompoundDrawablesWithIntrinsicBounds(this.mD1, this.mD2, this.mD3, this.mD4);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            TextView target = (TextView)root.findViewById(this.mViewId);
            if (target == null) {
                return ACTION_NOOP;
            }
            TextViewDrawableAction copy = this.mUseIcons ? new TextViewDrawableAction(this.mViewId, this.mIsRelative, this.mI1, this.mI2, this.mI3, this.mI4) : new TextViewDrawableAction(this.mViewId, this.mIsRelative, this.mD1, this.mD2, this.mD3, this.mD4);
            copy.mDrawablesLoaded = true;
            Context ctx = target.getContext();
            if (this.mUseIcons) {
                copy.mId1 = this.mI1 == null ? null : this.mI1.loadDrawable(ctx);
                copy.mId2 = this.mI2 == null ? null : this.mI2.loadDrawable(ctx);
                copy.mId3 = this.mI3 == null ? null : this.mI3.loadDrawable(ctx);
                copy.mId4 = this.mI4 == null ? null : this.mI4.loadDrawable(ctx);
            } else {
                copy.mId1 = this.mD1 == 0 ? null : ctx.getDrawable(this.mD1);
                copy.mId2 = this.mD2 == 0 ? null : ctx.getDrawable(this.mD2);
                copy.mId3 = this.mD3 == 0 ? null : ctx.getDrawable(this.mD3);
                copy.mId4 = this.mD4 == 0 ? null : ctx.getDrawable(this.mD4);
            }
            return copy;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.mUseIcons;
        }

        @Override
        public int getActionTag() {
            return 11;
        }

        @Override
        public void visitUris(@NonNull Consumer<Uri> visitor) {
            if (this.mUseIcons) {
                RemoteViews.visitIconUri(this.mI1, visitor);
                RemoteViews.visitIconUri(this.mI2, visitor);
                RemoteViews.visitIconUri(this.mI3, visitor);
                RemoteViews.visitIconUri(this.mI4, visitor);
            }
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(0x10B00000011L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1133871366146L, this.mIsRelative);
            if (this.mUseIcons) {
                long iconsToken = out.start(1146756268036L);
                if (this.mI1 != null) {
                    RemoteViews.writeIconToProto(out, appResources, this.mI1, 0x10B00000001L);
                }
                if (this.mI2 != null) {
                    RemoteViews.writeIconToProto(out, appResources, this.mI2, 1146756268034L);
                }
                if (this.mI3 != null) {
                    RemoteViews.writeIconToProto(out, appResources, this.mI3, 1146756268035L);
                }
                if (this.mI4 != null) {
                    RemoteViews.writeIconToProto(out, appResources, this.mI4, 1146756268036L);
                }
                out.end(iconsToken);
            } else {
                long resourcesToken = out.start(1146756268035L);
                if (this.mD1 != 0) {
                    out.write(0x10900000001L, appResources.getResourceName(this.mD1));
                }
                if (this.mD2 != 0) {
                    out.write(1138166333442L, appResources.getResourceName(this.mD2));
                }
                if (this.mD3 != 0) {
                    out.write(1138166333443L, appResources.getResourceName(this.mD3));
                }
                if (this.mD4 != 0) {
                    out.write(1138166333444L, appResources.getResourceName(this.mD4));
                }
                out.end(resourcesToken);
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            values.put(1146756268036L, new SparseArray());
            values.put(1146756268035L, new SparseArray());
            long token = in.start(0x10B00000011L);
            block18: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block18;
                    }
                    case 2: {
                        values.put(1133871366146L, in.readBoolean(1133871366146L));
                        continue block18;
                    }
                    case 3: {
                        long resourcesToken = in.start(1146756268035L);
                        block19: while (in.nextField() != -1) {
                            switch (in.getFieldNumber()) {
                                case 1: {
                                    ((SparseArray)values.get(1146756268035L)).put(1, in.readString(0x10900000001L));
                                    continue block19;
                                }
                                case 2: {
                                    ((SparseArray)values.get(1146756268035L)).put(2, in.readString(1138166333442L));
                                    continue block19;
                                }
                                case 3: {
                                    ((SparseArray)values.get(1146756268035L)).put(3, in.readString(1138166333443L));
                                    continue block19;
                                }
                                case 4: {
                                    ((SparseArray)values.get(1146756268035L)).put(4, in.readString(1138166333444L));
                                    continue block19;
                                }
                            }
                            Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
                        }
                        in.end(resourcesToken);
                        continue block18;
                    }
                    case 4: {
                        long iconsToken = in.start(1146756268036L);
                        block20: while (in.nextField() != -1) {
                            switch (in.getFieldNumber()) {
                                case 1: {
                                    ((SparseArray)values.get(1146756268036L)).put(1, RemoteViews.createIconFromProto(in, 0x10B00000001L));
                                    continue block20;
                                }
                                case 2: {
                                    ((SparseArray)values.get(1146756268036L)).put(2, RemoteViews.createIconFromProto(in, 1146756268034L));
                                    continue block20;
                                }
                                case 3: {
                                    ((SparseArray)values.get(1146756268036L)).put(3, RemoteViews.createIconFromProto(in, 1146756268035L));
                                    continue block20;
                                }
                                case 4: {
                                    ((SparseArray)values.get(1146756268036L)).put(4, RemoteViews.createIconFromProto(in, 1146756268036L));
                                    continue block20;
                                }
                            }
                            Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
                        }
                        in.end(iconsToken);
                        continue block18;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                SparseArray icons = (SparseArray)values.get(1146756268036L);
                SparseArray resArray = (SparseArray)values.get(1146756268035L);
                boolean isRelative = values.get(1133871366146L, false);
                if (icons.size() > 0) {
                    return new TextViewDrawableAction(viewId, isRelative, (Icon)((PendingResources)icons.get(1)).create(context, resources, rootData, depth), (Icon)((PendingResources)icons.get(2)).create(context, resources, rootData, depth), (Icon)((PendingResources)icons.get(3)).create(context, resources, rootData, depth), (Icon)((PendingResources)icons.get(4)).create(context, resources, rootData, depth));
                }
                int first = resArray.contains(1) ? RemoteViews.getAsIdentifier(resources, resArray, 1) : 0;
                int second = resArray.contains(2) ? RemoteViews.getAsIdentifier(resources, resArray, 2) : 0;
                int third = resArray.contains(3) ? RemoteViews.getAsIdentifier(resources, resArray, 3) : 0;
                int fourth = resArray.contains(4) ? RemoteViews.getAsIdentifier(resources, resArray, 4) : 0;
                return new TextViewDrawableAction(viewId, isRelative, first, second, third, fourth);
            };
        }
    }

    private static class TextViewSizeAction
    extends Action {
        int mUnits;
        float mSize;

        TextViewSizeAction(int viewId, int units, float size) {
            this.mViewId = viewId;
            this.mUnits = units;
            this.mSize = size;
        }

        TextViewSizeAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mUnits = parcel.readInt();
            this.mSize = parcel.readFloat();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mUnits);
            dest.writeFloat(this.mSize);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            TextView target = (TextView)root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            target.setTextSize(this.mUnits, this.mSize);
        }

        @Override
        public int getActionTag() {
            return 13;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268050L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464258L, this.mUnits);
            out.write(1108101562371L, this.mSize);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268050L);
            block5: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block5;
                    }
                    case 2: {
                        values.put(1120986464258L, in.readInt(1120986464258L));
                        continue block5;
                    }
                    case 3: {
                        values.put(1108101562371L, Float.valueOf(in.readFloat(1108101562371L)));
                        continue block5;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new TextViewSizeAction(viewId, values.get(1120986464258L, 0), ((Float)((Object)values.get(1108101562371L, 0))).floatValue());
            };
        }
    }

    private static class ViewPaddingAction
    extends Action {
        int mLeft;
        int mTop;
        int mRight;
        int mBottom;

        public ViewPaddingAction(int viewId, int left, int top, int right, int bottom) {
            this.mViewId = viewId;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
        }

        public ViewPaddingAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mLeft = parcel.readInt();
            this.mTop = parcel.readInt();
            this.mRight = parcel.readInt();
            this.mBottom = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mLeft);
            dest.writeInt(this.mTop);
            dest.writeInt(this.mRight);
            dest.writeInt(this.mBottom);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            ((View)target).setPadding(this.mLeft, this.mTop, this.mRight, this.mBottom);
        }

        @Override
        public int getActionTag() {
            return 14;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268053L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464258L, this.mLeft);
            out.write(1120986464259L, this.mRight);
            out.write(1120986464260L, this.mTop);
            out.write(0x10500000005L, this.mBottom);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268053L);
            block7: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block7;
                    }
                    case 2: {
                        values.put(1120986464258L, in.readInt(1120986464258L));
                        continue block7;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block7;
                    }
                    case 4: {
                        values.put(1120986464260L, in.readInt(1120986464260L));
                        continue block7;
                    }
                    case 5: {
                        values.put(0x10500000005L, in.readInt(0x10500000005L));
                        continue block7;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new ViewPaddingAction(viewId, values.get(1120986464258L, 0), values.get(1120986464260L, 0), values.get(1120986464259L, 0), values.get(0x10500000005L, 0));
            };
        }
    }

    private class BitmapReflectionAction
    extends Action {
        int mBitmapId;
        @UnsupportedAppUsage
        Bitmap mBitmap;
        @UnsupportedAppUsage
        String mMethodName;

        BitmapReflectionAction(RemoteViews remoteViews, int viewId, String methodName, Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mViewId = viewId;
            this.mMethodName = methodName;
            this.mBitmapId = remoteViews.mBitmapCache.getBitmapId(bitmap);
        }

        BitmapReflectionAction(RemoteViews remoteViews, Parcel in) {
            this.mViewId = in.readInt();
            this.mMethodName = in.readString8();
            this.mBitmapId = in.readInt();
            this.mBitmap = remoteViews.mBitmapCache.getBitmapForId(this.mBitmapId);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeString8(this.mMethodName);
            dest.writeInt(this.mBitmapId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
            ReflectionAction ra = new ReflectionAction(this.mViewId, this.mMethodName, 12, this.mBitmap);
            ra.apply(root, rootParent, params);
        }

        @Override
        public void setHierarchyRootData(HierarchyRootData rootData) {
            this.mBitmapId = rootData.mBitmapCache.getBitmapId(this.mBitmap);
        }

        @Override
        public int getActionTag() {
            return 12;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268034L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(1120986464259L, this.mBitmapId);
            out.end(token);
        }
    }

    private static class LayoutParamAction
    extends Action {
        static final int LAYOUT_MARGIN_LEFT = 0;
        static final int LAYOUT_MARGIN_TOP = 1;
        static final int LAYOUT_MARGIN_RIGHT = 2;
        static final int LAYOUT_MARGIN_BOTTOM = 3;
        static final int LAYOUT_MARGIN_START = 4;
        static final int LAYOUT_MARGIN_END = 5;
        static final int LAYOUT_WIDTH = 8;
        static final int LAYOUT_HEIGHT = 9;
        final int mProperty;
        final int mValueType;
        final int mValue;

        LayoutParamAction(int viewId, int property, float value, int units) {
            this.mViewId = viewId;
            this.mProperty = property;
            this.mValueType = 2;
            this.mValue = TypedValue.createComplexDimension(value, units);
        }

        LayoutParamAction(int viewId, int property, int value, int valueType) {
            this.mViewId = viewId;
            this.mProperty = property;
            this.mValueType = valueType;
            this.mValue = value;
        }

        public LayoutParamAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mProperty = parcel.readInt();
            this.mValueType = parcel.readInt();
            this.mValue = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mProperty);
            dest.writeInt(this.mValueType);
            dest.writeInt(this.mValue);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            ViewGroup.LayoutParams layoutParams = ((View)target).getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            switch (this.mProperty) {
                case 0: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).leftMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 1: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).topMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 2: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).rightMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 3: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).bottomMargin = this.getPixelOffset((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 4: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginStart(this.getPixelOffset((View)target));
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 5: {
                    if (!(layoutParams instanceof ViewGroup.MarginLayoutParams)) break;
                    ((ViewGroup.MarginLayoutParams)layoutParams).setMarginEnd(this.getPixelOffset((View)target));
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 8: {
                    layoutParams.width = this.getPixelSize((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                case 9: {
                    layoutParams.height = this.getPixelSize((View)target);
                    ((View)target).setLayoutParams(layoutParams);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property " + this.mProperty);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getPixelOffset(View target) {
            try {
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = target.getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            int n = typedArray.getDimensionPixelOffset(0, 0);
                            return n;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        if (this.mValue != 0) return target.getResources().getDimensionPixelOffset(this.mValue);
                        return 0;
                    }
                    case 2: {
                        return TypedValue.complexToDimensionPixelOffset(this.mValue, target.getResources().getDisplayMetrics());
                    }
                }
                return this.mValue;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int getPixelSize(View target) {
            try {
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = target.getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            int n = typedArray.getDimensionPixelSize(0, 0);
                            return n;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        if (this.mValue != 0) return target.getResources().getDimensionPixelSize(this.mValue);
                        return 0;
                    }
                    case 2: {
                        return TypedValue.complexToDimensionPixelSize(this.mValue, target.getResources().getDisplayMetrics());
                    }
                }
                return this.mValue;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 19;
        }

        @Override
        public String getUniqueKey() {
            return super.getUniqueKey() + this.mProperty;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268036L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464258L, this.mProperty);
            out.write(1120986464259L, this.mValue);
            out.write(1120986464260L, this.mValueType);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268036L);
            block6: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block6;
                    }
                    case 2: {
                        values.put(1120986464258L, in.readInt(1120986464258L));
                        continue block6;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block6;
                    }
                    case 4: {
                        values.put(1120986464260L, in.readInt(1120986464260L));
                        continue block6;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new LayoutParamAction(viewId, (int)values.get(1120986464258L, 0), values.get(1120986464259L, 0), (int)values.get(1120986464260L, 0));
            };
        }
    }

    private static class SetRippleDrawableColor
    extends Action {
        ColorStateList mColorStateList;

        SetRippleDrawableColor(int id2, ColorStateList colorStateList) {
            this.mViewId = id2;
            this.mColorStateList = colorStateList;
        }

        SetRippleDrawableColor(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mColorStateList = parcel.readParcelable(null, ColorStateList.class);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeParcelable(this.mColorStateList, 0);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = ((View)target).getBackground();
            if (targetDrawable instanceof RippleDrawable) {
                ((RippleDrawable)targetDrawable.mutate()).setColor(this.mColorStateList);
            }
        }

        @Override
        public int getActionTag() {
            return 21;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268047L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            RemoteViews.writeColorStateListToProto(out, this.mColorStateList, 1146756268034L);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268047L);
            block4: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block4;
                    }
                    case 2: {
                        values.put(1146756268034L, RemoteViews.createColorStateListFromProto(in, 1146756268034L));
                        continue block4;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1146756268034L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new SetRippleDrawableColor(viewId, (ColorStateList)values.get(1146756268034L));
            };
        }
    }

    private static class RemoveFromParentAction
    extends Action {
        RemoveFromParentAction(int viewId) {
            this.mViewId = viewId;
        }

        RemoveFromParentAction(Parcel parcel) {
            this.mViewId = parcel.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null || target == root) {
                return;
            }
            ViewParent parent = ((View)target).getParent();
            if (parent instanceof ViewManager) {
                ((ViewManager)((Object)parent)).removeView((View)target);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            root.createTree();
            final ViewTree target = root.findViewTreeById(this.mViewId);
            if (target == null || target == root) {
                return ACTION_NOOP;
            }
            ViewTree parent = root.findViewTreeParentOf(target);
            if (parent == null || !(parent.mRoot instanceof ViewManager)) {
                return ACTION_NOOP;
            }
            final ViewManager parentVg = (ViewManager)((Object)parent.mRoot);
            parent.mChildren.remove(target);
            return new RuntimeAction(this){

                @Override
                public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
                    parentVg.removeView(target.mRoot);
                }
            };
        }

        @Override
        public int getActionTag() {
            return 23;
        }

        @Override
        public int mergeBehavior() {
            return 1;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268039L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<String> values = new LongSparseArray<String>();
            long token = in.start(1146756268039L);
            block3: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block3;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new RemoveFromParentAction(viewId);
            };
        }
    }

    private static class ResourceReflectionAction
    extends BaseReflectionAction {
        static final int DIMEN_RESOURCE = 1;
        static final int COLOR_RESOURCE = 2;
        static final int STRING_RESOURCE = 3;
        private final int mResourceType;
        private final int mResId;

        ResourceReflectionAction(int viewId, String methodName, int parameterType, int resourceType, int resId) {
            super(viewId, methodName, parameterType);
            this.mResourceType = resourceType;
            this.mResId = resId;
        }

        ResourceReflectionAction(Parcel in) {
            super(in);
            this.mResourceType = in.readInt();
            this.mResId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mResourceType);
            dest.writeInt(this.mResId);
        }

        @Override
        @Nullable
        protected Object getParameterValue(@Nullable View view) throws ActionException {
            if (view == null) {
                return null;
            }
            Resources resources = view.getContext().getResources();
            try {
                switch (this.mResourceType) {
                    case 1: {
                        switch (this.mType) {
                            case 4: {
                                return this.mResId == 0 ? 0 : resources.getDimensionPixelSize(this.mResId);
                            }
                            case 6: {
                                return Float.valueOf(this.mResId == 0 ? 0.0f : resources.getDimension(this.mResId));
                            }
                        }
                        throw new ActionException("dimen resources must be used as INT or FLOAT, not " + this.mType);
                    }
                    case 2: {
                        switch (this.mType) {
                            case 4: {
                                return this.mResId == 0 ? 0 : view.getContext().getColor(this.mResId);
                            }
                            case 15: {
                                return this.mResId == 0 ? null : view.getContext().getColorStateList(this.mResId);
                            }
                        }
                        throw new ActionException("color resources must be used as INT or COLOR_STATE_LIST, not " + this.mType);
                    }
                    case 3: {
                        switch (this.mType) {
                            case 10: {
                                return this.mResId == 0 ? null : resources.getText(this.mResId);
                            }
                            case 9: {
                                return this.mResId == 0 ? null : resources.getString(this.mResId);
                            }
                        }
                        throw new ActionException("string resources must be used as STRING or CHAR_SEQUENCE, not " + this.mType);
                    }
                }
                throw new ActionException("unknown resource type: " + this.mResourceType);
            }
            catch (ActionException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 24;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268040L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(0x10500000005L, this.mType);
            out.write(1120986464259L, this.mResourceType);
            if (this.mResId != 0) {
                out.write(1138166333444L, appResources.getResourceName(this.mResId));
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268040L);
            block7: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block7;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block7;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block7;
                    }
                    case 4: {
                        values.put(1138166333444L, in.readString(1138166333444L));
                        continue block7;
                    }
                    case 5: {
                        values.put(0x10500000005L, in.readInt(0x10500000005L));
                        continue block7;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L, 0x10500000005L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int resId = values.indexOfKey(1138166333444L) >= 0 ? RemoteViews.getAsIdentifier(resources, values, 1138166333444L) : 0;
                return new ResourceReflectionAction(viewId, (String)values.get(1138166333442L), (Integer)values.get(0x10500000005L), values.get(1120986464259L, 0), resId);
            };
        }
    }

    private static class ComplexUnitDimensionReflectionAction
    extends BaseReflectionAction {
        private final float mValue;
        private final int mUnit;

        ComplexUnitDimensionReflectionAction(int viewId, String methodName, int parameterType, float value, int unit) {
            super(viewId, methodName, parameterType);
            this.mValue = value;
            this.mUnit = unit;
        }

        ComplexUnitDimensionReflectionAction(Parcel in) {
            super(in);
            this.mValue = in.readFloat();
            this.mUnit = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeFloat(this.mValue);
            dest.writeInt(this.mUnit);
        }

        @Override
        @Nullable
        protected Object getParameterValue(@Nullable View view) throws ActionException {
            if (view == null) {
                return null;
            }
            DisplayMetrics dm = view.getContext().getResources().getDisplayMetrics();
            try {
                int data = TypedValue.createComplexDimension(this.mValue, this.mUnit);
                switch (this.mType) {
                    case 4: {
                        return TypedValue.complexToDimensionPixelSize(data, dm);
                    }
                    case 6: {
                        return Float.valueOf(TypedValue.complexToDimension(data, dm));
                    }
                }
                throw new ActionException("parameter type must be INT or FLOAT, not " + this.mType);
            }
            catch (ActionException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 25;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268035L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(1120986464259L, this.mType);
            out.write(1108101562372L, this.mValue);
            out.write(0x10500000005L, this.mUnit);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268035L);
            block7: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block7;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block7;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block7;
                    }
                    case 4: {
                        values.put(1108101562372L, Float.valueOf(in.readFloat(1108101562372L)));
                        continue block7;
                    }
                    case 5: {
                        values.put(0x10500000005L, in.readInt(0x10500000005L));
                        continue block7;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L, 1120986464259L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new ComplexUnitDimensionReflectionAction(viewId, (String)values.get(1138166333442L), (Integer)values.get(1120986464259L), ((Float)((Object)values.get(1108101562372L, 0))).floatValue(), values.get(0x10500000005L, 0));
            };
        }
    }

    private static class SetCompoundButtonCheckedAction
    extends Action {
        private final boolean mChecked;

        SetCompoundButtonCheckedAction(int viewId, boolean checked) {
            this.mViewId = viewId;
            this.mChecked = checked;
        }

        SetCompoundButtonCheckedAction(Parcel in) {
            this.mViewId = in.readInt();
            this.mChecked = in.readBoolean();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeBoolean(this.mChecked);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof CompoundButton)) {
                Log.w(RemoteViews.LOG_TAG, "Cannot set checked to view " + this.mViewId + " because it is not a CompoundButton");
                return;
            }
            CompoundButton button = (CompoundButton)target;
            Object tag = button.getTag(16909486);
            if (tag instanceof CompoundButton.OnCheckedChangeListener) {
                button.setOnCheckedChangeListener(null);
                button.setChecked(this.mChecked);
                button.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)tag);
            } else {
                button.setChecked(this.mChecked);
            }
        }

        @Override
        public int getActionTag() {
            return 26;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268041L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1133871366146L, this.mChecked);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268041L);
            block4: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block4;
                    }
                    case 2: {
                        values.put(1133871366146L, in.readBoolean(1133871366146L));
                        continue block4;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new SetCompoundButtonCheckedAction(viewId, values.get(1133871366146L, false));
            };
        }
    }

    private static class SetRadioGroupCheckedAction
    extends Action {
        private final int mCheckedId;

        SetRadioGroupCheckedAction(int viewId, int checkedId) {
            this.mViewId = viewId;
            this.mCheckedId = checkedId;
        }

        SetRadioGroupCheckedAction(Parcel in) {
            this.mViewId = in.readInt();
            this.mCheckedId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mCheckedId);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
            Object tag;
            View child;
            int i;
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof RadioGroup)) {
                Log.w(RemoteViews.LOG_TAG, "Cannot check " + this.mViewId + " because it's not a RadioGroup");
                return;
            }
            RadioGroup group = (RadioGroup)target;
            for (i = 0; i < group.getChildCount(); ++i) {
                child = group.getChildAt(i);
                if (!(child instanceof CompoundButton) || !((tag = child.getTag(16909486)) instanceof CompoundButton.OnCheckedChangeListener)) continue;
                ((CompoundButton)child).setOnCheckedChangeListener(null);
            }
            group.check(this.mCheckedId);
            for (i = 0; i < group.getChildCount(); ++i) {
                child = group.getChildAt(i);
                if (!(child instanceof CompoundButton) || !((tag = child.getTag(16909486)) instanceof CompoundButton.OnCheckedChangeListener)) continue;
                ((CompoundButton)child).setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)tag);
            }
        }

        @Override
        public int getActionTag() {
            return 27;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268045L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            if (this.mCheckedId != -1) {
                out.write(1138166333442L, appResources.getResourceName(this.mCheckedId));
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<String> values = new LongSparseArray<String>();
            long token = in.start(1146756268045L);
            block4: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block4;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block4;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int checkedId = values.indexOfKey(1138166333442L) >= 0 ? RemoteViews.getAsIdentifier(resources, values, 1138166333442L) : -1;
                return new SetRadioGroupCheckedAction(viewId, checkedId);
            };
        }
    }

    private static class SetViewOutlinePreferredRadiusAction
    extends Action {
        private final int mValueType;
        private final int mValue;

        SetViewOutlinePreferredRadiusAction(int viewId, int value, int valueType) {
            this.mViewId = viewId;
            this.mValueType = valueType;
            this.mValue = value;
        }

        SetViewOutlinePreferredRadiusAction(int viewId, float radius, int units) {
            this.mViewId = viewId;
            this.mValueType = 2;
            this.mValue = TypedValue.createComplexDimension(radius, units);
        }

        SetViewOutlinePreferredRadiusAction(Parcel in) {
            this.mViewId = in.readInt();
            this.mValueType = in.readInt();
            this.mValue = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            dest.writeInt(this.mValueType);
            dest.writeInt(this.mValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) throws ActionException {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            try {
                float radius;
                switch (this.mValueType) {
                    case 4: {
                        TypedArray typedArray = ((View)target).getContext().obtainStyledAttributes(new int[]{this.mValue});
                        try {
                            radius = typedArray.getDimension(0, 0.0f);
                            break;
                        }
                        finally {
                            typedArray.recycle();
                        }
                    }
                    case 3: {
                        radius = this.mValue == 0 ? 0.0f : ((View)target).getResources().getDimension(this.mValue);
                        break;
                    }
                    case 2: {
                        radius = TypedValue.complexToDimension(this.mValue, ((View)target).getResources().getDisplayMetrics());
                        break;
                    }
                    default: {
                        radius = this.mValue;
                    }
                }
                ((View)target).setOutlineProvider(new RemoteViewOutlineProvider(radius));
            }
            catch (Throwable t) {
                throw new ActionException(t);
            }
        }

        @Override
        public int getActionTag() {
            return 28;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(0x10B00000010L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1120986464258L, this.mValueType);
            out.write(1120986464259L, this.mValue);
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(0x10B00000010L);
            block5: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block5;
                    }
                    case 2: {
                        values.put(1120986464258L, in.readInt(1120986464258L));
                        continue block5;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block5;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1120986464258L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                return new SetViewOutlinePreferredRadiusAction(viewId, values.get(1120986464259L, 0), (int)((Integer)values.get(1120986464258L)));
            };
        }
    }

    private class SetOnCheckedChangeResponse
    extends Action {
        private final RemoteResponse mResponse;

        SetOnCheckedChangeResponse(int id2, RemoteResponse response) {
            this.mViewId = id2;
            this.mResponse = response;
        }

        SetOnCheckedChangeResponse(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mResponse = new RemoteResponse();
            this.mResponse.readFromParcel(parcel);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            this.mResponse.writeToParcel(dest, flags);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof CompoundButton)) {
                Log.w(RemoteViews.LOG_TAG, "setOnCheckedChange methods cannot be used on non-CompoundButton child (id: " + this.mViewId + ")");
                return;
            }
            CompoundButton button = (CompoundButton)target;
            if (this.mResponse.mPendingIntent != null) {
                if (RemoteViews.this.hasFlags(2)) {
                    Log.w(RemoteViews.LOG_TAG, "Cannot setOnCheckedChangePendingIntent for collection item (id: " + this.mViewId + ")");
                    return;
                }
                ((View)target).setTagInternal(16909414, this.mResponse.mPendingIntent);
            } else if (this.mResponse.mFillIntent != null) {
                if (!RemoteViews.this.hasFlags(2)) {
                    Log.e(RemoteViews.LOG_TAG, "The method setOnCheckedChangeFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                    return;
                }
            } else {
                button.setOnCheckedChangeListener(null);
                button.setTagInternal(16909486, null);
                return;
            }
            CompoundButton.OnCheckedChangeListener onCheckedChangeListener = (v, isChecked) -> this.mResponse.handleViewInteraction(v, params.handler);
            button.setTagInternal(16909486, onCheckedChangeListener);
            button.setOnCheckedChangeListener(onCheckedChangeListener);
        }

        @Override
        public int getActionTag() {
            return 29;
        }
    }

    private static class NightModeReflectionAction
    extends BaseReflectionAction {
        private final Object mLightValue;
        private final Object mDarkValue;

        NightModeReflectionAction(int viewId, String methodName, int type, Object lightValue, Object darkValue) {
            super(viewId, methodName, type);
            this.mLightValue = lightValue;
            this.mDarkValue = darkValue;
        }

        NightModeReflectionAction(Parcel in) {
            super(in);
            switch (this.mType) {
                case 16: {
                    this.mLightValue = in.readTypedObject(Icon.CREATOR);
                    this.mDarkValue = in.readTypedObject(Icon.CREATOR);
                    break;
                }
                case 15: {
                    this.mLightValue = in.readTypedObject(ColorStateList.CREATOR);
                    this.mDarkValue = in.readTypedObject(ColorStateList.CREATOR);
                    break;
                }
                case 4: {
                    this.mLightValue = in.readInt();
                    this.mDarkValue = in.readInt();
                    break;
                }
                default: {
                    throw new ActionException("Unexpected night mode action type: " + this.mType);
                }
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            switch (this.mType) {
                case 15: 
                case 16: {
                    out.writeTypedObject((Parcelable)this.mLightValue, flags);
                    out.writeTypedObject((Parcelable)this.mDarkValue, flags);
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.mLightValue);
                    out.writeInt((Integer)this.mDarkValue);
                }
            }
        }

        @Override
        @Nullable
        protected Object getParameterValue(@Nullable View view) throws ActionException {
            if (view == null) {
                return null;
            }
            Configuration configuration = view.getResources().getConfiguration();
            return configuration.isNightModeActive() ? this.mDarkValue : this.mLightValue;
        }

        @Override
        public int getActionTag() {
            return 30;
        }

        @Override
        public void visitUris(@NonNull Consumer<Uri> visitor) {
            if (this.mType == 16) {
                RemoteViews.visitIconUri((Icon)this.mDarkValue, visitor);
                RemoteViews.visitIconUri((Icon)this.mLightValue, visitor);
            }
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(1146756268037L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(1120986464259L, this.mType);
            switch (this.mType) {
                case 16: {
                    RemoteViews.writeIconToProto(out, appResources, (Icon)this.mLightValue, 1146756268036L);
                    RemoteViews.writeIconToProto(out, appResources, (Icon)this.mDarkValue, 1146756268039L);
                    break;
                }
                case 15: {
                    RemoteViews.writeColorStateListToProto(out, (ColorStateList)this.mLightValue, 1146756268037L);
                    RemoteViews.writeColorStateListToProto(out, (ColorStateList)this.mDarkValue, 1146756268040L);
                    break;
                }
                case 4: {
                    out.write(1120986464262L, (Integer)this.mLightValue);
                    out.write(1120986464265L, (Integer)this.mDarkValue);
                }
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(1146756268037L);
            block11: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block11;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block11;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block11;
                    }
                    case 4: {
                        values.put(1146756268036L, RemoteViews.createIconFromProto(in, 1146756268036L));
                        continue block11;
                    }
                    case 5: {
                        values.put(1146756268037L, RemoteViews.createColorStateListFromProto(in, 1146756268037L));
                        continue block11;
                    }
                    case 6: {
                        values.put(1120986464262L, in.readInt(1120986464262L));
                        continue block11;
                    }
                    case 7: {
                        values.put(1146756268039L, RemoteViews.createIconFromProto(in, 1146756268039L));
                        continue block11;
                    }
                    case 8: {
                        values.put(1146756268040L, RemoteViews.createColorStateListFromProto(in, 1146756268040L));
                        continue block11;
                    }
                    case 9: {
                        values.put(1120986464265L, in.readInt(1120986464265L));
                        continue block11;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L, 1120986464259L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                String methodName = (String)values.get(1138166333442L);
                int parameterType = (Integer)values.get(1120986464259L);
                switch (parameterType) {
                    case 16: {
                        PendingResources pendingLightIcon = (PendingResources)values.get(1146756268036L);
                        PendingResources pendingDarkIcon = (PendingResources)values.get(1146756268039L);
                        Icon lightIcon = pendingLightIcon != null ? (Icon)pendingLightIcon.create(context, resources, rootData, depth) : null;
                        Icon darkIcon = pendingDarkIcon != null ? (Icon)pendingDarkIcon.create(context, resources, rootData, depth) : null;
                        return new NightModeReflectionAction(viewId, methodName, parameterType, lightIcon, darkIcon);
                    }
                    case 15: {
                        return new NightModeReflectionAction(viewId, methodName, parameterType, (ColorStateList)values.get(1146756268037L), (ColorStateList)values.get(1146756268040L));
                    }
                    case 4: {
                        return new NightModeReflectionAction(viewId, methodName, parameterType, (int)values.get(1120986464262L, 0), (int)values.get(1120986464265L, 0));
                    }
                }
                throw new RuntimeException("Unknown parameterType: " + parameterType);
            };
        }
    }

    private static class AttributeReflectionAction
    extends BaseReflectionAction {
        static final int DIMEN_RESOURCE = 1;
        static final int COLOR_RESOURCE = 2;
        static final int STRING_RESOURCE = 3;
        private final int mResourceType;
        private final int mAttrId;

        AttributeReflectionAction(int viewId, String methodName, int parameterType, int resourceType, int attrId) {
            super(viewId, methodName, parameterType);
            this.mResourceType = resourceType;
            this.mAttrId = attrId;
        }

        AttributeReflectionAction(Parcel in) {
            super(in);
            this.mResourceType = in.readInt();
            this.mAttrId = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mResourceType);
            dest.writeInt(this.mAttrId);
        }

        /*
         * Exception decompiling
         */
        @Override
        protected Object getParameterValue(View view) throws ActionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[SWITCH], 11[CASE]], but top level block is 7[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int getActionTag() {
            return 32;
        }

        @Override
        public boolean canWriteToProto() {
            return true;
        }

        @Override
        public void writeToProto(ProtoOutputStream out, Context context, Resources appResources) {
            long token = out.start(0x10B00000001L);
            out.write(0x10900000001L, appResources.getResourceName(this.mViewId));
            out.write(1138166333442L, this.mMethodName);
            out.write(1120986464259L, this.mType);
            out.write(1120986464260L, this.mResourceType);
            if (this.mAttrId != 0) {
                out.write(1138166333445L, appResources.getResourceName(this.mAttrId));
            }
            out.end(token);
        }

        public static PendingResources<Action> createFromProto(ProtoInputStream in) throws Exception {
            LongSparseArray<Object> values = new LongSparseArray<Object>();
            long token = in.start(0x10B00000001L);
            block7: while (in.nextField() != -1) {
                switch (in.getFieldNumber()) {
                    case 1: {
                        values.put(0x10900000001L, in.readString(0x10900000001L));
                        continue block7;
                    }
                    case 2: {
                        values.put(1138166333442L, in.readString(1138166333442L));
                        continue block7;
                    }
                    case 5: {
                        values.put(1138166333445L, in.readString(1138166333445L));
                        continue block7;
                    }
                    case 3: {
                        values.put(1120986464259L, in.readInt(1120986464259L));
                        continue block7;
                    }
                    case 4: {
                        values.put(1120986464260L, in.readInt(1120986464260L));
                        continue block7;
                    }
                }
                Log.w(RemoteViews.LOG_TAG, "Unhandled field while reading RemoteViews proto!\n" + ProtoUtils.currentFieldToString(in));
            }
            in.end(token);
            RemoteViews.checkContainsKeys(values, new long[]{0x10900000001L, 1138166333442L, 1120986464259L, 1120986464260L});
            return (context, resources, rootData, depth) -> {
                int viewId = RemoteViews.getAsIdentifier(resources, values, 0x10900000001L);
                int attributeId = values.indexOfKey(1138166333445L) >= 0 ? RemoteViews.getAsIdentifier(resources, values, 1138166333445L) : 0;
                return new AttributeReflectionAction(viewId, (String)values.get(1138166333442L), (Integer)values.get(1120986464259L), (Integer)values.get(1120986464260L), attributeId);
            };
        }
    }

    private class SetOnStylusHandwritingResponse
    extends Action {
        final PendingIntent mPendingIntent;

        SetOnStylusHandwritingResponse(@Nullable int id2, PendingIntent pendingIntent) {
            this.mViewId = id2;
            this.mPendingIntent = pendingIntent;
        }

        SetOnStylusHandwritingResponse(Parcel parcel) {
            this.mViewId = parcel.readInt();
            this.mPendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mViewId);
            PendingIntent.writePendingIntentOrNullToParcel(this.mPendingIntent, dest);
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object target = root.findViewById(this.mViewId);
            if (target == null) {
                return;
            }
            if (RemoteViews.this.hasFlags(2)) {
                Log.w(RemoteViews.LOG_TAG, "Cannot use setOnStylusHandwritingPendingIntent for collection item (id: " + this.mViewId + ")");
                return;
            }
            if (this.mPendingIntent != null) {
                RemoteResponse response = RemoteResponse.fromPendingIntent(this.mPendingIntent);
                ((View)target).setHandwritingDelegatorCallback(() -> response.handleViewInteraction((View)target, params.handler));
                ((View)target).setAllowedHandwritingDelegatePackage(this.mPendingIntent.getCreatorPackage());
            } else {
                ((View)target).setHandwritingDelegatorCallback(null);
                ((View)target).setAllowedHandwritingDelegatePackage(null);
            }
        }

        @Override
        public int getActionTag() {
            return 34;
        }
    }

    public static class RemoteResponse {
        public static final int INTERACTION_TYPE_CLICK = 0;
        public static final int INTERACTION_TYPE_CHECKED_CHANGE = 1;
        private PendingIntent mPendingIntent;
        private Intent mFillIntent;
        private int mInteractionType = 0;
        private IntArray mViewIds;
        private ArrayList<String> mElementNames;

        @NonNull
        public static RemoteResponse fromPendingIntent(@NonNull PendingIntent pendingIntent) {
            RemoteResponse response = new RemoteResponse();
            response.mPendingIntent = pendingIntent;
            return response;
        }

        @NonNull
        public static RemoteResponse fromFillInIntent(@NonNull Intent fillIntent) {
            RemoteResponse response = new RemoteResponse();
            response.mFillIntent = fillIntent;
            if (fillIntent != null) {
                fillIntent.collectExtraIntentKeys();
            }
            return response;
        }

        private static RemoteResponse fromPendingIntentTemplateAndFillInIntent(@NonNull PendingIntent pendingIntent, @NonNull Intent intent) {
            RemoteResponse response = new RemoteResponse();
            response.mPendingIntent = pendingIntent;
            response.mFillIntent = intent;
            intent.collectExtraIntentKeys();
            return response;
        }

        @NonNull
        public RemoteResponse addSharedElement(int viewId, @NonNull String sharedElementName) {
            if (this.mViewIds == null) {
                this.mViewIds = new IntArray();
                this.mElementNames = new ArrayList();
            }
            this.mViewIds.add(viewId);
            this.mElementNames.add(sharedElementName);
            return this;
        }

        @NonNull
        public RemoteResponse setInteractionType(int type) {
            this.mInteractionType = type;
            return this;
        }

        private void writeToParcel(Parcel dest, int flags) {
            PendingIntent.writePendingIntentOrNullToParcel(this.mPendingIntent, dest);
            dest.writeBoolean(this.mFillIntent != null);
            if (this.mFillIntent != null) {
                dest.writeTypedObject(this.mFillIntent, flags);
            }
            dest.writeInt(this.mInteractionType);
            dest.writeIntArray(this.mViewIds == null ? null : this.mViewIds.toArray());
            dest.writeStringList(this.mElementNames);
        }

        private void readFromParcel(Parcel parcel) {
            this.mPendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
            this.mFillIntent = parcel.readBoolean() ? parcel.readTypedObject(Intent.CREATOR) : null;
            this.mInteractionType = parcel.readInt();
            int[] viewIds = parcel.createIntArray();
            this.mViewIds = viewIds == null ? null : IntArray.wrap(viewIds);
            this.mElementNames = parcel.createStringArrayList();
        }

        private void handleViewInteraction(View v, InteractionHandler handler) {
            PendingIntent pi;
            if (this.mPendingIntent != null) {
                pi = this.mPendingIntent;
            } else if (this.mFillIntent != null) {
                AdapterView<?> ancestor = RemoteResponse.getAdapterViewAncestor(v);
                if (ancestor == null) {
                    Log.e(RemoteViews.LOG_TAG, "Collection item doesn't have AdapterView parent");
                    return;
                }
                if (!(ancestor.getTag() instanceof PendingIntent)) {
                    Log.e(RemoteViews.LOG_TAG, "Attempting setOnClickFillInIntent or setOnCheckedChangeFillInIntent without calling setPendingIntentTemplate on parent.");
                    return;
                }
                pi = (PendingIntent)ancestor.getTag();
            } else {
                Log.e(RemoteViews.LOG_TAG, "Response has neither pendingIntent nor fillInIntent");
                return;
            }
            handler.onInteraction(v, pi, this);
        }

        @Nullable
        private static AdapterView<?> getAdapterViewAncestor(@Nullable View view) {
            View parent;
            if (view == null) {
                return null;
            }
            for (parent = (View)((Object)view.getParent()); !(parent == null || parent instanceof AdapterView || parent instanceof AppWidgetHostView && !(parent instanceof AppWidgetHostView.AdapterChildHostView)); parent = (View)((Object)parent.getParent())) {
            }
            return parent instanceof AdapterView ? (AdapterView)parent : null;
        }

        public Pair<Intent, ActivityOptions> getLaunchOptions(View view) {
            Intent intent = this.mFillIntent == null ? new Intent() : new Intent(this.mFillIntent);
            intent.setSourceBounds(RemoteViews.getSourceBounds(view));
            if (view instanceof CompoundButton && this.mInteractionType == 1) {
                intent.putExtra(RemoteViews.EXTRA_CHECKED, ((CompoundButton)view).isChecked());
            }
            ActivityOptions opts = null;
            Context context = view.getContext();
            if (context.getResources().getBoolean(0x1110211)) {
                TypedArray windowStyle = context.getTheme().obtainStyledAttributes(R.styleable.Window);
                int windowAnimations = windowStyle.getResourceId(8, 0);
                TypedArray windowAnimationStyle = context.obtainStyledAttributes(windowAnimations, R.styleable.WindowAnimation);
                int enterAnimationId = windowAnimationStyle.getResourceId(26, 0);
                windowStyle.recycle();
                windowAnimationStyle.recycle();
                if (enterAnimationId != 0) {
                    opts = ActivityOptions.makeCustomAnimation(context, enterAnimationId, 0);
                    opts.setPendingIntentLaunchFlags(0x10000000);
                }
            }
            if (opts == null && this.mViewIds != null && this.mElementNames != null) {
                View parent;
                for (parent = (View)((Object)view.getParent()); parent != null && !(parent instanceof AppWidgetHostView); parent = (View)((Object)parent.getParent())) {
                }
                if (parent instanceof AppWidgetHostView) {
                    opts = ((AppWidgetHostView)parent).createSharedElementActivityOptions(this.mViewIds.toArray(), this.mElementNames.toArray(new String[this.mElementNames.size()]), intent);
                }
            }
            if (opts == null) {
                opts = ActivityOptions.makeBasic();
                opts.setPendingIntentLaunchFlags(0x10000000);
            }
            if (view.getDisplay() != null) {
                opts.setLaunchDisplayId(view.getDisplay().getDisplayId());
            } else {
                Log.w(RemoteViews.LOG_TAG, "getLaunchOptions: view.getDisplay() is null!", new Exception());
            }
            opts.setPendingIntentBackgroundActivityStartMode(3);
            return Pair.create(intent, opts);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface InteractionType {
        }
    }

    private static abstract class BaseReflectionAction
    extends Action {
        static final int BOOLEAN = 1;
        static final int BYTE = 2;
        static final int SHORT = 3;
        static final int INT = 4;
        static final int LONG = 5;
        static final int FLOAT = 6;
        static final int DOUBLE = 7;
        static final int CHAR = 8;
        static final int STRING = 9;
        static final int CHAR_SEQUENCE = 10;
        static final int URI = 11;
        static final int BITMAP = 12;
        static final int BUNDLE = 13;
        static final int INTENT = 14;
        static final int COLOR_STATE_LIST = 15;
        static final int ICON = 16;
        static final int BLEND_MODE = 17;
        @UnsupportedAppUsage
        String mMethodName;
        int mType;

        BaseReflectionAction(int viewId, String methodName, int type) {
            this.mViewId = viewId;
            this.mMethodName = methodName;
            this.mType = type;
        }

        BaseReflectionAction(Parcel in) {
            this.mViewId = in.readInt();
            this.mMethodName = in.readString8();
            this.mType = in.readInt();
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mViewId);
            out.writeString8(this.mMethodName);
            out.writeInt(this.mType);
        }

        @Nullable
        protected abstract Object getParameterValue(@Nullable View var1) throws ActionException;

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            Object view = root.findViewById(this.mViewId);
            if (view == null) {
                return;
            }
            Class<?> param = RemoteViews.getParameterType(this.mType);
            if (param == null) {
                throw new ActionException("bad type: " + this.mType);
            }
            Object value = this.getParameterValue((View)view);
            try {
                RemoteViews.getMethod(view, this.mMethodName, param, false).invoke((View)view, value);
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
        }

        @Override
        public Action initActionAsync(ViewTree root, ViewGroup rootParent, ActionApplyParams params) {
            Object view = root.findViewById(this.mViewId);
            if (view == null) {
                return ACTION_NOOP;
            }
            Class<?> param = RemoteViews.getParameterType(this.mType);
            if (param == null) {
                throw new ActionException("bad type: " + this.mType);
            }
            Object value = this.getParameterValue((View)view);
            try {
                Bitmap bitmap;
                Icon icon;
                MethodHandle method = RemoteViews.getMethod(view, this.mMethodName, param, true);
                if (value instanceof Bitmap) {
                    Bitmap bitmap2 = (Bitmap)value;
                    bitmap2.prepareToDraw();
                }
                if (value instanceof Icon && ((icon = (Icon)value).getType() == 1 || icon.getType() == 5) && (bitmap = icon.getBitmap()) != null) {
                    bitmap.prepareToDraw();
                }
                if (method != null) {
                    Runnable endAction = method.invoke((View)view, value);
                    if (endAction == null) {
                        return ACTION_NOOP;
                    }
                    if (endAction instanceof ViewStub.ViewReplaceRunnable) {
                        root.createTree();
                        root.findViewTreeById(this.mViewId).replaceView(((ViewStub.ViewReplaceRunnable)endAction).view);
                    }
                    return new RunnableAction(endAction);
                }
            }
            catch (Throwable ex) {
                throw new ActionException(ex);
            }
            return this;
        }

        @Override
        public int mergeBehavior() {
            if (this.mMethodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        @Override
        public String getUniqueKey() {
            return super.getUniqueKey() + this.mMethodName + this.mType;
        }

        @Override
        public boolean prefersAsyncApply() {
            return this.mType == 11 || this.mType == 16;
        }

        @Override
        public void visitUris(@NonNull Consumer<Uri> visitor) {
            switch (this.mType) {
                case 11: {
                    Uri uri = (Uri)this.getParameterValue(null);
                    if (uri == null) break;
                    visitor.accept(uri);
                    break;
                }
                case 16: {
                    Icon icon = (Icon)this.getParameterValue(null);
                    if (icon == null) break;
                    RemoteViews.visitIconUri(icon, visitor);
                }
            }
        }

        @Override
        public void visitIcons(@NonNull Consumer<Icon> visitor) {
            Object object;
            if (this.mType == 16 && (object = this.getParameterValue(null)) instanceof Icon) {
                Icon icon = (Icon)object;
                visitor.accept(icon);
            }
        }
    }

    public static interface InteractionHandler {
        public boolean onInteraction(View var1, PendingIntent var2, RemoteResponse var3);

        default public void onScroll(@NonNull AbsListView view) {
        }
    }

    public class ActionApplyParams {
        public InteractionHandler handler;
        public ColorResources colorResources;
        public Executor executor;
        public int applyThemeResId;

        public ActionApplyParams clone() {
            return new ActionApplyParams().withInteractionHandler(this.handler).withColorResources(this.colorResources).withExecutor(this.executor).withThemeResId(this.applyThemeResId);
        }

        public ActionApplyParams withInteractionHandler(InteractionHandler handler) {
            this.handler = handler;
            return this;
        }

        public ActionApplyParams withColorResources(ColorResources colorResources) {
            this.colorResources = colorResources;
            return this;
        }

        public ActionApplyParams withThemeResId(int themeResId) {
            this.applyThemeResId = themeResId;
            return this;
        }

        public ActionApplyParams withExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }
    }

    public static class ColorResources {
        private static final int FIRST_RESOURCE_COLOR_ID = 17170461;
        private static final int LAST_RESOURCE_COLOR_ID = 17170641;
        private static final int ARSC_ENTRY_SIZE = 16;
        private static final String OVERLAY_NAME = "remote_views_color_resources";
        private static final String OVERLAY_TARGET_PACKAGE_NAME = "android";
        private final ResourcesLoader mLoader;
        private final SparseIntArray mColorMapping;

        private ColorResources(ResourcesLoader loader, SparseIntArray colorMapping) {
            this.mLoader = loader;
            this.mColorMapping = colorMapping;
        }

        public void apply(Context context) {
            context.getResources().addLoaders(this.mLoader);
        }

        public SparseIntArray getColorMapping() {
            return this.mColorMapping;
        }

        private static ByteArrayOutputStream readFileContent(InputStream input) throws IOException {
            ByteArrayOutputStream content = new ByteArrayOutputStream(2048);
            byte[] buffer = new byte[4096];
            while (input.available() > 0) {
                int read = input.read(buffer);
                content.write(buffer, 0, read);
            }
            return content;
        }

        @Nullable
        private static byte[] createCompiledResourcesContent(Context context, SparseIntArray colorResources) throws IOException {
            byte[] content;
            try (InputStream input = context.getResources().openRawResource(0x1100007);){
                ByteArrayOutputStream rawContent = ColorResources.readFileContent(input);
                content = rawContent.toByteArray();
            }
            int valuesOffset = content.length - 3344 - 4;
            if (valuesOffset < 0) {
                Log.e(RemoteViews.LOG_TAG, "ARSC file for theme colors is invalid.");
                return null;
            }
            for (int colorRes = 17170461; colorRes <= 17170641; ++colorRes) {
                int index = colorRes & 0xFFFF;
                int offset = valuesOffset + index * 16;
                int value = colorResources.get(colorRes, context.getColor(colorRes));
                for (int b = 0; b < 4; ++b) {
                    content[offset + b] = (byte)(value & 0xFF);
                    value >>= 8;
                }
            }
            return content;
        }

        /*
         * Exception decompiling
         */
        @Nullable
        public static ColorResources create(Context context, SparseIntArray colorMapping) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @FlaggedApi(value="android.content.res.self_targeting_android_resource_frro")
        @Nullable
        public static ColorResources createWithOverlay(Context context, SparseIntArray colorMapping) {
            try {
                String owningPackage = context.getPackageName();
                FabricatedOverlay overlay = new FabricatedOverlay.Builder(owningPackage, OVERLAY_NAME, OVERLAY_TARGET_PACKAGE_NAME).build();
                for (int i = 0; i < colorMapping.size(); ++i) {
                    overlay.setResourceValue(context.getResources().getResourceName(colorMapping.keyAt(i)), 28, colorMapping.valueAt(i), (String)null);
                }
                OverlayManager overlayManager = context.getSystemService(OverlayManager.class);
                OverlayManagerTransaction.Builder transaction = new OverlayManagerTransaction.Builder().registerFabricatedOverlay(overlay).setSelfTargeting(true);
                overlayManager.commit(transaction.build());
                OverlayInfo overlayInfo = overlayManager.getOverlayInfosForTarget(OVERLAY_TARGET_PACKAGE_NAME).stream().filter(info -> TextUtils.equals(info.overlayName, OVERLAY_NAME) && TextUtils.equals(info.packageName, owningPackage)).findFirst().orElse(null);
                if (overlayInfo == null) {
                    Log.e(RemoteViews.LOG_TAG, "Failed to get overlay info ", new Throwable());
                    return null;
                }
                ResourcesLoader colorsLoader = new ResourcesLoader();
                colorsLoader.addProvider(ResourcesProvider.loadOverlay(overlayInfo));
                return new ColorResources(colorsLoader, colorMapping.clone());
            }
            catch (Exception e) {
                Log.e(RemoteViews.LOG_TAG, "Failed to add theme color overlay into loader", e);
                return null;
            }
        }
    }

    private static class RemoteViewsContextWrapper
    extends ContextWrapper {
        private final Context mContextForResources;

        RemoteViewsContextWrapper(Context context, Context contextForResources) {
            super(context);
            this.mContextForResources = contextForResources;
        }

        @Override
        public Resources getResources() {
            return this.mContextForResources.getResources();
        }

        @Override
        public Resources.Theme getTheme() {
            return this.mContextForResources.getTheme();
        }

        @Override
        public String getPackageName() {
            return this.mContextForResources.getPackageName();
        }

        @Override
        public UserHandle getUser() {
            return this.mContextForResources.getUser();
        }

        @Override
        public int getUserId() {
            return this.mContextForResources.getUserId();
        }

        @Override
        public boolean isRestricted() {
            return this.mContextForResources.isRestricted();
        }
    }

    public static interface OnViewAppliedListener {
        default public void onViewInflated(View v) {
        }

        public void onViewApplied(View var1);

        public void onError(Exception var1);
    }

    private class AsyncApplyTask
    extends AsyncTask<Void, Void, ViewTree>
    implements CancellationSignal.OnCancelListener {
        final CancellationSignal mCancelSignal = new CancellationSignal();
        final RemoteViews mRV;
        final ViewGroup mParent;
        final Context mContext;
        final OnViewAppliedListener mListener;
        final ActionApplyParams mApplyParams;
        final boolean mTopLevel;
        private View mResult;
        private ViewTree mTree;
        private Action[] mActions;
        private Exception mError;

        private AsyncApplyTask(RemoteViews rv, ViewGroup parent, Context context, OnViewAppliedListener listener, ActionApplyParams applyParams, View result, boolean topLevel) {
            this.mRV = rv;
            this.mParent = parent;
            this.mContext = context;
            this.mListener = listener;
            this.mTopLevel = topLevel;
            this.mApplyParams = applyParams;
            this.mResult = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        protected ViewTree doInBackground(Void ... params) {
            try {
                if (this.mResult == null) {
                    this.mResult = RemoteViews.this.inflateView(this.mContext, this.mRV, this.mParent, 0, this.mApplyParams.colorResources);
                }
                this.mTree = new ViewTree(this.mResult);
                if (this.mRV.mActions != null) {
                    int count = this.mRV.mActions.size();
                    this.mActions = new Action[count];
                    try {
                        Trace.beginSection(RemoteViews.this.hasDrawInstructions() ? "RemoteViews#initActionAsyncWithDrawInstructions" : "RemoteViews#initActionAsync");
                        for (int i = 0; i < count && !this.isCancelled(); ++i) {
                            this.mActions[i] = this.mRV.mActions.get(i).initActionAsync(this.mTree, this.mParent, this.mApplyParams);
                        }
                    }
                    finally {
                        Trace.endSection();
                    }
                } else {
                    this.mActions = null;
                }
                return this.mTree;
            }
            catch (Exception e) {
                this.mError = e;
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onPostExecute(ViewTree viewTree) {
            this.mCancelSignal.setOnCancelListener(null);
            if (this.mError == null) {
                if (this.mListener != null) {
                    this.mListener.onViewInflated(viewTree.mRoot);
                }
                try {
                    if (this.mActions != null) {
                        ActionApplyParams applyParams = this.mApplyParams.clone();
                        if (applyParams.handler == null) {
                            applyParams.handler = DEFAULT_INTERACTION_HANDLER;
                        }
                        try {
                            Trace.beginSection(RemoteViews.this.hasDrawInstructions() ? "RemoteViews#applyActionsAsyncWithDrawInstructions" : "RemoteViews#applyActionsAsync");
                            for (Action a : this.mActions) {
                                a.apply(viewTree.mRoot, this.mParent, applyParams);
                            }
                        }
                        finally {
                            Trace.endSection();
                        }
                    }
                    if (this.mTopLevel && this.mResult instanceof ViewGroup) {
                        RemoteViews.this.finalizeViewRecycling((ViewGroup)this.mResult);
                    }
                }
                catch (Exception e) {
                    this.mError = e;
                }
            }
            if (this.mListener != null) {
                if (this.mError != null) {
                    this.mListener.onError(this.mError);
                } else {
                    this.mListener.onViewApplied(viewTree.mRoot);
                }
            } else if (this.mError != null) {
                if (this.mError instanceof ActionException) {
                    throw (ActionException)this.mError;
                }
                throw new ActionException(this.mError);
            }
        }

        @Override
        public void onCancel() {
            this.cancel(true);
        }

        private CancellationSignal startTaskOnExecutor(Executor executor) {
            this.mCancelSignal.setOnCancelListener(this);
            this.executeOnExecutor(executor == null ? AsyncTask.THREAD_POOL_EXECUTOR : executor, new Void[0]);
            return this.mCancelSignal;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }

    private static class InvalidProtoException
    extends Exception {
        InvalidProtoException(String message) {
            super(message);
        }
    }

    private static class ViewTree {
        private static final int INSERT_AT_END_INDEX = -1;
        private View mRoot;
        private ArrayList<ViewTree> mChildren;

        private ViewTree(View root) {
            this.mRoot = root;
        }

        public void createTree() {
            if (this.mChildren != null) {
                return;
            }
            this.mChildren = new ArrayList();
            if (this.mRoot instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)this.mRoot;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    this.addViewChild(vg.getChildAt(i));
                }
            }
        }

        @Nullable
        public ViewTree findViewTreeById(int id2) {
            if (this.mRoot.getId() == id2) {
                return this;
            }
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                ViewTree result = tree.findViewTreeById(id2);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @Nullable
        public ViewTree findViewTreeParentOf(ViewTree child) {
            if (this.mChildren == null) {
                return null;
            }
            for (ViewTree tree : this.mChildren) {
                if (tree == child) {
                    return this;
                }
                ViewTree result = tree.findViewTreeParentOf(child);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void replaceView(View v) {
            this.mRoot = v;
            this.mChildren = null;
            this.createTree();
        }

        @Nullable
        public <T extends View> T findViewById(int id2) {
            if (this.mChildren == null) {
                return this.mRoot.findViewById(id2);
            }
            ViewTree tree = this.findViewTreeById(id2);
            return (T)(tree == null ? null : tree.mRoot);
        }

        public void addChild(ViewTree child) {
            this.addChild(child, -1);
        }

        public void addChild(ViewTree child, int index) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
            child.createTree();
            if (index == -1) {
                this.mChildren.add(child);
                return;
            }
            this.mChildren.add(index, child);
        }

        public void removeChildren(int start, int count) {
            if (this.mChildren != null) {
                for (int i = 0; i < count; ++i) {
                    this.mChildren.remove(start);
                }
            }
        }

        private void addViewChild(View v) {
            ViewTree target;
            if (v.isRootNamespace()) {
                return;
            }
            if (v.getId() != 0) {
                ViewTree tree = new ViewTree(v);
                this.mChildren.add(tree);
                target = tree;
            } else {
                target = this;
            }
            if (v instanceof ViewGroup && target.mChildren == null) {
                target.mChildren = new ArrayList();
                ViewGroup vg = (ViewGroup)v;
                int count = vg.getChildCount();
                for (int i = 0; i < count; ++i) {
                    target.addViewChild(vg.getChildAt(i));
                }
            }
        }

        public int findChildIndex(Predicate<View> condition) {
            return this.findChildIndex(0, condition);
        }

        public int findChildIndex(int startIndex, Predicate<View> condition) {
            if (this.mChildren == null) {
                return -1;
            }
            for (int i = startIndex; i < this.mChildren.size(); ++i) {
                if (!condition.test(this.mChildren.get((int)i).mRoot)) continue;
                return i;
            }
            return -1;
        }
    }

    public static class RemoteViewOutlineProvider
    extends ViewOutlineProvider {
        private final float mRadius;

        public RemoteViewOutlineProvider(float radius) {
            this.mRadius = radius;
        }

        public float getRadius() {
            return this.mRadius;
        }

        @Override
        public void getOutline(@NonNull View view, @NonNull Outline outline) {
            outline.setRoundRect(0, 0, view.getWidth(), view.getHeight(), this.mRadius);
        }
    }

    private static class RunnableAction
    extends RuntimeAction {
        private final Runnable mRunnable;

        RunnableAction(Runnable r) {
            this.mRunnable = r;
        }

        @Override
        public void apply(View root, ViewGroup rootParent, ActionApplyParams params) {
            this.mRunnable.run();
        }
    }

    private static abstract class RuntimeAction
    extends Action {
        private RuntimeAction() {
        }

        @Override
        public int getActionTag() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            throw new UnsupportedOperationException();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApplyFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ValueType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MarginType {
    }
}

