/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.RecordingCanvas;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewRootImpl;
import android.webkit.LegacyErrorStrings;
import android.webkit.WebViewFactory;
import com.android.internal.hidden_from_bootclasspath.android.webkit.Flags;

@SystemApi
public class WebViewDelegate {
    @UnsupportedAppUsage
    WebViewDelegate() {
    }

    public void setOnTraceEnabledChangeListener(final OnTraceEnabledChangeListener listener) {
        SystemProperties.addChangeCallback(new Runnable(){

            @Override
            public void run() {
                listener.onTraceEnabledChange(WebViewDelegate.this.isTraceTagEnabled());
            }
        });
    }

    public boolean isTraceTagEnabled() {
        return Trace.isTagEnabled(16L);
    }

    @Deprecated
    public boolean canInvokeDrawGlFunctor(View containerView) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void invokeDrawGlFunctor(View containerView, long nativeDrawGLFunctor, boolean waitForCompletion) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void callDrawGlFunction(Canvas canvas, long nativeDrawGLFunctor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void callDrawGlFunction(@NonNull Canvas canvas, long nativeDrawGLFunctor, @Nullable Runnable releasedRunnable) {
        throw new UnsupportedOperationException();
    }

    public void drawWebViewFunctor(@NonNull Canvas canvas, int functor) {
        if (!(canvas instanceof RecordingCanvas)) {
            throw new IllegalArgumentException(canvas.getClass().getName() + " is not a RecordingCanvas canvas");
        }
        ((RecordingCanvas)canvas).drawWebViewFunctor(functor);
    }

    @Deprecated
    public void detachDrawGlFunctor(View containerView, long nativeDrawGLFunctor) {
        if (Flags.mainlineApis()) {
            throw new UnsupportedOperationException();
        }
        ViewRootImpl viewRootImpl = containerView.getViewRootImpl();
        if (nativeDrawGLFunctor != 0L && viewRootImpl != null) {
            viewRootImpl.detachFunctor(nativeDrawGLFunctor);
        }
    }

    public int getPackageId(Resources resources, String packageName) {
        SparseArray<String> packageIdentifiers = resources.getAssets().getAssignedPackageIdentifiers();
        for (int i = 0; i < packageIdentifiers.size(); ++i) {
            String name = packageIdentifiers.valueAt(i);
            if (!packageName.equals(name)) continue;
            return packageIdentifiers.keyAt(i);
        }
        throw new RuntimeException("Package not found: " + packageName);
    }

    public Application getApplication() {
        return ActivityThread.currentApplication();
    }

    public String getErrorString(Context context, int errorCode) {
        return LegacyErrorStrings.getString(errorCode, context);
    }

    public void addWebViewAssetPath(Context context) {
    }

    public boolean isMultiProcessEnabled() {
        return true;
    }

    public String getDataDirectorySuffix() {
        return WebViewFactory.getDataDirectorySuffix();
    }

    @NonNull
    public WebViewFactory.StartupTimestamps getStartupTimestamps() {
        return WebViewFactory.getStartupTimestamps();
    }

    public static interface OnTraceEnabledChangeListener {
        public void onTraceEnabledChange(boolean var1);
    }
}

