/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.assist.ActivityId;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.translation.TranslationSpec;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.BitUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TranslationContext
implements Parcelable {
    public static final int FLAG_LOW_LATENCY = 1;
    public static final int FLAG_TRANSLITERATION = 2;
    public static final int FLAG_DEFINITIONS = 4;
    @NonNull
    private final TranslationSpec mSourceSpec;
    @NonNull
    private final TranslationSpec mTargetSpec;
    private final int mTranslationFlags;
    @Nullable
    private final ActivityId mActivityId;
    @NonNull
    public static final Parcelable.Creator<TranslationContext> CREATOR = new Parcelable.Creator<TranslationContext>(){

        public TranslationContext[] newArray(int size) {
            return new TranslationContext[size];
        }

        @Override
        public TranslationContext createFromParcel(@NonNull Parcel in) {
            return new TranslationContext(in);
        }
    };

    private static int defaultTranslationFlags() {
        return 0;
    }

    private static ActivityId defaultActivityId() {
        return null;
    }

    private void parcelActivityId(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mActivityId != null);
        if (this.mActivityId != null) {
            this.mActivityId.writeToParcel(dest, flags);
        }
    }

    @Nullable
    private ActivityId unparcelActivityId(@NonNull Parcel in) {
        boolean hasActivityId = in.readBoolean();
        return hasActivityId ? new ActivityId(in) : null;
    }

    @SystemApi
    @Nullable
    public ActivityId getActivityId() {
        return this.mActivityId;
    }

    public static String translationFlagToString(int value) {
        return BitUtils.flagsToString(value, TranslationContext::singleTranslationFlagToString);
    }

    static String singleTranslationFlagToString(int value) {
        switch (value) {
            case 1: {
                return "FLAG_LOW_LATENCY";
            }
            case 2: {
                return "FLAG_TRANSLITERATION";
            }
            case 4: {
                return "FLAG_DEFINITIONS";
            }
        }
        return Integer.toHexString(value);
    }

    TranslationContext(@NonNull TranslationSpec sourceSpec, @NonNull TranslationSpec targetSpec, int translationFlags, @Nullable ActivityId activityId) {
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
        this.mActivityId = activityId;
    }

    @NonNull
    public TranslationSpec getSourceSpec() {
        return this.mSourceSpec;
    }

    @NonNull
    public TranslationSpec getTargetSpec() {
        return this.mTargetSpec;
    }

    public int getTranslationFlags() {
        return this.mTranslationFlags;
    }

    public String toString() {
        return "TranslationContext { sourceSpec = " + this.mSourceSpec + ", targetSpec = " + this.mTargetSpec + ", translationFlags = " + TranslationContext.translationFlagToString(this.mTranslationFlags) + ", activityId = " + this.mActivityId + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mActivityId != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mSourceSpec, flags);
        dest.writeTypedObject(this.mTargetSpec, flags);
        dest.writeInt(this.mTranslationFlags);
        this.parcelActivityId(dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TranslationContext(@NonNull Parcel in) {
        byte flg = in.readByte();
        TranslationSpec sourceSpec = in.readTypedObject(TranslationSpec.CREATOR);
        TranslationSpec targetSpec = in.readTypedObject(TranslationSpec.CREATOR);
        int translationFlags = in.readInt();
        ActivityId activityId = this.unparcelActivityId(in);
        this.mSourceSpec = sourceSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
        this.mTargetSpec = targetSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        this.mTranslationFlags = translationFlags;
        Preconditions.checkFlagsArgument(this.mTranslationFlags, 7);
        this.mActivityId = activityId;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        @NonNull
        private TranslationSpec mSourceSpec;
        @NonNull
        private TranslationSpec mTargetSpec;
        private int mTranslationFlags;
        @Nullable
        private ActivityId mActivityId;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull TranslationSpec sourceSpec, @NonNull TranslationSpec targetSpec) {
            this.mSourceSpec = sourceSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mSourceSpec);
            this.mTargetSpec = targetSpec;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTargetSpec);
        }

        @NonNull
        public Builder setTranslationFlags(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mTranslationFlags = value;
            return this;
        }

        @NonNull
        public Builder setActivityId(@NonNull ActivityId value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mActivityId = value;
            return this;
        }

        @NonNull
        public TranslationContext build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mTranslationFlags = TranslationContext.defaultTranslationFlags();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mActivityId = TranslationContext.defaultActivityId();
            }
            TranslationContext o = new TranslationContext(this.mSourceSpec, this.mTargetSpec, this.mTranslationFlags, this.mActivityId);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x10L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TranslationFlag {
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }
    }
}

