/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.NonNull;
import android.view.textclassifier.ConversationActions;
import android.view.textclassifier.Log;
import android.view.textclassifier.SelectionEvent;
import android.view.textclassifier.SelectionSessionLogger;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSessionId;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextClassifierEvent;
import android.view.textclassifier.TextLanguage;
import android.view.textclassifier.TextLinks;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import com.android.layoutlib.bridge.libcore.util.Cleaner;
import java.util.Objects;
import java.util.function.Supplier;

class TextClassificationSession
implements TextClassifier {
    private static final String LOG_TAG = "TextClassificationSession";
    private final TextClassifier mDelegate;
    private final SelectionEventHelper mEventHelper;
    private final TextClassificationSessionId mSessionId;
    private final TextClassificationContext mClassificationContext;
    private final Cleaner mCleaner;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;

    TextClassificationSession(TextClassificationContext context, TextClassifier delegate) {
        this.mClassificationContext = Objects.requireNonNull(context);
        this.mDelegate = Objects.requireNonNull(delegate);
        this.mSessionId = new TextClassificationSessionId();
        this.mEventHelper = new SelectionEventHelper(this.mSessionId, this.mClassificationContext);
        this.initializeRemoteSession();
        this.mCleaner = Cleaner.create(this, new CleanerRunnable(this.mEventHelper, this.mDelegate));
    }

    @Override
    public TextSelection suggestSelection(TextSelection.Request request) {
        return this.checkDestroyedAndRun(() -> this.mDelegate.suggestSelection(request));
    }

    private void initializeRemoteSession() {
        if (this.mDelegate instanceof SystemTextClassifier) {
            ((SystemTextClassifier)this.mDelegate).initializeRemoteSession(this.mClassificationContext, this.mSessionId);
        }
    }

    @Override
    public TextClassification classifyText(TextClassification.Request request) {
        return this.checkDestroyedAndRun(() -> this.mDelegate.classifyText(request));
    }

    @Override
    public TextLinks generateLinks(TextLinks.Request request) {
        return this.checkDestroyedAndRun(() -> this.mDelegate.generateLinks(request));
    }

    @Override
    public ConversationActions suggestConversationActions(ConversationActions.Request request) {
        return this.checkDestroyedAndRun(() -> this.mDelegate.suggestConversationActions(request));
    }

    @Override
    public TextLanguage detectLanguage(TextLanguage.Request request) {
        return this.checkDestroyedAndRun(() -> this.mDelegate.detectLanguage(request));
    }

    @Override
    public int getMaxGenerateLinksTextLength() {
        return this.checkDestroyedAndRun(this.mDelegate::getMaxGenerateLinksTextLength);
    }

    @Override
    public void onSelectionEvent(SelectionEvent event) {
        this.checkDestroyedAndRun(() -> {
            try {
                if (this.mEventHelper.sanitizeEvent(event)) {
                    this.mDelegate.onSelectionEvent(event);
                }
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error reporting text classifier selection event", e);
            }
            return null;
        });
    }

    @Override
    public void onTextClassifierEvent(TextClassifierEvent event) {
        this.checkDestroyedAndRun(() -> {
            try {
                event.mHiddenTempSessionId = this.mSessionId;
                this.mDelegate.onTextClassifierEvent(event);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error reporting text classifier event", e);
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDestroyed) {
                this.mCleaner.clean();
                this.mDestroyed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T checkDestroyedAndRun(Supplier<T> responseSupplier) {
        if (!this.isDestroyed()) {
            T response = responseSupplier.get();
            Object object = this.mLock;
            synchronized (object) {
                if (!this.mDestroyed) {
                    return response;
                }
            }
        }
        throw new IllegalStateException("This TextClassification session has been destroyed");
    }

    private static class SelectionEventHelper {
        private final TextClassificationSessionId mSessionId;
        private final TextClassificationContext mContext;
        private int mInvocationMethod = 0;
        private SelectionEvent mPrevEvent;
        private SelectionEvent mSmartEvent;
        private SelectionEvent mStartEvent;

        SelectionEventHelper(TextClassificationSessionId sessionId, TextClassificationContext context) {
            this.mSessionId = Objects.requireNonNull(sessionId);
            this.mContext = Objects.requireNonNull(context);
        }

        boolean sanitizeEvent(SelectionEvent event) {
            this.updateInvocationMethod(event);
            this.modifyAutoSelectionEventType(event);
            if (event.getEventType() != 1 && this.mStartEvent == null) {
                Log.d(TextClassificationSession.LOG_TAG, "Selection session not yet started. Ignoring event");
                return false;
            }
            long now = System_Delegate.currentTimeMillis();
            switch (event.getEventType()) {
                case 1: {
                    Preconditions.checkArgument(event.getAbsoluteEnd() == event.getAbsoluteStart() + 1);
                    event.setSessionId(this.mSessionId);
                    this.mStartEvent = event;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.mSmartEvent = event;
                    break;
                }
                case 100: 
                case 107: {
                    if (this.mPrevEvent == null) break;
                    event.setEntityType(this.mPrevEvent.getEntityType());
                    break;
                }
                case 2: {
                    if (this.mPrevEvent == null || this.mPrevEvent.getAbsoluteStart() != event.getAbsoluteStart() || this.mPrevEvent.getAbsoluteEnd() != event.getAbsoluteEnd()) break;
                    return false;
                }
            }
            event.setEventTime(now);
            if (this.mStartEvent != null) {
                event.setSessionId(this.mStartEvent.getSessionId()).setDurationSinceSessionStart(now - this.mStartEvent.getEventTime()).setStart(event.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setEnd(event.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mSmartEvent != null) {
                event.setResultId(this.mSmartEvent.getResultId()).setSmartStart(this.mSmartEvent.getAbsoluteStart() - this.mStartEvent.getAbsoluteStart()).setSmartEnd(this.mSmartEvent.getAbsoluteEnd() - this.mStartEvent.getAbsoluteStart());
            }
            if (this.mPrevEvent != null) {
                event.setDurationSincePreviousEvent(now - this.mPrevEvent.getEventTime()).setEventIndex(this.mPrevEvent.getEventIndex() + 1);
            }
            this.mPrevEvent = event;
            return true;
        }

        void endSession() {
            this.mPrevEvent = null;
            this.mSmartEvent = null;
            this.mStartEvent = null;
        }

        private void updateInvocationMethod(SelectionEvent event) {
            event.setTextClassificationSessionContext(this.mContext);
            if (event.getInvocationMethod() == 0) {
                event.setInvocationMethod(this.mInvocationMethod);
            } else {
                this.mInvocationMethod = event.getInvocationMethod();
            }
        }

        private void modifyAutoSelectionEventType(SelectionEvent event) {
            switch (event.getEventType()) {
                case 3: 
                case 4: 
                case 5: {
                    if (SelectionSessionLogger.isPlatformLocalTextClassifierSmartSelection(event.getResultId())) {
                        if (event.getAbsoluteEnd() - event.getAbsoluteStart() > 1) {
                            event.setEventType(4);
                        } else {
                            event.setEventType(3);
                        }
                    } else {
                        event.setEventType(5);
                    }
                    return;
                }
            }
        }
    }

    private static class CleanerRunnable
    implements Runnable {
        @NonNull
        private final SelectionEventHelper mEventHelper;
        @NonNull
        private final TextClassifier mDelegate;

        CleanerRunnable(@NonNull SelectionEventHelper eventHelper, @NonNull TextClassifier delegate) {
            this.mEventHelper = Objects.requireNonNull(eventHelper);
            this.mDelegate = Objects.requireNonNull(delegate);
        }

        @Override
        public void run() {
            this.mEventHelper.endSession();
            this.mDelegate.destroy();
        }
    }
}

