/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.ServiceManager;
import android.view.textclassifier.Log;
import android.view.textclassifier.SystemTextClassifier;
import android.view.textclassifier.TextClassificationConstants;
import android.view.textclassifier.TextClassificationContext;
import android.view.textclassifier.TextClassificationSession;
import android.view.textclassifier.TextClassificationSessionFactory;
import android.view.textclassifier.TextClassifier;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.util.Objects;

public class TextClassificationManager {
    private static final String LOG_TAG = "androidtc";
    private static final TextClassificationConstants sDefaultSettings = new TextClassificationConstants();
    private final Object mLock = new Object();
    private final TextClassificationSessionFactory mDefaultSessionFactory = classificationContext -> new TextClassificationSession(classificationContext, this.getTextClassifier());
    private final Context mContext;
    @GuardedBy(value={"mLock"})
    @Nullable
    private TextClassifier mCustomTextClassifier;
    @GuardedBy(value={"mLock"})
    private TextClassificationSessionFactory mSessionFactory;
    @GuardedBy(value={"mLock"})
    private TextClassificationConstants mSettings;

    public TextClassificationManager(Context context) {
        this.mContext = Objects.requireNonNull(context);
        this.mSessionFactory = this.mDefaultSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public TextClassifier getTextClassifier() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCustomTextClassifier != null) {
                return this.mCustomTextClassifier;
            }
            if (this.getSettings().isSystemTextClassifierEnabled()) {
                return this.getSystemTextClassifier(1);
            }
            return this.getLocalTextClassifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassifier(@Nullable TextClassifier textClassifier) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCustomTextClassifier = textClassifier;
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public TextClassifier getTextClassifier(int type) {
        switch (type) {
            case 0: {
                return this.getLocalTextClassifier();
            }
        }
        return this.getSystemTextClassifier(type);
    }

    @SystemApi
    @NonNull
    @FlaggedApi(value="android.permission.flags.text_classifier_choice_api_enabled")
    @RequiresPermission(value="android.permission.ACCESS_TEXT_CLASSIFIER_BY_TYPE")
    public TextClassifier getClassifier(int type) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.ACCESS_TEXT_CLASSIFIER_BY_TYPE") != 0) {
            throw new SecurityException("Caller does not have permission android.permission.ACCESS_TEXT_CLASSIFIER_BY_TYPE");
        }
        return this.getTextClassifier(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassificationConstants getSettings() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSettings == null) {
                this.mSettings = new TextClassificationConstants();
            }
            return this.mSettings;
        }
    }

    @NonNull
    public TextClassifier createTextClassificationSession(@NonNull TextClassificationContext classificationContext) {
        Objects.requireNonNull(classificationContext);
        TextClassifier textClassifier = this.mSessionFactory.createTextClassificationSession(classificationContext);
        Objects.requireNonNull(textClassifier, "Session Factory should never return null");
        return textClassifier;
    }

    public TextClassifier createTextClassificationSession(TextClassificationContext classificationContext, TextClassifier textClassifier) {
        Objects.requireNonNull(classificationContext);
        Objects.requireNonNull(textClassifier);
        return new TextClassificationSession(classificationContext, textClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextClassificationSessionFactory(@Nullable TextClassificationSessionFactory factory) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionFactory = factory != null ? factory : this.mDefaultSessionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextClassifier getSystemTextClassifier(int type) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.getSettings().isSystemTextClassifierEnabled()) {
                try {
                    Log.d(LOG_TAG, "Initializing SystemTextClassifier, type = " + TextClassifier.typeToString(type));
                    return new SystemTextClassifier(this.mContext, this.getSettings(), type == 2);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    Log.e(LOG_TAG, "Could not initialize SystemTextClassifier", e);
                }
            }
            return TextClassifier.NO_OP;
        }
    }

    @NonNull
    private TextClassifier getLocalTextClassifier() {
        Log.d(LOG_TAG, "Local text-classifier not supported. Returning a no-op text-classifier.");
        return TextClassifier.NO_OP;
    }

    public void dump(IndentingPrintWriter pw) {
        this.getSystemTextClassifier(2).dump(pw);
        this.getSystemTextClassifier(1).dump(pw);
        this.getSettings().dump(pw);
    }

    public static TextClassificationConstants getSettings(Context context) {
        Objects.requireNonNull(context);
        TextClassificationManager tcm = context.getSystemService(TextClassificationManager.class);
        if (tcm != null) {
            return tcm.getSettings();
        }
        return sDefaultSettings;
    }
}

