/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.DataShareRequest;
import android.view.contentcapture.IContentCaptureOptionsCallback;
import android.view.contentcapture.IDataShareWriteAdapter;
import com.android.internal.os.IResultReceiver;

public interface IContentCaptureManager
extends IInterface {
    public static final String DESCRIPTOR = "android.view.contentcapture.IContentCaptureManager";

    public void startSession(IBinder var1, IBinder var2, ComponentName var3, int var4, int var5, IResultReceiver var6) throws RemoteException;

    public void finishSession(int var1) throws RemoteException;

    public void getServiceComponentName(IResultReceiver var1) throws RemoteException;

    public void removeData(DataRemovalRequest var1) throws RemoteException;

    public void shareData(DataShareRequest var1, IDataShareWriteAdapter var2) throws RemoteException;

    public void isContentCaptureFeatureEnabled(IResultReceiver var1) throws RemoteException;

    public void getServiceSettingsActivity(IResultReceiver var1) throws RemoteException;

    public void getContentCaptureConditions(String var1, IResultReceiver var2) throws RemoteException;

    public void resetTemporaryService(int var1) throws RemoteException;

    public void setTemporaryService(int var1, String var2, int var3) throws RemoteException;

    public void setDefaultServiceEnabled(int var1, boolean var2) throws RemoteException;

    public void registerContentCaptureOptionsCallback(String var1, IContentCaptureOptionsCallback var2) throws RemoteException;

    public void onLoginDetected(ParceledListSlice<ContentCaptureEvent> var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentCaptureManager {
        static final int TRANSACTION_startSession = 1;
        static final int TRANSACTION_finishSession = 2;
        static final int TRANSACTION_getServiceComponentName = 3;
        static final int TRANSACTION_removeData = 4;
        static final int TRANSACTION_shareData = 5;
        static final int TRANSACTION_isContentCaptureFeatureEnabled = 6;
        static final int TRANSACTION_getServiceSettingsActivity = 7;
        static final int TRANSACTION_getContentCaptureConditions = 8;
        static final int TRANSACTION_resetTemporaryService = 9;
        static final int TRANSACTION_setTemporaryService = 10;
        static final int TRANSACTION_setDefaultServiceEnabled = 11;
        static final int TRANSACTION_registerContentCaptureOptionsCallback = 12;
        static final int TRANSACTION_onLoginDetected = 13;

        public Stub() {
            this.attachInterface(this, IContentCaptureManager.DESCRIPTOR);
        }

        public static IContentCaptureManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContentCaptureManager.DESCRIPTOR);
            if (iin != null && iin instanceof IContentCaptureManager) {
                return (IContentCaptureManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startSession";
                }
                case 2: {
                    return "finishSession";
                }
                case 3: {
                    return "getServiceComponentName";
                }
                case 4: {
                    return "removeData";
                }
                case 5: {
                    return "shareData";
                }
                case 6: {
                    return "isContentCaptureFeatureEnabled";
                }
                case 7: {
                    return "getServiceSettingsActivity";
                }
                case 8: {
                    return "getContentCaptureConditions";
                }
                case 9: {
                    return "resetTemporaryService";
                }
                case 10: {
                    return "setTemporaryService";
                }
                case 11: {
                    return "setDefaultServiceEnabled";
                }
                case 12: {
                    return "registerContentCaptureOptionsCallback";
                }
                case 13: {
                    return "onLoginDetected";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContentCaptureManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    IResultReceiver _arg5 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishSession(_arg0);
                    break;
                }
                case 3: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getServiceComponentName(_arg0);
                    break;
                }
                case 4: {
                    DataRemovalRequest _arg0 = data.readTypedObject(DataRemovalRequest.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeData(_arg0);
                    break;
                }
                case 5: {
                    DataShareRequest _arg0 = data.readTypedObject(DataShareRequest.CREATOR);
                    IDataShareWriteAdapter _arg1 = IDataShareWriteAdapter.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.shareData(_arg0, _arg1);
                    break;
                }
                case 6: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isContentCaptureFeatureEnabled(_arg0);
                    break;
                }
                case 7: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getServiceSettingsActivity(_arg0);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    IResultReceiver _arg1 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getContentCaptureConditions(_arg0, _arg1);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetTemporaryService(_arg0);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTemporaryService(_arg0, _arg1, _arg2);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDefaultServiceEnabled(_arg0, _arg1);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    IContentCaptureOptionsCallback _arg1 = IContentCaptureOptionsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerContentCaptureOptionsCallback(_arg0, _arg1);
                    break;
                }
                case 13: {
                    ParceledListSlice _arg0 = data.readTypedObject(ParceledListSlice.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLoginDetected(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 12;
        }

        private static class Proxy
        implements IContentCaptureManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContentCaptureManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSession(IBinder activityToken, IBinder shareableActivityToken, ComponentName componentName, int sessionId, int flags, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(shareableActivityToken);
                    _data.writeTypedObject(componentName, 0);
                    _data.writeInt(sessionId);
                    _data.writeInt(flags);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSession(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceComponentName(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeData(DataRemovalRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void shareData(DataShareRequest request, IDataShareWriteAdapter adapter) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(adapter);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isContentCaptureFeatureEnabled(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceSettingsActivity(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getContentCaptureConditions(String packageName, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetTemporaryService(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(serviceName);
                    _data.writeInt(duration);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerContentCaptureOptionsCallback(String packageName, IContentCaptureOptionsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLoginDetected(ParceledListSlice<ContentCaptureEvent> events) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentCaptureManager.DESCRIPTOR);
                    _data.writeTypedObject(events, 0);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentCaptureManager {
        @Override
        public void startSession(IBinder activityToken, IBinder shareableActivityToken, ComponentName componentName, int sessionId, int flags, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void finishSession(int sessionId) throws RemoteException {
        }

        @Override
        public void getServiceComponentName(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void removeData(DataRemovalRequest request) throws RemoteException {
        }

        @Override
        public void shareData(DataShareRequest request, IDataShareWriteAdapter adapter) throws RemoteException {
        }

        @Override
        public void isContentCaptureFeatureEnabled(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getServiceSettingsActivity(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getContentCaptureConditions(String packageName, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void resetTemporaryService(int userId) throws RemoteException {
        }

        @Override
        public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
        }

        @Override
        public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
        }

        @Override
        public void registerContentCaptureOptionsCallback(String packageName, IContentCaptureOptionsCallback callback) throws RemoteException {
        }

        @Override
        public void onLoginDetected(ParceledListSlice<ContentCaptureEvent> events) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

