/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.RequiresNoPermission;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;

public interface IWindowSurfaceInfoCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.view.accessibility.IWindowSurfaceInfoCallback";

    @RequiresNoPermission
    public void provideWindowSurfaceInfo(int var1, int var2, SurfaceControl var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSurfaceInfoCallback {
        static final int TRANSACTION_provideWindowSurfaceInfo = 1;

        public Stub() {
            this.attachInterface(this, IWindowSurfaceInfoCallback.DESCRIPTOR);
        }

        public static IWindowSurfaceInfoCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IWindowSurfaceInfoCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IWindowSurfaceInfoCallback) {
                return (IWindowSurfaceInfoCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "provideWindowSurfaceInfo";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IWindowSurfaceInfoCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideWindowSurfaceInfo(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IWindowSurfaceInfoCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IWindowSurfaceInfoCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideWindowSurfaceInfo(int windowFlags, int processUid, SurfaceControl surfaceControl) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IWindowSurfaceInfoCallback.DESCRIPTOR);
                    _data.writeInt(windowFlags);
                    _data.writeInt(processUid);
                    _data.writeTypedObject(surfaceControl, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWindowSurfaceInfoCallback {
        @Override
        public void provideWindowSurfaceInfo(int windowFlags, int processUid, SurfaceControl surfaceControl) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

