/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.app.RemoteAction;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.os.BadParcelableException;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.InputEvent;
import android.view.MagnificationSpec;
import android.view.SurfaceControl;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityWindowAttributes;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityManagerClient;
import android.view.accessibility.IMagnificationConnection;
import android.view.accessibility.IUserInitializationCompleteCallback;
import java.util.ArrayList;
import java.util.List;

public interface IAccessibilityManager
extends IInterface {
    @RequiresNoPermission
    public void interrupt(int var1) throws RemoteException;

    @RequiresNoPermission
    public void sendAccessibilityEvent(AccessibilityEvent var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public long addClient(IAccessibilityManagerClient var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public boolean removeClient(IAccessibilityManagerClient var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public ParceledListSlice<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/accessibility/IAccessibilityManager.aidl:62:1:62:69")
    @RequiresNoPermission
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public int addAccessibilityInteractionConnection(IWindow var1, IBinder var2, IAccessibilityInteractionConnection var3, String var4, int var5) throws RemoteException;

    @RequiresNoPermission
    public void removeAccessibilityInteractionConnection(IWindow var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MODIFY_ACCESSIBILITY_DATA")
    public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection var1) throws RemoteException;

    @EnforcePermission(value="android.permission.RETRIEVE_WINDOW_CONTENT")
    public void registerUiTestAutomationService(IBinder var1, IAccessibilityServiceClient var2, AccessibilityServiceInfo var3, int var4, int var5) throws RemoteException;

    @RequiresNoPermission
    public void unregisterUiTestAutomationService(IAccessibilityServiceClient var1) throws RemoteException;

    @EnforcePermission(value="android.permission.RETRIEVE_WINDOW_CONTENT")
    public IBinder getWindowToken(int var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonClicked(int var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonLongClicked(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.STATUS_BAR_SERVICE")
    public void notifyAccessibilityButtonVisibilityChanged(boolean var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void performAccessibilityShortcut(int var1, int var2, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public List<String> getAccessibilityShortcutTargets(int var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public boolean sendFingerprintGesture(int var1) throws RemoteException;

    @RequiresNoPermission
    public int getAccessibilityWindowId(IBinder var1) throws RemoteException;

    @RequiresNoPermission
    public long getRecommendedTimeoutMillis() throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void registerSystemAction(RemoteAction var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void unregisterSystemAction(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.STATUS_BAR_SERVICE")
    public void setMagnificationConnection(IMagnificationConnection var1) throws RemoteException;

    @RequiresNoPermission
    public void associateEmbeddedHierarchy(IBinder var1, IBinder var2) throws RemoteException;

    @RequiresNoPermission
    public void disassociateEmbeddedHierarchy(IBinder var1) throws RemoteException;

    @RequiresNoPermission
    public int getFocusStrokeWidth() throws RemoteException;

    @RequiresNoPermission
    public int getFocusColor() throws RemoteException;

    @RequiresNoPermission
    public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException;

    @EnforcePermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningEnabled(boolean var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public boolean isSystemAudioCaptioningUiEnabled(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.SET_SYSTEM_AUDIO_CAPTION")
    public void setSystemAudioCaptioningUiEnabled(boolean var1, int var2) throws RemoteException;

    @RequiresNoPermission
    public void setAccessibilityWindowAttributes(int var1, int var2, int var3, AccessibilityWindowAttributes var4) throws RemoteException;

    public boolean registerProxyForDisplay(IAccessibilityServiceClient var1, int var2) throws RemoteException;

    public boolean unregisterProxyForDisplay(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.INJECT_EVENTS")
    public void injectInputEventToInputFilter(InputEvent var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public boolean startFlashNotificationSequence(String var1, int var2, IBinder var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public boolean stopFlashNotificationSequence(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public boolean startFlashNotificationEvent(String var1, int var2, String var3) throws RemoteException;

    @RequiresNoPermission
    public boolean isAccessibilityTargetAllowed(String var1, int var2, int var3) throws RemoteException;

    @RequiresNoPermission
    public boolean sendRestrictedDialogIntent(String var1, int var2, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public boolean isAccessibilityServiceWarningRequired(AccessibilityServiceInfo var1) throws RemoteException;

    @RequiresNoPermission
    public WindowTransformationSpec getWindowTransformationSpec(int var1) throws RemoteException;

    @EnforcePermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    public void attachAccessibilityOverlayToDisplay(int var1, SurfaceControl var2) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.STATUS_BAR_SERVICE", "android.permission.MANAGE_ACCESSIBILITY"})
    public void notifyQuickSettingsTilesChanged(int var1, List<ComponentName> var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void enableShortcutsForTargets(boolean var1, int var2, List<String> var3, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public Bundle getA11yFeatureToTileMap(int var1) throws RemoteException;

    @RequiresNoPermission
    public void registerUserInitializationCompleteCallback(IUserInitializationCompleteCallback var1) throws RemoteException;

    @RequiresNoPermission
    public void unregisterUserInitializationCompleteCallback(IUserInitializationCompleteCallback var1) throws RemoteException;

    @RequiresNoPermission
    public boolean enableTrustedAccessibilityService(ComponentName var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.MANAGE_ACCESSIBILITY")
    public void setTrustedAccessibilityServiceForTesting(ComponentName var1) throws RemoteException;

    public static class WindowTransformationSpec
    implements Parcelable {
        public float[] transformationMatrix;
        public MagnificationSpec magnificationSpec;
        public static final Parcelable.Creator<WindowTransformationSpec> CREATOR = new Parcelable.Creator<WindowTransformationSpec>(){

            @Override
            public WindowTransformationSpec createFromParcel(Parcel _aidl_source) {
                WindowTransformationSpec _aidl_out = new WindowTransformationSpec();
                _aidl_out.readFromParcel(_aidl_source);
                return _aidl_out;
            }

            public WindowTransformationSpec[] newArray(int _aidl_size) {
                return new WindowTransformationSpec[_aidl_size];
            }
        };

        @Override
        public void writeToParcel(Parcel _aidl_parcel, int _aidl_flag) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.writeInt(0);
            _aidl_parcel.writeFloatArray(this.transformationMatrix);
            _aidl_parcel.writeTypedObject(this.magnificationSpec, _aidl_flag);
            int _aidl_end_pos = _aidl_parcel.dataPosition();
            _aidl_parcel.setDataPosition(_aidl_start_pos);
            _aidl_parcel.writeInt(_aidl_end_pos - _aidl_start_pos);
            _aidl_parcel.setDataPosition(_aidl_end_pos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readFromParcel(Parcel _aidl_parcel) {
            int _aidl_start_pos = _aidl_parcel.dataPosition();
            int _aidl_parcelable_size = _aidl_parcel.readInt();
            try {
                if (_aidl_parcelable_size < 4) {
                    throw new BadParcelableException("Parcelable too small");
                }
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.transformationMatrix = _aidl_parcel.createFloatArray();
                if (_aidl_parcel.dataPosition() - _aidl_start_pos >= _aidl_parcelable_size) {
                    return;
                }
                this.magnificationSpec = _aidl_parcel.readTypedObject(MagnificationSpec.CREATOR);
            }
            finally {
                if (_aidl_start_pos > Integer.MAX_VALUE - _aidl_parcelable_size) {
                    throw new BadParcelableException("Overflow in the size of parcelable");
                }
                _aidl_parcel.setDataPosition(_aidl_start_pos + _aidl_parcelable_size);
            }
        }

        @Override
        public int describeContents() {
            int _mask = 0;
            return _mask |= this.describeContents(this.magnificationSpec);
        }

        private int describeContents(Object _v) {
            if (_v == null) {
                return 0;
            }
            if (_v instanceof Parcelable) {
                return ((Parcelable)_v).describeContents();
            }
            return 0;
        }
    }

    public static abstract class Stub
    extends Binder
    implements IAccessibilityManager {
        private final PermissionEnforcer mEnforcer;
        public static final String DESCRIPTOR = "android.view.accessibility.IAccessibilityManager";
        static final int TRANSACTION_interrupt = 1;
        static final int TRANSACTION_sendAccessibilityEvent = 2;
        static final int TRANSACTION_addClient = 3;
        static final int TRANSACTION_removeClient = 4;
        static final int TRANSACTION_getInstalledAccessibilityServiceList = 5;
        static final int TRANSACTION_getEnabledAccessibilityServiceList = 6;
        static final int TRANSACTION_addAccessibilityInteractionConnection = 7;
        static final int TRANSACTION_removeAccessibilityInteractionConnection = 8;
        static final int TRANSACTION_setPictureInPictureActionReplacingConnection = 9;
        static final int TRANSACTION_registerUiTestAutomationService = 10;
        static final int TRANSACTION_unregisterUiTestAutomationService = 11;
        static final int TRANSACTION_getWindowToken = 12;
        static final int TRANSACTION_notifyAccessibilityButtonClicked = 13;
        static final int TRANSACTION_notifyAccessibilityButtonLongClicked = 14;
        static final int TRANSACTION_notifyAccessibilityButtonVisibilityChanged = 15;
        static final int TRANSACTION_performAccessibilityShortcut = 16;
        static final int TRANSACTION_getAccessibilityShortcutTargets = 17;
        static final int TRANSACTION_sendFingerprintGesture = 18;
        static final int TRANSACTION_getAccessibilityWindowId = 19;
        static final int TRANSACTION_getRecommendedTimeoutMillis = 20;
        static final int TRANSACTION_registerSystemAction = 21;
        static final int TRANSACTION_unregisterSystemAction = 22;
        static final int TRANSACTION_setMagnificationConnection = 23;
        static final int TRANSACTION_associateEmbeddedHierarchy = 24;
        static final int TRANSACTION_disassociateEmbeddedHierarchy = 25;
        static final int TRANSACTION_getFocusStrokeWidth = 26;
        static final int TRANSACTION_getFocusColor = 27;
        static final int TRANSACTION_isAudioDescriptionByDefaultEnabled = 28;
        static final int TRANSACTION_setSystemAudioCaptioningEnabled = 29;
        static final int TRANSACTION_isSystemAudioCaptioningUiEnabled = 30;
        static final int TRANSACTION_setSystemAudioCaptioningUiEnabled = 31;
        static final int TRANSACTION_setAccessibilityWindowAttributes = 32;
        static final int TRANSACTION_registerProxyForDisplay = 33;
        static final int TRANSACTION_unregisterProxyForDisplay = 34;
        static final int TRANSACTION_injectInputEventToInputFilter = 35;
        static final int TRANSACTION_startFlashNotificationSequence = 36;
        static final int TRANSACTION_stopFlashNotificationSequence = 37;
        static final int TRANSACTION_startFlashNotificationEvent = 38;
        static final int TRANSACTION_isAccessibilityTargetAllowed = 39;
        static final int TRANSACTION_sendRestrictedDialogIntent = 40;
        static final int TRANSACTION_isAccessibilityServiceWarningRequired = 41;
        static final int TRANSACTION_getWindowTransformationSpec = 42;
        static final int TRANSACTION_attachAccessibilityOverlayToDisplay = 43;
        static final int TRANSACTION_notifyQuickSettingsTilesChanged = 44;
        static final String[] PERMISSIONS_notifyQuickSettingsTilesChanged = new String[]{"android.permission.STATUS_BAR_SERVICE", "android.permission.MANAGE_ACCESSIBILITY"};
        static final int TRANSACTION_enableShortcutsForTargets = 45;
        static final int TRANSACTION_getA11yFeatureToTileMap = 46;
        static final int TRANSACTION_registerUserInitializationCompleteCallback = 47;
        static final int TRANSACTION_unregisterUserInitializationCompleteCallback = 48;
        static final int TRANSACTION_enableTrustedAccessibilityService = 49;
        static final int TRANSACTION_setTrustedAccessibilityServiceForTesting = 50;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IAccessibilityManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAccessibilityManager) {
                return (IAccessibilityManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "interrupt";
                }
                case 2: {
                    return "sendAccessibilityEvent";
                }
                case 3: {
                    return "addClient";
                }
                case 4: {
                    return "removeClient";
                }
                case 5: {
                    return "getInstalledAccessibilityServiceList";
                }
                case 6: {
                    return "getEnabledAccessibilityServiceList";
                }
                case 7: {
                    return "addAccessibilityInteractionConnection";
                }
                case 8: {
                    return "removeAccessibilityInteractionConnection";
                }
                case 9: {
                    return "setPictureInPictureActionReplacingConnection";
                }
                case 10: {
                    return "registerUiTestAutomationService";
                }
                case 11: {
                    return "unregisterUiTestAutomationService";
                }
                case 12: {
                    return "getWindowToken";
                }
                case 13: {
                    return "notifyAccessibilityButtonClicked";
                }
                case 14: {
                    return "notifyAccessibilityButtonLongClicked";
                }
                case 15: {
                    return "notifyAccessibilityButtonVisibilityChanged";
                }
                case 16: {
                    return "performAccessibilityShortcut";
                }
                case 17: {
                    return "getAccessibilityShortcutTargets";
                }
                case 18: {
                    return "sendFingerprintGesture";
                }
                case 19: {
                    return "getAccessibilityWindowId";
                }
                case 20: {
                    return "getRecommendedTimeoutMillis";
                }
                case 21: {
                    return "registerSystemAction";
                }
                case 22: {
                    return "unregisterSystemAction";
                }
                case 23: {
                    return "setMagnificationConnection";
                }
                case 24: {
                    return "associateEmbeddedHierarchy";
                }
                case 25: {
                    return "disassociateEmbeddedHierarchy";
                }
                case 26: {
                    return "getFocusStrokeWidth";
                }
                case 27: {
                    return "getFocusColor";
                }
                case 28: {
                    return "isAudioDescriptionByDefaultEnabled";
                }
                case 29: {
                    return "setSystemAudioCaptioningEnabled";
                }
                case 30: {
                    return "isSystemAudioCaptioningUiEnabled";
                }
                case 31: {
                    return "setSystemAudioCaptioningUiEnabled";
                }
                case 32: {
                    return "setAccessibilityWindowAttributes";
                }
                case 33: {
                    return "registerProxyForDisplay";
                }
                case 34: {
                    return "unregisterProxyForDisplay";
                }
                case 35: {
                    return "injectInputEventToInputFilter";
                }
                case 36: {
                    return "startFlashNotificationSequence";
                }
                case 37: {
                    return "stopFlashNotificationSequence";
                }
                case 38: {
                    return "startFlashNotificationEvent";
                }
                case 39: {
                    return "isAccessibilityTargetAllowed";
                }
                case 40: {
                    return "sendRestrictedDialogIntent";
                }
                case 41: {
                    return "isAccessibilityServiceWarningRequired";
                }
                case 42: {
                    return "getWindowTransformationSpec";
                }
                case 43: {
                    return "attachAccessibilityOverlayToDisplay";
                }
                case 44: {
                    return "notifyQuickSettingsTilesChanged";
                }
                case 45: {
                    return "enableShortcutsForTargets";
                }
                case 46: {
                    return "getA11yFeatureToTileMap";
                }
                case 47: {
                    return "registerUserInitializationCompleteCallback";
                }
                case 48: {
                    return "unregisterUserInitializationCompleteCallback";
                }
                case 49: {
                    return "enableTrustedAccessibilityService";
                }
                case 50: {
                    return "setTrustedAccessibilityServiceForTesting";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.interrupt(_arg0);
                    break;
                }
                case 2: {
                    AccessibilityEvent _arg0 = data.readTypedObject(AccessibilityEvent.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.sendAccessibilityEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IAccessibilityManagerClient _arg0 = IAccessibilityManagerClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    long _result = this.addClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 4: {
                    IAccessibilityManagerClient _arg0 = IAccessibilityManagerClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    ParceledListSlice<AccessibilityServiceInfo> _result = this.getInstalledAccessibilityServiceList(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<AccessibilityServiceInfo> _result = this.getEnabledAccessibilityServiceList(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 7: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    IBinder _arg1 = data.readStrongBinder();
                    IAccessibilityInteractionConnection _arg2 = IAccessibilityInteractionConnection.Stub.asInterface(data.readStrongBinder());
                    String _arg3 = data.readString();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.addAccessibilityInteractionConnection(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    IWindow _arg0 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeAccessibilityInteractionConnection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IAccessibilityInteractionConnection _arg0 = IAccessibilityInteractionConnection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setPictureInPictureActionReplacingConnection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    IAccessibilityServiceClient _arg1 = IAccessibilityServiceClient.Stub.asInterface(data.readStrongBinder());
                    AccessibilityServiceInfo _arg2 = data.readTypedObject(AccessibilityServiceInfo.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerUiTestAutomationService(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    IAccessibilityServiceClient _arg0 = IAccessibilityServiceClient.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterUiTestAutomationService(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.notifyAccessibilityButtonClicked(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyAccessibilityButtonLongClicked(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.notifyAccessibilityButtonVisibilityChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    this.performAccessibilityShortcut(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    List<String> _result = this.getAccessibilityShortcutTargets(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 18: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.sendFingerprintGesture(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getAccessibilityWindowId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 20: {
                    long _result = this.getRecommendedTimeoutMillis();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 21: {
                    RemoteAction _arg0 = data.readTypedObject(RemoteAction.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerSystemAction(_arg0, _arg1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSystemAction(_arg0);
                    break;
                }
                case 23: {
                    IMagnificationConnection _arg0 = IMagnificationConnection.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setMagnificationConnection(_arg0);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.associateEmbeddedHierarchy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.disassociateEmbeddedHierarchy(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _result = this.getFocusStrokeWidth();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 27: {
                    int _result = this.getFocusColor();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    boolean _result = this.isAudioDescriptionByDefaultEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 29: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSystemAudioCaptioningEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isSystemAudioCaptioningUiEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 31: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setSystemAudioCaptioningUiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AccessibilityWindowAttributes _arg3 = data.readTypedObject(AccessibilityWindowAttributes.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAccessibilityWindowAttributes(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 33: {
                    IAccessibilityServiceClient _arg0 = IAccessibilityServiceClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerProxyForDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 34: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.unregisterProxyForDisplay(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    InputEvent _arg0 = data.readTypedObject(InputEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.injectInputEventToInputFilter(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.startFlashNotificationSequence(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.stopFlashNotificationSequence(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 38: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.startFlashNotificationEvent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isAccessibilityTargetAllowed(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.sendRestrictedDialogIntent(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 41: {
                    AccessibilityServiceInfo _arg0 = data.readTypedObject(AccessibilityServiceInfo.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isAccessibilityServiceWarningRequired(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    WindowTransformationSpec _result = this.getWindowTransformationSpec(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 43: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.attachAccessibilityOverlayToDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    int _arg0 = data.readInt();
                    ArrayList<ComponentName> _arg1 = data.createTypedArrayList(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyQuickSettingsTilesChanged(_arg0, _arg1);
                    break;
                }
                case 45: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    ArrayList<String> _arg2 = data.createStringArrayList();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.enableShortcutsForTargets(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 46: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Bundle _result = this.getA11yFeatureToTileMap(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 47: {
                    IUserInitializationCompleteCallback _arg0 = IUserInitializationCompleteCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerUserInitializationCompleteCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    IUserInitializationCompleteCallback _arg0 = IUserInitializationCompleteCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterUserInitializationCompleteCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.enableTrustedAccessibilityService(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 50: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTrustedAccessibilityServiceForTesting(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void setPictureInPictureActionReplacingConnection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MODIFY_ACCESSIBILITY_DATA", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerUiTestAutomationService_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.RETRIEVE_WINDOW_CONTENT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getWindowToken_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.RETRIEVE_WINDOW_CONTENT", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAccessibilityButtonClicked_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.STATUS_BAR_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAccessibilityButtonLongClicked_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.STATUS_BAR_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyAccessibilityButtonVisibilityChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.STATUS_BAR_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void performAccessibilityShortcut_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAccessibilityShortcutTargets_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void registerSystemAction_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void unregisterSystemAction_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setMagnificationConnection_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.STATUS_BAR_SERVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSystemAudioCaptioningEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_SYSTEM_AUDIO_CAPTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setSystemAudioCaptioningUiEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.SET_SYSTEM_AUDIO_CAPTION", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void injectInputEventToInputFilter_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.INJECT_EVENTS", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startFlashNotificationSequence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void stopFlashNotificationSequence_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void startFlashNotificationEvent_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isAccessibilityServiceWarningRequired_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void attachAccessibilityOverlayToDisplay_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.INTERNAL_SYSTEM_WINDOW", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void notifyQuickSettingsTilesChanged_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_notifyQuickSettingsTilesChanged, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enableShortcutsForTargets_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getA11yFeatureToTileMap_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setTrustedAccessibilityServiceForTesting_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.MANAGE_ACCESSIBILITY", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 49;
        }

        private static class Proxy
        implements IAccessibilityManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void interrupt(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendAccessibilityEvent(AccessibilityEvent uiEvent, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(uiEvent, 0);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long addClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParceledListSlice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) throws RemoteException {
                ArrayList<AccessibilityServiceInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(feedbackType);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AccessibilityServiceInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addAccessibilityInteractionConnection(IWindow windowToken, IBinder leashToken, IAccessibilityInteractionConnection connection, String packageName, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(windowToken);
                    _data.writeStrongBinder(leashToken);
                    _data.writeStrongInterface(connection);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAccessibilityInteractionConnection(IWindow windowToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(windowToken);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient client, AccessibilityServiceInfo info, int userId, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(owner);
                    _data.writeStrongInterface(client);
                    _data.writeTypedObject(info, 0);
                    _data.writeInt(userId);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUiTestAutomationService(IAccessibilityServiceClient client) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getWindowToken(int windowId, int userId) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(windowId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAccessibilityButtonClicked(int displayId, String targetName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeString(targetName);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAccessibilityButtonLongClicked(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyAccessibilityButtonVisibilityChanged(boolean available) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(available);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void performAccessibilityShortcut(int displayId, int shortcutType, String targetName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shortcutType);
                    _data.writeString(targetName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAccessibilityShortcutTargets(int shortcutType, int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(shortcutType);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendFingerprintGesture(int gestureKeyCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(gestureKeyCode);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAccessibilityWindowId(IBinder windowToken) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(windowToken);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getRecommendedTimeoutMillis() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemAction(RemoteAction action, int actionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(action, 0);
                    _data.writeInt(actionId);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemAction(int actionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(actionId);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMagnificationConnection(IMagnificationConnection connection) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(connection);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void associateEmbeddedHierarchy(IBinder host, IBinder embedded) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(host);
                    _data.writeStrongBinder(embedded);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disassociateEmbeddedHierarchy(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusStrokeWidth() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getFocusColor() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioCaptioningEnabled(boolean isEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSystemAudioCaptioningUiEnabled(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSystemAudioCaptioningUiEnabled(boolean isEnabled, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isEnabled);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAccessibilityWindowAttributes(int displayId, int windowId, int userId, AccessibilityWindowAttributes attributes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(windowId);
                    _data.writeInt(userId);
                    _data.writeTypedObject(attributes, 0);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerProxyForDisplay(IAccessibilityServiceClient proxy, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(proxy);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterProxyForDisplay(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void injectInputEventToInputFilter(InputEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(event, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startFlashNotificationSequence(String opPkg, int reason, IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(opPkg);
                    _data.writeInt(reason);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopFlashNotificationSequence(String opPkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(opPkg);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startFlashNotificationEvent(String opPkg, int reason, String reasonPkg) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(opPkg);
                    _data.writeInt(reason);
                    _data.writeString(reasonPkg);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAccessibilityTargetAllowed(String packageName, int uid, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean sendRestrictedDialogIntent(String packageName, int uid, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(uid);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAccessibilityServiceWarningRequired(AccessibilityServiceInfo info) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowTransformationSpec getWindowTransformationSpec(int windowId) throws RemoteException {
                WindowTransformationSpec _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(windowId);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowTransformationSpec.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachAccessibilityOverlayToDisplay(int displayId, SurfaceControl surfaceControl) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(surfaceControl, 0);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyQuickSettingsTilesChanged(int userId, List<ComponentName> tileComponentNames) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedList(tileComponentNames, 0);
                    boolean bl = this.mRemote.transact(44, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableShortcutsForTargets(boolean enable, int shortcutTypes, List<String> shortcutTargets, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    _data.writeInt(shortcutTypes);
                    _data.writeStringList(shortcutTargets);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bundle getA11yFeatureToTileMap(int userId) throws RemoteException {
                Bundle _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bundle.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUserInitializationCompleteCallback(IUserInitializationCompleteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUserInitializationCompleteCallback(IUserInitializationCompleteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableTrustedAccessibilityService(ComponentName trustedAccessibilityService, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(trustedAccessibilityService, 0);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTrustedAccessibilityServiceForTesting(ComponentName trustedAccessibilityService) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(trustedAccessibilityService, 0);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAccessibilityManager {
        @Override
        public void interrupt(int userId) throws RemoteException {
        }

        @Override
        public void sendAccessibilityEvent(AccessibilityEvent uiEvent, int userId) throws RemoteException {
        }

        @Override
        public long addClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
            return 0L;
        }

        @Override
        public boolean removeClient(IAccessibilityManagerClient client, int userId) throws RemoteException {
            return false;
        }

        @Override
        public ParceledListSlice<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) throws RemoteException {
            return null;
        }

        @Override
        public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) throws RemoteException {
            return null;
        }

        @Override
        public int addAccessibilityInteractionConnection(IWindow windowToken, IBinder leashToken, IAccessibilityInteractionConnection connection, String packageName, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeAccessibilityInteractionConnection(IWindow windowToken) throws RemoteException {
        }

        @Override
        public void setPictureInPictureActionReplacingConnection(IAccessibilityInteractionConnection connection) throws RemoteException {
        }

        @Override
        public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient client, AccessibilityServiceInfo info, int userId, int flags) throws RemoteException {
        }

        @Override
        public void unregisterUiTestAutomationService(IAccessibilityServiceClient client) throws RemoteException {
        }

        @Override
        public IBinder getWindowToken(int windowId, int userId) throws RemoteException {
            return null;
        }

        @Override
        public void notifyAccessibilityButtonClicked(int displayId, String targetName) throws RemoteException {
        }

        @Override
        public void notifyAccessibilityButtonLongClicked(int displayId) throws RemoteException {
        }

        @Override
        public void notifyAccessibilityButtonVisibilityChanged(boolean available) throws RemoteException {
        }

        @Override
        public void performAccessibilityShortcut(int displayId, int shortcutType, String targetName) throws RemoteException {
        }

        @Override
        public List<String> getAccessibilityShortcutTargets(int shortcutType, int userId) throws RemoteException {
            return null;
        }

        @Override
        public boolean sendFingerprintGesture(int gestureKeyCode) throws RemoteException {
            return false;
        }

        @Override
        public int getAccessibilityWindowId(IBinder windowToken) throws RemoteException {
            return 0;
        }

        @Override
        public long getRecommendedTimeoutMillis() throws RemoteException {
            return 0L;
        }

        @Override
        public void registerSystemAction(RemoteAction action, int actionId) throws RemoteException {
        }

        @Override
        public void unregisterSystemAction(int actionId) throws RemoteException {
        }

        @Override
        public void setMagnificationConnection(IMagnificationConnection connection) throws RemoteException {
        }

        @Override
        public void associateEmbeddedHierarchy(IBinder host, IBinder embedded) throws RemoteException {
        }

        @Override
        public void disassociateEmbeddedHierarchy(IBinder token) throws RemoteException {
        }

        @Override
        public int getFocusStrokeWidth() throws RemoteException {
            return 0;
        }

        @Override
        public int getFocusColor() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isAudioDescriptionByDefaultEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setSystemAudioCaptioningEnabled(boolean isEnabled, int userId) throws RemoteException {
        }

        @Override
        public boolean isSystemAudioCaptioningUiEnabled(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setSystemAudioCaptioningUiEnabled(boolean isEnabled, int userId) throws RemoteException {
        }

        @Override
        public void setAccessibilityWindowAttributes(int displayId, int windowId, int userId, AccessibilityWindowAttributes attributes) throws RemoteException {
        }

        @Override
        public boolean registerProxyForDisplay(IAccessibilityServiceClient proxy, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterProxyForDisplay(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void injectInputEventToInputFilter(InputEvent event) throws RemoteException {
        }

        @Override
        public boolean startFlashNotificationSequence(String opPkg, int reason, IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopFlashNotificationSequence(String opPkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean startFlashNotificationEvent(String opPkg, int reason, String reasonPkg) throws RemoteException {
            return false;
        }

        @Override
        public boolean isAccessibilityTargetAllowed(String packageName, int uid, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean sendRestrictedDialogIntent(String packageName, int uid, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isAccessibilityServiceWarningRequired(AccessibilityServiceInfo info) throws RemoteException {
            return false;
        }

        @Override
        public WindowTransformationSpec getWindowTransformationSpec(int windowId) throws RemoteException {
            return null;
        }

        @Override
        public void attachAccessibilityOverlayToDisplay(int displayId, SurfaceControl surfaceControl) throws RemoteException {
        }

        @Override
        public void notifyQuickSettingsTilesChanged(int userId, List<ComponentName> tileComponentNames) throws RemoteException {
        }

        @Override
        public void enableShortcutsForTargets(boolean enable, int shortcutTypes, List<String> shortcutTargets, int userId) throws RemoteException {
        }

        @Override
        public Bundle getA11yFeatureToTileMap(int userId) throws RemoteException {
            return null;
        }

        @Override
        public void registerUserInitializationCompleteCallback(IUserInitializationCompleteCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterUserInitializationCompleteCallback(IUserInitializationCompleteCallback callback) throws RemoteException {
        }

        @Override
        public boolean enableTrustedAccessibilityService(ComponentName trustedAccessibilityService, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setTrustedAccessibilityServiceForTesting(ComponentName trustedAccessibilityService) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

