/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.VerifiedKeyEvent;
import android.view.VerifiedMotionEvent;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SuppressLint(value={"ParcelNotFinal"})
public abstract class VerifiedInputEvent
implements Parcelable {
    private static final String TAG = "VerifiedInputEvent";
    protected static final int VERIFIED_KEY = 1;
    protected static final int VERIFIED_MOTION = 2;
    private int mType;
    private int mDeviceId;
    private long mEventTimeNanos;
    private int mSource;
    private int mDisplayId;
    @NonNull
    public static final Parcelable.Creator<VerifiedInputEvent> CREATOR = new Parcelable.Creator<VerifiedInputEvent>(){

        public VerifiedInputEvent[] newArray(int size) {
            return new VerifiedInputEvent[size];
        }

        @Override
        public VerifiedInputEvent createFromParcel(@NonNull Parcel in) {
            int type = VerifiedInputEvent.peekInt(in);
            if (type == 1) {
                return VerifiedKeyEvent.CREATOR.createFromParcel(in);
            }
            if (type == 2) {
                return VerifiedMotionEvent.CREATOR.createFromParcel(in);
            }
            throw new IllegalArgumentException("Unexpected input event type in parcel.");
        }
    };

    protected VerifiedInputEvent(int type, int deviceId, long eventTimeNanos, int source, int displayId) {
        this.mType = type;
        this.mDeviceId = deviceId;
        this.mEventTimeNanos = eventTimeNanos;
        this.mSource = source;
        this.mDisplayId = displayId;
    }

    protected VerifiedInputEvent(@NonNull Parcel in, int expectedType) {
        this.mType = in.readInt();
        if (this.mType != expectedType) {
            throw new IllegalArgumentException("Unexpected input event type token in parcel.");
        }
        this.mDeviceId = in.readInt();
        this.mEventTimeNanos = in.readLong();
        this.mSource = in.readInt();
        this.mDisplayId = in.readInt();
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getEventTimeNanos() {
        return this.mEventTimeNanos;
    }

    public int getSource() {
        return this.mSource;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeInt(this.mDeviceId);
        dest.writeLong(this.mEventTimeNanos);
        dest.writeInt(this.mSource);
        dest.writeInt(this.mDisplayId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static int peekInt(@NonNull Parcel parcel) {
        int initialDataPosition = parcel.dataPosition();
        int data = parcel.readInt();
        parcel.setDataPosition(initialDataPosition);
        return data;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerifiedInputEvent that = (VerifiedInputEvent)o;
        return this.mType == that.mType && this.getDeviceId() == that.getDeviceId() && this.getEventTimeNanos() == that.getEventTimeNanos() && this.getSource() == that.getSource() && this.getDisplayId() == that.getDisplayId();
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mType;
        _hash = 31 * _hash + this.getDeviceId();
        _hash = 31 * _hash + Long.hashCode(this.getEventTimeNanos());
        _hash = 31 * _hash + this.getSource();
        _hash = 31 * _hash + this.getDisplayId();
        return _hash;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerifiedInputEventType {
    }
}

