/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RoundedCorner
implements Parcelable {
    public static final int POSITION_TOP_LEFT = 0;
    public static final int POSITION_TOP_RIGHT = 1;
    public static final int POSITION_BOTTOM_RIGHT = 2;
    public static final int POSITION_BOTTOM_LEFT = 3;
    private final int mPosition;
    private final int mRadius;
    @NonNull
    private final Point mCenter;
    @NonNull
    public static final Parcelable.Creator<RoundedCorner> CREATOR = new Parcelable.Creator<RoundedCorner>(){

        @Override
        public RoundedCorner createFromParcel(Parcel in) {
            return new RoundedCorner(in.readInt(), in.readInt(), in.readInt(), in.readInt());
        }

        public RoundedCorner[] newArray(int size) {
            return new RoundedCorner[size];
        }
    };

    @VisibleForTesting
    public RoundedCorner(int position) {
        this.mPosition = position;
        this.mRadius = 0;
        this.mCenter = new Point(0, 0);
    }

    public RoundedCorner(int position, int radius, int centerX, int centerY) {
        this.mPosition = position;
        this.mRadius = radius;
        this.mCenter = new Point(centerX, centerY);
    }

    RoundedCorner(RoundedCorner rc) {
        this.mPosition = rc.getPosition();
        this.mRadius = rc.getRadius();
        this.mCenter = new Point(rc.getCenter());
    }

    public int getPosition() {
        return this.mPosition;
    }

    public int getRadius() {
        return this.mRadius;
    }

    @NonNull
    public Point getCenter() {
        return new Point(this.mCenter);
    }

    public boolean isEmpty() {
        return this.mRadius == 0 || this.mCenter.x <= 0 || this.mCenter.y <= 0;
    }

    private String getPositionString(int position) {
        switch (position) {
            case 0: {
                return "TopLeft";
            }
            case 1: {
                return "TopRight";
            }
            case 2: {
                return "BottomRight";
            }
            case 3: {
                return "BottomLeft";
            }
        }
        return "Invalid";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RoundedCorner) {
            RoundedCorner r = (RoundedCorner)o;
            return this.mPosition == r.mPosition && this.mRadius == r.mRadius && this.mCenter.equals(r.mCenter);
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.mPosition;
        result = 31 * result + this.mRadius;
        result = 31 * result + this.mCenter.hashCode();
        return result;
    }

    public String toString() {
        return "RoundedCorner{position=" + this.getPositionString(this.mPosition) + ", radius=" + this.mRadius + ", center=" + this.mCenter + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mPosition);
        out.writeInt(this.mRadius);
        out.writeInt(this.mCenter.x);
        out.writeInt(this.mCenter.y);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Position {
    }
}

