/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.CancellationSignal;
import android.view.InsetsController;
import android.view.InsetsState;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;

public class PendingInsetsController
implements WindowInsetsController {
    private static final int KEEP_BEHAVIOR = -1;
    private final ArrayList<PendingRequest> mRequests = new ArrayList();
    private int mAppearance;
    private int mAppearanceMask;
    private int mAppearanceFromResource;
    private int mAppearanceFromResourceMask;
    private int mBehavior = -1;
    private boolean mAnimationsDisabled;
    private final InsetsState mDummyState = new InsetsState();
    private InsetsController mReplayedInsetsController;
    private ArrayList<WindowInsetsController.OnControllableInsetsChangedListener> mControllableInsetsChangedListeners = new ArrayList();
    private int mImeCaptionBarInsetsHeight = 0;
    private WindowInsetsAnimationControlListener mLoggingListener;
    private int mRequestedVisibleTypes = WindowInsets.Type.defaultVisible();

    @Override
    public void show(int types) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.show(types);
        } else {
            this.mRequests.add(new ShowRequest(types));
            this.mRequestedVisibleTypes |= types;
        }
    }

    @Override
    public void hide(int types) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.hide(types);
        } else {
            this.mRequests.add(new HideRequest(types));
            this.mRequestedVisibleTypes &= ~types;
        }
    }

    @Override
    public void setSystemBarsAppearance(int appearance, int mask) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.setSystemBarsAppearance(appearance, mask);
        } else {
            this.mAppearance = this.mAppearance & ~mask | appearance & mask;
            this.mAppearanceMask |= mask;
        }
    }

    @Override
    public void setSystemBarsAppearanceFromResource(int appearance, int mask) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.setSystemBarsAppearanceFromResource(appearance, mask);
        } else {
            this.mAppearanceFromResource = this.mAppearanceFromResource & ~mask | appearance & mask;
            this.mAppearanceFromResourceMask |= mask;
        }
    }

    @Override
    public int getSystemBarsAppearance() {
        if (this.mReplayedInsetsController != null) {
            return this.mReplayedInsetsController.getSystemBarsAppearance();
        }
        return this.mAppearance | this.mAppearanceFromResource & ~this.mAppearanceMask;
    }

    @Override
    public void setImeCaptionBarInsetsHeight(int height) {
        this.mImeCaptionBarInsetsHeight = height;
    }

    @Override
    public void setSystemBarsBehavior(int behavior) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.setSystemBarsBehavior(behavior);
        } else {
            this.mBehavior = behavior;
        }
    }

    @Override
    public int getSystemBarsBehavior() {
        if (this.mReplayedInsetsController != null) {
            return this.mReplayedInsetsController.getSystemBarsBehavior();
        }
        if (this.mBehavior == -1) {
            return 1;
        }
        return this.mBehavior;
    }

    @Override
    public void setAnimationsDisabled(boolean disable) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.setAnimationsDisabled(disable);
        } else {
            this.mAnimationsDisabled = disable;
        }
    }

    @Override
    @NonNull
    public InsetsState getState() {
        return this.mDummyState;
    }

    @Override
    public int getRequestedVisibleTypes() {
        if (this.mReplayedInsetsController != null) {
            return this.mReplayedInsetsController.getRequestedVisibleTypes();
        }
        return this.mRequestedVisibleTypes;
    }

    @Override
    public void addOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.addOnControllableInsetsChangedListener(listener);
        } else {
            this.mControllableInsetsChangedListeners.add(listener);
            listener.onControllableInsetsChanged(this, 0);
        }
    }

    @Override
    public void removeOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.removeOnControllableInsetsChangedListener(listener);
        } else {
            this.mControllableInsetsChangedListeners.remove(listener);
        }
    }

    @VisibleForTesting
    public void replayAndAttach(InsetsController controller) {
        int i;
        if (this.mBehavior != -1) {
            controller.setSystemBarsBehavior(this.mBehavior);
        }
        if (this.mAppearanceMask != 0) {
            controller.setSystemBarsAppearance(this.mAppearance, this.mAppearanceMask);
        }
        if (this.mAppearanceFromResourceMask != 0) {
            controller.setSystemBarsAppearanceFromResource(this.mAppearanceFromResource, this.mAppearanceFromResourceMask);
        }
        if (this.mImeCaptionBarInsetsHeight != 0) {
            controller.setImeCaptionBarInsetsHeight(this.mImeCaptionBarInsetsHeight);
        }
        if (this.mAnimationsDisabled) {
            controller.setAnimationsDisabled(true);
        }
        int size = this.mRequests.size();
        for (i = 0; i < size; ++i) {
            this.mRequests.get(i).replay(controller);
        }
        size = this.mControllableInsetsChangedListeners.size();
        for (i = 0; i < size; ++i) {
            controller.addOnControllableInsetsChangedListener(this.mControllableInsetsChangedListeners.get(i));
        }
        if (this.mLoggingListener != null) {
            controller.setSystemDrivenInsetsAnimationLoggingListener(this.mLoggingListener);
        }
        this.mRequests.clear();
        this.mControllableInsetsChangedListeners.clear();
        this.mBehavior = -1;
        this.mAppearance = 0;
        this.mAppearanceMask = 0;
        this.mAppearanceFromResource = 0;
        this.mAppearanceFromResourceMask = 0;
        this.mAnimationsDisabled = false;
        this.mLoggingListener = null;
        this.mRequestedVisibleTypes = WindowInsets.Type.defaultVisible();
        this.mReplayedInsetsController = controller;
    }

    @VisibleForTesting
    public void detach() {
        this.mReplayedInsetsController = null;
    }

    @Override
    public void setSystemDrivenInsetsAnimationLoggingListener(@Nullable WindowInsetsAnimationControlListener listener) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.setSystemDrivenInsetsAnimationLoggingListener(listener);
        } else {
            this.mLoggingListener = listener;
        }
    }

    @Override
    public void controlWindowInsetsAnimation(int types, long durationMillis, @Nullable Interpolator interpolator2, CancellationSignal cancellationSignal, @NonNull WindowInsetsAnimationControlListener listener) {
        if (this.mReplayedInsetsController != null) {
            this.mReplayedInsetsController.controlWindowInsetsAnimation(types, durationMillis, interpolator2, cancellationSignal, listener);
        } else {
            listener.onCancelled(null);
        }
    }

    private static class ShowRequest
    implements PendingRequest {
        private final int mTypes;

        public ShowRequest(int types) {
            this.mTypes = types;
        }

        @Override
        public void replay(InsetsController controller) {
            controller.show(this.mTypes);
        }
    }

    private static class HideRequest
    implements PendingRequest {
        private final int mTypes;

        public HideRequest(int types) {
            this.mTypes = types;
        }

        @Override
        public void replay(InsetsController controller) {
            controller.hide(this.mTypes);
        }
    }

    private static interface PendingRequest {
        public void replay(InsetsController var1);
    }
}

