/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.tools.layoutlib.create.OverrideMethod;
import libcore.util.NativeAllocationRegistry;

public class InputChannel
implements Parcelable {
    private static final String TAG = "InputChannel";
    private static final boolean DEBUG = false;
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(InputChannel.class.getClassLoader(), InputChannel.nativeGetFinalizer());
    @UnsupportedAppUsage
    @NonNull
    public static final Parcelable.Creator<InputChannel> CREATOR = new Parcelable.Creator<InputChannel>(){

        @Override
        public InputChannel createFromParcel(Parcel source) {
            InputChannel result = new InputChannel();
            result.readFromParcel(source);
            return result;
        }

        public InputChannel[] newArray(int size) {
            return new InputChannel[size];
        }
    };
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mPtr;

    private static long[] nativeOpenInputChannelPair(String string2) {
        return (long[])OverrideMethod.invokeA("android.view.InputChannel#nativeOpenInputChannelPair(Ljava/lang/String;)[J", true, null);
    }

    private static long nativeGetFinalizer() {
        return OverrideMethod.invokeL("android.view.InputChannel#nativeGetFinalizer()J", true, null);
    }

    private void nativeDispose(long l) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeDispose(J)V", true, this);
    }

    private long nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.InputChannel#nativeReadFromParcel(Landroid/os/Parcel;)J", true, this);
    }

    private void nativeWriteToParcel(Parcel parcel, long l) {
        OverrideMethod.invokeV("android.view.InputChannel#nativeWriteToParcel(Landroid/os/Parcel;J)V", true, this);
    }

    private long nativeDup(long l) {
        return OverrideMethod.invokeL("android.view.InputChannel#nativeDup(J)J", true, this);
    }

    private IBinder nativeGetToken(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.InputChannel#nativeGetToken(J)Landroid/os/IBinder;", true, this);
    }

    private String nativeGetName(long l) {
        return (String)OverrideMethod.invokeA("android.view.InputChannel#nativeGetName(J)Ljava/lang/String;", true, this);
    }

    @UnsupportedAppUsage
    public InputChannel() {
    }

    private void setNativeInputChannel(long nativeChannel) {
        if (nativeChannel == 0L) {
            throw new IllegalArgumentException("Attempting to set native input channel to null.");
        }
        if (this.mPtr != 0L) {
            throw new IllegalArgumentException("Already has native input channel.");
        }
        sRegistry.registerNativeAllocation(this, nativeChannel);
        this.mPtr = nativeChannel;
    }

    public static InputChannel[] openInputChannelPair(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        InputChannel[] channels = new InputChannel[2];
        long[] nativeChannels = InputChannel.nativeOpenInputChannelPair(name);
        for (int i = 0; i < 2; ++i) {
            channels[i] = new InputChannel();
            channels[i].setNativeInputChannel(nativeChannels[i]);
        }
        return channels;
    }

    public String getName() {
        String name = this.nativeGetName(this.mPtr);
        return name != null ? name : "uninitialized";
    }

    public void dispose() {
        this.nativeDispose(this.mPtr);
    }

    public void release() {
    }

    public void copyTo(InputChannel outParameter) {
        if (outParameter == null) {
            throw new IllegalArgumentException("outParameter must not be null");
        }
        if (outParameter.mPtr != 0L) {
            throw new IllegalArgumentException("Other object already has a native input channel.");
        }
        outParameter.setNativeInputChannel(this.nativeDup(this.mPtr));
    }

    public InputChannel dup() {
        InputChannel target = new InputChannel();
        target.setNativeInputChannel(this.nativeDup(this.mPtr));
        return target;
    }

    @Override
    public int describeContents() {
        return 1;
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("in must not be null");
        }
        long nativeIn = this.nativeReadFromParcel(in);
        if (nativeIn != 0L) {
            this.setNativeInputChannel(nativeIn);
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("out must not be null");
        }
        this.nativeWriteToParcel(out, this.mPtr);
        if ((flags & 1) != 0) {
            this.dispose();
        }
    }

    public String toString() {
        return this.getName();
    }

    public IBinder getToken() {
        return this.nativeGetToken(this.mPtr);
    }
}

