/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.ISurfaceControlViewHostParent;
import android.view.InsetsState;
import android.window.ISurfaceSyncGroup;
import android.window.InputTransferToken;

public interface ISurfaceControlViewHost
extends IInterface {
    public static final String DESCRIPTOR = "android.view.ISurfaceControlViewHost";

    public void onConfigurationChanged(Configuration var1) throws RemoteException;

    public void onDispatchAttachedToWindow(InputTransferToken var1) throws RemoteException;

    public void onDispatchDetachedFromWindow() throws RemoteException;

    public void onInsetsChanged(InsetsState var1, Rect var2) throws RemoteException;

    public ISurfaceSyncGroup getSurfaceSyncGroup() throws RemoteException;

    public void attachParentInterface(ISurfaceControlViewHostParent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISurfaceControlViewHost {
        static final int TRANSACTION_onConfigurationChanged = 1;
        static final int TRANSACTION_onDispatchAttachedToWindow = 2;
        static final int TRANSACTION_onDispatchDetachedFromWindow = 3;
        static final int TRANSACTION_onInsetsChanged = 4;
        static final int TRANSACTION_getSurfaceSyncGroup = 5;
        static final int TRANSACTION_attachParentInterface = 6;

        public Stub() {
            this.attachInterface(this, ISurfaceControlViewHost.DESCRIPTOR);
        }

        public static ISurfaceControlViewHost asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISurfaceControlViewHost.DESCRIPTOR);
            if (iin != null && iin instanceof ISurfaceControlViewHost) {
                return (ISurfaceControlViewHost)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConfigurationChanged";
                }
                case 2: {
                    return "onDispatchAttachedToWindow";
                }
                case 3: {
                    return "onDispatchDetachedFromWindow";
                }
                case 4: {
                    return "onInsetsChanged";
                }
                case 5: {
                    return "getSurfaceSyncGroup";
                }
                case 6: {
                    return "attachParentInterface";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISurfaceControlViewHost.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    Configuration _arg0 = data.readTypedObject(Configuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 2: {
                    InputTransferToken _arg0 = data.readTypedObject(InputTransferToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDispatchAttachedToWindow(_arg0);
                    break;
                }
                case 3: {
                    this.onDispatchDetachedFromWindow();
                    break;
                }
                case 4: {
                    InsetsState _arg0 = data.readTypedObject(InsetsState.CREATOR);
                    Rect _arg1 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onInsetsChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    ISurfaceSyncGroup _result = this.getSurfaceSyncGroup();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    ISurfaceControlViewHostParent _arg0 = ISurfaceControlViewHostParent.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.attachParentInterface(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ISurfaceControlViewHost {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISurfaceControlViewHost.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(Configuration newConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeTypedObject(newConfig, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDispatchAttachedToWindow(InputTransferToken token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeTypedObject(token, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDispatchDetachedFromWindow() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInsetsChanged(InsetsState state, Rect insetFrame) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeTypedObject(state, 0);
                    _data.writeTypedObject(insetFrame, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ISurfaceSyncGroup getSurfaceSyncGroup() throws RemoteException {
                ISurfaceSyncGroup _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = ISurfaceSyncGroup.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachParentInterface(ISurfaceControlViewHostParent parentInterface) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISurfaceControlViewHost.DESCRIPTOR);
                    _data.writeStrongInterface(parentInterface);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISurfaceControlViewHost {
        @Override
        public void onConfigurationChanged(Configuration newConfig) throws RemoteException {
        }

        @Override
        public void onDispatchAttachedToWindow(InputTransferToken token) throws RemoteException {
        }

        @Override
        public void onDispatchDetachedFromWindow() throws RemoteException {
        }

        @Override
        public void onInsetsChanged(InsetsState state, Rect insetFrame) throws RemoteException {
        }

        @Override
        public ISurfaceSyncGroup getSurfaceSyncGroup() throws RemoteException {
            return null;
        }

        @Override
        public void attachParentInterface(ISurfaceControlViewHostParent parentInterface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

