/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.SystemClock;
import android.view.Display;
import android.view.ViewRootImpl;
import java.util.function.Consumer;

class HdrRenderState
implements Consumer<Display> {
    private static final float TRANSITION_PER_MS = 0.01f;
    private final ViewRootImpl mViewRoot;
    private boolean mIsHdrEnabled = false;
    private boolean mIsListenerRegistered = false;
    private boolean mUpdateHdrSdrRatioInfo = false;
    private float mDesiredHdrSdrRatio = 1.0f;
    private float mTargetDesiredHdrSdrRatio = 1.0f;
    private float mTargetHdrSdrRatio = 1.0f;
    private float mRenderHdrSdrRatio = 1.0f;
    private float mPreviousRenderRatio = 1.0f;
    private long mLastUpdateMillis = -1L;

    HdrRenderState(ViewRootImpl viewRoot) {
        this.mViewRoot = viewRoot;
    }

    @Override
    public void accept(Display display) {
        this.forceUpdateHdrSdrRatio();
        this.mViewRoot.invalidate();
    }

    boolean isHdrEnabled() {
        return this.mIsHdrEnabled;
    }

    void stopListening() {
        if (this.mIsListenerRegistered) {
            this.mViewRoot.mDisplay.unregisterHdrSdrRatioChangedListener(this);
            this.mIsListenerRegistered = false;
        }
    }

    void startListening() {
        if (this.isHdrEnabled() && !this.mIsListenerRegistered && this.mViewRoot.mDisplay != null) {
            this.mViewRoot.mDisplay.registerHdrSdrRatioChangedListener(this.mViewRoot.mExecutor, this);
            this.mIsListenerRegistered = true;
        }
    }

    boolean updateForFrame(long frameTimeMillis) {
        boolean hasUpdate = this.mUpdateHdrSdrRatioInfo;
        this.mUpdateHdrSdrRatioInfo = false;
        this.mRenderHdrSdrRatio = this.mTargetHdrSdrRatio;
        long timeDelta = Math.max(Math.min(32L, frameTimeMillis - this.mLastUpdateMillis), 8L);
        float maxStep = (float)timeDelta * 0.01f;
        this.mLastUpdateMillis = frameTimeMillis;
        if (hasUpdate) {
            if (this.isHdrEnabled()) {
                float delta = this.mTargetHdrSdrRatio - this.mPreviousRenderRatio;
                if (delta > maxStep) {
                    this.mRenderHdrSdrRatio = this.mPreviousRenderRatio + maxStep;
                    this.mUpdateHdrSdrRatioInfo = true;
                    this.mViewRoot.invalidate();
                }
                this.mPreviousRenderRatio = this.mRenderHdrSdrRatio;
                if (this.mTargetDesiredHdrSdrRatio < this.mDesiredHdrSdrRatio) {
                    this.mDesiredHdrSdrRatio = Math.max(this.mTargetDesiredHdrSdrRatio, this.mDesiredHdrSdrRatio - maxStep);
                    if (this.mDesiredHdrSdrRatio != this.mTargetDesiredHdrSdrRatio) {
                        this.mUpdateHdrSdrRatioInfo = true;
                        this.mViewRoot.invalidate();
                    }
                }
            } else {
                this.mPreviousRenderRatio = this.mTargetHdrSdrRatio;
                this.mDesiredHdrSdrRatio = this.mTargetDesiredHdrSdrRatio;
            }
        }
        return hasUpdate;
    }

    float getDesiredHdrSdrRatio() {
        return this.mDesiredHdrSdrRatio;
    }

    float getRenderHdrSdrRatio() {
        return this.mRenderHdrSdrRatio;
    }

    void forceUpdateHdrSdrRatio() {
        this.mTargetHdrSdrRatio = this.isHdrEnabled() ? Math.min(this.mDesiredHdrSdrRatio, this.mViewRoot.mDisplay.getHdrSdrRatio()) : 1.0f;
        this.mUpdateHdrSdrRatioInfo = true;
    }

    void setDesiredHdrSdrRatio(boolean isHdrEnabled, float desiredRatio) {
        this.mIsHdrEnabled = isHdrEnabled;
        this.mLastUpdateMillis = SystemClock.uptimeMillis();
        if (desiredRatio != this.mTargetDesiredHdrSdrRatio) {
            this.mTargetDesiredHdrSdrRatio = desiredRatio;
            if (this.mTargetDesiredHdrSdrRatio > this.mDesiredHdrSdrRatio) {
                this.mDesiredHdrSdrRatio = this.mTargetDesiredHdrSdrRatio;
            }
            this.forceUpdateHdrSdrRatio();
            this.mViewRoot.invalidate();
            if (this.isHdrEnabled()) {
                this.startListening();
            } else {
                this.stopListening();
            }
        }
    }
}

