/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ContentRecordingSession
implements Parcelable {
    public static final int RECORD_CONTENT_DISPLAY = 0;
    public static final int RECORD_CONTENT_TASK = 1;
    public static final int RECORD_CONTENT_BELOW_OVERLAY = 2;
    public static final int TARGET_UID_FULL_SCREEN = -1;
    public static final int TARGET_UID_UNKNOWN = -2;
    public static final int TASK_ID_UNKNOWN = -1;
    private int mTaskId = -1;
    private int mRecordingOwnerUid;
    private int mVirtualDisplayId = -1;
    private int mContentToRecord = 0;
    private int mDisplayToRecord = -1;
    @Nullable
    private IBinder mTokenToRecord = null;
    private boolean mWaitingForConsent = false;
    private int mTargetUid = -2;
    @NonNull
    public static final Parcelable.Creator<ContentRecordingSession> CREATOR = new Parcelable.Creator<ContentRecordingSession>(){

        public ContentRecordingSession[] newArray(int size) {
            return new ContentRecordingSession[size];
        }

        @Override
        public ContentRecordingSession createFromParcel(@NonNull Parcel in) {
            return new ContentRecordingSession(in);
        }
    };

    private ContentRecordingSession() {
    }

    public static ContentRecordingSession createDisplaySession(int displayToMirror) {
        return new ContentRecordingSession().setDisplayToRecord(displayToMirror).setContentToRecord(0).setTargetUid(-1);
    }

    public static ContentRecordingSession createTaskSession(@NonNull IBinder taskWindowContainerToken) {
        return ContentRecordingSession.createTaskSession(taskWindowContainerToken, -1);
    }

    public static ContentRecordingSession createTaskSession(@NonNull IBinder taskWindowContainerToken, int taskId) {
        return new ContentRecordingSession().setContentToRecord(1).setTokenToRecord(taskWindowContainerToken).setTaskId(taskId);
    }

    public static ContentRecordingSession createOverlaySession(int displayToMirror, int recordingOwnerUid) {
        return new ContentRecordingSession().setDisplayToRecord(displayToMirror).setContentToRecord(2).setRecordingOwnerUid(recordingOwnerUid);
    }

    public static boolean isValid(ContentRecordingSession session) {
        if (session == null) {
            return false;
        }
        if (session.getVirtualDisplayId() == -1) {
            return false;
        }
        boolean isValidTaskSession = session.getContentToRecord() == 1 && session.getTokenToRecord() != null;
        boolean isValidDisplaySession = session.getContentToRecord() == 0 && session.getDisplayToRecord() > -1;
        boolean isValidOverlaySession = session.getContentToRecord() == 2 && session.getDisplayToRecord() > -1 && session.getRecordingOwnerUid() > -1;
        return isValidTaskSession || isValidDisplaySession || isValidOverlaySession;
    }

    public static boolean isProjectionOnSameDisplay(ContentRecordingSession session, ContentRecordingSession incomingSession) {
        return session != null && incomingSession != null && session.getVirtualDisplayId() == incomingSession.getVirtualDisplayId();
    }

    public static String recordContentToString(int value) {
        switch (value) {
            case 0: {
                return "RECORD_CONTENT_DISPLAY";
            }
            case 1: {
                return "RECORD_CONTENT_TASK";
            }
            case 2: {
                return "RECORD_CONTENT_BELOW_OVERLAY";
            }
        }
        return Integer.toHexString(value);
    }

    public static String targetUidToString(int value) {
        switch (value) {
            case -1: {
                return "TARGET_UID_FULL_SCREEN";
            }
            case -2: {
                return "TARGET_UID_UNKNOWN";
            }
        }
        return Integer.toHexString(value);
    }

    ContentRecordingSession(int taskId, int recordingOwnerUid, int virtualDisplayId, int contentToRecord, int displayToRecord, @Nullable IBinder tokenToRecord, boolean waitingForConsent, int targetUid) {
        this.mTaskId = taskId;
        this.mRecordingOwnerUid = recordingOwnerUid;
        this.mVirtualDisplayId = virtualDisplayId;
        this.mContentToRecord = contentToRecord;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1 && this.mContentToRecord != 2) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + "), RECORD_CONTENT_BELOW_OVERLAY(" + 2 + ")");
        }
        this.mDisplayToRecord = displayToRecord;
        this.mTokenToRecord = tokenToRecord;
        this.mWaitingForConsent = waitingForConsent;
        this.mTargetUid = targetUid;
    }

    public int getTaskId() {
        return this.mTaskId;
    }

    public int getRecordingOwnerUid() {
        return this.mRecordingOwnerUid;
    }

    public int getVirtualDisplayId() {
        return this.mVirtualDisplayId;
    }

    public int getContentToRecord() {
        return this.mContentToRecord;
    }

    public int getDisplayToRecord() {
        return this.mDisplayToRecord;
    }

    @Nullable
    public IBinder getTokenToRecord() {
        return this.mTokenToRecord;
    }

    public boolean isWaitingForConsent() {
        return this.mWaitingForConsent;
    }

    public int getTargetUid() {
        return this.mTargetUid;
    }

    @NonNull
    public ContentRecordingSession setTaskId(int value) {
        this.mTaskId = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setRecordingOwnerUid(int value) {
        this.mRecordingOwnerUid = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setVirtualDisplayId(int value) {
        this.mVirtualDisplayId = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setContentToRecord(int value) {
        this.mContentToRecord = value;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1 && this.mContentToRecord != 2) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + "), RECORD_CONTENT_BELOW_OVERLAY(" + 2 + ")");
        }
        return this;
    }

    @NonNull
    public ContentRecordingSession setDisplayToRecord(int value) {
        this.mDisplayToRecord = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setTokenToRecord(@NonNull IBinder value) {
        this.mTokenToRecord = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setWaitingForConsent(boolean value) {
        this.mWaitingForConsent = value;
        return this;
    }

    @NonNull
    public ContentRecordingSession setTargetUid(int value) {
        this.mTargetUid = value;
        return this;
    }

    public String toString() {
        return "ContentRecordingSession { taskId = " + this.mTaskId + ", recordingOwnerUid = " + this.mRecordingOwnerUid + ", virtualDisplayId = " + this.mVirtualDisplayId + ", contentToRecord = " + ContentRecordingSession.recordContentToString(this.mContentToRecord) + ", displayToRecord = " + this.mDisplayToRecord + ", tokenToRecord = " + this.mTokenToRecord + ", waitingForConsent = " + this.mWaitingForConsent + ", targetUid = " + this.mTargetUid + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentRecordingSession that = (ContentRecordingSession)o;
        return this.mTaskId == that.mTaskId && this.mRecordingOwnerUid == that.mRecordingOwnerUid && this.mVirtualDisplayId == that.mVirtualDisplayId && this.mContentToRecord == that.mContentToRecord && this.mDisplayToRecord == that.mDisplayToRecord && Objects.equals(this.mTokenToRecord, that.mTokenToRecord) && this.mWaitingForConsent == that.mWaitingForConsent && this.mTargetUid == that.mTargetUid;
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mTaskId;
        _hash = 31 * _hash + this.mRecordingOwnerUid;
        _hash = 31 * _hash + this.mVirtualDisplayId;
        _hash = 31 * _hash + this.mContentToRecord;
        _hash = 31 * _hash + this.mDisplayToRecord;
        _hash = 31 * _hash + Objects.hashCode(this.mTokenToRecord);
        _hash = 31 * _hash + Boolean.hashCode(this.mWaitingForConsent);
        _hash = 31 * _hash + this.mTargetUid;
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        int flg = 0;
        if (this.mWaitingForConsent) {
            flg |= 0x40;
        }
        if (this.mTokenToRecord != null) {
            flg |= 0x20;
        }
        dest.writeInt(flg);
        dest.writeInt(this.mTaskId);
        dest.writeInt(this.mRecordingOwnerUid);
        dest.writeInt(this.mVirtualDisplayId);
        dest.writeInt(this.mContentToRecord);
        dest.writeInt(this.mDisplayToRecord);
        if (this.mTokenToRecord != null) {
            dest.writeStrongBinder(this.mTokenToRecord);
        }
        dest.writeInt(this.mTargetUid);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ContentRecordingSession(@NonNull Parcel in) {
        int flg = in.readInt();
        boolean waitingForConsent = (flg & 0x40) != 0;
        int taskId = in.readInt();
        int recordingOwnerUid = in.readInt();
        int virtualDisplayId = in.readInt();
        int contentToRecord = in.readInt();
        int displayToRecord = in.readInt();
        IBinder tokenToRecord = (flg & 0x20) == 0 ? null : in.readStrongBinder();
        int targetUid = in.readInt();
        this.mTaskId = taskId;
        this.mRecordingOwnerUid = recordingOwnerUid;
        this.mVirtualDisplayId = virtualDisplayId;
        this.mContentToRecord = contentToRecord;
        if (this.mContentToRecord != 0 && this.mContentToRecord != 1 && this.mContentToRecord != 2) {
            throw new IllegalArgumentException("contentToRecord was " + this.mContentToRecord + " but must be one of: RECORD_CONTENT_DISPLAY(" + 0 + "), RECORD_CONTENT_TASK(" + 1 + "), RECORD_CONTENT_BELOW_OVERLAY(" + 2 + ")");
        }
        this.mDisplayToRecord = displayToRecord;
        this.mTokenToRecord = tokenToRecord;
        this.mWaitingForConsent = waitingForConsent;
        this.mTargetUid = targetUid;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder {
        private int mTaskId;
        private int mRecordingOwnerUid;
        private int mVirtualDisplayId;
        private int mContentToRecord;
        private int mDisplayToRecord;
        @Nullable
        private IBinder mTokenToRecord;
        private boolean mWaitingForConsent;
        private int mTargetUid;
        private long mBuilderFieldsSet = 0L;

        public Builder(int recordingOwnerUid) {
            this.mRecordingOwnerUid = recordingOwnerUid;
        }

        @NonNull
        public Builder setTaskId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mTaskId = value;
            return this;
        }

        @NonNull
        public Builder setRecordingOwnerUid(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mRecordingOwnerUid = value;
            return this;
        }

        @NonNull
        public Builder setVirtualDisplayId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mVirtualDisplayId = value;
            return this;
        }

        @NonNull
        public Builder setContentToRecord(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mContentToRecord = value;
            return this;
        }

        @NonNull
        public Builder setDisplayToRecord(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mDisplayToRecord = value;
            return this;
        }

        @NonNull
        public Builder setTokenToRecord(@NonNull IBinder value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mTokenToRecord = value;
            return this;
        }

        @NonNull
        public Builder setWaitingForConsent(boolean value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            this.mWaitingForConsent = value;
            return this;
        }

        @NonNull
        public Builder setTargetUid(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x80L;
            this.mTargetUid = value;
            return this;
        }

        @NonNull
        public ContentRecordingSession build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x100L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mTaskId = -1;
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mVirtualDisplayId = -1;
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mContentToRecord = 0;
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mDisplayToRecord = -1;
            }
            if ((this.mBuilderFieldsSet & 0x20L) == 0L) {
                this.mTokenToRecord = null;
            }
            if ((this.mBuilderFieldsSet & 0x40L) == 0L) {
                this.mWaitingForConsent = false;
            }
            if ((this.mBuilderFieldsSet & 0x80L) == 0L) {
                this.mTargetUid = -2;
            }
            ContentRecordingSession o = new ContentRecordingSession(this.mTaskId, this.mRecordingOwnerUid, this.mVirtualDisplayId, this.mContentToRecord, this.mDisplayToRecord, this.mTokenToRecord, this.mWaitingForConsent, this.mTargetUid);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x100L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TargetUid {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordContent {
    }
}

