/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.FrameInfo;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.TimeUtils;
import android.view.Choreographer_Delegate;
import android.view.DisplayEventReceiver;
import android.view.DisplayInfo;
import android.view.ThreadedRenderer;
import android.view.animation.AnimationUtils;
import com.android.internal.hidden_from_bootclasspath.android.view.flags.Flags;
import com.android.internal.lang.System_Delegate;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class Choreographer {
    private static final String TAG = "Choreographer";
    private static final boolean DEBUG_JANK = false;
    private static final boolean DEBUG_FRAMES = false;
    private static final long DEFAULT_FRAME_DELAY = 10L;
    private static volatile long sFrameDelay = 10L;
    private static final ThreadLocal<Choreographer> sThreadInstance = new ThreadLocal<Choreographer>(){

        @Override
        protected Choreographer initialValue() {
            Looper looper = Looper.myLooper();
            if (looper == null) {
                throw new IllegalStateException("The current thread must have a looper!");
            }
            Choreographer choreographer = new Choreographer(looper, 0);
            if (looper == Looper.getMainLooper()) {
                mMainInstance = choreographer;
            }
            return choreographer;
        }
    };
    private static volatile Choreographer mMainInstance;
    private static final ThreadLocal<Choreographer> sSfThreadInstance;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769497L)
    private static final boolean USE_VSYNC;
    private static final boolean USE_FRAME_TIME;
    private static final int SKIPPED_FRAME_WARNING_LIMIT;
    private static final int MSG_DO_FRAME = 0;
    private static final int MSG_DO_SCHEDULE_VSYNC = 1;
    private static final int MSG_DO_SCHEDULE_CALLBACK = 2;
    private static final Object FRAME_CALLBACK_TOKEN;
    private static final Object VSYNC_CALLBACK_TOKEN;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final Object mLock = new Object();
    private final Looper mLooper;
    private final FrameHandler mHandler;
    @UnsupportedAppUsage
    private final FrameDisplayEventReceiver mDisplayEventReceiver;
    private CallbackRecord mCallbackPool;
    @UnsupportedAppUsage
    public final CallbackQueue[] mCallbackQueues;
    public boolean mFrameScheduled;
    public boolean mCallbacksRunning;
    @UnsupportedAppUsage
    private long mLastFrameTimeNanos;
    private long mLastNoOffsetFrameTimeNanos;
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="Use {@link android.view.Display#getRefreshRate} instead")
    private long mFrameIntervalNanos;
    private long mLastFrameIntervalNanos;
    private boolean mDebugPrintNextFrameTimeDelta;
    private int mFPSDivisor = 1;
    private final DisplayEventReceiver.VsyncEventData mLastVsyncEventData = new DisplayEventReceiver.VsyncEventData();
    private final FrameData mFrameData = new FrameData();
    private volatile boolean mInDoFrameCallback = false;
    private final BufferStuffingState mBufferStuffingState = new BufferStuffingState();
    FrameInfo mFrameInfo = new FrameInfo();
    private static final String[] CALLBACK_TRACE_TITLES;
    public static final int CALLBACK_INPUT = 0;
    public static final int CALLBACK_ANIMATION = 1;
    public static final int CALLBACK_INSETS_ANIMATION = 2;
    public static final int CALLBACK_TRAVERSAL = 3;
    public static final int CALLBACK_COMMIT = 4;
    private static final int CALLBACK_LAST = 4;

    public void onWaitForBufferRelease(long durationNanos) {
        if (durationNanos > this.mLastFrameIntervalNanos / 2L) {
            this.mBufferStuffingState.isStuffed.set(true);
        }
    }

    private Choreographer(Looper looper, int vsyncSource) {
        this(looper, vsyncSource, 0L);
    }

    private Choreographer(Looper looper, int vsyncSource, long layerHandle) {
        this.mLooper = looper;
        this.mHandler = new FrameHandler(looper);
        this.mDisplayEventReceiver = USE_VSYNC ? new FrameDisplayEventReceiver(looper, vsyncSource, layerHandle) : null;
        this.mLastFrameTimeNanos = Long.MIN_VALUE;
        this.mFrameIntervalNanos = (long)(1.0E9f / Choreographer.getRefreshRate());
        this.mCallbackQueues = new CallbackQueue[5];
        for (int i = 0; i <= 4; ++i) {
            this.mCallbackQueues[i] = new CallbackQueue();
        }
        this.setFPSDivisor(SystemProperties.getInt("debug.hwui.fps_divisor", 1));
    }

    static float getRefreshRate_Original() {
        DisplayInfo di = DisplayManagerGlobal.getInstance().getDisplayInfo(0);
        return di.getRefreshRate();
    }

    @LayoutlibDelegate
    private static float getRefreshRate() {
        return Choreographer_Delegate.getRefreshRate();
    }

    public static Choreographer getInstance() {
        return sThreadInstance.get();
    }

    @Deprecated
    @UnsupportedAppUsage
    public static Choreographer getSfInstance() {
        return sSfThreadInstance.get();
    }

    @NonNull
    static Choreographer getInstanceForSurfaceControl(long layerHandle, @NonNull Looper looper) {
        if (looper == null) {
            throw new IllegalStateException("The current thread must have a looper!");
        }
        return new Choreographer(looper, 0, layerHandle);
    }

    public static Choreographer getMainThreadInstance() {
        return mMainInstance;
    }

    public static void releaseInstance() {
        Choreographer old = sThreadInstance.get();
        sThreadInstance.remove();
        old.dispose();
    }

    private void dispose() {
        this.mDisplayEventReceiver.dispose();
    }

    @UnsupportedAppUsage
    void invalidate() {
        this.dispose();
    }

    boolean isTheLooperSame(Looper looper) {
        return this.mLooper == looper;
    }

    public Looper getLooper() {
        return this.mLooper;
    }

    @UnsupportedAppUsage
    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long frameDelay) {
        sFrameDelay = frameDelay;
    }

    public static long subtractFrameDelay(long delayMillis) {
        long frameDelay = sFrameDelay;
        return delayMillis <= frameDelay ? 0L : delayMillis - frameDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFrameIntervalNanos() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLastFrameIntervalNanos;
        }
    }

    void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.println("Choreographer:");
        writer.print(innerPrefix);
        writer.print("mFrameScheduled=");
        writer.println(this.mFrameScheduled);
        writer.print(innerPrefix);
        writer.print("mLastFrameTime=");
        writer.println(TimeUtils.formatUptime(this.mLastFrameTimeNanos / 1000000L));
    }

    @UnsupportedAppUsage
    public void postCallback(int callbackType, Runnable action, Object token) {
        this.postCallbackDelayed(callbackType, action, token, 0L);
    }

    @UnsupportedAppUsage
    public void postCallbackDelayed(int callbackType, Runnable action, Object token, long delayMillis) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (callbackType < 0 || callbackType > 4) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.postCallbackDelayedInternal(callbackType, action, token, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postCallbackDelayedInternal_Original(int callbackType, Object action, Object token, long delayMillis) {
        Object object = this.mLock;
        synchronized (object) {
            long now = SystemClock.uptimeMillis();
            long dueTime = now + delayMillis;
            this.mCallbackQueues[callbackType].addCallbackLocked(dueTime, action, token);
            if (dueTime <= now) {
                this.scheduleFrameLocked(now);
            } else {
                Message msg = this.mHandler.obtainMessage(2, action);
                msg.arg1 = callbackType;
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, dueTime);
            }
        }
    }

    @LayoutlibDelegate
    private void postCallbackDelayedInternal(int n, Object object, Object object2, long l) {
        Choreographer_Delegate.postCallbackDelayedInternal(this, n, object, object2, l);
    }

    public void postVsyncCallback(@NonNull VsyncCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.postCallbackDelayedInternal(1, callback, VSYNC_CALLBACK_TOKEN, 0L);
    }

    @UnsupportedAppUsage
    public void removeCallbacks(int callbackType, Runnable action, Object token) {
        if (callbackType < 0 || callbackType > 4) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.removeCallbacksInternal(callbackType, action, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksInternal_Original(int callbackType, Object action, Object token) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackQueues[callbackType].removeCallbacksLocked(action, token);
            if (action != null && token == null) {
                this.mHandler.removeMessages(2, action);
            }
        }
    }

    @LayoutlibDelegate
    private void removeCallbacksInternal(int n, Object object, Object object2) {
        Choreographer_Delegate.removeCallbacksInternal(this, n, object, object2);
    }

    public void postFrameCallback(FrameCallback callback) {
        this.postFrameCallbackDelayed(callback, 0L);
    }

    public void postFrameCallbackDelayed(FrameCallback callback, long delayMillis) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.postCallbackDelayedInternal(1, callback, FRAME_CALLBACK_TOKEN, delayMillis);
    }

    public void removeFrameCallback(FrameCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.removeCallbacksInternal(1, callback, FRAME_CALLBACK_TOKEN);
    }

    public void removeVsyncCallback(@Nullable VsyncCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.removeCallbacksInternal(1, callback, VSYNC_CALLBACK_TOKEN);
    }

    @UnsupportedAppUsage
    public long getFrameTime() {
        return this.getFrameTimeNanos() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    @FlaggedApi(value="android.view.flags.expected_presentation_time_api")
    public long getFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCallbacksRunning) {
                throw new IllegalStateException("This method must only be called as part of a callback while a frame is in progress.");
            }
            return USE_FRAME_TIME ? this.mLastFrameTimeNanos : System_Delegate.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            return USE_FRAME_TIME ? this.mLastFrameTimeNanos : System_Delegate.nanoTime();
        }
    }

    public long getExpectedPresentationTimeNanos() {
        return this.mFrameData.getPreferredFrameTimeline().getExpectedPresentationTimeNanos();
    }

    public long getExpectedPresentationTimeMillis() {
        return this.getExpectedPresentationTimeNanos() / 1000000L;
    }

    public long getLatestExpectedPresentTimeNanos() {
        if (this.mDisplayEventReceiver == null) {
            return System_Delegate.nanoTime();
        }
        return this.mDisplayEventReceiver.getLatestVsyncEventData().preferredFrameTimeline().expectedPresentationTime;
    }

    private void scheduleFrameLocked(long now) {
        if (!this.mFrameScheduled) {
            this.mFrameScheduled = true;
            if (USE_VSYNC) {
                if (this.isRunningOnLooperThreadLocked()) {
                    this.scheduleVsyncLocked();
                } else {
                    Message msg = this.mHandler.obtainMessage(1);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageAtFrontOfQueue(msg);
                }
            } else {
                long nextFrameTime = Math.max(this.mLastFrameTimeNanos / 1000000L + sFrameDelay, now);
                Message msg = this.mHandler.obtainMessage(0);
                msg.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(msg, nextFrameTime);
            }
        }
    }

    public long getVsyncId() {
        if (!this.mInDoFrameCallback && Trace.isTagEnabled(8L)) {
            String message = String.format(AndroidLocale.getDefault(), "unsync-vsync-id=%d isSfChoreo=%s", this.mLastVsyncEventData.preferredFrameTimeline().vsyncId, this == Choreographer.getSfInstance());
            Trace.instant(8L, message);
        }
        return this.mLastVsyncEventData.preferredFrameTimeline().vsyncId;
    }

    public long getFrameDeadline() {
        return this.mLastVsyncEventData.preferredFrameTimeline().deadline;
    }

    void setFPSDivisor(int divisor) {
        if (divisor <= 0) {
            divisor = 1;
        }
        this.mFPSDivisor = divisor;
        ThreadedRenderer.setFPSDivisor(divisor);
    }

    private void traceMessage(String msg) {
        Trace.traceBegin(8L, msg);
        Trace.traceEnd(8L);
    }

    BufferStuffingState.RecoveryAction updateBufferStuffingState(long frameTimeNanos, DisplayEventReceiver.VsyncEventData vsyncEventData) {
        long vsyncsSinceLastCallback;
        if (!this.mBufferStuffingState.isRecovering) {
            if (!this.mBufferStuffingState.isStuffed.getAndSet(false)) {
                return BufferStuffingState.RecoveryAction.NONE;
            }
            this.mBufferStuffingState.isRecovering = true;
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackBegin(8L, "Buffer stuffing recovery", "Thread " + Process.myTid() + ", recover frame", 0);
            }
            return BufferStuffingState.RecoveryAction.DELAY_FRAME;
        }
        int totalFrameDelays = this.mBufferStuffingState.numberWaitsForNextVsync + 2;
        long l = vsyncsSinceLastCallback = this.mLastFrameIntervalNanos > 0L ? (frameTimeNanos - this.mLastNoOffsetFrameTimeNanos) / this.mLastFrameIntervalNanos : 0L;
        if (vsyncsSinceLastCallback > (long)totalFrameDelays) {
            if (Trace.isTagEnabled(8L)) {
                Trace.asyncTraceForTrackEnd(8L, "Buffer stuffing recovery", 0);
            }
            this.mBufferStuffingState.reset();
            return BufferStuffingState.RecoveryAction.NONE;
        }
        if (Trace.isTagEnabled(8L)) {
            Trace.instantForTrack(8L, "Buffer stuffing recovery", "Negative offset added to animation");
        }
        return BufferStuffingState.RecoveryAction.OFFSET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void doFrame(long frameTimeNanos, int frame, DisplayEventReceiver.VsyncEventData vsyncEventData) {
        long timeSinceVsync;
        FrameTimeline timeline;
        boolean resynced;
        long intendedFrameTimeNanos;
        long frameIntervalNanos;
        block30: {
            frameIntervalNanos = vsyncEventData.frameInterval;
            intendedFrameTimeNanos = frameTimeNanos;
            long offsetFrameTimeNanos = frameTimeNanos;
            resynced = false;
            if (Flags.bufferStuffingRecovery()) {
                switch (this.updateBufferStuffingState(frameTimeNanos, vsyncEventData).ordinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        offsetFrameTimeNanos = frameTimeNanos - frameIntervalNanos;
                        break;
                    }
                    case 2: {
                        this.scheduleVsyncLocked();
                        return;
                    }
                }
            }
            timeline = this.mFrameData.update(offsetFrameTimeNanos, vsyncEventData);
            if (Trace.isTagEnabled(8L)) {
                Trace.traceBegin(8L, "Choreographer#doFrame " + timeline.mVsyncId);
                this.mInDoFrameCallback = true;
            }
            Object object = this.mLock;
            // MONITORENTER : object
            if (this.mFrameScheduled) break block30;
            this.traceMessage("Frame not scheduled");
            // MONITOREXIT : object
            AnimationUtils.unlockAnimationClock();
            this.mInDoFrameCallback = false;
            if (resynced) {
                Trace.traceEnd(8L);
            }
            Trace.traceEnd(8L);
            return;
        }
        this.mLastNoOffsetFrameTimeNanos = frameTimeNanos;
        long startNanos = System_Delegate.nanoTime();
        long jitterNanos = startNanos - frameTimeNanos;
        if (jitterNanos >= frameIntervalNanos) {
            frameTimeNanos = startNanos;
            if (frameIntervalNanos == 0L) {
                Log.i(TAG, "Vsync data empty due to timeout");
            } else {
                long lastFrameOffset = jitterNanos % frameIntervalNanos;
                frameTimeNanos -= lastFrameOffset;
                long skippedFrames = jitterNanos / frameIntervalNanos;
                if (skippedFrames >= (long)SKIPPED_FRAME_WARNING_LIMIT) {
                    Log.i(TAG, "Skipped " + skippedFrames + " frames!  The application may be doing too much work on its main thread.");
                }
            }
            if (this.mBufferStuffingState.isRecovering) {
                frameTimeNanos -= frameIntervalNanos;
            }
            timeline = this.mFrameData.update(frameTimeNanos, this.mDisplayEventReceiver, jitterNanos);
            resynced = true;
        }
        if (frameTimeNanos < this.mLastFrameTimeNanos) {
            this.traceMessage("Frame time goes backward");
            if (this.mBufferStuffingState.isRecovering) {
                ++this.mBufferStuffingState.numberWaitsForNextVsync;
            }
            this.scheduleVsyncLocked();
            // MONITOREXIT : object
            AnimationUtils.unlockAnimationClock();
            this.mInDoFrameCallback = false;
            if (resynced) {
                Trace.traceEnd(8L);
            }
            Trace.traceEnd(8L);
            return;
        }
        if (this.mFPSDivisor > 1 && (timeSinceVsync = frameTimeNanos - this.mLastFrameTimeNanos) < frameIntervalNanos * (long)this.mFPSDivisor && timeSinceVsync > 0L) {
            this.traceMessage("Frame skipped due to FPSDivisor");
            if (this.mBufferStuffingState.isRecovering) {
                ++this.mBufferStuffingState.numberWaitsForNextVsync;
            }
            this.scheduleVsyncLocked();
            // MONITOREXIT : object
            AnimationUtils.unlockAnimationClock();
            this.mInDoFrameCallback = false;
            if (resynced) {
                Trace.traceEnd(8L);
            }
            Trace.traceEnd(8L);
            return;
        }
        try {
            this.mFrameInfo.setVsync(intendedFrameTimeNanos, frameTimeNanos, vsyncEventData.preferredFrameTimeline().vsyncId, vsyncEventData.preferredFrameTimeline().deadline, startNanos, vsyncEventData.frameInterval);
            this.mFrameScheduled = false;
            this.mLastFrameTimeNanos = frameTimeNanos;
            this.mLastFrameIntervalNanos = frameIntervalNanos;
            this.mLastVsyncEventData.copyFrom(vsyncEventData);
            // MONITOREXIT : object
            if (resynced && Trace.isTagEnabled(8L)) {
                String message = String.format("Choreographer#doFrame - resynced to %d in %.1fms", timeline.mVsyncId, Float.valueOf((float)(timeline.mDeadlineNanos - startNanos) * 1.0E-6f));
                Trace.traceBegin(8L, message);
            }
            AnimationUtils.lockAnimationClock(frameTimeNanos / 1000000L, timeline.mExpectedPresentationTimeNanos);
            this.mFrameInfo.markInputHandlingStart();
            this.doCallbacks(0, frameIntervalNanos);
            this.mFrameInfo.markAnimationsStart();
            this.doCallbacks(1, frameIntervalNanos);
            this.doCallbacks(2, frameIntervalNanos);
            this.mFrameInfo.markPerformTraversalsStart();
            this.doCallbacks(3, frameIntervalNanos);
            this.doCallbacks(4, frameIntervalNanos);
            return;
        }
        finally {
            AnimationUtils.unlockAnimationClock();
            this.mInDoFrameCallback = false;
            if (resynced) {
                Trace.traceEnd(8L);
            }
            Trace.traceEnd(8L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCallbacks_Original(int callbackType, long frameIntervalNanos) {
        CallbackRecord callbacks;
        long frameTimeNanos = this.mFrameData.mFrameTimeNanos;
        Object object = this.mLock;
        synchronized (object) {
            long now = System_Delegate.nanoTime();
            callbacks = this.mCallbackQueues[callbackType].extractDueCallbacksLocked(now / 1000000L);
            if (callbacks == null) {
                return;
            }
            this.mCallbacksRunning = true;
            if (callbackType == 4) {
                long jitterNanos = now - frameTimeNanos;
                Trace.traceCounter(8L, "jitterNanos", (int)jitterNanos);
                if (frameIntervalNanos > 0L && jitterNanos >= 2L * frameIntervalNanos) {
                    long lastFrameOffset = jitterNanos % frameIntervalNanos + frameIntervalNanos;
                    this.mLastFrameTimeNanos = frameTimeNanos = now - lastFrameOffset;
                    this.mFrameData.update(frameTimeNanos, this.mDisplayEventReceiver, jitterNanos);
                }
            }
        }
        try {
            Trace.traceBegin(8L, CALLBACK_TRACE_TITLES[callbackType]);
            CallbackRecord c = callbacks;
            while (c != null) {
                c.run(this.mFrameData);
                c = c.next;
            }
        }
        finally {
            object = this.mLock;
            synchronized (object) {
                CallbackRecord next;
                this.mCallbacksRunning = false;
                do {
                    next = callbacks.next;
                    this.recycleCallbackLocked(callbacks);
                } while ((callbacks = next) != null);
            }
            Trace.traceEnd(8L);
        }
    }

    @LayoutlibDelegate
    void doCallbacks(int n, long l) {
        Choreographer_Delegate.doCallbacks(this, n, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScheduleVsync() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFrameScheduled) {
                this.scheduleVsyncLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doScheduleCallback(int callbackType) {
        Object object = this.mLock;
        synchronized (object) {
            long now;
            if (!this.mFrameScheduled && this.mCallbackQueues[callbackType].hasDueCallbacksLocked(now = SystemClock.uptimeMillis())) {
                this.scheduleFrameLocked(now);
            }
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private void scheduleVsyncLocked() {
        try {
            Trace.traceBegin(8L, "Choreographer#scheduleVsyncLocked");
            this.mDisplayEventReceiver.scheduleVsync();
        }
        finally {
            Trace.traceEnd(8L);
        }
    }

    private boolean isRunningOnLooperThreadLocked() {
        return Looper.myLooper() == this.mLooper;
    }

    private CallbackRecord obtainCallbackLocked(long dueTime, Object action, Object token) {
        CallbackRecord callback = this.mCallbackPool;
        if (callback == null) {
            callback = new CallbackRecord();
        } else {
            this.mCallbackPool = callback.next;
            callback.next = null;
        }
        callback.dueTime = dueTime;
        callback.action = action;
        callback.token = token;
        return callback;
    }

    private void recycleCallbackLocked(CallbackRecord callback) {
        callback.action = null;
        callback.token = null;
        callback.next = this.mCallbackPool;
        this.mCallbackPool = callback;
    }

    static {
        sSfThreadInstance = new ThreadLocal<Choreographer>(){

            @Override
            protected Choreographer initialValue() {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    throw new IllegalStateException("The current thread must have a looper!");
                }
                return new Choreographer(looper, 1);
            }
        };
        USE_VSYNC = SystemProperties.getBoolean("debug.choreographer.vsync", true);
        USE_FRAME_TIME = SystemProperties.getBoolean("debug.choreographer.frametime", true);
        SKIPPED_FRAME_WARNING_LIMIT = SystemProperties.getInt("debug.choreographer.skipwarning", 30);
        FRAME_CALLBACK_TOKEN = new Object(){

            public String toString() {
                return "FRAME_CALLBACK_TOKEN";
            }
        };
        VSYNC_CALLBACK_TOKEN = new Object(){

            public String toString() {
                return "VSYNC_CALLBACK_TOKEN";
            }
        };
        CALLBACK_TRACE_TITLES = new String[]{"input", "animation", "insets_animation", "traversal", "commit"};
    }

    private static class BufferStuffingState {
        public AtomicBoolean isStuffed = new AtomicBoolean(false);
        public boolean isRecovering = false;
        public int numberWaitsForNextVsync = 0;

        private BufferStuffingState() {
        }

        public void reset() {
            this.isStuffed.set(false);
            this.isRecovering = false;
            this.numberWaitsForNextVsync = 0;
        }

        static enum RecoveryAction {
            NONE,
            OFFSET,
            DELAY_FRAME;

        }
    }

    public static class FrameData {
        private long mFrameTimeNanos;
        private FrameTimeline[] mFrameTimelines;
        private int mPreferredFrameTimelineIndex;
        private boolean mInCallback = false;

        FrameData() {
            this.allocateFrameTimelines(7);
        }

        public long getFrameTimeNanos() {
            this.checkInCallback();
            return this.mFrameTimeNanos;
        }

        @NonNull
        @SuppressLint(value={"ArrayReturn"})
        public FrameTimeline[] getFrameTimelines() {
            this.checkInCallback();
            return this.mFrameTimelines;
        }

        @NonNull
        public FrameTimeline getPreferredFrameTimeline() {
            this.checkInCallback();
            return this.mFrameTimelines[this.mPreferredFrameTimelineIndex];
        }

        void setInCallback(boolean inCallback) {
            this.mInCallback = inCallback;
            for (int i = 0; i < this.mFrameTimelines.length; ++i) {
                this.mFrameTimelines[i].setInCallback(inCallback);
            }
        }

        private void checkInCallback() {
            if (!this.mInCallback) {
                throw new IllegalStateException("FrameData is not valid outside of the vsync callback");
            }
        }

        private void allocateFrameTimelines(int length) {
            length = Math.max(1, length);
            if (this.mFrameTimelines == null || this.mFrameTimelines.length != length) {
                this.mFrameTimelines = new FrameTimeline[length];
                for (int i = 0; i < this.mFrameTimelines.length; ++i) {
                    this.mFrameTimelines[i] = new FrameTimeline();
                }
            }
        }

        FrameTimeline update(long frameTimeNanos, DisplayEventReceiver.VsyncEventData vsyncEventData) {
            this.allocateFrameTimelines(vsyncEventData.frameTimelinesLength);
            this.mFrameTimeNanos = frameTimeNanos;
            this.mPreferredFrameTimelineIndex = vsyncEventData.preferredFrameTimelineIndex;
            for (int i = 0; i < this.mFrameTimelines.length; ++i) {
                DisplayEventReceiver.VsyncEventData.FrameTimeline frameTimeline = vsyncEventData.frameTimelines[i];
                this.mFrameTimelines[i].update(frameTimeline.vsyncId, frameTimeline.expectedPresentationTime, frameTimeline.deadline);
            }
            return this.mFrameTimelines[this.mPreferredFrameTimelineIndex];
        }

        FrameTimeline update(long frameTimeNanos, DisplayEventReceiver displayEventReceiver, long jitterNanos) {
            int newPreferredIndex;
            long minimumDeadline = this.mFrameTimelines[this.mPreferredFrameTimelineIndex].mDeadlineNanos + jitterNanos;
            for (newPreferredIndex = 0; newPreferredIndex < this.mFrameTimelines.length - 1 && this.mFrameTimelines[newPreferredIndex].mDeadlineNanos < minimumDeadline; ++newPreferredIndex) {
            }
            long newPreferredDeadline = this.mFrameTimelines[newPreferredIndex].mDeadlineNanos;
            if (newPreferredDeadline < minimumDeadline) {
                DisplayEventReceiver.VsyncEventData latestVsyncEventData = displayEventReceiver.getLatestVsyncEventData();
                if (latestVsyncEventData == null) {
                    Log.w(Choreographer.TAG, "Could not get latest VsyncEventData. Did SurfaceFlinger crash?");
                } else {
                    this.update(frameTimeNanos, latestVsyncEventData);
                }
            } else {
                this.update(frameTimeNanos, newPreferredIndex);
            }
            return this.mFrameTimelines[this.mPreferredFrameTimelineIndex];
        }

        void update(long frameTimeNanos, int newPreferredFrameTimelineIndex) {
            this.mFrameTimeNanos = frameTimeNanos;
            this.mPreferredFrameTimelineIndex = newPreferredFrameTimelineIndex;
        }
    }

    private class FrameHandler
    extends Handler {
        public FrameHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    Choreographer.this.doFrame(System_Delegate.nanoTime(), 0, new DisplayEventReceiver.VsyncEventData());
                    break;
                }
                case 1: {
                    Choreographer.this.doScheduleVsync();
                    break;
                }
                case 2: {
                    Choreographer.this.doScheduleCallback(msg.arg1);
                }
            }
        }
    }

    private class FrameDisplayEventReceiver
    extends DisplayEventReceiver
    implements Runnable {
        private boolean mHavePendingVsync;
        private long mTimestampNanos;
        private int mFrame;
        private final DisplayEventReceiver.VsyncEventData mLastVsyncEventData;

        FrameDisplayEventReceiver(Looper looper, int vsyncSource, long layerHandle) {
            super(looper, vsyncSource, 0, layerHandle);
            this.mLastVsyncEventData = new DisplayEventReceiver.VsyncEventData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVsync(long timestampNanos, long physicalDisplayId, int frame, DisplayEventReceiver.VsyncEventData vsyncEventData) {
            try {
                long now;
                if (Trace.isTagEnabled(8L)) {
                    Trace.traceBegin(8L, "Choreographer#onVsync " + vsyncEventData.preferredFrameTimeline().vsyncId);
                }
                if (timestampNanos > (now = System_Delegate.nanoTime())) {
                    Log.w(Choreographer.TAG, "Frame time is " + (float)(timestampNanos - now) * 1.0E-6f + " ms in the future!  Check that graphics HAL is generating vsync timestamps using the correct timebase.");
                    timestampNanos = now;
                }
                if (this.mHavePendingVsync) {
                    Log.w(Choreographer.TAG, "Already have a pending vsync event.  There should only be one at a time.");
                } else {
                    this.mHavePendingVsync = true;
                }
                this.mTimestampNanos = timestampNanos;
                this.mFrame = frame;
                this.mLastVsyncEventData.copyFrom(vsyncEventData);
                Message msg = Message.obtain((Handler)Choreographer.this.mHandler, this);
                msg.setAsynchronous(true);
                Choreographer.this.mHandler.sendMessageAtTime(msg, timestampNanos / 1000000L);
            }
            finally {
                Trace.traceEnd(8L);
            }
        }

        @Override
        public void run() {
            this.mHavePendingVsync = false;
            Choreographer.this.doFrame(this.mTimestampNanos, this.mFrame, this.mLastVsyncEventData);
        }
    }

    public class CallbackQueue {
        public CallbackRecord mHead;

        private CallbackQueue() {
        }

        public boolean hasDueCallbacksLocked(long now) {
            return this.mHead != null && this.mHead.dueTime <= now;
        }

        public CallbackRecord extractDueCallbacksLocked(long now) {
            CallbackRecord callbacks = this.mHead;
            if (callbacks == null || callbacks.dueTime > now) {
                return null;
            }
            CallbackRecord last = callbacks;
            CallbackRecord next = last.next;
            while (next != null) {
                if (next.dueTime > now) {
                    last.next = null;
                    break;
                }
                last = next;
                next = next.next;
            }
            this.mHead = next;
            return callbacks;
        }

        @UnsupportedAppUsage
        public void addCallbackLocked(long dueTime, Object action, Object token) {
            CallbackRecord callback = Choreographer.this.obtainCallbackLocked(dueTime, action, token);
            CallbackRecord entry = this.mHead;
            if (entry == null) {
                this.mHead = callback;
                return;
            }
            if (dueTime < entry.dueTime) {
                callback.next = entry;
                this.mHead = callback;
                return;
            }
            while (entry.next != null) {
                if (dueTime < entry.next.dueTime) {
                    callback.next = entry.next;
                    break;
                }
                entry = entry.next;
            }
            entry.next = callback;
        }

        public void removeCallbacksLocked(Object action, Object token) {
            CallbackRecord predecessor = null;
            CallbackRecord callback = this.mHead;
            while (callback != null) {
                CallbackRecord next = callback.next;
                if (!(action != null && callback.action != action || token != null && callback.token != token)) {
                    if (predecessor != null) {
                        predecessor.next = next;
                    } else {
                        this.mHead = next;
                    }
                    Choreographer.this.recycleCallbackLocked(callback);
                } else {
                    predecessor = callback;
                }
                callback = next;
            }
        }
    }

    public static interface FrameCallback {
        public void doFrame(long var1);
    }

    public static class FrameTimeline {
        private long mVsyncId = -1L;
        private long mExpectedPresentationTimeNanos = -1L;
        private long mDeadlineNanos = -1L;
        private boolean mInCallback = false;

        FrameTimeline() {
        }

        void setInCallback(boolean inCallback) {
            this.mInCallback = inCallback;
        }

        private void checkInCallback() {
            if (!this.mInCallback) {
                throw new IllegalStateException("FrameTimeline is not valid outside of the vsync callback");
            }
        }

        void update(long vsyncId, long expectedPresentationTimeNanos, long deadlineNanos) {
            this.mVsyncId = vsyncId;
            this.mExpectedPresentationTimeNanos = expectedPresentationTimeNanos;
            this.mDeadlineNanos = deadlineNanos;
        }

        public long getVsyncId() {
            this.checkInCallback();
            return this.mVsyncId;
        }

        public long getExpectedPresentationTimeNanos() {
            this.checkInCallback();
            return this.mExpectedPresentationTimeNanos;
        }

        public long getDeadlineNanos() {
            this.checkInCallback();
            return this.mDeadlineNanos;
        }
    }

    private static class CallbackRecord {
        public CallbackRecord next;
        public long dueTime;
        public Object action;
        public Object token;

        private CallbackRecord() {
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public void run(long frameTimeNanos) {
            if (this.token == FRAME_CALLBACK_TOKEN) {
                ((FrameCallback)this.action).doFrame(frameTimeNanos);
            } else {
                ((Runnable)this.action).run();
            }
        }

        void run(FrameData frameData) {
            frameData.setInCallback(true);
            if (this.token == VSYNC_CALLBACK_TOKEN) {
                ((VsyncCallback)this.action).onVsync(frameData);
            } else {
                this.run(frameData.getFrameTimeNanos());
            }
            frameData.setInCallback(false);
        }
    }

    public static interface VsyncCallback {
        public void onVsync(@NonNull FrameData var1);
    }
}

