/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.Looper;
import android.os.Trace;
import android.view.Choreographer;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventReceiver;

public class BatchedInputEventReceiver
extends InputEventReceiver {
    private Choreographer mChoreographer;
    private boolean mBatchingEnabled;
    private boolean mBatchedInputScheduled;
    private final String mTag;
    private final Handler mHandler;
    private final Runnable mConsumeBatchedInputEvents = new Runnable(){

        @Override
        public void run() {
            BatchedInputEventReceiver.this.consumeBatchedInputEvents(-1L);
        }
    };
    private final BatchedInputRunnable mBatchedInputRunnable = new BatchedInputRunnable();

    @UnsupportedAppUsage
    public BatchedInputEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer) {
        super(inputChannel, looper);
        this.mChoreographer = choreographer;
        this.mBatchingEnabled = true;
        this.mTag = inputChannel.getName();
        this.traceBoolVariable("mBatchingEnabled", this.mBatchingEnabled);
        this.traceBoolVariable("mBatchedInputScheduled", this.mBatchedInputScheduled);
        this.mHandler = new Handler(looper);
    }

    @Override
    public void onBatchedInputEventPending(int source) {
        if (this.mBatchingEnabled) {
            this.scheduleBatchedInput();
        } else {
            this.consumeBatchedInputEvents(-1L);
        }
    }

    @Override
    public void dispose() {
        this.unscheduleBatchedInput();
        this.consumeBatchedInputEvents(-1L);
        super.dispose();
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        if (this.mBatchingEnabled == batchingEnabled) {
            return;
        }
        this.mBatchingEnabled = batchingEnabled;
        this.traceBoolVariable("mBatchingEnabled", this.mBatchingEnabled);
        this.mHandler.removeCallbacks(this.mConsumeBatchedInputEvents);
        if (!batchingEnabled) {
            this.unscheduleBatchedInput();
            this.mHandler.post(this.mConsumeBatchedInputEvents);
        }
    }

    protected void doConsumeBatchedInput(long frameTimeNanos) {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            this.traceBoolVariable("mBatchedInputScheduled", this.mBatchedInputScheduled);
            if (this.consumeBatchedInputEvents(frameTimeNanos) && frameTimeNanos != -1L) {
                this.scheduleBatchedInput();
            }
        }
    }

    private void scheduleBatchedInput() {
        if (!this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = true;
            this.traceBoolVariable("mBatchedInputScheduled", this.mBatchedInputScheduled);
            this.mChoreographer.postCallback(0, this.mBatchedInputRunnable, null);
        }
    }

    private void unscheduleBatchedInput() {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            this.traceBoolVariable("mBatchedInputScheduled", this.mBatchedInputScheduled);
            this.mChoreographer.removeCallbacks(0, this.mBatchedInputRunnable, null);
        }
    }

    private void traceBoolVariable(String name, boolean value) {
        Trace.traceCounter(4L, name, value ? 1 : 0);
    }

    private class BatchedInputRunnable
    implements Runnable {
        private BatchedInputRunnable() {
        }

        @Override
        public void run() {
            try {
                Trace.traceBegin(4L, BatchedInputEventReceiver.this.mTag);
                BatchedInputEventReceiver.this.doConsumeBatchedInput(BatchedInputEventReceiver.this.mChoreographer.getFrameTimeNanos());
            }
            finally {
                Trace.traceEnd(4L);
            }
        }
    }

    public static class SimpleBatchedInputEventReceiver
    extends BatchedInputEventReceiver {
        protected InputEventListener mListener;

        public SimpleBatchedInputEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer, InputEventListener listener) {
            super(inputChannel, looper, choreographer);
            this.mListener = listener;
        }

        @Override
        public void onInputEvent(InputEvent event) {
            boolean handled = false;
            try {
                handled = this.mListener.onInputEvent(event);
            }
            finally {
                this.finishInputEvent(event, handled);
            }
        }

        public static interface InputEventListener {
            public boolean onInputEvent(InputEvent var1);
        }
    }
}

