/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.ClickableSpan;
import android.util.LongSparseArray;
import android.util.Slog;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeIdManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.AccessibilityRequestPreparer;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IWindowSurfaceInfoCallback;
import android.window.ScreenCapture;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.hidden_from_bootclasspath.android.view.accessibility.Flags;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class AccessibilityInteractionController {
    private static final String LOG_TAG = "AccessibilityInteractionController";
    private static final boolean ENFORCE_NODE_TREE_CONSISTENT = false;
    private static final boolean IGNORE_REQUEST_PREPARERS = true;
    private static final boolean CONSIDER_REQUEST_PREPARERS = false;
    private static final long REQUEST_PREPARER_TIMEOUT_MS = 500L;
    private static final int FLAGS_AFFECTING_REPORTED_DATA = 896;
    private final ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList = new ArrayList();
    private final Object mLock = new Object();
    private final PrivateHandler mHandler;
    private final ViewRootImpl mViewRootImpl;
    private final AccessibilityNodePrefetcher mPrefetcher;
    private final long mMyLooperThreadId;
    private final int mMyProcessId;
    private final AccessibilityManager mA11yManager;
    private final ArrayList<View> mTempArrayList = new ArrayList();
    private final Rect mTempRect = new Rect();
    private final RectF mTempRectF = new RectF();
    private AddNodeInfosForViewId mAddNodeInfosForViewId;
    @GuardedBy(value={"mLock"})
    private ArrayList<Message> mPendingFindNodeByIdMessages;
    @GuardedBy(value={"mLock"})
    private int mNumActiveRequestPreparers;
    @GuardedBy(value={"mLock"})
    private List<MessageHolder> mMessagesWaitingForRequestPreparer;
    @GuardedBy(value={"mLock"})
    private int mActiveRequestPreparerId;

    public AccessibilityInteractionController(ViewRootImpl viewRootImpl) {
        Looper looper = viewRootImpl.mHandler.getLooper();
        this.mMyLooperThreadId = looper.getThread().getId();
        this.mMyProcessId = Process.myPid();
        this.mHandler = new PrivateHandler(looper);
        this.mViewRootImpl = viewRootImpl;
        this.mPrefetcher = new AccessibilityNodePrefetcher();
        this.mA11yManager = this.mViewRootImpl.mContext.getSystemService(AccessibilityManager.class);
        this.mPendingFindNodeByIdMessages = new ArrayList();
    }

    private void scheduleMessage(Message message, int interrogatingPid, long interrogatingTid, boolean ignoreRequestPreparers) {
        if (ignoreRequestPreparers || !this.holdOffMessageIfNeeded(message, interrogatingPid, interrogatingTid)) {
            if (interrogatingPid == this.mMyProcessId && interrogatingTid == this.mMyLooperThreadId && this.mHandler.hasAccessibilityCallback(message)) {
                AccessibilityInteractionClient.getInstanceForThread(interrogatingTid).setSameThreadMessage(message);
            } else if (!this.mHandler.hasAccessibilityCallback(message) && Thread.currentThread().getId() == this.mMyLooperThreadId) {
                this.mHandler.handleMessage(message);
            } else {
                this.mHandler.sendMessage(message);
            }
        }
    }

    private boolean isShown(View view) {
        return view != null && view.getWindowVisibility() == 0 && view.isShown();
    }

    private boolean isVisibleToAccessibilityService(View view) {
        return view != null && (this.mA11yManager.isRequestFromAccessibilityTool() || !view.isAccessibilityDataSensitive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findAccessibilityNodeInfoByAccessibilityIdClientThread(long accessibilityNodeId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, float[] matrixValues, Bundle arguments) {
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        args.arg4 = arguments;
        args.arg5 = matrixValues;
        message.obj = args;
        Object object = this.mLock;
        synchronized (object) {
            this.mPendingFindNodeByIdMessages.add(message);
            this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean holdOffMessageIfNeeded(Message originalMessage, int callingPid, long callingTid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNumActiveRequestPreparers != 0) {
                this.queueMessageToHandleOncePrepared(originalMessage, callingPid, callingTid);
                return true;
            }
            if (originalMessage.what != 2) {
                return false;
            }
            SomeArgs originalMessageArgs = (SomeArgs)originalMessage.obj;
            Bundle requestArguments = (Bundle)originalMessageArgs.arg4;
            if (requestArguments == null) {
                return false;
            }
            int accessibilityViewId = originalMessageArgs.argi1;
            List<AccessibilityRequestPreparer> preparers = this.mA11yManager.getRequestPreparersForAccessibilityId(accessibilityViewId);
            if (preparers == null) {
                return false;
            }
            String extraDataKey = requestArguments.getString("android.view.accessibility.AccessibilityNodeInfo.extra_data_requested");
            if (extraDataKey == null) {
                return false;
            }
            this.mNumActiveRequestPreparers = preparers.size();
            for (int i = 0; i < preparers.size(); ++i) {
                Message requestPreparerMessage = this.mHandler.obtainMessage(7);
                SomeArgs requestPreparerArgs = SomeArgs.obtain();
                requestPreparerArgs.argi1 = originalMessageArgs.argi2 == Integer.MAX_VALUE ? -1 : originalMessageArgs.argi2;
                requestPreparerArgs.arg1 = preparers.get(i);
                requestPreparerArgs.arg2 = extraDataKey;
                requestPreparerArgs.arg3 = requestArguments;
                Message preparationFinishedMessage = this.mHandler.obtainMessage(8);
                preparationFinishedMessage.arg1 = ++this.mActiveRequestPreparerId;
                requestPreparerArgs.arg4 = preparationFinishedMessage;
                requestPreparerMessage.obj = requestPreparerArgs;
                this.scheduleMessage(requestPreparerMessage, callingPid, callingTid, true);
                this.mHandler.obtainMessage(9);
                this.mHandler.sendEmptyMessageDelayed(9, 500L);
            }
            this.queueMessageToHandleOncePrepared(originalMessage, callingPid, callingTid);
            return true;
        }
    }

    private void prepareForExtraDataRequestUiThread(Message message) {
        SomeArgs args = (SomeArgs)message.obj;
        int virtualDescendantId = args.argi1;
        AccessibilityRequestPreparer preparer = (AccessibilityRequestPreparer)args.arg1;
        String extraDataKey = (String)args.arg2;
        Bundle requestArguments = (Bundle)args.arg3;
        Message preparationFinishedMessage = (Message)args.arg4;
        preparer.onPrepareExtraData(virtualDescendantId, extraDataKey, requestArguments, preparationFinishedMessage);
    }

    private void queueMessageToHandleOncePrepared(Message message, int interrogatingPid, long interrogatingTid) {
        if (this.mMessagesWaitingForRequestPreparer == null) {
            this.mMessagesWaitingForRequestPreparer = new ArrayList<MessageHolder>(1);
        }
        MessageHolder messageHolder = new MessageHolder(message, interrogatingPid, interrogatingTid);
        this.mMessagesWaitingForRequestPreparer.add(messageHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestPreparerDoneUiThread(Message message) {
        Object object = this.mLock;
        synchronized (object) {
            if (message.arg1 != this.mActiveRequestPreparerId) {
                Slog.e(LOG_TAG, "Surprising AccessibilityRequestPreparer callback (likely late)");
                return;
            }
            --this.mNumActiveRequestPreparers;
            if (this.mNumActiveRequestPreparers <= 0) {
                this.mHandler.removeMessages(9);
                this.scheduleAllMessagesWaitingForRequestPreparerLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestPreparerTimeoutUiThread() {
        Object object = this.mLock;
        synchronized (object) {
            Slog.e(LOG_TAG, "AccessibilityRequestPreparer timed out");
            this.scheduleAllMessagesWaitingForRequestPreparerLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private void scheduleAllMessagesWaitingForRequestPreparerLocked() {
        int numMessages = this.mMessagesWaitingForRequestPreparer.size();
        for (int i = 0; i < numMessages; ++i) {
            MessageHolder request = this.mMessagesWaitingForRequestPreparer.get(i);
            this.scheduleMessage(request.mMessage, request.mInterrogatingPid, request.mInterrogatingTid, i == 0);
        }
        this.mMessagesWaitingForRequestPreparer.clear();
        this.mNumActiveRequestPreparers = 0;
        this.mActiveRequestPreparerId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        ArrayList<AccessibilityNodeInfo> infos;
        boolean interruptPrefetch;
        AccessibilityNodeInfo requestedNode;
        View requestedView;
        float[] matrixValues;
        Bundle arguments;
        Region interactiveRegion;
        MagnificationSpec spec;
        IAccessibilityInteractionConnectionCallback callback;
        int interactionId;
        int virtualDescendantId;
        int accessibilityViewId;
        int flags;
        block15: {
            Object object = this.mLock;
            synchronized (object) {
                this.mPendingFindNodeByIdMessages.remove(message);
            }
            flags = message.arg1;
            SomeArgs args = (SomeArgs)message.obj;
            accessibilityViewId = args.argi1;
            virtualDescendantId = args.argi2;
            interactionId = args.argi3;
            callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
            spec = (MagnificationSpec)args.arg2;
            interactiveRegion = (Region)args.arg3;
            arguments = (Bundle)args.arg4;
            matrixValues = (float[])args.arg5;
            args.recycle();
            requestedView = null;
            requestedNode = null;
            interruptPrefetch = (flags & 0x20) == 0;
            infos = this.mTempAccessibilityNodeInfoList;
            infos.clear();
            try {
                if (this.mViewRootImpl.mView != null && this.mViewRootImpl.mAttachInfo != null) break block15;
                if (!interruptPrefetch) {
                    this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, matrixValues, interactiveRegion);
                    SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest = this.getSatisfiedRequestInPrefetch(requestedNode == null ? null : requestedNode, infos, flags);
                    if (satisfiedRequest != null) {
                        this.returnFindNodeResult(satisfiedRequest);
                    }
                    return;
                }
                this.updateInfoForViewportAndReturnFindNodeResult(requestedNode == null ? null : new AccessibilityNodeInfo(requestedNode), callback, interactionId, spec, matrixValues, interactiveRegion);
                return;
            }
            catch (Throwable throwable) {
                if (!interruptPrefetch) {
                    this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, matrixValues, interactiveRegion);
                    SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest = this.getSatisfiedRequestInPrefetch(requestedNode == null ? null : requestedNode, infos, flags);
                    if (satisfiedRequest != null) {
                        this.returnFindNodeResult(satisfiedRequest);
                    }
                    return;
                }
                this.updateInfoForViewportAndReturnFindNodeResult(requestedNode == null ? null : new AccessibilityNodeInfo(requestedNode), callback, interactionId, spec, matrixValues, interactiveRegion);
                throw throwable;
            }
        }
        this.setAccessibilityFetchFlags(flags);
        requestedView = this.findViewByAccessibilityId(accessibilityViewId);
        if (requestedView != null && this.isShown(requestedView)) {
            requestedNode = this.populateAccessibilityNodeInfoForView(requestedView, arguments, virtualDescendantId);
            this.mPrefetcher.mInterruptPrefetch = interruptPrefetch;
            this.mPrefetcher.mFetchFlags = flags & 0x3F;
            if (!interruptPrefetch) {
                infos.add(requestedNode);
                this.mPrefetcher.prefetchAccessibilityNodeInfos(requestedView, requestedNode == null ? null : new AccessibilityNodeInfo(requestedNode), infos);
                this.resetAccessibilityFetchFlags();
            }
        }
        if (!interruptPrefetch) {
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, matrixValues, interactiveRegion);
            SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest = this.getSatisfiedRequestInPrefetch(requestedNode == null ? null : requestedNode, infos, flags);
            if (satisfiedRequest != null) {
                this.returnFindNodeResult(satisfiedRequest);
            }
            return;
        }
        this.updateInfoForViewportAndReturnFindNodeResult(requestedNode == null ? null : new AccessibilityNodeInfo(requestedNode), callback, interactionId, spec, matrixValues, interactiveRegion);
        this.mPrefetcher.prefetchAccessibilityNodeInfos(requestedView, requestedNode == null ? null : new AccessibilityNodeInfo(requestedNode), infos);
        this.resetAccessibilityFetchFlags();
        this.updateInfosForViewPort(infos, spec, matrixValues, interactiveRegion);
        SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest = this.getSatisfiedRequestInPrefetch(requestedNode == null ? null : requestedNode, infos, flags);
        this.returnPrefetchResult(interactionId, infos, callback);
        if (satisfiedRequest != null) {
            this.returnFindNodeResult(satisfiedRequest);
        }
    }

    private AccessibilityNodeInfo populateAccessibilityNodeInfoForView(View view, Bundle arguments, int virtualViewId) {
        AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
        String extraDataRequested = arguments == null ? null : arguments.getString("android.view.accessibility.AccessibilityNodeInfo.extra_data_requested");
        AccessibilityNodeInfo root = null;
        if (provider == null) {
            root = view.createAccessibilityNodeInfo();
            if (root != null && extraDataRequested != null) {
                view.addExtraDataToAccessibilityNodeInfo(root, extraDataRequested, arguments);
            }
        } else {
            root = provider.createAccessibilityNodeInfo(virtualViewId);
            if (root != null && extraDataRequested != null) {
                provider.addExtraDataToAccessibilityNodeInfo(virtualViewId, root, extraDataRequested, arguments);
            }
        }
        return root;
    }

    public void findAccessibilityNodeInfosByViewIdClientThread(long accessibilityNodeId, String viewId, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, float[] matrixValues) {
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = viewId;
        args.arg4 = interactiveRegion;
        args.arg5 = matrixValues;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfosByViewIdUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        String viewId = (String)args.arg3;
        Region interactiveRegion = (Region)args.arg4;
        float[] matrixValues = (float[])args.arg5;
        args.recycle();
        ArrayList<AccessibilityNodeInfo> infos = this.mTempAccessibilityNodeInfoList;
        infos.clear();
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null || viewId == null) {
                return;
            }
            this.setAccessibilityFetchFlags(flags);
            View root = this.findViewByAccessibilityId(accessibilityViewId);
            if (root != null) {
                int resolvedViewId = root.getContext().getResources().getIdentifier(viewId, null, null);
                if (resolvedViewId <= 0) {
                    return;
                }
                if (this.mAddNodeInfosForViewId == null) {
                    this.mAddNodeInfosForViewId = new AddNodeInfosForViewId();
                }
                this.mAddNodeInfosForViewId.init(resolvedViewId, infos);
                root.findViewByPredicate(this.mAddNodeInfosForViewId);
                this.mAddNodeInfosForViewId.reset();
            }
        }
        finally {
            this.resetAccessibilityFetchFlags();
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, matrixValues, interactiveRegion);
        }
    }

    public void findAccessibilityNodeInfosByTextClientThread(long accessibilityNodeId, String text, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, float[] matrixValues) {
        Message message = this.mHandler.obtainMessage();
        message.what = 4;
        message.arg1 = flags;
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = text;
        args.arg2 = callback;
        args.arg3 = spec;
        args.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi3 = interactionId;
        args.arg4 = interactiveRegion;
        args.arg5 = matrixValues;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAccessibilityNodeInfosByTextUiThread(Message message) {
        int flags = message.arg1;
        SomeArgs args = (SomeArgs)message.obj;
        String text = (String)args.arg1;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg2;
        MagnificationSpec spec = (MagnificationSpec)args.arg3;
        int accessibilityViewId = args.argi1;
        int virtualDescendantId = args.argi2;
        int interactionId = args.argi3;
        Region interactiveRegion = (Region)args.arg4;
        float[] matrixValues = (float[])args.arg5;
        args.recycle();
        List<AccessibilityNodeInfo> infos = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.setAccessibilityFetchFlags(flags);
            View root = this.findViewByAccessibilityId(accessibilityViewId);
            if (root != null && this.isShown(root)) {
                AccessibilityNodeProvider provider = root.getAccessibilityNodeProvider();
                if (provider != null) {
                    infos = provider.findAccessibilityNodeInfosByText(text, virtualDescendantId);
                } else if (virtualDescendantId == -1) {
                    ArrayList<View> foundViews = this.mTempArrayList;
                    foundViews.clear();
                    root.findViewsWithText(foundViews, text, 7);
                    if (!foundViews.isEmpty()) {
                        infos = this.mTempAccessibilityNodeInfoList;
                        infos.clear();
                        int viewCount = foundViews.size();
                        for (int i = 0; i < viewCount; ++i) {
                            View foundView = foundViews.get(i);
                            if (!this.isShown(foundView) || !this.isVisibleToAccessibilityService(foundView)) continue;
                            provider = foundView.getAccessibilityNodeProvider();
                            if (provider != null) {
                                List<AccessibilityNodeInfo> infosFromProvider = provider.findAccessibilityNodeInfosByText(text, -1);
                                if (infosFromProvider == null) continue;
                                infos.addAll(infosFromProvider);
                                continue;
                            }
                            infos.add(foundView.createAccessibilityNodeInfo());
                        }
                    }
                }
            }
        }
        finally {
            this.resetAccessibilityFetchFlags();
            this.updateInfosForViewportAndReturnFindNodeResult(infos, callback, interactionId, spec, matrixValues, interactiveRegion);
        }
    }

    public void takeScreenshotOfWindowClientThread(int interactionId, ScreenCapture.ScreenCaptureListener listener, IAccessibilityInteractionConnectionCallback callback) {
        Message message = PooledLambda.obtainMessage(AccessibilityInteractionController::takeScreenshotOfWindowUiThread, this, interactionId, listener, callback);
        this.mHandler.sendMessage(message);
    }

    private void takeScreenshotOfWindowUiThread(int interactionId, ScreenCapture.ScreenCaptureListener listener, IAccessibilityInteractionConnectionCallback callback) {
        try {
            if ((this.mViewRootImpl.getWindowFlags() & 0x2000) != 0) {
                callback.sendTakeScreenshotOfWindowError(6, interactionId);
                return;
            }
            ScreenCapture.LayerCaptureArgs captureArgs = ((ScreenCapture.LayerCaptureArgs.Builder)new ScreenCapture.LayerCaptureArgs.Builder(this.mViewRootImpl.getSurfaceControl()).setChildrenOnly(false).setUid(Process.myUid())).build();
            if (ScreenCapture.captureLayers(captureArgs, listener) != 0) {
                callback.sendTakeScreenshotOfWindowError(1, interactionId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void getWindowSurfaceInfoClientThread(IWindowSurfaceInfoCallback callback) {
        Message message = PooledLambda.obtainMessage(AccessibilityInteractionController::getWindowSurfaceInfoUiThread, this, callback);
        this.mHandler.sendMessage(message);
    }

    private void getWindowSurfaceInfoUiThread(IWindowSurfaceInfoCallback callback) {
        try {
            callback.provideWindowSurfaceInfo(this.mViewRootImpl.getWindowFlags(), Process.myUid(), this.mViewRootImpl.getSurfaceControl());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void findFocusClientThread(long accessibilityNodeId, int focusType, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, float[] matrixValues) {
        Message message = this.mHandler.obtainMessage();
        message.what = 5;
        message.arg1 = flags;
        message.arg2 = focusType;
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = interactionId;
        args.argi2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        args.argi3 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        args.arg4 = matrixValues;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void findFocusUiThread(Message message) {
        int flags = message.arg1;
        int focusType = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int interactionId = args.argi1;
        int accessibilityViewId = args.argi2;
        int virtualDescendantId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        float[] matrixValues = (float[])args.arg4;
        args.recycle();
        AccessibilityNodeInfo focused = null;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.setAccessibilityFetchFlags(flags);
            View root = this.findViewByAccessibilityId(accessibilityViewId);
            if (root == null || !this.isShown(root)) return;
            switch (focusType) {
                case 2: {
                    View host = this.mViewRootImpl.mAccessibilityFocusedHost;
                    if (host == null) return;
                    if (!ViewRootImpl.isViewDescendantOf(host, root)) {
                        return;
                    } else if (!this.isShown(host)) {
                        return;
                    } else if (!this.isVisibleToAccessibilityService(host)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
                        if (provider != null) {
                            AccessibilityNodeInfo focusNode = this.mViewRootImpl.mAccessibilityFocusedVirtualView;
                            if (focusNode == null) return;
                            int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(focusNode.getSourceNodeId());
                            focused = provider.createAccessibilityNodeInfo(virtualNodeId);
                            return;
                        } else {
                            if (virtualDescendantId != -1) return;
                            focused = host.createAccessibilityNodeInfo();
                            return;
                        }
                    }
                }
                case 1: {
                    View target = root.findFocus();
                    if (!this.isShown(target)) {
                        return;
                    } else if (!this.isVisibleToAccessibilityService(target)) {
                        return;
                    } else {
                        AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                        if (provider != null) {
                            focused = provider.findFocus(focusType);
                        }
                        if (focused != null) return;
                        focused = target.createAccessibilityNodeInfo();
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown focus type: " + focusType);
                }
            }
        }
        finally {
            this.resetAccessibilityFetchFlags();
            this.updateInfoForViewportAndReturnFindNodeResult(focused, callback, interactionId, spec, matrixValues, interactiveRegion);
        }
    }

    public void focusSearchClientThread(long accessibilityNodeId, int direction, Region interactiveRegion, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid, MagnificationSpec spec, float[] matrixValues) {
        Message message = this.mHandler.obtainMessage();
        message.what = 6;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi2 = direction;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = spec;
        args.arg3 = interactiveRegion;
        args.arg4 = matrixValues;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void focusSearchUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int direction = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        MagnificationSpec spec = (MagnificationSpec)args.arg2;
        Region interactiveRegion = (Region)args.arg3;
        float[] matrixValues = (float[])args.arg4;
        args.recycle();
        AccessibilityNodeInfo next = null;
        try {
            View nextView;
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
                return;
            }
            this.setAccessibilityFetchFlags(flags);
            View root = this.findViewByAccessibilityId(accessibilityViewId);
            if (root != null && this.isShown(root) && (nextView = root.focusSearch(direction)) != null) {
                next = nextView.createAccessibilityNodeInfo();
            }
        }
        finally {
            this.resetAccessibilityFetchFlags();
            this.updateInfoForViewportAndReturnFindNodeResult(next, callback, interactionId, spec, matrixValues, interactiveRegion);
        }
    }

    public void performAccessibilityActionClientThread(long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, int interrogatingPid, long interrogatingTid) {
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        message.arg1 = flags;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId);
        SomeArgs args = SomeArgs.obtain();
        args.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeId);
        args.argi2 = action;
        args.argi3 = interactionId;
        args.arg1 = callback;
        args.arg2 = arguments;
        message.obj = args;
        this.scheduleMessage(message, interrogatingPid, interrogatingTid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAccessibilityActionUiThread(Message message) {
        int flags = message.arg1;
        int accessibilityViewId = message.arg2;
        SomeArgs args = (SomeArgs)message.obj;
        int virtualDescendantId = args.argi1;
        int action = args.argi2;
        int interactionId = args.argi3;
        IAccessibilityInteractionConnectionCallback callback = (IAccessibilityInteractionConnectionCallback)args.arg1;
        Bundle arguments = (Bundle)args.arg2;
        args.recycle();
        boolean succeeded = false;
        try {
            if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null || this.mViewRootImpl.mStopped || this.mViewRootImpl.mPausedForTransition) {
                return;
            }
            this.setAccessibilityFetchFlags(flags);
            View target = this.findViewByAccessibilityId(accessibilityViewId);
            if (target != null && this.isShown(target) && this.isVisibleToAccessibilityService(target)) {
                this.mA11yManager.notifyPerformingAction(action);
                if (action == 16908713) {
                    succeeded = this.handleClickableSpanActionUiThread(target, virtualDescendantId, arguments);
                } else {
                    AccessibilityNodeProvider provider = target.getAccessibilityNodeProvider();
                    if (provider != null) {
                        succeeded = provider.performAction(virtualDescendantId, action, arguments);
                    } else if (virtualDescendantId == -1) {
                        succeeded = target.performAccessibilityAction(action, arguments);
                    }
                }
                this.mA11yManager.notifyPerformingAction(0);
            }
        }
        finally {
            try {
                this.resetAccessibilityFetchFlags();
                callback.setPerformAccessibilityActionResult(succeeded, interactionId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    public void clearAccessibilityFocusClientThread() {
        Message message = this.mHandler.obtainMessage();
        message.what = 101;
        this.scheduleMessage(message, 0, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAccessibilityFocusUiThread() {
        if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null) {
            return;
        }
        try {
            this.setAccessibilityFetchFlags(640);
            View root = this.getRootView();
            if (root != null && this.isShown(root)) {
                View host = this.mViewRootImpl.mAccessibilityFocusedHost;
                if (host == null || !ViewRootImpl.isViewDescendantOf(host, root)) {
                    return;
                }
                AccessibilityNodeProvider provider = host.getAccessibilityNodeProvider();
                AccessibilityNodeInfo focusNode = this.mViewRootImpl.mAccessibilityFocusedVirtualView;
                if (provider != null && focusNode != null) {
                    int virtualNodeId = AccessibilityNodeInfo.getVirtualDescendantId(focusNode.getSourceNodeId());
                    provider.performAction(virtualNodeId, AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS.getId(), null);
                } else {
                    host.performAccessibilityAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLEAR_ACCESSIBILITY_FOCUS.getId(), null);
                }
            }
        }
        finally {
            this.resetAccessibilityFetchFlags();
        }
    }

    public void notifyOutsideTouchClientThread() {
        Message message = this.mHandler.obtainMessage();
        message.what = 102;
        this.scheduleMessage(message, 0, 0L, false);
    }

    private void notifyOutsideTouchUiThread() {
        if (this.mViewRootImpl.mView == null || this.mViewRootImpl.mAttachInfo == null || this.mViewRootImpl.mStopped || this.mViewRootImpl.mPausedForTransition) {
            return;
        }
        View root = this.getRootView();
        if (root != null && this.isShown(root)) {
            long now = SystemClock.uptimeMillis();
            MotionEvent event = MotionEvent.obtain(now, now, 4, 0.0f, 0.0f, 0);
            event.setSource(4098);
            this.mViewRootImpl.dispatchInputEvent(event);
        }
    }

    private View findViewByAccessibilityId(int accessibilityId) {
        if (accessibilityId == 0x7FFFFFFE) {
            return this.getRootView();
        }
        return AccessibilityNodeIdManager.getInstance().findView(accessibilityId);
    }

    @VisibleForTesting
    public View getRootView() {
        if (!this.isVisibleToAccessibilityService(this.mViewRootImpl.mView)) {
            return null;
        }
        if (Flags.ignoreUnimportantRoot()) {
            if (this.mViewRootImpl.mView == null || !this.mViewRootImpl.mView.includeForAccessibility()) {
                return null;
            }
            return this.mViewRootImpl.mView;
        }
        return this.mViewRootImpl.mView;
    }

    private void setAccessibilityFetchFlags(int flags) {
        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = flags;
        this.mA11yManager.setRequestFromAccessibilityTool((flags & 0x200) != 0);
    }

    private void resetAccessibilityFetchFlags() {
        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
        this.mA11yManager.setRequestFromAccessibilityTool(false);
    }

    private void adjustIsVisibleToUserIfNeeded(AccessibilityNodeInfo info, Region interactiveRegion, MagnificationSpec spec) {
        if (interactiveRegion == null || info == null) {
            return;
        }
        Rect boundsInScreen = this.mTempRect;
        info.getBoundsInScreen(boundsInScreen);
        if (spec != null && !spec.isNop()) {
            boundsInScreen.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
            boundsInScreen.scale(1.0f / spec.scale);
        }
        if (interactiveRegion.quickReject(boundsInScreen) && !this.shouldBypassAdjustIsVisible()) {
            info.setVisibleToUser(false);
        }
    }

    private boolean shouldBypassAdjustIsVisible() {
        int windowType = this.mViewRootImpl.mOrigWindowType;
        return windowType == 2011;
    }

    private void applyHostWindowMatrixIfNeeded(AccessibilityNodeInfo info) {
        if (info == null || this.shouldBypassApplyWindowMatrix()) {
            return;
        }
        Rect boundsInScreen = this.mTempRect;
        RectF transformedBounds = this.mTempRectF;
        Matrix windowMatrix = this.mViewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy;
        info.getBoundsInScreen(boundsInScreen);
        transformedBounds.set(boundsInScreen);
        windowMatrix.mapRect(transformedBounds);
        boundsInScreen.set((int)transformedBounds.left, (int)transformedBounds.top, (int)transformedBounds.right, (int)transformedBounds.bottom);
        info.setBoundsInScreen(boundsInScreen);
    }

    private boolean shouldBypassApplyWindowMatrix() {
        Matrix windowMatrix = this.mViewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy;
        return windowMatrix == null || windowMatrix.isIdentity();
    }

    private void associateLeashedParentIfNeeded(AccessibilityNodeInfo info) {
        if (info == null || this.shouldBypassAssociateLeashedParent()) {
            return;
        }
        if (this.mViewRootImpl.mView.getAccessibilityViewId() != AccessibilityNodeInfo.getAccessibilityViewId(info.getSourceNodeId())) {
            return;
        }
        info.setLeashedParent(this.mViewRootImpl.mAttachInfo.mLeashedParentToken, this.mViewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId);
    }

    private boolean shouldBypassAssociateLeashedParent() {
        return this.mViewRootImpl.mAttachInfo.mLeashedParentToken == null && this.mViewRootImpl.mAttachInfo.mLeashedParentAccessibilityViewId == -1;
    }

    private boolean shouldApplyAppScaleAndMagnificationSpec(float appScale, MagnificationSpec spec) {
        return appScale != 1.0f || spec != null && !spec.isNop();
    }

    private void updateInfosForViewPort(List<AccessibilityNodeInfo> infos, MagnificationSpec spec, float[] matrixValues, Region interactiveRegion) {
        for (int i = 0; i < infos.size(); ++i) {
            this.updateInfoForViewPort(infos.get(i), spec, matrixValues, interactiveRegion);
        }
    }

    private void updateInfoForViewPort(AccessibilityNodeInfo info, MagnificationSpec spec, float[] matrixValues, Region interactiveRegion) {
        this.associateLeashedParentIfNeeded(info);
        this.applyHostWindowMatrixIfNeeded(info);
        this.transformBoundsWithScreenMatrix(info, matrixValues);
        this.adjustIsVisibleToUserIfNeeded(info, interactiveRegion, spec);
    }

    private void transformBoundsWithScreenMatrix(AccessibilityNodeInfo info, float[] matrixValues) {
        Bundle extras;
        RectF[] textLocations;
        if (info == null || matrixValues == null) {
            return;
        }
        Rect boundInScreen = this.mTempRect;
        RectF transformedBounds = this.mTempRectF;
        info.getBoundsInScreen(boundInScreen);
        transformedBounds.set(boundInScreen);
        Matrix transformMatrix = new Matrix();
        transformMatrix.setValues(matrixValues);
        float applicationScale = this.mViewRootImpl.mAttachInfo.mApplicationScale;
        if (applicationScale != 1.0f) {
            transformMatrix.preScale(applicationScale, applicationScale);
        }
        if (this.mViewRootImpl.mAttachInfo.mWindowMatrixInEmbeddedHierarchy == null) {
            transformMatrix.preTranslate(-this.mViewRootImpl.mAttachInfo.mWindowLeft, -this.mViewRootImpl.mAttachInfo.mWindowTop);
        }
        if (transformMatrix.isIdentity()) {
            return;
        }
        transformMatrix.mapRect(transformedBounds);
        AccessibilityInteractionController.roundRectFToRect(transformedBounds, boundInScreen);
        info.setBoundsInScreen(boundInScreen);
        if (info.hasExtras() && (textLocations = (extras = info.getExtras()).getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", RectF.class)) != null) {
            for (int i = 0; i < textLocations.length; ++i) {
                RectF textLocation = textLocations[i];
                if (textLocation == null) continue;
                transformMatrix.mapRect(textLocation);
            }
        }
        this.applyTransformMatrixToBoundsInParentIfNeeded(info, transformMatrix);
    }

    private void applyTransformMatrixToBoundsInParentIfNeeded(AccessibilityNodeInfo info, Matrix transformMatrix) {
        float[] screenMatrixValues = new float[9];
        transformMatrix.getValues(screenMatrixValues);
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(screenMatrixValues[0], screenMatrixValues[0]);
        if (scaleMatrix.isIdentity()) {
            return;
        }
        Rect boundsInParent = this.mTempRect;
        RectF transformedBounds = this.mTempRectF;
        info.getBoundsInParent(boundsInParent);
        transformedBounds.set(boundsInParent);
        scaleMatrix.mapRect(transformedBounds);
        AccessibilityInteractionController.roundRectFToRect(transformedBounds, boundsInParent);
        info.setBoundsInParent(boundsInParent);
    }

    private void updateInfosForViewportAndReturnFindNodeResult(List<AccessibilityNodeInfo> infos, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, float[] matrixValues, Region interactiveRegion) {
        if (infos != null) {
            this.updateInfosForViewPort(infos, spec, matrixValues, interactiveRegion);
        }
        this.returnFindNodesResult(infos, callback, interactionId);
    }

    private void returnFindNodeResult(AccessibilityNodeInfo info, IAccessibilityInteractionConnectionCallback callback, int interactionId) {
        try {
            callback.setFindAccessibilityNodeInfoResult(info, interactionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void returnFindNodeResult(SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest) {
        try {
            AccessibilityNodeInfo info = satisfiedRequest.mSatisfiedRequestNode;
            IAccessibilityInteractionConnectionCallback callback = satisfiedRequest.mSatisfiedRequestCallback;
            int interactionId = satisfiedRequest.mSatisfiedRequestInteractionId;
            callback.setFindAccessibilityNodeInfoResult(info, interactionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void returnFindNodesResult(List<AccessibilityNodeInfo> infos, IAccessibilityInteractionConnectionCallback callback, int interactionId) {
        try {
            callback.setFindAccessibilityNodeInfosResult(infos, interactionId);
            if (infos != null) {
                infos.clear();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SatisfiedFindAccessibilityNodeByAccessibilityIdRequest getSatisfiedRequestInPrefetch(AccessibilityNodeInfo requestedNode, List<AccessibilityNodeInfo> infos, int flags) {
        SatisfiedFindAccessibilityNodeByAccessibilityIdRequest satisfiedRequest = null;
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mPendingFindNodeByIdMessages.size(); ++i) {
                Message pendingMessage = this.mPendingFindNodeByIdMessages.get(i);
                int pendingFlags = pendingMessage.arg1;
                if ((pendingFlags & 0x380) != (flags & 0x380)) continue;
                SomeArgs args = (SomeArgs)pendingMessage.obj;
                int accessibilityViewId = args.argi1;
                int virtualDescendantId = args.argi2;
                AccessibilityNodeInfo satisfiedRequestNode = this.nodeWithIdFromList(requestedNode, infos, AccessibilityNodeInfo.makeNodeId(accessibilityViewId, virtualDescendantId));
                if (satisfiedRequestNode == null) continue;
                this.mHandler.removeMessages(2, pendingMessage.obj);
                IAccessibilityInteractionConnectionCallback satisfiedRequestCallback = (IAccessibilityInteractionConnectionCallback)args.arg1;
                int satisfiedRequestInteractionId = args.argi3;
                satisfiedRequest = new SatisfiedFindAccessibilityNodeByAccessibilityIdRequest(satisfiedRequestNode, satisfiedRequestCallback, satisfiedRequestInteractionId);
                args.recycle();
                break;
            }
            this.mPendingFindNodeByIdMessages.clear();
            if (satisfiedRequest != null && satisfiedRequest.mSatisfiedRequestNode != requestedNode) {
                infos.remove(satisfiedRequest.mSatisfiedRequestNode);
            }
            return satisfiedRequest;
        }
    }

    private AccessibilityNodeInfo nodeWithIdFromList(AccessibilityNodeInfo requestedNode, List<AccessibilityNodeInfo> infos, long nodeId) {
        if (requestedNode != null && requestedNode.getSourceNodeId() == nodeId) {
            return requestedNode;
        }
        for (int j = 0; j < infos.size(); ++j) {
            AccessibilityNodeInfo info = infos.get(j);
            if (info.getSourceNodeId() != nodeId) continue;
            return info;
        }
        return null;
    }

    private void returnPrefetchResult(int interactionId, List<AccessibilityNodeInfo> infos, IAccessibilityInteractionConnectionCallback callback) {
        if (infos.size() > 0) {
            try {
                callback.setPrefetchAccessibilityNodeInfoResult(infos, interactionId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void updateInfoForViewportAndReturnFindNodeResult(AccessibilityNodeInfo info, IAccessibilityInteractionConnectionCallback callback, int interactionId, MagnificationSpec spec, float[] matrixValues, Region interactiveRegion) {
        this.updateInfoForViewPort(info, spec, matrixValues, interactiveRegion);
        this.returnFindNodeResult(info, callback, interactionId);
    }

    private boolean handleClickableSpanActionUiThread(View view, int virtualDescendantId, Bundle arguments) {
        Object span = arguments.getParcelable("android.view.accessibility.action.ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN");
        if (!(span instanceof AccessibilityClickableSpan)) {
            return false;
        }
        AccessibilityNodeInfo infoWithSpan = null;
        AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
        if (provider != null) {
            infoWithSpan = provider.createAccessibilityNodeInfo(virtualDescendantId);
        } else if (virtualDescendantId == -1) {
            infoWithSpan = view.createAccessibilityNodeInfo();
        }
        if (infoWithSpan == null) {
            return false;
        }
        ClickableSpan clickableSpan = ((AccessibilityClickableSpan)span).findClickableSpan(infoWithSpan.getOriginalText());
        if (clickableSpan != null) {
            clickableSpan.onClick(view);
            return true;
        }
        return false;
    }

    private static void roundRectFToRect(@NonNull RectF sourceRectF, @NonNull Rect outRect) {
        outRect.set((int)((double)sourceRectF.left + 0.5), (int)((double)sourceRectF.top + 0.5), (int)((double)sourceRectF.right + 0.5), (int)((double)sourceRectF.bottom + 0.5));
    }

    public void destroy() {
        if (Flags.preventLeakingViewrootimpl()) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
    }

    public void attachAccessibilityOverlayToWindowClientThread(SurfaceControl sc, int interactionId, IAccessibilityInteractionConnectionCallback callback) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AccessibilityInteractionController::attachAccessibilityOverlayToWindowUiThread, this, sc, interactionId, callback));
    }

    private void attachAccessibilityOverlayToWindowUiThread(SurfaceControl sc, int interactionId, IAccessibilityInteractionConnectionCallback callback) {
        SurfaceControl parent = this.mViewRootImpl.getSurfaceControl();
        if (!parent.isValid()) {
            try {
                callback.sendAttachOverlayResult(1, interactionId);
                return;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        SurfaceControl.Transaction t = new SurfaceControl.Transaction();
        t.reparent(sc, parent).apply();
        t.close();
        try {
            callback.sendAttachOverlayResult(0, interactionId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private class PrivateHandler
    extends Handler {
        private static final int MSG_PERFORM_ACCESSIBILITY_ACTION = 1;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID = 2;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID = 3;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT = 4;
        private static final int MSG_FIND_FOCUS = 5;
        private static final int MSG_FOCUS_SEARCH = 6;
        private static final int MSG_PREPARE_FOR_EXTRA_DATA_REQUEST = 7;
        private static final int MSG_APP_PREPARATION_FINISHED = 8;
        private static final int MSG_APP_PREPARATION_TIMEOUT = 9;
        private static final int FIRST_NO_ACCESSIBILITY_CALLBACK_MSG = 100;
        private static final int MSG_CLEAR_ACCESSIBILITY_FOCUS = 101;
        private static final int MSG_NOTIFY_OUTSIDE_TOUCH = 102;

        public PrivateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public String getMessageName(Message message) {
            int type = message.what;
            switch (type) {
                case 1: {
                    return "MSG_PERFORM_ACCESSIBILITY_ACTION";
                }
                case 2: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID";
                }
                case 3: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID";
                }
                case 4: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT";
                }
                case 5: {
                    return "MSG_FIND_FOCUS";
                }
                case 6: {
                    return "MSG_FOCUS_SEARCH";
                }
                case 7: {
                    return "MSG_PREPARE_FOR_EXTRA_DATA_REQUEST";
                }
                case 8: {
                    return "MSG_APP_PREPARATION_FINISHED";
                }
                case 9: {
                    return "MSG_APP_PREPARATION_TIMEOUT";
                }
                case 101: {
                    return "MSG_CLEAR_ACCESSIBILITY_FOCUS";
                }
                case 102: {
                    return "MSG_NOTIFY_OUTSIDE_TOUCH";
                }
            }
            throw new IllegalArgumentException("Unknown message type: " + type);
        }

        @Override
        public void handleMessage(Message message) {
            int type = message.what;
            switch (type) {
                case 2: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfoByAccessibilityIdUiThread(message);
                    break;
                }
                case 1: {
                    AccessibilityInteractionController.this.performAccessibilityActionUiThread(message);
                    break;
                }
                case 3: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByViewIdUiThread(message);
                    break;
                }
                case 4: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByTextUiThread(message);
                    break;
                }
                case 5: {
                    AccessibilityInteractionController.this.findFocusUiThread(message);
                    break;
                }
                case 6: {
                    AccessibilityInteractionController.this.focusSearchUiThread(message);
                    break;
                }
                case 7: {
                    AccessibilityInteractionController.this.prepareForExtraDataRequestUiThread(message);
                    break;
                }
                case 8: {
                    AccessibilityInteractionController.this.requestPreparerDoneUiThread(message);
                    break;
                }
                case 9: {
                    AccessibilityInteractionController.this.requestPreparerTimeoutUiThread();
                    break;
                }
                case 101: {
                    AccessibilityInteractionController.this.clearAccessibilityFocusUiThread();
                    break;
                }
                case 102: {
                    AccessibilityInteractionController.this.notifyOutsideTouchUiThread();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + type);
                }
            }
        }

        boolean hasAccessibilityCallback(Message message) {
            return message.what < 100;
        }

        boolean hasUserInteractiveMessagesWaiting() {
            return this.hasMessagesOrCallbacks();
        }
    }

    private class AccessibilityNodePrefetcher {
        private final ArrayList<View> mTempViewList = new ArrayList();
        private boolean mInterruptPrefetch;
        private int mFetchFlags;

        private AccessibilityNodePrefetcher() {
        }

        public void prefetchAccessibilityNodeInfos(View view, AccessibilityNodeInfo root, List<AccessibilityNodeInfo> outInfos) {
            if (root == null) {
                return;
            }
            AccessibilityNodeProvider provider = view.getAccessibilityNodeProvider();
            boolean prefetchPredecessors = this.isFlagSet(1);
            if (provider == null) {
                if (prefetchPredecessors) {
                    this.prefetchPredecessorsOfRealNode(view, outInfos);
                }
                if (this.isFlagSet(2)) {
                    this.prefetchSiblingsOfRealNode(view, outInfos, prefetchPredecessors);
                }
                if (this.isFlagSet(4)) {
                    this.prefetchDescendantsOfRealNode(view, outInfos);
                }
            } else {
                if (prefetchPredecessors) {
                    this.prefetchPredecessorsOfVirtualNode(root, view, provider, outInfos);
                }
                if (this.isFlagSet(2)) {
                    this.prefetchSiblingsOfVirtualNode(root, view, provider, outInfos, prefetchPredecessors);
                }
                if (this.isFlagSet(4)) {
                    this.prefetchDescendantsOfVirtualNode(root, provider, outInfos);
                }
            }
            if (this.isFlagSet(8) || this.isFlagSet(16)) {
                if (this.shouldStopPrefetching(outInfos)) {
                    return;
                }
                PrefetchDeque deque = new PrefetchDeque(this.mFetchFlags & 0x1C, outInfos);
                this.addChildrenOfRoot(view, root, provider, deque);
                deque.performTraversalAndPrefetch();
            }
        }

        private void addChildrenOfRoot(View root, AccessibilityNodeInfo rootInfo, AccessibilityNodeProvider rootProvider, PrefetchDeque deque) {
            DequeNode rootDequeNode = rootProvider == null ? new ViewNode(root) : new VirtualNode(-1L, rootProvider);
            rootDequeNode.addChildren(rootInfo, deque);
        }

        private boolean isFlagSet(int strategy) {
            return (this.mFetchFlags & strategy) != 0;
        }

        public boolean shouldStopPrefetching(List prefetchedInfos) {
            return AccessibilityInteractionController.this.mHandler.hasUserInteractiveMessagesWaiting() && this.mInterruptPrefetch || prefetchedInfos.size() >= 50;
        }

        private void enforceNodeTreeConsistent(AccessibilityNodeInfo root, List<AccessibilityNodeInfo> nodes) {
            LongSparseArray<AccessibilityNodeInfo> nodeMap = new LongSparseArray<AccessibilityNodeInfo>();
            int nodeCount = nodes.size();
            for (int i = 0; i < nodeCount; ++i) {
                AccessibilityNodeInfo node = nodes.get(i);
                nodeMap.put(node.getSourceNodeId(), node);
            }
            AccessibilityNodeInfo parent = root;
            while (parent != null) {
                root = parent;
                parent = (AccessibilityNodeInfo)nodeMap.get(parent.getParentNodeId());
            }
            AccessibilityNodeInfo accessFocus = null;
            AccessibilityNodeInfo inputFocus = null;
            HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
            fringe.add(root);
            while (!fringe.isEmpty()) {
                AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
                if (!seen.add(current)) {
                    throw new IllegalStateException("Duplicate node: " + current + " in window:" + AccessibilityInteractionController.this.mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                }
                if (current.isAccessibilityFocused()) {
                    if (accessFocus != null) {
                        throw new IllegalStateException("Duplicate accessibility focus:" + current + " in window:" + AccessibilityInteractionController.this.mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    accessFocus = current;
                }
                if (current.isFocused()) {
                    if (inputFocus != null) {
                        throw new IllegalStateException("Duplicate input focus: " + current + " in window:" + AccessibilityInteractionController.this.mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    inputFocus = current;
                }
                int childCount = current.getChildCount();
                for (int j = 0; j < childCount; ++j) {
                    long childId = current.getChildId(j);
                    AccessibilityNodeInfo child = (AccessibilityNodeInfo)nodeMap.get(childId);
                    if (child == null) continue;
                    fringe.add(child);
                }
            }
            for (int j = nodeMap.size() - 1; j >= 0; --j) {
                AccessibilityNodeInfo info = (AccessibilityNodeInfo)nodeMap.valueAt(j);
                if (seen.contains(info)) continue;
                throw new IllegalStateException("Disconnected node: " + info);
            }
        }

        private void prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> outInfos) {
            if (this.shouldStopPrefetching(outInfos)) {
                return;
            }
            ViewParent parent = view.getParentForAccessibility();
            while (parent instanceof View && !this.shouldStopPrefetching(outInfos)) {
                View parentView = (View)((Object)parent);
                AccessibilityNodeInfo info = parentView.createAccessibilityNodeInfo();
                if (info != null) {
                    outInfos.add(info);
                }
                parent = parent.getParentForAccessibility();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchSiblingsOfRealNode(View current, List<AccessibilityNodeInfo> outInfos, boolean predecessorsPrefetched) {
            if (this.shouldStopPrefetching(outInfos)) {
                return;
            }
            ViewParent parent = current.getParentForAccessibility();
            if (parent instanceof ViewGroup) {
                ViewGroup parentGroup = (ViewGroup)parent;
                ArrayList<View> children = this.mTempViewList;
                children.clear();
                try {
                    AccessibilityNodeInfo parentInfo;
                    if (!predecessorsPrefetched && (parentInfo = ((ViewGroup)parent).createAccessibilityNodeInfo()) != null) {
                        outInfos.add(parentInfo);
                    }
                    parentGroup.addChildrenForAccessibility(children);
                    int childCount = children.size();
                    for (int i = 0; i < childCount; ++i) {
                        if (this.shouldStopPrefetching(outInfos)) {
                            return;
                        }
                        View child = children.get(i);
                        if (child.getAccessibilityViewId() == current.getAccessibilityViewId() || !AccessibilityInteractionController.this.isShown(child)) continue;
                        AccessibilityNodeInfo info = null;
                        AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                        info = provider == null ? child.createAccessibilityNodeInfo() : provider.createAccessibilityNodeInfo(-1);
                        if (info == null) continue;
                        outInfos.add(info);
                    }
                }
                finally {
                    children.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prefetchDescendantsOfRealNode(View root, List<AccessibilityNodeInfo> outInfos) {
            if (this.shouldStopPrefetching(outInfos) || !(root instanceof ViewGroup)) {
                return;
            }
            LinkedHashMap<View, AccessibilityNodeInfo> addedChildren = new LinkedHashMap<View, AccessibilityNodeInfo>();
            ArrayList<View> children = this.mTempViewList;
            children.clear();
            try {
                root.addChildrenForAccessibility(children);
                int childCount = children.size();
                for (int i = 0; i < childCount; ++i) {
                    AccessibilityNodeInfo info;
                    if (this.shouldStopPrefetching(outInfos)) {
                        return;
                    }
                    View child = children.get(i);
                    if (!AccessibilityInteractionController.this.isShown(child)) continue;
                    AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                    if (provider == null) {
                        info = child.createAccessibilityNodeInfo();
                        if (info == null) continue;
                        outInfos.add(info);
                        addedChildren.put(child, null);
                        continue;
                    }
                    info = provider.createAccessibilityNodeInfo(-1);
                    if (info == null) continue;
                    outInfos.add(info);
                    addedChildren.put(child, info);
                }
            }
            finally {
                children.clear();
            }
            if (!this.shouldStopPrefetching(outInfos)) {
                for (Map.Entry entry : addedChildren.entrySet()) {
                    View addedChild = (View)entry.getKey();
                    AccessibilityNodeInfo virtualRoot = (AccessibilityNodeInfo)entry.getValue();
                    if (virtualRoot == null) {
                        this.prefetchDescendantsOfRealNode(addedChild, outInfos);
                        continue;
                    }
                    AccessibilityNodeProvider provider = addedChild.getAccessibilityNodeProvider();
                    this.prefetchDescendantsOfVirtualNode(virtualRoot, provider, outInfos);
                }
            }
        }

        private void prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo root, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialResultSize = outInfos.size();
            long parentNodeId = root.getParentNodeId();
            int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            while (accessibilityViewId != Integer.MAX_VALUE) {
                if (this.shouldStopPrefetching(outInfos)) {
                    return;
                }
                int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
                if (virtualDescendantId != -1 || accessibilityViewId == providerHost.getAccessibilityViewId()) {
                    AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(virtualDescendantId);
                    if (parent == null) {
                        int currentResultSize = outInfos.size();
                        for (int i = currentResultSize - 1; i >= initialResultSize; --i) {
                            outInfos.remove(i);
                        }
                        return;
                    }
                    outInfos.add(parent);
                    parentNodeId = parent.getParentNodeId();
                    accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
                    continue;
                }
                this.prefetchPredecessorsOfRealNode(providerHost, outInfos);
                return;
            }
        }

        private void prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo current, View providerHost, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos, boolean predecessorsPrefetched) {
            long parentNodeId = current.getParentNodeId();
            int parentAccessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(parentNodeId);
            int parentVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(parentNodeId);
            if (parentVirtualDescendantId != -1 || parentAccessibilityViewId == providerHost.getAccessibilityViewId()) {
                AccessibilityNodeInfo parent = provider.createAccessibilityNodeInfo(parentVirtualDescendantId);
                if (parent != null) {
                    if (!predecessorsPrefetched) {
                        outInfos.add(parent);
                    }
                    int childCount = parent.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        int childVirtualDescendantId;
                        AccessibilityNodeInfo child;
                        if (this.shouldStopPrefetching(outInfos)) {
                            return;
                        }
                        long childNodeId = parent.getChildId(i);
                        if (childNodeId == current.getSourceNodeId() || (child = provider.createAccessibilityNodeInfo(childVirtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(childNodeId))) == null) continue;
                        outInfos.add(child);
                    }
                }
            } else {
                this.prefetchSiblingsOfRealNode(providerHost, outInfos, predecessorsPrefetched);
            }
        }

        private void prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo root, AccessibilityNodeProvider provider, List<AccessibilityNodeInfo> outInfos) {
            int initialOutInfosSize = outInfos.size();
            int childCount = root.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (this.shouldStopPrefetching(outInfos)) {
                    return;
                }
                long childNodeId = root.getChildId(i);
                AccessibilityNodeInfo child = provider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(childNodeId));
                if (child == null) continue;
                outInfos.add(child);
            }
            if (!this.shouldStopPrefetching(outInfos)) {
                int addedChildCount = outInfos.size() - initialOutInfosSize;
                for (int i = 0; i < addedChildCount; ++i) {
                    AccessibilityNodeInfo child = outInfos.get(initialOutInfosSize + i);
                    this.prefetchDescendantsOfVirtualNode(child, provider, outInfos);
                }
            }
        }
    }

    private static class MessageHolder {
        final Message mMessage;
        final int mInterrogatingPid;
        final long mInterrogatingTid;

        MessageHolder(Message message, int interrogatingPid, long interrogatingTid) {
            this.mMessage = message;
            this.mInterrogatingPid = interrogatingPid;
            this.mInterrogatingTid = interrogatingTid;
        }
    }

    private static class SatisfiedFindAccessibilityNodeByAccessibilityIdRequest {
        final AccessibilityNodeInfo mSatisfiedRequestNode;
        final IAccessibilityInteractionConnectionCallback mSatisfiedRequestCallback;
        final int mSatisfiedRequestInteractionId;

        SatisfiedFindAccessibilityNodeByAccessibilityIdRequest(AccessibilityNodeInfo satisfiedRequestNode, IAccessibilityInteractionConnectionCallback satisfiedRequestCallback, int satisfiedRequestInteractionId) {
            this.mSatisfiedRequestNode = satisfiedRequestNode;
            this.mSatisfiedRequestCallback = satisfiedRequestCallback;
            this.mSatisfiedRequestInteractionId = satisfiedRequestInteractionId;
        }
    }

    private class AddNodeInfosForViewId
    implements Predicate<View> {
        private int mViewId = -1;
        private List<AccessibilityNodeInfo> mInfos;

        private AddNodeInfosForViewId() {
        }

        public void init(int viewId, List<AccessibilityNodeInfo> infos) {
            this.mViewId = viewId;
            this.mInfos = infos;
        }

        public void reset() {
            this.mViewId = -1;
            this.mInfos = null;
        }

        @Override
        public boolean test(View view) {
            if (view.getId() == this.mViewId && AccessibilityInteractionController.this.isShown(view) && AccessibilityInteractionController.this.isVisibleToAccessibilityService(view)) {
                this.mInfos.add(view.createAccessibilityNodeInfo());
            }
            return false;
        }
    }

    private class VirtualNode
    implements DequeNode {
        long mInfoId;
        AccessibilityNodeProvider mProvider;

        VirtualNode(long id2, AccessibilityNodeProvider provider) {
            this.mInfoId = id2;
            this.mProvider = provider;
        }

        @Override
        public AccessibilityNodeInfo getA11yNodeInfo() {
            if (this.mProvider == null) {
                return null;
            }
            return this.mProvider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(this.mInfoId));
        }

        @Override
        public void addChildren(AccessibilityNodeInfo virtualRoot, PrefetchDeque deque) {
            if (virtualRoot == null) {
                return;
            }
            int childCount = virtualRoot.getChildCount();
            if (deque.isStack()) {
                for (int i = childCount - 1; i >= 0; --i) {
                    long childNodeId = virtualRoot.getChildId(i);
                    deque.push(new VirtualNode(childNodeId, this.mProvider));
                }
            } else {
                for (int i = 0; i < childCount; ++i) {
                    long childNodeId = virtualRoot.getChildId(i);
                    deque.push(new VirtualNode(childNodeId, this.mProvider));
                }
            }
        }
    }

    private class ViewNode
    implements DequeNode {
        View mView;
        private final ArrayList<View> mTempViewList = new ArrayList();

        ViewNode(View view) {
            this.mView = view;
        }

        @Override
        public AccessibilityNodeInfo getA11yNodeInfo() {
            if (this.mView == null) {
                return null;
            }
            return this.mView.createAccessibilityNodeInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addChildren(AccessibilityNodeInfo virtualRoot, PrefetchDeque deque) {
            if (this.mView == null) {
                return;
            }
            if (!(this.mView instanceof ViewGroup)) {
                return;
            }
            ArrayList<View> children = this.mTempViewList;
            children.clear();
            try {
                this.mView.addChildrenForAccessibility(children);
                int childCount = children.size();
                if (deque.isStack()) {
                    for (int i = childCount - 1; i >= 0; --i) {
                        this.addChild(deque, children.get(i));
                    }
                } else {
                    for (int i = 0; i < childCount; ++i) {
                        this.addChild(deque, children.get(i));
                    }
                }
            }
            finally {
                children.clear();
            }
        }

        private void addChild(ArrayDeque deque, View child) {
            if (AccessibilityInteractionController.this.isShown(child)) {
                AccessibilityNodeProvider provider = child.getAccessibilityNodeProvider();
                if (provider == null) {
                    deque.push(new ViewNode(child));
                } else {
                    deque.push(new VirtualNode(-1L, provider));
                }
            }
        }
    }

    static interface DequeNode {
        public AccessibilityNodeInfo getA11yNodeInfo();

        public void addChildren(AccessibilityNodeInfo var1, PrefetchDeque var2);
    }

    private class PrefetchDeque<E extends DequeNode>
    extends ArrayDeque<E> {
        int mStrategy;
        List<AccessibilityNodeInfo> mPrefetchOutput;

        PrefetchDeque(int strategy, List<AccessibilityNodeInfo> output) {
            this.mStrategy = strategy;
            this.mPrefetchOutput = output;
        }

        void performTraversalAndPrefetch() {
            try {
                while (!this.isEmpty()) {
                    E child = this.getNext();
                    AccessibilityNodeInfo childInfo = child.getA11yNodeInfo();
                    if (childInfo != null) {
                        this.mPrefetchOutput.add(childInfo);
                    }
                    if (AccessibilityInteractionController.this.mPrefetcher.shouldStopPrefetching(this.mPrefetchOutput)) {
                        return;
                    }
                    child.addChildren(childInfo, this);
                }
            }
            finally {
                this.clear();
            }
        }

        E getNext() {
            if (this.isStack()) {
                return (E)((DequeNode)this.pop());
            }
            return (E)((DequeNode)this.removeLast());
        }

        boolean isStack() {
            return (this.mStrategy & 8) != 0;
        }
    }
}

