/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;

@SystemApi
public class UwbAddress
implements Parcelable {
    public static final int SHORT_ADDRESS_BYTE_LENGTH = 2;
    public static final int EXTENDED_ADDRESS_BYTE_LENGTH = 8;
    private final byte[] mAddressBytes;
    @NonNull
    public static final Parcelable.Creator<UwbAddress> CREATOR = new Parcelable.Creator<UwbAddress>(){

        @Override
        public UwbAddress createFromParcel(Parcel in) {
            byte[] address = new byte[in.readInt()];
            in.readByteArray(address);
            return UwbAddress.fromBytes(address);
        }

        public UwbAddress[] newArray(int size) {
            return new UwbAddress[size];
        }
    };

    private UwbAddress(byte[] address) {
        this.mAddressBytes = address;
    }

    @NonNull
    public static UwbAddress fromBytes(@NonNull byte[] address) {
        if (address.length != 2 && address.length != 8) {
            throw new IllegalArgumentException("Invalid UwbAddress length " + address.length);
        }
        return new UwbAddress(address);
    }

    @NonNull
    public byte[] toBytes() {
        return this.mAddressBytes;
    }

    public int size() {
        return this.mAddressBytes.length;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder("0x");
        for (byte addressByte : this.mAddressBytes) {
            builder.append(String.format("%02X", addressByte));
        }
        return builder.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UwbAddress) {
            return Arrays.equals(this.mAddressBytes, ((UwbAddress)obj).toBytes());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mAddressBytes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mAddressBytes.length);
        dest.writeByteArray(this.mAddressBytes);
    }
}

