/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifest;
import android.util.jar.StrictJarManifestReader;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import sun.security.jca.Providers;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

class StrictJarVerifier {
    private static final String SF_ATTRIBUTE_ANDROID_APK_SIGNED_NAME = "X-Android-APK-Signed";
    private static final String[] DIGEST_ALGORITHMS = new String[]{"SHA-512", "SHA-384", "SHA-256", "SHA1"};
    private static final int MAX_JAR_SIGNERS = 10;
    private final String jarName;
    private final StrictJarManifest manifest;
    private final HashMap<String, byte[]> metaEntries;
    private final int mainAttributesEnd;
    private final boolean signatureSchemeRollbackProtectionsEnforced;
    private final Hashtable<String, HashMap<String, Attributes>> signatures = new Hashtable(5);
    private final Hashtable<String, Certificate[]> certificates = new Hashtable(5);
    private final Hashtable<String, Certificate[][]> verifiedEntries = new Hashtable();

    private static SecurityException invalidDigest(String signatureFile, String name, String jarName) {
        throw new SecurityException(signatureFile + " has invalid digest for " + name + " in " + jarName);
    }

    private static SecurityException failedVerification(String jarName, String signatureFile) {
        throw new SecurityException(jarName + " failed verification of " + signatureFile);
    }

    private static SecurityException failedVerification(String jarName, String signatureFile, Throwable e) {
        throw new SecurityException(jarName + " failed verification of " + signatureFile, e);
    }

    StrictJarVerifier(String name, StrictJarManifest manifest, HashMap<String, byte[]> metaEntries, boolean signatureSchemeRollbackProtectionsEnforced) {
        this.jarName = name;
        this.manifest = manifest;
        this.metaEntries = metaEntries;
        this.mainAttributesEnd = manifest.getMainAttributesEnd();
        this.signatureSchemeRollbackProtectionsEnforced = signatureSchemeRollbackProtectionsEnforced;
    }

    VerifierEntry initEntry(String name) {
        if (this.manifest == null || this.signatures.isEmpty()) {
            return null;
        }
        Attributes attributes = this.manifest.getAttributes(name);
        if (attributes == null) {
            return null;
        }
        ArrayList<Certificate[]> certChains = new ArrayList<Certificate[]>();
        for (Map.Entry<String, HashMap<String, Attributes>> entry : this.signatures.entrySet()) {
            String signatureFile;
            Certificate[] certChain;
            HashMap<String, Attributes> hm = entry.getValue();
            if (hm.get(name) == null || (certChain = this.certificates.get(signatureFile = entry.getKey())) == null) continue;
            certChains.add(certChain);
        }
        if (certChains.isEmpty()) {
            return null;
        }
        Certificate[][] certChainsArray = (Certificate[][])certChains.toArray((T[])new Certificate[certChains.size()][]);
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + "-Digest");
            if (hash == null) continue;
            byte[] hashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            try {
                return new VerifierEntry(name, MessageDigest.getInstance(algorithm), hashBytes, certChainsArray, this.verifiedEntries);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return null;
    }

    void addMetaEntry(String name, byte[] buf) {
        this.metaEntries.put(name.toUpperCase(Locale.US), buf);
    }

    synchronized boolean readCertificates() {
        if (this.metaEntries.isEmpty()) {
            return false;
        }
        int signerCount = 0;
        Iterator<String> it = this.metaEntries.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.endsWith(".DSA") && !key.endsWith(".RSA") && !key.endsWith(".EC")) continue;
            if (++signerCount > 10) {
                throw new SecurityException("APK Signature Scheme v1 only supports a maximum of 10 signers");
            }
            this.verifyCertificate(key);
            it.remove();
        }
        return true;
    }

    static Certificate[] verifyBytes(byte[] blockBytes, byte[] sfBytes) throws GeneralSecurityException {
        Object obj = null;
        try {
            obj = Providers.startJarVerification();
            PKCS7 block = new PKCS7(blockBytes);
            SignerInfo[] verifiedSignerInfos = block.verify(sfBytes);
            if (verifiedSignerInfos == null || verifiedSignerInfos.length == 0) {
                throw new GeneralSecurityException("Failed to verify signature: no verified SignerInfos");
            }
            SignerInfo verifiedSignerInfo = verifiedSignerInfos[0];
            ArrayList<X509Certificate> verifiedSignerCertChain = verifiedSignerInfo.getCertificateChain(block);
            if (verifiedSignerCertChain == null) {
                throw new GeneralSecurityException("Failed to find verified SignerInfo certificate chain");
            }
            if (verifiedSignerCertChain.isEmpty()) {
                throw new GeneralSecurityException("Verified SignerInfo certificate chain is emtpy");
            }
            Certificate[] certificateArray = verifiedSignerCertChain.toArray(new X509Certificate[verifiedSignerCertChain.size()]);
            return certificateArray;
        }
        catch (IOException e) {
            throw new GeneralSecurityException("IO exception verifying jar cert", e);
        }
        finally {
            Providers.stopJarVerification(obj);
        }
    }

    private void verifyCertificate(String certFile) {
        String digestAttribute;
        String apkSignatureSchemeIdList;
        String signatureFile = certFile.substring(0, certFile.lastIndexOf(46)) + ".SF";
        byte[] sfBytes = this.metaEntries.get(signatureFile);
        if (sfBytes == null) {
            return;
        }
        byte[] manifestBytes = this.metaEntries.get("META-INF/MANIFEST.MF");
        if (manifestBytes == null) {
            return;
        }
        byte[] sBlockBytes = this.metaEntries.get(certFile);
        try {
            Certificate[] signerCertChain = StrictJarVerifier.verifyBytes(sBlockBytes, sfBytes);
            if (signerCertChain != null) {
                this.certificates.put(signatureFile, signerCertChain);
            }
        }
        catch (GeneralSecurityException e) {
            throw StrictJarVerifier.failedVerification(this.jarName, signatureFile, e);
        }
        Attributes attributes = new Attributes();
        HashMap<String, Attributes> entries = new HashMap<String, Attributes>();
        try {
            StrictJarManifestReader im = new StrictJarManifestReader(sfBytes, attributes);
            im.readEntries(entries, null);
        }
        catch (IOException e) {
            return;
        }
        if (this.signatureSchemeRollbackProtectionsEnforced && (apkSignatureSchemeIdList = attributes.getValue(SF_ATTRIBUTE_ANDROID_APK_SIGNED_NAME)) != null) {
            boolean v2SignatureGenerated = false;
            boolean v3SignatureGenerated = false;
            StringTokenizer tokenizer = new StringTokenizer(apkSignatureSchemeIdList, ",");
            while (tokenizer.hasMoreTokens()) {
                int id2;
                String idText = tokenizer.nextToken().trim();
                if (idText.isEmpty()) continue;
                try {
                    id2 = Integer.parseInt(idText);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (id2 == 2) {
                    v2SignatureGenerated = true;
                    break;
                }
                if (id2 != 3) continue;
                v3SignatureGenerated = true;
                break;
            }
            if (v2SignatureGenerated) {
                throw new SecurityException(signatureFile + " indicates " + this.jarName + " is signed using APK Signature Scheme v2, but no such signature was found. Signature stripped?");
            }
            if (v3SignatureGenerated) {
                throw new SecurityException(signatureFile + " indicates " + this.jarName + " is signed using APK Signature Scheme v3, but no such signature was found. Signature stripped?");
            }
        }
        if (attributes.get(Attributes.Name.SIGNATURE_VERSION) == null) {
            return;
        }
        boolean createdBySigntool = false;
        String createdBy = attributes.getValue("Created-By");
        if (createdBy != null) {
            boolean bl = createdBySigntool = createdBy.indexOf("signtool") != -1;
        }
        if (this.mainAttributesEnd > 0 && !createdBySigntool && !this.verify(attributes, digestAttribute = "-Digest-Manifest-Main-Attributes", manifestBytes, 0, this.mainAttributesEnd, false, true)) {
            throw StrictJarVerifier.failedVerification(this.jarName, signatureFile);
        }
        String string2 = digestAttribute = createdBySigntool ? "-Digest" : "-Digest-Manifest";
        if (!this.verify(attributes, digestAttribute, manifestBytes, 0, manifestBytes.length, false, false)) {
            for (Map.Entry<String, Attributes> entry : entries.entrySet()) {
                StrictJarManifest.Chunk chunk = this.manifest.getChunk(entry.getKey());
                if (chunk == null) {
                    return;
                }
                if (this.verify(entry.getValue(), "-Digest", manifestBytes, chunk.start, chunk.end, createdBySigntool, false)) continue;
                throw StrictJarVerifier.invalidDigest(signatureFile, entry.getKey(), this.jarName);
            }
        }
        this.metaEntries.put(signatureFile, null);
        this.signatures.put(signatureFile, entries);
    }

    boolean isSignedJar() {
        return this.certificates.size() > 0;
    }

    private boolean verify(Attributes attributes, String entry, byte[] data, int start, int end, boolean ignoreSecondEndline, boolean ignorable) {
        for (int i = 0; i < DIGEST_ALGORITHMS.length; ++i) {
            MessageDigest md;
            String algorithm = DIGEST_ALGORITHMS[i];
            String hash = attributes.getValue(algorithm + entry);
            if (hash == null) continue;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                continue;
            }
            if (ignoreSecondEndline && data[end - 1] == 10 && data[end - 2] == 10) {
                md.update(data, start, end - 1 - start);
            } else {
                md.update(data, start, end - start);
            }
            byte[] b = md.digest();
            byte[] encodedHashBytes = hash.getBytes(StandardCharsets.ISO_8859_1);
            return StrictJarVerifier.verifyMessageDigest(b, encodedHashBytes);
        }
        return ignorable;
    }

    private static boolean verifyMessageDigest(byte[] expected, byte[] encodedActual) {
        byte[] actual;
        try {
            actual = Base64.getDecoder().decode(encodedActual);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return MessageDigest.isEqual(expected, actual);
    }

    Certificate[][] getCertificateChains(String name) {
        return this.verifiedEntries.get(name);
    }

    void removeMetaEntries() {
        this.metaEntries.clear();
    }

    static class VerifierEntry
    extends OutputStream {
        private final String name;
        private final MessageDigest digest;
        private final byte[] hash;
        private final Certificate[][] certChains;
        private final Hashtable<String, Certificate[][]> verifiedEntries;

        VerifierEntry(String name, MessageDigest digest, byte[] hash, Certificate[][] certChains, Hashtable<String, Certificate[][]> verifedEntries) {
            this.name = name;
            this.digest = digest;
            this.hash = hash;
            this.certChains = certChains;
            this.verifiedEntries = verifedEntries;
        }

        @Override
        public void write(int value) {
            this.digest.update((byte)value);
        }

        @Override
        public void write(byte[] buf, int off, int nbytes) {
            this.digest.update(buf, off, nbytes);
        }

        void verify() {
            byte[] d = this.digest.digest();
            if (!StrictJarVerifier.verifyMessageDigest(d, this.hash)) {
                throw StrictJarVerifier.invalidDigest("META-INF/MANIFEST.MF", this.name, this.name);
            }
            this.verifiedEntries.put(this.name, this.certChains);
        }
    }
}

