/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

@RavenwoodKeepWholeClass
public class StyleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final int mStyle;
    private final int mFontWeightAdjustment;

    public StyleSpan(int style2) {
        this(style2, Integer.MAX_VALUE);
    }

    public StyleSpan(int style2, int fontWeightAdjustment) {
        this.mStyle = style2;
        this.mFontWeightAdjustment = fontWeightAdjustment;
    }

    public StyleSpan(@NonNull Parcel src) {
        this.mStyle = src.readInt();
        this.mFontWeightAdjustment = src.readInt();
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 7;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mStyle);
        dest.writeInt(this.mFontWeightAdjustment);
    }

    public int getStyle() {
        return this.mStyle;
    }

    public int getFontWeightAdjustment() {
        return this.mFontWeightAdjustment;
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        StyleSpan.apply(ds, this.mStyle, this.mFontWeightAdjustment);
    }

    @Override
    public void updateMeasureState(TextPaint paint) {
        StyleSpan.apply(paint, this.mStyle, this.mFontWeightAdjustment);
    }

    private static void apply(Paint paint, int style2, int fontWeightAdjustment) {
        int fake;
        Typeface old = paint.getTypeface();
        int oldStyle = old == null ? 0 : old.getStyle();
        int want = oldStyle | style2;
        Typeface tf = old == null ? Typeface.defaultFromStyle(want) : Typeface.create(old, want);
        if ((style2 & 1) != 0 && fontWeightAdjustment != 0 && fontWeightAdjustment != Integer.MAX_VALUE) {
            int newWeight = Math.min(Math.max(tf.getWeight() + fontWeightAdjustment, 1), 1000);
            boolean italic = (want & 2) != 0;
            tf = Typeface.create(tf, newWeight, italic);
        }
        if (((fake = want & ~tf.getStyle()) & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }

    public String toString() {
        return "StyleSpan{style=" + this.getStyle() + ", fontWeightAdjustment=" + this.getFontWeightAdjustment() + '}';
    }
}

