/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.NonNull;
import android.graphics.Paint;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.ParagraphStyle;
import android.text.style.WrapTogetherSpan;
import com.android.internal.util.Preconditions;

@RavenwoodKeepWholeClass
public interface LineHeightSpan
extends ParagraphStyle,
WrapTogetherSpan {
    public void chooseHeight(CharSequence var1, int var2, int var3, int var4, int var5, Paint.FontMetricsInt var6);

    public static class Standard
    implements LineHeightSpan,
    ParcelableSpan {
        private final int mHeight;

        public Standard(int height) {
            Preconditions.checkArgument(height > 0, "Height: %d must be positive", height);
            this.mHeight = height;
        }

        public Standard(@NonNull Parcel src) {
            this.mHeight = src.readInt();
        }

        public int getHeight() {
            return this.mHeight;
        }

        @Override
        public int getSpanTypeId() {
            return this.getSpanTypeIdInternal();
        }

        @Override
        public int getSpanTypeIdInternal() {
            return 28;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            this.writeToParcelInternal(dest, flags);
        }

        @Override
        public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mHeight);
        }

        @Override
        public void chooseHeight(@NonNull CharSequence text, int start, int end, int spanstartv, int lineHeight, @NonNull Paint.FontMetricsInt fm) {
            int originHeight = fm.descent - fm.ascent;
            if (originHeight <= 0) {
                return;
            }
            float ratio = (float)this.mHeight * 1.0f / (float)originHeight;
            fm.descent = Math.round((float)fm.descent * ratio);
            fm.ascent = fm.descent - this.mHeight;
        }
    }

    public static interface WithDensity
    extends LineHeightSpan {
        public void chooseHeight(CharSequence var1, int var2, int var3, int var4, int var5, Paint.FontMetricsInt var6, TextPaint var7);
    }
}

