/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.graphics.text.LineBreakConfig;
import android.os.Parcel;
import android.os.Parcelable;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.text.ParcelableSpan;
import java.util.Objects;

@FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
@RavenwoodKeepWholeClass
public class LineBreakConfigSpan
implements ParcelableSpan {
    private final LineBreakConfig mLineBreakConfig;
    private static final LineBreakConfig sNoHyphenationConfig = new LineBreakConfig.Builder().setHyphenation(0).build();
    private static final LineBreakConfig sNoBreakConfig = new LineBreakConfig.Builder().setLineBreakStyle(4).build();
    @NonNull
    public static final Parcelable.Creator<LineBreakConfigSpan> CREATOR = new Parcelable.Creator<LineBreakConfigSpan>(){

        @Override
        public LineBreakConfigSpan createFromParcel(Parcel source) {
            LineBreakConfig lbc = source.readParcelable(LineBreakConfig.class.getClassLoader(), LineBreakConfig.class);
            return new LineBreakConfigSpan(lbc);
        }

        public LineBreakConfigSpan[] newArray(int size) {
            return new LineBreakConfigSpan[size];
        }
    };

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    public LineBreakConfigSpan(@NonNull LineBreakConfig lineBreakConfig) {
        this.mLineBreakConfig = lineBreakConfig;
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    @NonNull
    public LineBreakConfig getLineBreakConfig() {
        return this.mLineBreakConfig;
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    @NonNull
    public static LineBreakConfigSpan createNoBreakSpan() {
        return new LineBreakConfigSpan(sNoBreakConfig);
    }

    @FlaggedApi(value="com.android.text.flags.no_break_no_hyphenation_span")
    @NonNull
    public static LineBreakConfigSpan createNoHyphenationSpan() {
        return new LineBreakConfigSpan(sNoHyphenationConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineBreakConfigSpan)) {
            return false;
        }
        LineBreakConfigSpan that = (LineBreakConfigSpan)o;
        return Objects.equals(this.mLineBreakConfig, that.mLineBreakConfig);
    }

    public int hashCode() {
        return Objects.hash(this.mLineBreakConfig);
    }

    public String toString() {
        return "LineBreakConfigSpan{mLineBreakConfig=" + this.mLineBreakConfig + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 30;
    }

    @Override
    public void writeToParcelInternal(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mLineBreakConfig, flags);
    }
}

